/*
 * Decompiled with CFR 0.152.
 */
package ca.slashdev.bb.tasks;

import ca.slashdev.bb.tasks.BaseTask;
import ca.slashdev.bb.types.OverrideType;
import ca.slashdev.bb.util.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.ResourceUtils;

public class JadtoolTask
extends BaseTask {
    private File input;
    private String output;
    private File destDir;
    private Vector<ResourceCollection> resources = new Vector();
    private Vector<OverrideType> overrides = new Vector();
    private Map<String, OverrideType> overrideMap = new HashMap<String, OverrideType>();

    public void setInput(File input) {
        this.input = input;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void add(ResourceCollection res) {
        this.resources.add(res);
    }

    public void addOverride(OverrideType override) {
        this.overrides.add(override);
    }

    public void execute() throws BuildException {
        super.execute();
        if (this.input == null) {
            throw new BuildException("input is a required attribute");
        }
        if (!this.input.exists()) {
            throw new BuildException("input file is missing");
        }
        if (this.output == null) {
            this.output = this.input.getName();
        }
        if (this.resources.size() == 0) {
            throw new BuildException("specify at least one cod file");
        }
        if (this.destDir == null) {
            throw new BuildException("destdir is a required attribute");
        }
        if (!this.destDir.exists() && !this.destDir.mkdirs()) {
            throw new BuildException("unable to create destination directory");
        }
        for (OverrideType o : this.overrides) {
            o.validate();
            this.overrideMap.put(o.getKey().toLowerCase(), o);
        }
        this.executeRewrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRewrite() {
        BufferedReader reader = null;
        PrintStream output = null;
        try {
            try {
                String line;
                reader = new BufferedReader(new FileReader(this.input));
                output = new PrintStream(new File(this.destDir, this.output));
                int num = 0;
                while ((line = reader.readLine()) != null) {
                    ++num;
                    int i = line.indexOf(58);
                    if (i == -1) {
                        throw new BuildException("unexpected line in jad file: " + num);
                    }
                    String key = line.substring(0, i);
                    String value = line.substring(i + 1).trim();
                    if (key.startsWith("RIM-COD-URL") || key.startsWith("RIM-COD-SHA1") || key.startsWith("RIM-COD-Size")) continue;
                    OverrideType override = this.overrideMap.get(key.toLowerCase());
                    if (override != null) {
                        value = override.getValue();
                        this.overrideMap.remove(key.toLowerCase());
                    }
                    output.printf("%s: %s\n", key, value);
                }
            }
            catch (IOException e) {
                throw new BuildException("error creating jad file", (Throwable)e);
            }
            try {
                int num = 0;
                for (ResourceCollection rc : this.resources) {
                    for (Resource r : rc) {
                        File destFile = new File(this.destDir, Utils.getFilePart(r));
                        if (Utils.isZip(r)) {
                            String[] zipEntries;
                            for (String entry : zipEntries = Utils.extract(r, this.destDir)) {
                                destFile = new File(this.destDir, entry);
                                if (num == 0) {
                                    output.printf("RIM-COD-URL: %s\n", destFile.getName());
                                    output.printf("RIM-COD-SHA1: %s\n", Utils.getSHA1(destFile));
                                    output.printf("RIM-COD-Size: %d\n", destFile.length());
                                } else {
                                    output.printf("RIM-COD-URL-%d: %s\n", num, destFile.getName());
                                    output.printf("RIM-COD-SHA1-%d: %s\n", num, Utils.getSHA1(destFile));
                                    output.printf("RIM-COD-Size-%d: %d\n", num, destFile.length());
                                }
                                ++num;
                            }
                            continue;
                        }
                        ResourceUtils.copyResource((Resource)r, (Resource)new FileResource(destFile));
                        if (num == 0) {
                            output.printf("RIM-COD-URL: %s\n", destFile.getName());
                            output.printf("RIM-COD-SHA1: %s\n", Utils.getSHA1(destFile));
                            output.printf("RIM-COD-Size: %d\n", destFile.length());
                        } else {
                            output.printf("RIM-COD-URL-%d: %s\n", num, destFile.getName());
                            output.printf("RIM-COD-SHA1-%d: %s\n", num, Utils.getSHA1(destFile));
                            output.printf("RIM-COD-Size-%d: %d\n", num, destFile.length());
                        }
                        ++num;
                    }
                }
            }
            catch (IOException e) {
                throw new BuildException("error copying cod file", (Throwable)e);
            }
            for (OverrideType override : this.overrideMap.values()) {
                output.printf("%s: %s\n", override.getKey(), override.getValue());
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(reader);
            FileUtils.close(output);
            throw throwable;
        }
        FileUtils.close((Reader)reader);
        FileUtils.close((OutputStream)output);
    }
}

