/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.entity;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.ContentEncoderChannel;
import org.apache.http.nio.FileContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.ProducingNHttpEntity;

public class NFileEntity
extends AbstractHttpEntity
implements ProducingNHttpEntity {
    private final File file;
    private FileChannel fileChannel;
    private long idx = -1L;
    private boolean useFileChannels;

    public NFileEntity(File file, String contentType, boolean useFileChannels) {
        if (file == null) {
            throw new IllegalArgumentException("File may not be null");
        }
        this.file = file;
        this.useFileChannels = useFileChannels;
        this.setContentType(contentType);
    }

    public NFileEntity(File file, String contentType) {
        this(file, contentType, true);
    }

    public void finish() {
        try {
            if (this.fileChannel != null) {
                this.fileChannel.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fileChannel = null;
    }

    public long getContentLength() {
        return this.file.length();
    }

    public boolean isRepeatable() {
        return true;
    }

    public void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        long transferred;
        if (this.fileChannel == null) {
            FileInputStream in = new FileInputStream(this.file);
            this.fileChannel = in.getChannel();
            this.idx = 0L;
        }
        if ((transferred = this.useFileChannels && encoder instanceof FileContentEncoder ? ((FileContentEncoder)encoder).transfer(this.fileChannel, this.idx, Long.MAX_VALUE) : this.fileChannel.transferTo(this.idx, Long.MAX_VALUE, new ContentEncoderChannel(encoder))) > 0L) {
            this.idx += transferred;
        }
        if (this.idx >= this.fileChannel.size()) {
            encoder.complete();
        }
    }

    public boolean isStreaming() {
        return false;
    }

    public InputStream getContent() throws IOException {
        return new FileInputStream(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outstream) throws IOException {
        if (outstream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        FileInputStream instream = new FileInputStream(this.file);
        try {
            int l;
            byte[] tmp = new byte[4096];
            while ((l = ((InputStream)instream).read(tmp)) != -1) {
                outstream.write(tmp, 0, l);
            }
            outstream.flush();
        }
        finally {
            ((InputStream)instream).close();
        }
    }
}

