/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.obfuscate.DictionaryNameFactory;
import proguard.obfuscate.NameFactory;
import proguard.obfuscate.NumericNameFactory;
import proguard.obfuscate.SimpleNameFactory;
import proguard.util.FileNameParser;
import proguard.util.ListParser;
import proguard.util.StringMatcher;

public class ClassObfuscator
extends SimplifiedVisitor
implements ClassVisitor,
AttributeVisitor,
InnerClassesInfoVisitor,
ConstantVisitor {
    private final DictionaryNameFactory classNameFactory;
    private final DictionaryNameFactory packageNameFactory;
    private final boolean useMixedCaseClassNames;
    private final StringMatcher keepPackageNamesMatcher;
    private final String flattenPackageHierarchy;
    private final String repackageClasses;
    private final boolean allowAccessModification;
    private final Set classNamesToAvoid = new HashSet();
    private final Map packagePrefixMap = new HashMap();
    private final Map packagePrefixPackageNameFactoryMap = new HashMap();
    private final Map packagePrefixClassNameFactoryMap = new HashMap();
    private final Map packagePrefixNumericClassNameFactoryMap = new HashMap();
    private String newClassName;
    private boolean numericClassName;

    public ClassObfuscator(ClassPool classPool, DictionaryNameFactory dictionaryNameFactory, DictionaryNameFactory dictionaryNameFactory2, boolean bl, List list, String string, String string2, boolean bl2) {
        this.classNameFactory = dictionaryNameFactory;
        this.packageNameFactory = dictionaryNameFactory2;
        if (string != null && string.length() > 0) {
            string = string + '/';
        }
        if (string2 != null && string2.length() > 0) {
            string2 = string2 + '/';
        }
        this.useMixedCaseClassNames = bl;
        this.keepPackageNamesMatcher = list == null ? null : new ListParser(new FileNameParser()).parse(list);
        this.flattenPackageHierarchy = string;
        this.repackageClasses = string2;
        this.allowAccessModification = bl2;
        this.packagePrefixMap.put("", "");
        classPool.classesAccept(new MyKeepCollector());
    }

    public void visitProgramClass(ProgramClass programClass) {
        this.newClassName = ClassObfuscator.newClassName(programClass);
        if (this.newClassName == null) {
            programClass.attributesAccept(this);
            String string = this.newClassName != null ? this.newClassName + '$' : this.newPackagePrefix(ClassUtil.internalPackagePrefix(programClass.getName()));
            this.newClassName = this.newClassName != null && this.numericClassName ? this.generateUniqueNumericClassName(string) : this.generateUniqueClassName(string);
            ClassObfuscator.setNewClassName(programClass, this.newClassName);
        }
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        innerClassesAttribute.innerClassEntriesAccept(clazz, this);
    }

    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        enclosingMethodAttribute.referencedClassAccept(this);
        String string = clazz.getName();
        String string2 = clazz.getClassName(enclosingMethodAttribute.u2classIndex);
        this.numericClassName = this.isNumericClassName(string, string2);
    }

    public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
        String string;
        int n = innerClassesInfo.u2innerClassIndex;
        int n2 = innerClassesInfo.u2outerClassIndex;
        if (n != 0 && n2 != 0 && (string = clazz.getClassName(n)).equals(clazz.getName())) {
            clazz.constantPoolEntryAccept(n2, this);
            String string2 = clazz.getClassName(n2);
            this.numericClassName = this.isNumericClassName(string, string2);
        }
    }

    private boolean isNumericClassName(String string, String string2) {
        int n;
        int n2 = string2.length() + 1;
        if (n2 >= (n = string.length())) {
            return false;
        }
        for (int i = n2; i < n; ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.referencedClassAccept(this);
    }

    private String newPackagePrefix(String string) {
        String string2 = (String)this.packagePrefixMap.get(string);
        if (string2 == null) {
            if (this.keepPackageNamesMatcher != null && this.keepPackageNamesMatcher.matches(string.length() > 0 ? string.substring(0, string.length() - 1) : string)) {
                return string;
            }
            if (this.repackageClasses != null) {
                return this.repackageClasses;
            }
            String string3 = this.flattenPackageHierarchy != null ? this.flattenPackageHierarchy : this.newPackagePrefix(ClassUtil.internalPackagePrefix(string));
            string2 = this.generateUniquePackagePrefix(string3);
            this.packagePrefixMap.put(string, string2);
        }
        return string2;
    }

    private String generateUniquePackagePrefix(String string) {
        NameFactory nameFactory = (NameFactory)this.packagePrefixPackageNameFactoryMap.get(string);
        if (nameFactory == null) {
            nameFactory = new SimpleNameFactory(this.useMixedCaseClassNames);
            if (this.packageNameFactory != null) {
                nameFactory = new DictionaryNameFactory(this.packageNameFactory, nameFactory);
            }
            this.packagePrefixPackageNameFactoryMap.put(string, nameFactory);
        }
        return this.generateUniquePackagePrefix(string, nameFactory);
    }

    private String generateUniquePackagePrefix(String string, NameFactory nameFactory) {
        String string2;
        while (this.packagePrefixMap.containsValue(string2 = string + nameFactory.nextName() + '/')) {
        }
        return string2;
    }

    private String generateUniqueClassName(String string) {
        NameFactory nameFactory = (NameFactory)this.packagePrefixClassNameFactoryMap.get(string);
        if (nameFactory == null) {
            nameFactory = new SimpleNameFactory(this.useMixedCaseClassNames);
            if (this.classNameFactory != null) {
                nameFactory = new DictionaryNameFactory(this.classNameFactory, nameFactory);
            }
            this.packagePrefixClassNameFactoryMap.put(string, nameFactory);
        }
        return this.generateUniqueClassName(string, nameFactory);
    }

    private String generateUniqueNumericClassName(String string) {
        NameFactory nameFactory = (NameFactory)this.packagePrefixNumericClassNameFactoryMap.get(string);
        if (nameFactory == null) {
            nameFactory = new NumericNameFactory();
            this.packagePrefixNumericClassNameFactoryMap.put(string, nameFactory);
        }
        return this.generateUniqueClassName(string, nameFactory);
    }

    private String generateUniqueClassName(String string, NameFactory nameFactory) {
        String string2;
        while (this.classNamesToAvoid.contains(this.mixedCaseClassName(string2 = string + nameFactory.nextName()))) {
        }
        return string2;
    }

    private String mixedCaseClassName(String string) {
        return this.useMixedCaseClassNames ? string : string.toLowerCase();
    }

    static void setNewClassName(Clazz clazz, String string) {
        clazz.setVisitorInfo(string);
    }

    static String newClassName(Clazz clazz) {
        Object object = clazz.getVisitorInfo();
        return object instanceof String ? (String)object : null;
    }

    private class MyKeepCollector
    implements ClassVisitor {
        private MyKeepCollector() {
        }

        public void visitProgramClass(ProgramClass programClass) {
            String string = ClassObfuscator.newClassName(programClass);
            if (string != null) {
                ClassObfuscator.this.classNamesToAvoid.add(ClassObfuscator.this.mixedCaseClassName(string));
                if (ClassObfuscator.this.repackageClasses == null || !ClassObfuscator.this.allowAccessModification) {
                    String string2 = programClass.getName();
                    this.mapPackageName(string2, string, ClassObfuscator.this.repackageClasses == null && ClassObfuscator.this.flattenPackageHierarchy == null);
                }
            }
        }

        public void visitLibraryClass(LibraryClass libraryClass) {
        }

        private void mapPackageName(String string, String string2, boolean bl) {
            String string3 = ClassUtil.internalPackagePrefix(string);
            String string4 = ClassUtil.internalPackagePrefix(string2);
            do {
                ClassObfuscator.this.packagePrefixMap.put(string3, string4);
                if (!bl) break;
                string3 = ClassUtil.internalPackagePrefix(string3);
                string4 = ClassUtil.internalPackagePrefix(string4);
            } while (string3.length() > 0 && string4.length() > 0);
        }
    }
}

