/*
 * Decompiled with CFR 0.152.
 */
package antenna.preprocessor.v2;

import antenna.preprocessor.IPreprocessor;
import antenna.preprocessor.PreprocessorException;
import antenna.preprocessor.v2.PPException;
import antenna.preprocessor.v2.Preprocessor;
import de.pleumann.antenna.misc.Strings;
import de.pleumann.antenna.misc.Utility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.Project;

public class PreprocessorBridge
implements IPreprocessor {
    private Preprocessor m_preprocessor;
    private final Utility m_utility;

    public PreprocessorBridge(Utility utility) {
        this.m_utility = utility;
        Preprocessor.ILineFilter filter = null;
        Preprocessor.ILogger logger = null;
        if (utility != null) {
            final Project project = utility.getProject();
            filter = new Preprocessor.ILineFilter(){

                public String filter(String line) {
                    return project.replaceProperties(line);
                }
            };
            logger = new Preprocessor.ILogger(){

                public void log(String message) {
                    project.log(message);
                }
            };
        }
        this.m_preprocessor = new Preprocessor(logger, filter);
    }

    public void setMode(int mode) {
        this.m_preprocessor.setVerbose((mode & 0x10) != 0);
    }

    public void setFile(File fileName) {
        this.m_preprocessor.setFile(fileName);
    }

    public boolean preprocess(InputStream in, OutputStream out, String encoding) throws IOException, PreprocessorException {
        try {
            return this.m_preprocessor.preprocess(in, out, encoding);
        }
        catch (PPException e) {
            throw new PreprocessorException(e.getMessage(), e);
        }
    }

    public boolean preprocess(Strings lines, String encoding) throws PreprocessorException, IOException {
        try {
            return this.m_preprocessor.preprocess(lines.getVector(), encoding);
        }
        catch (PPException e) {
            throw new PreprocessorException(e.getMessage(), e);
        }
    }

    public boolean isVerbose() {
        return this.m_preprocessor.isVerbose();
    }

    public void addSymbols(String defines) throws PreprocessorException {
        try {
            this.m_preprocessor.addDefines(defines);
        }
        catch (PPException e) {
            throw new PreprocessorException(e.getMessage(), e);
        }
    }

    public void addSymbols(InputStream in) throws PreprocessorException, IOException {
        try {
            this.m_preprocessor.addDefines(in);
        }
        catch (PPException e) {
            throw new PreprocessorException(e.getMessage(), e);
        }
    }

    public void addSymbols(File file) throws PreprocessorException, IOException {
        try {
            this.m_preprocessor.addDefines(file);
        }
        catch (PPException e) {
            throw new PreprocessorException(e.getMessage(), e);
        }
    }

    public void clearSymbols() throws PreprocessorException {
        this.m_preprocessor.clearDefines();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputDefinesToFile(File file, String encoding) throws PreprocessorException, IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(this.m_preprocessor.getDefines().toString().getBytes(encoding != null ? encoding : "UTF-8"));
            out.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public void printSymbols() throws PreprocessorException {
        this.m_utility.getProject().log("Symbols: " + this.m_preprocessor.getDefines().toString());
    }

    public void setDebugLevel(String level) throws PreprocessorException {
        if ("none".equals(level) || level == null) {
            this.m_preprocessor.getDefines().undefine("DEBUG");
        } else if (level.equalsIgnoreCase("debug") || level.equalsIgnoreCase("info") || level.equalsIgnoreCase("warn") || level.equalsIgnoreCase("error") || level.equalsIgnoreCase("fatal")) {
            try {
                this.m_preprocessor.addDefines("DEBUG=" + level);
            }
            catch (PPException e) {
                throw new PreprocessorException("Error adding defines", e);
            }
        } else {
            throw new PreprocessorException("Unsupported debug level " + level + ", Supported values are [debug|info|warn|error|fatal|none]");
        }
    }
}

