/*
 * Decompiled with CFR 0.152.
 */
package com.example.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Crypter
extends Task {
    public static final String DEFAULT_CIPHER_TRANSFORMATION = "AES/CBC/PKCS5Padding";
    public static final String DEFAULT_KEY_ALGORITHM = "AES/CBC";
    private String keyFile;
    private File inputFile;
    private File outputFile;
    private boolean encrypt = true;
    private boolean generateKey = false;
    private String salt = "EYnJl9GPHi44mt";
    private String cipherTransformation = "AES/CBC/PKCS5Padding";
    private String keyAlgorithm = "AES/CBC";
    private IvParameterSpec ivSpec;

    private void logInfo(String message) {
        if (this.getProject() != null) {
            this.log(message, 2);
        } else {
            System.out.println(message);
        }
    }

    private SecretKey readKey() throws BuildException {
        if (this.keyFile == null) {
            throw new BuildException("No 'keyFile' specified, cannot continue.");
        }
        try {
            this.logInfo(" key: " + this.keyFile + " " + this.keyFile.length());
            this.logInfo(" salt: " + this.salt);
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            for (int i = 0; i < 128; ++i) {
                digest.update(this.salt.getBytes());
                digest.update(this.keyFile.getBytes());
                digest.update(digest.digest());
            }
            byte[] sha1 = digest.digest();
            byte[] aes_key = new byte[16];
            System.arraycopy(sha1, 0, aes_key, 0, aes_key.length);
            SecretKeySpec secret = new SecretKeySpec(aes_key, "AES");
            return secret;
        }
        catch (Exception e) {
            this.logInfo("readKey error: " + e);
            return null;
        }
    }

    private Cipher initialiseCipher(Key key) throws BuildException {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(this.cipherTransformation);
            byte[] iv = new byte[16];
            Arrays.fill(iv, (byte)0);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            if (this.encrypt) {
                cipher.init(1, key, ivSpec);
                this.logInfo("Initialised cipher to perform encryption using " + this.cipherTransformation);
                this.logInfo("key: " + this.hex(key.getEncoded()));
            } else {
                cipher.init(2, key, ivSpec);
                this.logInfo("Initialised cipher to perform decryption using " + this.cipherTransformation);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new BuildException("Cipher transformation algorithm [" + this.cipherTransformation + "] not supported", (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            throw new BuildException("Cipher padding scheme not supported", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            this.logInfo("Error: " + e);
            throw new BuildException("Invalid key for cipher", (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            this.logInfo("Error: " + e);
            throw new BuildException("Invalid AlgorithmParameter for cipher", (Throwable)e);
        }
        return cipher;
    }

    private String hex(byte[] data) {
        int offset = 0;
        int length = data.length;
        StringBuffer buf = new StringBuffer();
        for (int i = offset; i < offset + length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int twohalfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (twohalfs++ < 1);
        }
        return buf.toString();
    }

    private void crypt(Cipher cipher) throws BuildException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.inputFile);
        }
        catch (FileNotFoundException e) {
            throw new BuildException("Could not find input file " + this.inputFile, (Throwable)e);
        }
        FileOutputStream fileout = null;
        try {
            fileout = new FileOutputStream(this.outputFile);
        }
        catch (FileNotFoundException e) {
            throw new BuildException("Invalid output file " + this.outputFile, (Throwable)e);
        }
        CipherOutputStream out = new CipherOutputStream(fileout, cipher);
        byte[] buffer = new byte[8192];
        try {
            int length;
            while ((length = in.read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            throw new BuildException("Error writing output file " + this.outputFile, (Throwable)e);
        }
        this.logInfo("Performed cryptographic transformation on " + this.inputFile.getAbsolutePath() + " to " + this.outputFile.getAbsolutePath());
    }

    public void execute() throws BuildException {
        if (this.inputFile != null || this.outputFile != null) {
            SecretKey key = this.readKey();
            this.logInfo("key read " + (key != null));
            Cipher cipher = this.initialiseCipher(key);
            this.crypt(cipher);
        }
    }

    public void setKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
    }

    public void setKeyFile(String key) {
        this.keyFile = key;
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public void setEncrypt(boolean encrypt) {
        this.encrypt = encrypt;
    }

    public void setCipherTransformation(String transformation) {
        this.cipherTransformation = transformation;
    }

    public static byte[] SHA1(byte[] message, int offset, int length) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(message, offset, length);
            byte[] sha1 = digest.digest();
            return sha1;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static byte[] SHA1(byte[] message) {
        return Crypter.SHA1(message, 0, message.length);
    }
}

