#include <stdio.h>

#include <stdlib.h>

#include <windows.h>



#include "zlib.h"





void MyDoMinus64(LARGE_INTEGER *R,LARGE_INTEGER A,LARGE_INTEGER B)

{

    R->HighPart = A.HighPart - B.HighPart;

    if (A.LowPart >= B.LowPart)

        R->LowPart = A.LowPart - B.LowPart;

    else

    {

        R->LowPart = A.LowPart - B.LowPart;

        R->HighPart --;

    }

}



#ifdef _M_X64

// see http://msdn2.microsoft.com/library/twchhe95(en-us,vs.80).aspx for __rdtsc

unsigned __int64 __rdtsc(void);

void BeginCountRdtsc(LARGE_INTEGER * pbeginTime64)

{

 //   printf("rdtsc = %I64x\n",__rdtsc());

   pbeginTime64->QuadPart=__rdtsc();

}



LARGE_INTEGER GetResRdtsc(LARGE_INTEGER beginTime64,BOOL fComputeTimeQueryPerf)

{

    LARGE_INTEGER LIres;

    unsigned _int64 res=__rdtsc()-((unsigned _int64)(beginTime64.QuadPart));

    LIres.QuadPart=res;

   // printf("rdtsc = %I64x\n",__rdtsc());

    return LIres;

}

#else

#ifdef _M_IX86

void myGetRDTSC32(LARGE_INTEGER * pbeginTime64)

{

    DWORD dwEdx,dwEax;

    _asm

    {

        rdtsc

        mov dwEax,eax

        mov dwEdx,edx

    }

    pbeginTime64->LowPart=dwEax;

    pbeginTime64->HighPart=dwEdx;

}



void BeginCountRdtsc(LARGE_INTEGER * pbeginTime64)

{

    myGetRDTSC32(pbeginTime64);

}



LARGE_INTEGER GetResRdtsc(LARGE_INTEGER beginTime64,BOOL fComputeTimeQueryPerf)

{

    LARGE_INTEGER LIres,endTime64;

    myGetRDTSC32(&endTime64);



    LIres.LowPart=LIres.HighPart=0;

    MyDoMinus64(&LIres,endTime64,beginTime64);

    return LIres;

}

#else

void myGetRDTSC32(LARGE_INTEGER * pbeginTime64)

{

}



void BeginCountRdtsc(LARGE_INTEGER * pbeginTime64)

{

}



LARGE_INTEGER GetResRdtsc(LARGE_INTEGER beginTime64,BOOL fComputeTimeQueryPerf)

{

    LARGE_INTEGER lr;

    lr.QuadPart=0;

    return lr;

}

#endif

#endif



void BeginCountPerfCounter(LARGE_INTEGER * pbeginTime64,BOOL fComputeTimeQueryPerf)

{

    if ((!fComputeTimeQueryPerf) || (!QueryPerformanceCounter(pbeginTime64)))

    {

        pbeginTime64->LowPart = GetTickCount();

        pbeginTime64->HighPart = 0;

    }

}



DWORD GetMsecSincePerfCounter(LARGE_INTEGER beginTime64,BOOL fComputeTimeQueryPerf)

{

    LARGE_INTEGER endTime64,ticksPerSecond,ticks;

    DWORDLONG ticksShifted,tickSecShifted;

    DWORD dwLog=16+0;

    DWORD dwRet;

    if ((!fComputeTimeQueryPerf) || (!QueryPerformanceCounter(&endTime64)))

        dwRet = (GetTickCount() - beginTime64.LowPart)*1;

    else

    {

        MyDoMinus64(&ticks,endTime64,beginTime64);

        QueryPerformanceFrequency(&ticksPerSecond);



    

        {

            ticksShifted = Int64ShrlMod32(*(DWORDLONG*)&ticks,dwLog);

            tickSecShifted = Int64ShrlMod32(*(DWORDLONG*)&ticksPerSecond,dwLog);

        

        } 



        dwRet = (DWORD)((((DWORD)ticksShifted)*1000)/(DWORD)(tickSecShifted));

        dwRet *=1;

    }

    return dwRet;

}



int ReadFileMemory(const char* filename,long* plFileSize,void** pFilePtr)

{

    FILE* stream;

    void* ptr;

    int retVal=1;

    stream=fopen(filename, "rb");

    if (stream==NULL)

        return 0;



    fseek(stream,0,SEEK_END);



    *plFileSize=ftell(stream);

    fseek(stream,0,SEEK_SET);

    ptr=malloc((*plFileSize)+1);

    if (ptr==NULL)

        retVal=0;

    else

    {

        if (fread(ptr, 1, *plFileSize,stream) != (*plFileSize))

            retVal=0;

    }

    fclose(stream);

    *pFilePtr=ptr;

    return retVal;

}



int main(int argc, char *argv[])

{

    int BlockSizeCompress=0x8000;

    int BlockSizeUncompress=0x8000;

    int cprLevel=Z_DEFAULT_COMPRESSION ;

    long lFileSize;

    unsigned char* FilePtr;

    long lBufferSizeCpr;

    long lBufferSizeUncpr;

    long lCompressedSize=0;

    unsigned char* CprPtr;

    unsigned char* UncprPtr;

    long lSizeCpr,lSizeUncpr;

    DWORD dwGetTick,dwMsecQP;

    LARGE_INTEGER li_qp,li_rdtsc,dwResRdtsc;



    if (argc<=1)

    {

        printf("run TestZlib <File> [BlockSizeCompress] [BlockSizeUncompress] [compres. level]\n");

        return 0;

    }



    if (ReadFileMemory(argv[1],&lFileSize,&FilePtr)==0)

    {

        printf("error reading %s\n",argv[1]);

        return 1;

    }

    else printf("file %s read, %u bytes\n",argv[1],lFileSize);



    if (argc>=3)

        BlockSizeCompress=atol(argv[2]);



    if (argc>=4)

        BlockSizeUncompress=atol(argv[3]);



    if (argc>=5)

        cprLevel=(int)atol(argv[4]);



    lBufferSizeCpr = lFileSize + (lFileSize/0x10) + 0x200;

    lBufferSizeUncpr = lBufferSizeCpr;



    CprPtr=(unsigned char*)malloc(lBufferSizeCpr + BlockSizeCompress);



    BeginCountPerfCounter(&li_qp,TRUE);

    dwGetTick=GetTickCount();

    BeginCountRdtsc(&li_rdtsc);

    {

        z_stream zcpr;

        int ret=Z_OK;

        long lOrigToDo = lFileSize;

        long lOrigDone = 0;

        int step=0;

        memset(&zcpr,0,sizeof(z_stream));

        deflateInit(&zcpr,cprLevel);



        zcpr.next_in = FilePtr;

        zcpr.next_out = CprPtr;





        do

        {

            long all_read_before = zcpr.total_in;

            zcpr.avail_in = min(lOrigToDo,BlockSizeCompress);

            zcpr.avail_out = BlockSizeCompress;

            ret=deflate(&zcpr,(zcpr.avail_in==lOrigToDo) ? Z_FINISH : Z_SYNC_FLUSH);

            lOrigDone += (zcpr.total_in-all_read_before);

            lOrigToDo -= (zcpr.total_in-all_read_before);

            step++;

        } while (ret==Z_OK);



        lSizeCpr=zcpr.total_out;

        deflateEnd(&zcpr);

        dwGetTick=GetTickCount()-dwGetTick;

        dwMsecQP=GetMsecSincePerfCounter(li_qp,TRUE);

        dwResRdtsc=GetResRdtsc(li_rdtsc,TRUE);

        printf("total compress size = %u, in %u step\n",lSizeCpr,step);

        printf("time = %u msec = %f sec\n",dwGetTick,dwGetTick/(double)1000.);

        printf("defcpr time QP = %u msec = %f sec\n",dwMsecQP,dwMsecQP/(double)1000.);

        printf("defcpr result rdtsc = %I64x\n\n",dwResRdtsc.QuadPart);

    }



    CprPtr=(unsigned char*)realloc(CprPtr,lSizeCpr);

    UncprPtr=(unsigned char*)malloc(lBufferSizeUncpr + BlockSizeUncompress);



    BeginCountPerfCounter(&li_qp,TRUE);

    dwGetTick=GetTickCount();

    BeginCountRdtsc(&li_rdtsc);

    {

        z_stream zcpr;

        int ret=Z_OK;

        long lOrigToDo = lSizeCpr;

        long lOrigDone = 0;

        int step=0;

        memset(&zcpr,0,sizeof(z_stream));

        inflateInit(&zcpr);



        zcpr.next_in = CprPtr;

        zcpr.next_out = UncprPtr;





        do

        {

            long all_read_before = zcpr.total_in;

            zcpr.avail_in = min(lOrigToDo,BlockSizeUncompress);

            zcpr.avail_out = BlockSizeUncompress;

            ret=inflate(&zcpr,Z_SYNC_FLUSH);

            lOrigDone += (zcpr.total_in-all_read_before);

            lOrigToDo -= (zcpr.total_in-all_read_before);

            step++;

        } while (ret==Z_OK);



        lSizeUncpr=zcpr.total_out;

        inflateEnd(&zcpr);

        dwGetTick=GetTickCount()-dwGetTick;

        dwMsecQP=GetMsecSincePerfCounter(li_qp,TRUE);

        dwResRdtsc=GetResRdtsc(li_rdtsc,TRUE);

        printf("total uncompress size = %u, in %u step\n",lSizeUncpr,step);

        printf("time = %u msec = %f sec\n",dwGetTick,dwGetTick/(double)1000.);

        printf("uncpr  time QP = %u msec = %f sec\n",dwMsecQP,dwMsecQP/(double)1000.);

        printf("uncpr  result rdtsc = %I64x\n\n",dwResRdtsc.QuadPart);

    }



    if (lSizeUncpr==lFileSize)

    {

        if (memcmp(FilePtr,UncprPtr,lFileSize)==0)

            printf("compare ok\n");



    }



    return 0;

}

