E
NAME
        figlet  -  print  in large characters made up of ordinary screen
        characters
SYNOPSIS
        figlet [ -clnptvDEF ] [ -m smushmode ] [ -w outputwidth ]
             [ -d fontdirectory ] [ -f fontfile ] [ -o outputfile ]

DESCRIPTION
        figlet prints its input using large characters made  up  of  or-
        dinary screen  characters.   figlet output is generally reminis-
        cent of the sort of ``signatures'' many people like  to  put  at
        the end of e-mail and UseNet messages, and is oriented normally,
        not sideways as in many banner programs.
        figlet can print in a variety of fonts, with adjacent characters
        ``smushed'' together  in  various ways.  figlet fonts are stored
        in separate files, which can be identified by the suffix ``.flf.
        figlet Most figlet font files will be stored in figlet's default
        font directory.

OTHER FONT FILES & MAILING LIST
        You can get many fonts which are not in the basic Figlet package
        by    anonymous    ftp    from     ftp.isu.edu:pub/figlet/fonts.
        ftp.isu.edu:pub/figlet should also contain the latest version of
        figlet and  other  utilites  related  to figlet.  Of special in-
        terest are non-Roman fonts.  As of writing, there are Hebrew and
        Russian fonts, but more are expected.
        There is also a  mailing  list  associated  with  Figlet,  where
        software  upgrades,  new fonts, and discussion about figlet take
        place.  (You can set it so that you see only the topic you want,
        eg.  if you don't want to read  the  discussions  but  are  only
        interested  in  the upgrade notices, or new fonts.) To subscribe
        to this mailing list, send  email  to  listserv@vmd.cso.uiuc.edu
        with  the message "subscribe figlet-l YOUR NAME" where YOUR NAME
        should be replaced with your name.

USAGE
        Just start up figlet (type ``figlet) and then type whatever  you
        want.   Alternatively, pipe a file or the output of another com-
        mand through figlet.  See EXAMPLES for other things to do.

OPTIONS
        figlet reads command line options from left to right,  and  only
        the last  option that affects a parameter has any effect.  Every
        option (except -v and -F) has an inverse, so that, for  example,
        if  figlet  is  customized with a C-shell alias, all the options
        are still available.

        -c

        -l -c centers the output horizontally.  -l puts it back to left-
        justified (default).

        -d fontdirectory Change the default font directory.  figlet looks
        for fonts first in the default directory and then in the current
        directory.  If the -d option is not specified, figlet  uses  the
        directory that  was specified when it was compiled.  To find out
        which directory this is, use the -F option.

        -f fontfile Select the font.  The .flf suffix may be left off  of
        fontfile, in which case figlet automatically appends it.  figlet
        looks  for the file first in the default font directory and then
        in the current directory, or, if fontfile was given  as  a  full
        pathname, in the given directory.
        
        -o outputfile Choose a file that figlet will output the text to.
        Added for the Atari by Richard Morris.

        -woutputwidth Sets the outputwidth to the given integer.  figlet
        uses the outputwidth to determine when to break lines and how to
        center the  output.  Normally, figlet assumes 80 columns so that
        people with wide terminals won't annoy the  people  they  e-mail
        figlet output to.  -w and -t override each other.

        -msmushmode  Specifies  how  figlet should ``smush'' consecutive
        characters together.  This option is rarely needed, as a  figlet
        font  file  specifies  the  best smushmode to use with the font.
        smushmode can be one of:

        -2 Get mode from font file (default).  Every  figlet  font  file
        specifies the best smushmode to use with the font.  This will be
        one of the following smushmodes (-1 through 63).

        -1 No smushing.  Characters are simply concatenated together.
        In  any  non-negative  smushmode  figlet  pushes  adjacent  font
        characters together until their non-blank portions  touch.    At
        that  point,  it  may  or may not push the two font characters 1
        screen character closer, depending on the  smushmode.    Pushing
        font  characters  one step closer requires ``smushing'' two non-
        blank screen characters into a single screen character.   figlet
        has  6 ways of doing this, represented by 1, 2, 4, 8, 16 and 32.
        The various non-negative smushmodes (0-63) are obtained  by  ad-
        ding up the numbers corresponding to the sort of smushing figlet
        should do.

        1 Smush  equal  characters.    Two screen characters are smushed
        into a single character if they are the  same.    The  resulting
        character is  the same as both of the original characters.  This
        mode does not smush the character known as a hardblank, which is
        a character that prints as a blank, but is not  smushed  (except
        in   mode  32).  See  FONTFILEFORMAT  for  more  information  on
        hardblanks.

        2 Smush underscores.  An underscore will be  smushed  into  (and
        replaced by) any of ``|/\[]{}()<>''.

        4 Hierarchy  smushing.   Smushes certain characters together ac-
        cording to a hierarchy  containing  6  classes:  ``|'',  ``/\'',
        ``[]'', ``{}'',  ``()'',  ``<>''.   A member of any class can be
        smushed into and replaced by a member of any later class.

        8 Opposite pair smushing, type I.    Smushes  opposing  brackets
        (``[]''),  braces  (``{}'')  and  parentheses (``()'') together,
        replacing them with a vertical bar (`|').

        16 Opposite pair smushing, type II.   Smushes  opposing  slashes
        (``/\'') and less-than/greater-than (``<>'') together, replacing
        them with an upper-case `X'.

        32 Hardblank smushing.  Smushes two hardblanks together, replac-
        ing them  with  a single hardblank.  See FONTFILEFORMAT for more
        information on hardblanks.

        -p

        -n -p puts figlet into paragraph  mode,  which  eliminates  some
        spurious  line  breaks  when  piping  a  multi-line file through
        figlet.  In paragraph mode, figlet treats line breaks  within  a
        paragraph   as   if  they  were  merely  blanks  between  words.
        (Specifically, -p causes figlet to convert any newline which  is
        not  preceded by a newline and not followed by a space character
        into a blank.) -n puts figlet back to normal (default), in which
        every newline figlet reads causes it to produce a line break.

        -t Sets the outputwidth to the terminal width.  If the  terminal
        width  is  not  known,  the  previous  outputwidth  is retained.
        figlet uses the outputwidth to determine when to break lines and
        how to center the output.  Normally, figlet assumes  80  columns
        so  that  people with wide terminals won't annoy the people they
        e-mail figlet output to.  -w and -t override each other.

        -v Prints  out  the  version  and  copyright  information,  then
        exits.

        -D

        -E -D  switches  to  the  German (Deutsch) character set.  Turns
        `[', `\' and `]' into umlauted A, O and U, respectively.    `{',
        `|'  and  `}'  turn  into  the respective lower case versions of
        these.  `~' turns  into  s-z.    -E  switches  back  to  English
        (default). No other character sets are currently supported.

        -F  Displays  the  name of the default font and the default font
        directory, along with the names  of  the  figlet  fonts  in  the
        default directory, then exits.  (This will reflect any change of
        the default directory with the -d option, as long as -d is given
        before the -F).

EXAMPLES
        To use figlet with its default settings, simply type
                
                
                example% figlet
                
                
        and then type whatever you like.
        Use the -c option if you would prefer centered output:
                
                
                example% figlet -c
                
                
        To change the font, use the -f option, for example,
                
                
                example% figlet -f script
                
                
        To  see  what fonts are available in the default font directory,
        use -F:
                
                
                example% figlet -F
                
                
        We have found the most common usage of figlet to  be  making  up
        large text  to  be  placed in e-mail messages.  For this reason,
        figlet defaults to 80 column output.  If you are using  a  wider
        terminal,  and  would  like figlet to use the full width of your
        terminal, use the -t option:
                
                
                example% figlet -t
                
                
        If figlet gets its input from a file, it is often a good idea to
        use -p:
                
                
                example% figlet -p < myfile
                
                
        Of course, most of the above can be combined:
                
                
                example% figlet -ptf shadow < anotherfile
                example% figlet -cf slant
                
                

        Other Things to Try

        On many systems nice effects can be obtained from the lean  font
        by piping  it  through  tr.   Some you might want to try are the
        following:
                
                example% figlet -f lean | tr ' _/' ' ()'
                example% figlet -f lean | tr ' _/' './\\'
                example% figlet -f lean | tr ' _/' ' //'
                example% figlet -f lean | tr ' _/' '/  '
                
        Similar things can be done with the block font.

FONT FILE FORMAT
        If you would like to design a figlet font, it is usually best to
        begin with an already-existing font.  Except for the first  line
        of a  font  file, most of the file format should be obvious.  If
        you design a font, please let us know about it!    (See  AUTHORS
        for e-mail addresses.)
        A figlet font filename must have the suffix ``.flf.
        A figlet font file begins with a header.  The header consists of
        one  line giving information about the font, followed by zero or
        more comment lines, which figlet ignores.  Following the  header
        is the font data.

        The Header

        The first line of a figlet font file is of the following form:
                flf2ahardblank height up_ht maxlen smushmode cmt_count
        for example:
                
                flf2a$ 6 5 20 15 1
                
        The  first  five  characters  of  a font file should be ``flf2a.
        ``flf2 is the magicnumber of a figlet 2 font  file.    The  next
        character (`a)  is  currently ignored.  It may mean something in
        future versions of figlet.  If/when it does,  you  can  be  sure
        your fonts will still work if this character is `a.
        Immediately  following  this  is the hardblank (character). Note
        that there are no blanks  between  ``flf2a  and  the  hardblank.
        figlet  can  smush  together  consecutive  characters in various
        ways.  Normally, any character can be smushed into a blank.    A
        hardblank  prints  as  a  blank,  but cannot be smushed into any
        character except a blank,  and,  if  smushmode  32  is  enabled,
        another hardblank.  (For example, the `r' in script.flf contains
        a hardblank,  `$'  in  that font.  To see why this is necessary,
        create a copy of script.flf with this hardblank  replaced  by  a
        blank.  In this new font, the ``tr'' combination looks awful.)
        By convention, the hardblank is a `$', but it can be any charac-
        ter besides  blank,  newline  and  null.  If you want the entire
        printing ASCII set  available  to  use,  make  the  hardblank  a
        <delete> character.
        Then  comes  the  height (integer). This is the number of screen
        lines high that each character in the font is.
        up_ht (integer) is the number of lines from the  baseline  of  a
        character to the top of the character, i.e., it is the height of
        a character,  ignoring any descenders.  This number is currently
        ignored by figlet, but future versions may use it.
        maxlen (integer) is the maximum length of a  line  in  the  font
        file (excluding the first line and the comments lines, which can
        be as long as you want).  You are free to make this a little (or
        alot) too  large  as  a  safety  measure.    As  an added safety
        measure, figlet adds a fudge factor to maxlen.
        smushmode (integer)  determines  how  much  figlet  smushes  the
        font.  Possible smushmodes are -1 through 63.  Typically, you'll
        want  to  use -1 (no smushing), 0 (push font characters together
        until they touch) or  15  (smush  various  pairs  of  characters
        together into   single   characters).    To  try  out  different
        smushmodes with your font, use the -m command-line option.   See
        OPTIONS  for  a  more  detailed explanation of these smushmodes.
        (Note that a smushmode of -2 can be given on the  command  line,
        but not in a font file.)
        Between the first line and the actual characters of the font are
        the comment  lines.    Cmt_count  specifies how many lines there
        are.  These lines are optional, may be as long as you want,  and
        are ignored by figlet.
        Thus,  a  complete  figlet  font file header will look something
        like the following:
                
                flf2a$ 6 5 20 15 1
                Example by Glenn Chappell 7/93
                

        The Font Data

        The font data begins on the next line  after  the  comments  and
        continues to  the  end  of the file.  The characters from ` ' to
        `~' are given in standard ASCII order,  followed  by  the  extra
        German  characters: umlauted `A', `O', `U', `a', `o' and `u' and
        s-z.  Each character uses height lines, where height  was  given
        on the  first line of the font file.  The characters in the file
        are given exactly as  they  should  be  printed  out,  with  two
        exceptions:  (1)  hardblanks  should be the hardblank character,
        not a blank, and (2) every line has an endmark character.
        In most figlet fonts, the endmark is either `@' or '#'.   figlet
        eliminates  the  last block of consecutive equal characters from
        each line (other than the header lines) when the  file  is  read
        in.   By  convention,  the  last  line of a font character has 2
        endmarks, while all the rest have one.  This makes  it  easy  to
        see where  characters  begin  and end.  No line should have more
        than 2 endmarks.
        It is very important that every character in a font has the same
        height, and, once the endmarks are removed, that all  the  lines
        constituting a  single  font character have the same length.  Be
        careful also that no  lines  in  the  font  file  have  trailing
        blanks, as figlet will take these to be the endmarks.
        If  you  don't  want  to define all the characters, make the un-
        defined characters empty,  i.e.,  each  line  of  the  character
        should consist only of an endmark.
        The   blank   character  should  usually  be  made  entirely  of
        hardblanks.  (Some slanted fonts are an exception.)
        Again, if you design a font, please let us know!

FILES

        file.flf figlet font file

DIAGNOSTICS
        figlet's  diagnostics  are  intended  to  be   self-explanatory.
        Possible messages are
                
                Usage: ...
                Out of memory
                Unable to open font file
                Not a Figlet 2 font file
                Unable to open directory
                
                "-t" is disabled, since ioctl is not fully implemented.
                
        This  last  message  is printed when the -t option is given, but
        the operating system in use does not  include  the  system  call
        figlet uses to determine the terminal width.

ORIGIN
        ``figlet stands for ``Frank, Ian and Glenn's LETters''. Inspired
        by Frank's
 .sig, Glenn wrote (most of) it, and Ian helped.
        Most  of the figlet fonts were inspired by signatures on various
        UseNet articles.  Since typically hundreds  of  people  use  the
        same  style  of  letters  in their signatures, it was not deemed
        necessary to give credit to any one font designer.

BUGS
        Very little error checking is done on font files.  While  figlet
        tries  to  be  forgiving of errors, and should (hopefully) never
        actually crash, using an  improperly-formatted  font  file  with
        figlet will produce unpredictable output.
        figlet  does  not  handle  formatting  characters  in a very in-
        telligent way.  A tab character is converted  to  a  blank,  and
        vertical-tab,  form-feed  and carriage-return are each converted
        to a newline.  On many systems, tabs can be  handled  better  by
        piping files through expand before piping through figlet.
        figlet   output   is   quite  ugly  if  it  is  displayed  in  a
        proportionally-spaced font.  I suppose this is to be expected.

AUTHORS
        Glenn Chappell <ggc@uiuc.edu> did most of the  work.    You  can
        e-mail him  but he is not an e-mail fanatic...  people who email
        Glenn will probably get answers,  but  if  you  email  his  best
        friend:
        Ian  Chai  <spectre@uiuc.edu>  (or  figlet@uiuc.edu),  who is an
        e-mail fanatic, you'll get answers, endless  conversation  about
        the  mysteries  of  life,  invitations  to join some 473 mailing
        lists and a free  toaster.    (Well,  ok,  maybe  not  the  free
        toaster.)
        Frank inspired this whole project with his .sig, but don't email
        him...  he's decidedly an un-email-fanatic.

