/**************************************************************************\
|** eXtensions to AES ver 0.35 <MultiTOS 1.04  Compatible> by Ken Hollis **|
|**************************************************************************|
|** This library is offerred as an extension to the AES library that is  **|
|** already a part of your Atari ST.  It offers some extensions to func- **|
|** tions that are not available to the standard AES library, and some   **|
|** that are, but just "jazzed" up a bit more.  Notice to C.ROUNTREE2:   **|
|** Well, Christian, you can see you will need to work a lot harder!  :) **|
|**************************************************************************|
|** This library offers the following features:  Up to 8 fully selectable**|
|** and managable windows on desktop at a time, Popup windows with ultra **|
|** fast selection routines, Custom editing routine, Custom form_button  **|
|** replacement and form_keybd replacements, Extended Object Types and   **|
|** sensing routines, Easy macros provided as extensions, and much more! **|
|**************************************************************************|
|** As you can see, I have quite a bit more work to do on these routines **|
|** but I have seen some of the routines that people have made, and I can**|
|** say that I am both impressed and not-so impressed.                   **|
|**************************************************************************|
|** Please note that although indeces are given for MY Extended Object   **|
|** Types, they are not official since Atari has reported that it is     **|
|** reserving Extended Object Types for its own use.  Once I get the     **|
|** official object types, I will not be using or demonstrating any of   **|
|** the effects created with Extended Object Types, therefore the modify **|
|** object tree function will not be included in any of the few upcoming **|
|** versions of XAES.  You can call them, they are just not demonstrated.**|
|** Also, remember - for MultiTOS/Falcon030 applications, all buttons    **|
|** should contain the Draw3D flag!                                      **|
|**************************************************************************|
|** XAES was conceived, designed and programmed by Ken Hollis (Jigen)    **|
|** Ideas contributed by Olaf Meisiek, Dan Hollis, E_GEM, APP_LIB, GEM++ **|
|** GEM dialog box slider routines by Tom Hudson (ANALOG/ANTIC Magazine) **|
|** GEM help provided by Dan Hollis, and Tim Oren                        **|
|**************************************************************************|
|** Although many pieces of source code were downloaded from InterNET and**|
|** examined, I can assure you that none of the code was stolen.  All    **|
|** code (except for Tom Hudson's part) is totally original. - Jigen '93 **|
|**************************************************************************|
|** This library is SourceWare.  Please feel free to include it and use  **|
|** it in your own programs.  You may modify it for your own usage if you**|
|** feel the need, but please don't give it away in modified form.  If   **|
|** you choose to use it, please give Ken Hollis the credits for writing **|
|** the source code.  SourceWare made possible by BitGate Software PD    **|
|** SourceWare is a priviledge, so please don't abuse your priviledge!   **|
|**************************************************************************|
|** Although it is going to be sold, it will remain SourceWare until     **|
|** further notice, so start including these routines into your programs **|
|** while you have a chance now, or you may not get a chance later!      **|
\**************************************************************************/

#ifndef	XAES_MACROS		/* XAES macros defined yet? */
#define	XAES_MACROS		/* if not, define them */
#define	FreeResource		(void)rsrc_free();	/* GEM Macro */
#define	ChangeMouseStyle(i)	(void)graf_mouse(i,0L);	/* GEM Macro */
#define	BeginUpdate		(void)wind_update(BEG_UPDATE);
#define	EndUpdate		(void)wind_update(END_UPDATE);
#endif				/* No more macros for now */

#ifndef BIOS_OUTPUTS		/* BIOS input/output ports */
#define	BIOS_OUTPUTS		/* May not be compatible with Falcon030 */
#define	LINE_PRT	0	/* Line printer */
#define	AUX_PRT		1	/* Serial port */
#define	CON_PRT		3	/* Console port */
#endif				/* No more defines for now */

#ifndef	WINDOW_CONTROLS		/* Are we already defined? */
#define	WINDOW_CONTROLS		/* No, go ahead and define. */
#define	APP_ERR		-1	/* Application initialization error */
#define	APPEX_ERROR	0	/* Application exit error */
#define NOT_POPUP	1	/* Not a popup type - ExtObType = 10 */
#define	NOT_SLIDER	2	/* Not a slider - ExtObType = 11 */
#define	NOT_MOVER	3	/* Not a movable object - ExtObType = 17 */
#define	NOT_SUBMENU	4	/* Not a submenu type - ExtObType = 12 */
#define	BOTH_BUTTON_UP	0	/* Button return masks */
#define	LEFT_BUTTON_DN	1	/* Left button down */
#define	RIGHT_BUTTON_DN	2	/* Right button down */
#define BOTH_BUTTON_DN	3	/* Both buttons down */
#define	DESKTOP_HANDLE	0	/* Desktop screen dimensions */
#endif				/* End definition check */

#ifndef	WR_STANDARDS		/* Wind_return standards defined? */
#define	WR_STANDARDS		/* No, then define */
#define	WIND_SELECTED	-1	/* Another window was selected */
#define	OKSTD_SELECTED	-2	/* "OK" button standard was selected */
#define	CANSTD_SELECTED	-3	/* "CANCEL" button standard was selected */
#endif

#ifndef	EOBT_STANDARDS		/* Although some are not used, they will */
#define	EOBT_STANDARDS		/* eventually be implemented.  EOBStd's */
#define	OK_STANDARD	1	/* "OK" button standard */
#define	CANCEL_STANDARD	2	/* "CANCEL" button standard */
#define	MOVE_STANDARD	3	/* Movable dialog box standard */
#define	ULINE_STANDARD	4	/* Underlined text standard */
#define	POPUP_STANDARD	5	/* Popup type standard */
#define	SUBMNU_STANDARD	6	/* Submenu standard (not used) */
#define	SLIDE_STANDARD	7	/* Slider standard */
#define	ESLIDE_STANDARD	8	/* Extended slider standard (not used) */
#define	DRAW3D_STANDARD	9	/* Draw 3-D standard (not used) */
#define	RADIO_STANDARD	10	/* Circle drawn radio button (not used) */
#define	KBSEL_STANDARD	11	/* Keyboard selectable object (not used) */
#define	WCASC_STANDARD	12	/* Cascadable window standard (not used) */
#define	WMENU_STANDARD	13	/* Menu-in-a-window standard (not used) */
#define	MAR_STANDARD	14	/* Move-and-redraw standard (not used) */
#define	EOBF_MOVE	17	/* Movable dialog box (EXTOBFIX standard) */
#define	EOBF_ULINE	19	/* Underline (EXTOBFIX standard) */
#endif				/* No more definitions for now... */

#ifndef	WINDOW_FAILS		/* Window fail return values defined? */
#define	WINDOW_FAILS		/* No, then define them */
#define	NO_WIND_FAILURE	0	/* No window failures reported */
#define	NOMORE_WINDOWS	-1	/* No more windows can be made */
#define	NOT_MOVABLE	-1	/* Not movable - too large */
#define	NOT_SLIDABLE	-2	/* Not slidable - not enough room */
#define	XAES_INIT_FAIL	-1	/* XAES initialization failure */
#endif				/* No more failures for now... */

#ifndef	MYMSG_RETURNS		/* MyMessage buffer return values */
#define	MYMSG_RETURNS		/* Define them if not defined already */
#define	NOMSG_ID	-1	/* No message ID returned */
#define	OBJC_ID		200	/* Object selected message */
#define	MENU_ID		201	/* Menu selected message */
#define	RES1_ID		202	/* Reserved ID */
#define	RES2_ID		203	/* Reserved ID */
#define	RES3_ID		204	/* Reserved ID */
#define	RES4_ID		205	/* Reserved ID */
#define	RES5_ID		206	/* Reserved ID */
#endif				/* More will be added, don't worry. */

#ifndef	EVENT_SCANS		/* Keyboard event codes returned */
#define	EVENT_SCANS		/* Are they already defined? */
#define	SCANRET		7181
#define	SCANENTER	29197
#define	SCANUNDO	24832
#define	SCANHELP	25088
#define	SCANUP		18432
#define	SCANDOWN	20480
#define	SCANLEFT	19200
#define	SCANCTRLLEFT	29440
#define	SCANCTRLRIGHT	29696
#define	SCANRIGHT	19712
#define	SCANTAB		3849
#define	SCANHOME	18176
#define	SCANSHIFTHOME	18231
#define	SCANDEL		21375
#define	SCANINS		20992
#endif				/* No more keycodes forever */

#ifndef	XAES_VARS		/* XAES Screen variables defined? */
#define	XAES_VARS		/* No, then define them. */
GRECT	desk;			/* Desktop screen coordinates */
#endif				/* No more screen variables for now */

#ifndef	MYMSG			/* Mymsg buffer installed yet? */
typedef struct specialmsg {	/* No, then define it below: */
	int	MsgType,ObjSelected,TitleSelected,ItemSelected;
} MYMSG;
#endif				/* No more buffered stuff for now */

#ifndef	POPUP_VARS		/* Popup variables/typedefs defined? */
#define	POPUP_VARS		/* No, then define them! */
typedef	struct pops {
	int	LastSelPop[10];	/* Up to 10 popups positionable in memory */
} POPS;				/* Our great little label - POPS and pops */
#endif				/* No more additions for now... */

#ifndef	GLOBALS			/* Global variables defined? */
#define	GLOBALS			/* If not, then define them! */
extern	int	gl_apid;
	int	ap_id;
	int	phys_handle,handle;	
	int	cellw,cellh,chspcw,chspch;
	int	work_in[12],work_out[57];
	int	contrl[12],intin[128],ptsin[128],intout[128],ptsout[128];
#endif				/* No more global variables for now... */

#ifndef	Bool
typedef enum {FALSE,TRUE} Bool;
#endif

#ifndef OBX
typedef struct objx {
	Bool	Closed[8];			/* Window closed flag */
	int	WindowHandles[8];		/* GEM Window handle */
	int	PosX[8],PosY[8],PosW[8],PosH[8];/* Position of window */
	int	Dial[8];			/* Dialog window idx */
	int	CurrEdit[8];			/* Cursor location */

/* --> Private variable segment, only used by XAES and not programmer <-- */

	int	CursPos[8];			/* Cursor position */
	Bool	EditAlreadyDisp[8];		/* Curs already disp flag */
	Bool	JustOpened[8];			/* Just created flag */
} OBX;
#endif

#ifdef	POPUP_VARS		/* Are the popup variables defined? */
POPS	GlobPop;		/* Yes, then define our global stuff */
#endif				/* And do no more for here. */

#ifndef	THUD_VARS		/* Tom Hudson's slider vars defined? */
#define	THUD_VARS		/* if not, then define them. */
long	slidstep[10],slidacc[10];
int	slidpos[10],slidmax[10];
static	int mousex,mousey,dum,moved;
static	int tbasex,tbasey,sbasex,sbasey;
#endif

#ifndef	XAES_GLOBS		/* XAES Global variables defined? */
#define	XAES_GLOBS		/* No, then define them. */
int	CurrWindow;
OBX	WStuff;
long	_stksize = 16000;
#endif

#ifndef	ED_START		/* GEM Binding for ED_START defined? */
#define	ED_START	0	/* ED_START is reserved */
#define	ED_INIT		1	/* ED_INIT enables the text cursor */
#define	ED_CHAR		2	/* ED_CHAR processes the character */
#define	ED_END		3	/* ED_END disables the text cursor */
#endif				/* No more bindings (GEM/XAES) for now */

#ifndef	XAES_CODE		/* XAES code already installed? */
#define	XAES_CODE		/* If no, then install it! */
void	CloseWorkspace()
{
	v_clsvwk(handle);
	handle = phys_handle;
}

void	ExitApplication()
{
	int	i;

	i = appl_exit();
	if (i==APPEX_ERROR) printf("An error occurred while exiting to GEM.\n");
}

void	FindDialog(index,adr)
int	index;
OBJECT	**adr;
{
	OBJECT	*dummy;

	rsrc_gaddr(R_TREE, index, &dummy);
	*adr = dummy;
}

void	CenterDialog(adr)
OBJECT	*adr;
{
	form_center(adr,&adr->ob_x,&adr->ob_y,&adr->ob_width,&adr->ob_height);
}

int	DoDialogComplete(index,stob,gs)
int	index;
int	stob;
int	gs;
{
	OBJECT	*ob;
	int	i;

	rsrc_gaddr(R_TREE, index, &ob);
	form_dial(FMD_START,0,0,0,0,ob->ob_x,ob->ob_y,ob->ob_width,
		  ob->ob_height);
	if (gs==1) {
		form_dial(FMD_GROW,320,100,1,1,ob->ob_x,ob->ob_y,
			  ob->ob_width,ob->ob_height);
	}
	objc_draw(ob,ROOT,MAX_DEPTH,ob->ob_x,ob->ob_y,ob->ob_width,
		  ob->ob_height);
	i=form_do(ob,stob);
	form_dial(FMD_FINISH,0,0,0,0,ob->ob_x,ob->ob_y,ob->ob_width,
		  ob->ob_height);
	if (gs) {
		form_dial(FMD_SHRINK,320,100,1,1,ob->ob_x,ob->ob_y,
			  ob->ob_width,ob->ob_height);
	}
	return(i);
}

int	DoDialogNoClose(index,stob,gs)
int	index;
int	stob;
int	gs;
{
	OBJECT	*ob;
	int	i;

	rsrc_gaddr(R_TREE, index, &ob);
	form_dial(FMD_START,0,0,0,0,ob->ob_x,ob->ob_y,ob->ob_width,
		  ob->ob_height);
	if (gs) {
		form_dial(FMD_GROW,320,100,1,1,ob->ob_x,ob->ob_y,
			  ob->ob_width,ob->ob_height);
	}
	objc_draw(ob,ROOT,MAX_DEPTH,ob->ob_x,ob->ob_y,ob->ob_width,
		  ob->ob_height);
	i=form_do(ob,stob);
	return(i);
}

void	ShowDialog(index,gs)
int	index;
int	gs;
{
	OBJECT	*ob;

	rsrc_gaddr(R_TREE, index, &ob);
	form_dial(FMD_START,0,0,0,0,ob->ob_x,ob->ob_y,ob->ob_width,
		  ob->ob_height);
	if (gs) {
		form_dial(FMD_GROW,320,100,1,1,ob->ob_x,ob->ob_y,
			  ob->ob_width,ob->ob_height);
	}
	objc_draw(ob,ROOT,MAX_DEPTH,ob->ob_x,ob->ob_y,ob->ob_width,
		  ob->ob_height);
}

void	EndDialogComplete(index,gs)
int	index;
int	gs;
{
	OBJECT	*ob;

	rsrc_gaddr(R_TREE, index, &ob);
	if (gs==1) {
		form_dial(FMD_SHRINK,320,100,1,1,ob->ob_x,ob->ob_y,
			  ob->ob_width,ob->ob_height);
	}
	form_dial(FMD_FINISH,0,0,0,0,ob->ob_x,ob->ob_y,ob->ob_width,
		  ob->ob_height);
}

int	ReturnObjectState(obj,idx)
OBJECT	*obj;
int	idx;
{
	OBJECT	*ob;

	ob=&obj[idx];
	return(ob->ob_state);
}

char	*ReturnObjectText(obj,idx)
OBJECT	*obj;
int	idx;
{
	TEDINFO	*obspec;

	obspec = (TEDINFO *)(obj + idx)->ob_spec;
	return(obspec->te_ptext);
}

void	MoveDialogRelative(dial,oldpos,newpos)
OBJECT	*dial;
int	oldpos,newpos;
{
	OBJECT	*ob,*obnewpos;
	int	obx,oby,obnx,obny;

	ob = &dial[ROOT];
	rsrc_gaddr(R_TREE, oldpos, &ob);
	obnewpos = &dial[newpos];
	rsrc_gaddr(R_OBJECT, newpos, &obnewpos);
	objc_offset(ob,oldpos,&obx,&oby);
	obnx = (obnewpos->ob_x)-obx;
	obny = (obnewpos->ob_y)-(oby-1);
	ob->ob_x = obnx;
	ob->ob_y = obny;
	if (ob->ob_x+ob->ob_width>desk.g_x+desk.g_w) ob->ob_x = desk.g_x+desk.g_w-ob->ob_width;
	if (ob->ob_y+ob->ob_height>desk.g_y+desk.g_h) ob->ob_y = desk.g_y+desk.g_h-ob->ob_height;
}

void	OpenWorkspace()
{

	int	x;
	int	temp[4];

	for (x = 0; x < 10; work_in[x++] = 1);
	work_in[10] = 2;
	handle = phys_handle = graf_handle(&cellw,&cellh,&chspcw,&chspch);
	v_opnvwk(work_in, &handle, work_out);
	graf_mouse(M_OFF,0L);
	vsf_interior(handle,2);
	vsf_style(handle,8);
	vsf_color(handle,GREEN);
	temp[0]=desk.g_x; temp[1]=desk.g_y; temp[2]=desk.g_w; temp[3]=desk.g_h;
	v_bar(handle,temp);
	vsf_color(handle,1);
	graf_mouse(M_ON,0L);
}

void	MoveDialog(index,gs)
int	index;
Bool	gs;
{
	OBJECT	*ob;
	int	ox,oy,ow,oh,nx,ny;

	rsrc_gaddr(R_TREE, index, &ob);
	graf_mouse(FLAT_HAND,0L);
	ox = ob->ob_x;
	oy = ob->ob_y;
	ow = ob->ob_width;
	oh = ob->ob_height;
	graf_dragbox(ow,oh,ox,oy,desk.g_x,desk.g_y,desk.g_w,desk.g_h,&nx,&ny);
	EndDialogComplete(index, gs);
	ob->ob_x = nx;
	ob->ob_y = ny;
	graf_mouse(ARROW);
}

void	Redraw_Part_Dialog(index,clip)
int	index;
int	clip[4];
{
	OBJECT	*ob;

	rsrc_gaddr(R_TREE, index, &ob);
	form_dial(FMD_START,0,0,0,0,clip[0],clip[1],clip[2],clip[3]);
	objc_draw(ob,ROOT,MAX_DEPTH,clip[0],clip[1],clip[2],clip[3]);
}

void	RepositionDialog(index,clip)
int	index;
int	clip[4];
{
	OBJECT	*ob;

	rsrc_gaddr(R_TREE, index, &ob);
	ob->ob_x = clip[0];
	ob->ob_y = clip[1];
}

void	ChangeObjectState(obj,idx,state)
OBJECT	*obj;
int	idx,state;
{
	OBJECT	*ob;

	ob=&obj[idx];
	ob->ob_state = state;
}

void	ChangeObjectText(obj,idx,txt,size,just)
OBJECT	*obj;
int	idx;
char	*txt;
int	size,just;
{
	TEDINFO	*obspec;

	obspec = (TEDINFO *)(obj + idx)->ob_spec;
	(char *)obspec.te_ptext = txt;
	obspec.te_txtlen = strlen(txt);
	obspec.te_font = size;
	obspec.te_just = just;
}

void	DoDialogDraw(index,gs)
int	index;
int	gs;
{
	OBJECT	*ob;

	rsrc_gaddr(R_TREE, index, &ob);
	form_dial(FMD_START,0,0,0,0,ob->ob_x,ob->ob_y,ob->ob_width,
		  ob->ob_height);
	if (gs==1) {
		form_dial(FMD_GROW,320,100,1,1,ob->ob_x,ob->ob_y,
			  ob->ob_width,ob->ob_height);
	}
	objc_draw(ob,ROOT,MAX_DEPTH,ob->ob_x,ob->ob_y,ob->ob_width,
		  ob->ob_height);
}

/****************************************************/
/* RESET HORIZONTAL SLIDER                          */
/* -----------------------                          */
/* Parameters:                                      */
/* number  = slider number (0-9)                    */
/* tree    = address of dialog tree                 */
/* trackix = index of slider track                  */
/* slidix  = index of slider                        */
/* maximum = maximum slider setting (0-maximum)     */
/* initial = initial slider setting (0-maximum)     */
/****************************************************/

HorizontalSlideReset(number,tree,trackix,slidix,maximum,initial)
int number,tree[][12],trackix,slidix,maximum,initial;
{
slidmax[number]=maximum;
slidpos[number]=initial;
slidstep[number]=((long)(tree[trackix][10]-tree[slidix][10])<<16)/(long)maximum;
slidacc[number]=slidstep[number]*(long)initial;
tree[slidix][8]=(int)(slidacc[number]>>16);
objc_draw(tree,trackix,1,tree[0][8],tree[0][9],tree[0][10],tree[0][11]);
}

/****************************************************/
/* PROCESS HORIZONTAL SLIDER                        */
/* -------------------------                        */
/* Parameters:                                      */
/* number  = slider number (0-9)                    */
/* tree    = address of dialog tree                 */
/* trackix = index of slider track                  */
/* slidix  = index of slider                        */
/* leftix  = index of left-move button              */
/* rightix = index of right-move button             */
/* whichix = index of item from form_do             */
/* trakstep = # of steps for in-track click         */
/****************************************************/

DoHorizontalSlide(number,tree,trackix,slidix,leftix,rightix,whichix,trakstep)
int tree[][12],trackix,slidix,leftix,rightix,whichix,trakstep;
{
	register int ix;
	int tempx;

	moved=0;

	if(whichix==trackix) {
		graf_mkstate(&mousex,&mousey,&dum,&dum);
		objc_offset(tree,slidix,&sbasex,&dum);
		if(mousex>sbasex) {
			for(ix=0; ix<trakstep; ++ix) {
				if(slidpos[number]<slidmax[number]) {
					slidacc[number]+=slidstep[number];
					slidpos[number]++;
					moved=1;
				} else break;
			}
		} else {
			for(ix=0; ix<trakstep; ++ix) {
				if(slidpos[number]>0) {
					slidacc[number]-=slidstep[number];
					slidpos[number]--;
					moved=1;
				} else break;
			}
		}
	} else if(whichix==rightix) {
		if(slidpos[number]<slidmax[number]) {
			slidacc[number]+=slidstep[number];
			slidpos[number]++;
			moved=1;
		}
	} else if(whichix==leftix) {
		if(slidpos[number]>0) {
			slidacc[number]-=slidstep[number];
			slidpos[number]--;
			moved=1;
		}
	} else if(whichix==slidix) {
		objc_offset(tree,slidix,&sbasex,&sbasey);
		objc_offset(tree,trackix,&tbasex,&tbasey);
		graf_dragbox(tree[slidix][10],tree[slidix][11],sbasex,sbasey,
			     tbasex,tbasey,tree[trackix][10],tree[trackix][11],
			     &tempx,&dum);
		if(tempx!=sbasex) {
			slidacc[number]=(long)(tempx-tbasex)<<16;
			slidpos[number]=(int)(slidacc[number]/slidstep[number]);
			slidacc[number]=(long)slidpos[number]*slidstep[number];
			moved=1;
		}
	}

	if(moved) {
		tree[slidix][8]=(int)(slidacc[number]>>16);
		objc_draw(tree,trackix,1,tree[0][8],tree[0][9],tree[0][10],tree[0][11]);
	}
}

/****************************************************/
/* RESET VERTICAL SLIDER                            */
/* ----------------------                           */
/* Parameters:                                      */
/* number  = slider number (0-9)                    */
/* tree    = address of dialog tree                 */
/* trackix = index of slider track                  */
/* slidix  = index of slider                        */
/* maximum = maximum slider setting (0-maximum)     */
/* initial = initial slider setting (0-maximum)     */
/****************************************************/

VerticalSlideReset(number,tree,trackix,slidix,maximum,initial)
int number,tree[][12],trackix,slidix,maximum,initial;
{
	long work1;

	slidmax[number]=maximum;
	slidpos[number]=initial;
	work1=(long)(tree[trackix][11]-tree[slidix][11])<<16;
	slidstep[number]=work1/(long)maximum;
	slidacc[number]=work1-slidstep[number]*(long)initial;
	tree[slidix][9]=(int)(slidacc[number]>>16);
	objc_draw(tree,trackix,1,tree[0][8],tree[0][9],tree[0][10],tree[0][11]);
}

/****************************************************/
/* PROCESS VERTICAL SLIDER                          */
/* -----------------------                          */
/* Parameters:                                      */
/* number  = slider number (0-9)                    */
/* tree    = address of dialog tree                 */
/* trackix = index of slider track                  */
/* slidix  = index of slider                        */
/* upix    = index of up-move button                */
/* downix  = index of down-move button              */
/* whichix = index of item from form_do             */
/* trakstep = # of steps for in-track click         */
/****************************************************/

DoVerticalSlide(number,tree,trackix,slidix,upix,downix,whichix,trakstep)
int tree[][12],trackix,slidix,upix,downix,whichix,trakstep;
{
	register int ix;
	int tempy;

	moved=0;

	if(whichix==trackix) {
		graf_mkstate(&mousex,&mousey,&dum,&dum);
		objc_offset(tree,slidix,&dum,&sbasey);
		if(mousey>sbasey) {
			for(ix=0; ix<trakstep; ++ix) {
				if(slidpos[number]>0) {
					slidacc[number]+=slidstep[number];
					slidpos[number]--;
				}
			}
			moved=1;
		} else {
			for(ix=0; ix<trakstep; ++ix) {
				if(slidpos[number]<slidmax[number]) {
					slidacc[number]-=slidstep[number];
					slidpos[number]++;
				}
			}
			moved=1;
		}
	} else if(whichix==downix) {
		if(slidpos[number]>0) {
			slidacc[number]+=slidstep[number];
			slidpos[number]--;
			moved=1;
		}
	} else if(whichix==upix) {
		if(slidpos[number]<slidmax[number]) {
			slidacc[number]-=slidstep[number];
			slidpos[number]++;
			moved=1;
		}
	} else if(whichix==slidix) {
		objc_offset(tree,slidix,&sbasex,&sbasey);
		objc_offset(tree,trackix,&tbasex,&tbasey);
		graf_dragbox(tree[slidix][10],tree[slidix][11],sbasex,sbasey,
		             tbasex,tbasey,tree[trackix][10],tree[trackix][11],
		             &dum,&tempy);
		if(tempy!=sbasey) {
			slidacc[number]=(long)(tempy-tbasey)<<16;
			slidpos[number]=slidmax[number]-(int)(slidacc[number]/slidstep[number]);
			slidacc[number]=((long)(tree[trackix][11]-tree[slidix][11])<<16)
			                -(long)slidpos[number]*slidstep[number];
			moved=1;
		}
	}

	if(moved) {
		tree[slidix][9]=(int)(slidacc[number]>>16);
		objc_draw(tree,trackix,1,tree[0][8],tree[0][9],tree[0][10],tree[0][11]);
	}
}

void	Private_GtoRect(r,array)
GRECT	*r;
int	*array;
{
	*array++ = r->g_x;
	*array++ = r->g_y;
	*array++ = r->g_w;
	*array = r->g_h;
}

int	Private_ReturnEObT(adr,obj)
OBJECT	*adr;
int	obj;
{
	return((int)((adr[obj].ob_type & 0xFF00) >> 8));
}

int	Private_ReturnMouseButtonState()
{
	int	event,dummy,mx,my,bstate,clicks;
	int	msg[8];

	event = evnt_multi(MU_BUTTON|MU_TIMER,
			   0x0001,0x0001,1,0,0,0,0,0,0,0,0,0,0,msg,0x0001,0x0000,
			   &mx,&my,&bstate,&dummy,&dummy,&clicks);
	return(bstate);
}

void	Private_CloseWindow(windhand)
int	windhand;
{
	int	x,y,w,h;

	if (windhand!=-1){
		wind_get(windhand,WF_WORKXYWH,&x,&y,&w,&h);
		WStuff.Closed[windhand] = TRUE;
		WStuff.WindowHandles[windhand] = -1;
		WStuff.PosX[windhand] = 0;
		WStuff.PosY[windhand] = 0;
		WStuff.PosW[windhand] = 0;
		WStuff.PosH[windhand] = 0;
		WStuff.Dial[windhand] = 0;
		wind_close(windhand);
		graf_shrinkbox(desk.g_w/2,desk.g_h/2,2,2,x,y,w,h);
		wind_delete(windhand);
	}
}

void	Private_ClearDisplay(whand,vw)
int	whand,vw;
{
	int	temp[4];
	int	x,y,w,h;

	ChangeMouseStyle(M_OFF);
	vsf_interior(vw,2);
	vsf_style(vw,8);
	vsf_color(vw,WHITE);
	wind_get(whand,WF_WORKXYWH,&x,&y,&w,&h);
	temp[0]=x;
	temp[1]=y;
	temp[2]=x+w-1;
	temp[3]=y+h-1;
	v_bar(vw,temp);
	vsf_color(vw,1);
	ChangeMouseStyle(M_ON);
}

void	Private_DoDisplay(whand,vw)
int	whand,vw;
{
	ChangeMouseStyle(M_OFF);
	Private_ClearDisplay(whand,vw);
	ShowDialog(WStuff.Dial[whand],FALSE);
	ChangeMouseStyle(M_ON);
}

void	Private_RedrawWindow(x,y,w,h,whand,vw)
int	x,y,w,h,whand,vw;
{
	int	clip[4];
	GRECT	t1,t2;

	if (!WStuff.JustOpened[whand]) {
		ChangeMouseStyle(M_OFF);
		BeginUpdate;
		t2.g_x=x;
		t2.g_y=y;
		t2.g_w=w;
		t2.g_h=h;
		wind_get(whand,WF_FIRSTXYWH,&t1.g_x,&t1.g_y,&t1.g_w,&t1.g_h);
		while(t1.g_w && t1.g_h){
			if (rc_intersect(&t2,&t1)) {
				clip[0]=t1.g_x;	clip[1]=t1.g_y;
				clip[2]=t1.g_w;	clip[3]=t1.g_h;
				vs_clip(vw,TRUE,clip);
				Redraw_Part_Dialog(WStuff.Dial[whand],clip);
			}
			wind_get(whand,WF_NEXTXYWH,&t1.g_x,&t1.g_y,&t1.g_w,&t1.g_h);
		}
		EndUpdate;
		ChangeMouseStyle(M_ON);
	} else WStuff.JustOpened[whand] = FALSE;
}

Bool	ProcessMessage(msg,mymsg)
int	msg[8];
MYMSG	*mymsg;
{
	Bool	exitflag;
	int	clip[4];

	exitflag = FALSE;
	BeginUpdate;
	switch(msg[0]){
		case WM_CLOSED:	Private_CloseWindow(msg[3]);
				exitflag = TRUE;
				break;
		case WM_REDRAW: Private_RedrawWindow(msg[4],msg[5],msg[6],msg[7],msg[3],handle);
				break;
		case WM_NEWTOP:
		case WM_TOPPED:	wind_set(msg[3],WF_TOP,0,0,0,0);
				CurrWindow = msg[3];
				break;
		case WM_MOVED:	wind_set(msg[3],WF_CURRXYWH,msg[4],msg[5],msg[6],msg[7]);
				wind_calc(WC_WORK,(NAME|MOVER|CLOSER),msg[4],msg[5],msg[6],msg[7],&msg[4],&msg[5],&msg[6],&msg[7]);
				wind_set(msg[3],WF_WORKXYWH,msg[4],msg[5],msg[6],msg[7]);
				clip[0]=msg[4]; clip[1]=msg[5];
				clip[2]=msg[6]; clip[3]=msg[7];
				RepositionDialog(WStuff.Dial[msg[3]],clip);
				break;
		case MN_SELECTED:
				mymsg->MsgType = MENU_ID;
				mymsg->TitleSelected = msg[3];
				mymsg->ItemSelected = msg[4];
				break;
		case DEFAULT:	mymsg->MsgType = NOMSG_ID;
				break;
	}
	EndUpdate;
	return(exitflag);
}

int	NewWindowDialog(name,dialog,silence)
char	*name;
int	dialog;
Bool	silence;
{
	int	whandle;
	OBJECT	*ob;

	rsrc_gaddr(R_TREE, dialog, &ob);
	whandle = wind_create((NAME|MOVER|CLOSER),ob->ob_x,ob->ob_y-11,ob->ob_width,ob->ob_height+10);
	if ((whandle>8) || (whandle<0)) {
		if (!silence) form_alert(1,"[3][GEM/XAES cannot allocate|room for another|window.  Close and|try again.][ Okay ]");
		return(NOMORE_WINDOWS);
	} else {
		wind_set(whandle,WF_NAME,name,0,0);
		graf_growbox(desk.g_w/2,desk.g_h/2,2,2,ob->ob_x,ob->ob_y-11,ob->ob_width,ob->ob_height+10);
		wind_open(whandle,ob->ob_x,ob->ob_y-11,ob->ob_width,ob->ob_height+10);
		WStuff.Closed[whandle] = FALSE;
		WStuff.WindowHandles[whandle] = whandle;
		WStuff.PosX[whandle] = ob->ob_x;
		WStuff.PosY[whandle] = ob->ob_y-11;
		WStuff.PosW[whandle] = ob->ob_width;
		WStuff.PosH[whandle] = ob->ob_height+10;
		WStuff.Dial[whandle] = dialog;
		WStuff.JustOpened[whandle] = TRUE;
		Private_DoDisplay(whandle,handle);
		return(NO_WIND_FAILURE);
	}
}

void	XAES_InitWindowDialogs()
{
	int	i=0;

	do {
		++i;
		WStuff.Closed[i] = TRUE;
		WStuff.WindowHandles[i] = -1;
		WStuff.PosX[i] = 0;
		WStuff.PosY[i] = 0;
		WStuff.PosW[i] = 0;
		WStuff.PosH[i] = 0;
		WStuff.Dial[i] = 0;
		WStuff.CurrEdit[i] = 0;
		WStuff.CursPos[i] = 0;
		WStuff.EditAlreadyDisp[i] = FALSE;
		WStuff.JustOpened[i] = FALSE;
	} while(i!=8);
}

Bool	CheckAllClosed()
{
	if ((WStuff.WindowHandles[1]==-1) && (WStuff.WindowHandles[2]==-1) &&
	   (WStuff.WindowHandles[3]==-1) && (WStuff.WindowHandles[4]==-1) &&
	   (WStuff.WindowHandles[5]==-1) && (WStuff.WindowHandles[6]==-1) &&
	   (WStuff.WindowHandles[7]==-1) && (WStuff.WindowHandles[8]==-1)) return(TRUE); else return(FALSE);
}

int	Initialize_XAES()
{
	XAES_InitWindowDialogs();
	if (Getrez()<1) {
		form_alert(1,"[3][XAES requires 640 X 200|resolution or higher!][ Okay ]");
		return(XAES_INIT_FAIL);
	}
}

Bool	Private_ValidWindow()
{
	if (!WStuff.Closed[CurrWindow]) return(TRUE); else return(FALSE);
}

int	Private_CheckDefault(adr)
OBJECT	*adr;
{
	int	i = 1;

	do {
		if (adr[i++].ob_flags & DEFAULT) {
			return(i);
			break;
		}
	} while(!adr[i].ob_flags & LASTOB);
	return(0);
}

void	Private_ClearRadios(adr,obj)
OBJECT	*adr;
int	obj;
{
	int	i = 1;
	int	f;

	for(i=0;;i++) {
		if (((f=adr[i].ob_flags) & RBUTTON) && (i!=obj)) {
			adr[i].ob_state &= ~SELECTED;
			objc_change(adr,i,0,desk.g_x,desk.g_y,desk.g_w,desk.g_h,NORMAL,1);
		}
		if (f & LASTOB) break;
	}
}

int	Private_CheckButton(adr,obj)
OBJECT	*adr;
int	obj;
{
	int	obflags,mx,my,button,prevobj,state;
	Bool	clicked = FALSE;

	if (obj!=0) {
		prevobj = obj;
		obflags = adr[obj].ob_flags;
		state = adr[obj].ob_state;
		do {
			vq_mouse(handle,&button,&mx,&my);
			state = adr[obj].ob_state;
			if (prevobj == objc_find(adr,0,MAX_DEPTH,mx,my)) {
				if ((state & SELECTED) && (!clicked)) {
					state &= ~SELECTED;
					objc_change(adr,prevobj,0,desk.g_x,desk.g_y,desk.g_w,desk.g_h,state,1);
					goto done_button;
				}
				if (obflags & SELECTABLE) {
					state |= SELECTED;
					objc_change(adr,prevobj,0,desk.g_x,desk.g_y,desk.g_w,desk.g_h,state,1);
					clicked = TRUE;
				}
				if (obflags & RBUTTON) {
					state |= SELECTED;
					objc_change(adr,prevobj,0,desk.g_x,desk.g_y,desk.g_w,desk.g_h,state,1);
					Private_ClearRadios(adr,prevobj);
					clicked = TRUE;
				}
				if (obflags & TOUCHEXIT) goto done_touch;
			} else {
				state &= ~SELECTED;
				objc_change(adr,prevobj,0,desk.g_x,desk.g_y,desk.g_w,desk.g_h,state,1);
				clicked = TRUE;
			}
		} while(button);
		done_button: {
			do {
				vq_mouse(handle,&button,&mx,&my);
			} while(button);
			if (state & SELECTED) return(prevobj);
		}
		done_touch: {
			if (state & SELECTED) return(prevobj);
		}
		return(0);
	}
}

Bool	Private_Opened(i)
int	i;
{
	int	x = 1;
	Bool	found = FALSE;

	do {
		if (WStuff.Dial[x++]==i) found = TRUE;
	} while(x<8);
	return(found);
}

void	GetMYMSG(msg,menu)
MYMSG	*msg;
OBJECT	*menu;
{
	int	event,mg[8],mx,my,button,shift_state,key,dummy;
	Bool	done = FALSE;
	MYMSG	mesg;

	do {
		event = evnt_multi((MU_MESAG | MU_TIMER | MU_BUTTON | MU_KEYBD),
			1,1,1,0,0,0,0,0,0,0,0,0,0,mg,0x0000,
			0x0000,&mx,&my,&button,&shift_state,
			&key,&dummy);
		if (event & MU_MESAG) {
			ProcessMessage(mg,&mesg);
			msg->MsgType = MENU_ID;
			msg->TitleSelected = mesg.TitleSelected;
			msg->ItemSelected = mesg.ItemSelected;
			if (menu) menu_tnormal(menu,mesg.TitleSelected);
			done = TRUE;
		}
	} while (!done);
}

Bool	IsHidden(tree,obj,flag)
OBJECT	*tree;
int	obj;
Bool	flag;
{
	int	index = obj, next;

	if (!(tree[obj].ob_flags & HIDETREE)) {
		if (flag==TRUE || !(tree[obj].ob_state & DISABLED)) {
			while((next=tree[index].ob_next)!=-1) {
				if ((tree[index].ob_flags & HIDETREE))
					return(TRUE);
				index = next;
			}
			return(FALSE);
		}
	}
	return(TRUE);
}

Bool	IsFlag(tree,obj,flag,mask)
OBJECT	*tree;
int	obj,flag,mask;
{
	if ((flag & mask) && (!IsHidden(tree,obj,FALSE))) return(TRUE); else
		return(FALSE);
}

void	FirstEdit(tree,Window)
OBJECT	*tree;
int	Window;
{
	int	index = 0;

	if (WStuff.CurrEdit[Window]) {
		do {
			index++;
			if (IsFlag(tree,index,tree[index].ob_flags,EDITABLE)==TRUE) {
				WStuff.CurrEdit[Window] = index;
				break;
			}
		} while(!(tree[index].ob_flags & LASTOB));
	}
}

void	LastEdit(tree,Window)
OBJECT	*tree;
int	Window;
{
	int	index,last;

	index = last = 0;
	if (WStuff.CurrEdit[Window]) {
		do {
			index++;
			if (IsFlag(tree,index,tree[index].ob_flags,EDITABLE)==TRUE)
				last = index;
		} while(!(tree[index].ob_flags & LASTOB));
		if (last) WStuff.CurrEdit[Window] = index;
	}
}

void	NextEdit(tree,Window)
OBJECT	*tree;
{
	int	index = WStuff.CurrEdit[Window];
	Bool	flag = FALSE;

	if (index) {
		if (!(tree[index].ob_flags & LASTOB)) {
			do {
				index++;
				if (IsFlag(tree,index,tree[index].ob_flags,EDITABLE)==TRUE) {
					WStuff.CurrEdit[Window] = index;
					flag = TRUE;
					break;
				}
			} while(!(tree[index].ob_flags & LASTOB));
		}
		if (!flag) FirstEdit(tree,Window);
	}
}

void	PrevEdit(tree,Window)
OBJECT	*tree;
int	Window;
{
	int	index = WStuff.CurrEdit[Window];
	Bool	flag = FALSE;

	if (index) {
		do {
			index--;
			if (IsFlag(tree,index,tree[index].ob_flags,EDITABLE)==TRUE) {
				WStuff.CurrEdit[Window] = index;
				flag = TRUE;
				break;
			}
		} while(index>0);
		if (!flag) LastEdit(tree);
	}
}
	
int	DoDialogWindow(closeafter,mret,menu)
Bool	closeafter;
MYMSG	*mret;
OBJECT	*menu;
{
	int	button,mx,my,msg[8];
	int	key,dummy,shift_state,event,co,curspos,PrevWindow;
	Bool	done = FALSE;
	OBJECT	*ob;
	MYMSG	mesg;

	mesg.MsgType = NOMSG_ID;
	key = 0;
	do {
		msg[key++]=0;
	} while(key!=8);
	PrevWindow = CurrWindow;
	rsrc_gaddr(R_TREE, WStuff.Dial[CurrWindow], &ob);
	if (WStuff.CurrEdit[PrevWindow]) objc_edit(edits,WStuff.CurrEdit[PrevWindow],0,&curspos,ED_INIT);
	do {
		event = evnt_multi((MU_MESAG | MU_TIMER | MU_BUTTON | MU_KEYBD),
			1,1,1,0,0,0,0,0,0,0,0,0,0,msg,0x0000,
			0x0000,&mx,&my,&button,&shift_state,
			&key,&dummy);
		if (!CheckAllClosed()) {
			CurrWindow = wind_find(mx,my);
			rsrc_gaddr(R_TREE, WStuff.Dial[CurrWindow], &ob);
			co = objc_find(ob,0,MAX_DEPTH,mx,my);
			if (event & MU_MESAG) {
				if (WStuff.CurrEdit[PrevWindow]) objc_edit(edits,WStuff.CurrEdit[PrevWindow],0,&curspos,ED_END);
				ProcessMessage(msg,&mesg);
				mret->MsgType = MENU_ID;
				mret->TitleSelected = mesg.TitleSelected;
				mret->ItemSelected = mesg.ItemSelected;
				if (menu) menu_tnormal(menu,mesg.TitleSelected);
				done = TRUE;
				return(TRUE);
			}
	 		if (event & MU_BUTTON) {
				if ((ob[co].ob_flags & EDITABLE) && (WStuff.CurrEdit[PrevWindow])) {
					objc_edit(edits,WStuff.CurrEdit[PrevWindow],0,&curspos,ED_END);
					WStuff.CurrEdit[PrevWindow] = co;
					done = TRUE;
					return(CurrWindow);
				}
				if (Private_CheckButton(ob,co)) {
					mret->MsgType = OBJC_ID;
					mret->ObjSelected = co;
					done = TRUE;
					return(CurrWindow);
				} else mret->MsgType = NOMSG_ID;
			}
			if (event & MU_KEYBD) {
				switch(key) {
					case SCANDOWN:
					case SCANTAB:
					case SCANENTER:
					case SCANRET:	if (WStuff.CurrEdit[PrevWindow]) {
								objc_edit(edits,WStuff.CurrEdit[PrevWindow],0,&curspos,ED_END);
								NextEdit(edits,PrevWindow);
								objc_edit(edits,WStuff.CurrEdit[PrevWindow],0,&curspos,ED_INIT);
							}
							break;
					case SCANUP:	if (WStuff.CurrEdit[PrevWindow]) {
								objc_edit(edits,WStuff.CurrEdit[PrevWindow],0,&curspos,ED_END);
								PrevEdit(edits,PrevWindow);
								objc_edit(edits,WStuff.CurrEdit[PrevWindow],0,&curspos,ED_INIT);
							}
							break;
					case SCANHOME:	if (WStuff.CurrEdit[PrevWindow]) {
								objc_edit(edits,WStuff.CurrEdit[PrevWindow],0,&curspos,ED_END);
								LastEdit(edits,PrevWindow);
								objc_edit(edits,WStuff.CurrEdit[PrevWindow],0,&curspos,ED_INIT);
							}
							break;
					case SCANSHIFTHOME:
							if (WStuff.CurrEdit[PrevWindow]) {
								objc_edit(edits,WStuff.CurrEdit[PrevWindow],0,&curspos,ED_END);
								FirstEdit(edits,PrevWindow);
								objc_edit(edits,WStuff.CurrEdit[PrevWindow],0,&curspos,ED_INIT);
							}
							break;
					case SCANINS:	if (WStuff.CurrEdit[PrevWindow]) objc_edit(edits,WStuff.CurrEdit[PrevWindow],' ',&curspos,ED_CHAR);
							break;
					default:	if (WStuff.CurrEdit[PrevWindow]) objc_edit(edits,WStuff.CurrEdit[PrevWindow],key,&curspos,ED_CHAR);
							break;
				}
			}
		} else {
			done = TRUE;
			mret->MsgType = NOMSG_ID;
			return(-1);
		}
	} while(!done);
	if (closeafter) Private_CloseWindow(WStuff.WindowHandles[CurrWindow]);
}

int	HandlePopupNoWindow(index,gs,menu_addr,show)
int	index;
Bool	gs;
OBJECT	*menu_addr;
Bool	show;
{
	int LastOb,CurrOb;
	int button,mx,my,EObT;
	OBJECT	*ptr;

	if (!show) {
		menu_bar(menu_addr,0);
	}
	rsrc_gaddr(R_TREE, index, &ptr);
	ShowDialog(index, gs);
	LastOb = -1;
	do {
		vq_mouse(handle,&button,&mx,&my);
		CurrOb = objc_find(ptr, 0, MAX_DEPTH, mx, my);
		EObT = Private_ReturnEObT(ptr,CurrOb);
		if ((button) && (EObT==EOBF_MOVE)) {
			MoveDialog(index,FALSE);
			ShowDialog(index,FALSE);
			button = 0;
		}
		if ((CurrOb>0) && (LastOb!=CurrOb) && (ptr[LastOb].ob_flags & SELECTABLE)) {
			if ((LastOb>0) && (ptr[LastOb].ob_flags!=DISABLED)) objc_change(ptr,LastOb,0,desk.g_x,desk.g_y,desk.g_w,desk.g_h,NORMAL,1);
			LastOb = -1;
		}
		if ((CurrOb!=LastOb) && (ptr[CurrOb].ob_flags & SELECTABLE)) {
			if ((LastOb>0) && (ptr[LastOb].ob_flags!=DISABLED)) objc_change(ptr,LastOb,0,desk.g_x,desk.g_y,desk.g_w,desk.g_h,NORMAL,1);
			if ((CurrOb>0) && (ptr[CurrOb].ob_flags!=DISABLED)) objc_change(ptr,CurrOb,0,desk.g_x,desk.g_y,desk.g_w,desk.g_h,SELECTED,1);
			LastOb = CurrOb;
		}
	} while(button!=1);
	if ((LastOb>0) && (ptr[LastOb].ob_flags!=DISABLED) && (ptr[LastOb].ob_flags & SELECTABLE))
		objc_change(ptr,LastOb,0,desk.g_x,desk.g_y,desk.g_w,desk.g_h,NORMAL,1);
	if ((CurrOb>0) && (ptr[CurrOb].ob_flags!=DISABLED) && (ptr[CurrOb].ob_flags & SELECTABLE))
		objc_change(ptr,CurrOb,0,desk.g_x,desk.g_y,desk.g_w,desk.g_h,NORMAL,1);
	EndDialogComplete(index, gs);
	return(LastOb);
}
#endif			/* Endif of XAES_CODE macro */
