/*
  DU_LIB v2
  Gem Window Management & Dialog Library For Lattice C
  1994, by Craig Graham.
  
  Based on the DU_LIBv1 Library for HiSoft Basic.
*/

/*
	Main Code
*/

#include "dulib.h"

short junk;
short messB[40];
short timeB[40];
short x_handle;
short AESid;				/* Our AES id */
Wdetails windows[max_windows];
Elist *event_value[max_dialogs];
mouse_shape wm_mouse_shape;

short wm_inv[512],wm_outv[200];

short menu; 						/*The menubar form*/
short last_opened_window;			/*The handle of the last handle opened by activate_dialog*/
short d_parm;						/*Any parameter which has to be returned by a dialog (eg slider pos.)*/
short this_ob,this_dialog;			/*The current object handle when any callback routine is called*/
short udx,udy,udw,udh,icon_x,icon_y;
short cr_wind_handle;	
GRECT cr_clip;						/*Custom redraw object locations*/
GRECT cr_dclip;						/*Custom redraw object display clip rectangle*/
short cr_mx,cr_my;					/*Custom redraw/callback relative mouse location inside object*/
short scrn_x,scrn_y,scrn_w,scrn_h;	/*screen size*/
short scrn_planes;					/*screen - number of bitplanes*/
short wmi_total_buffering;
short scroll_selection;				/*index to string when a scroll text has been clicked on */
CallBack XaccTextHandler;			/*handler routine for Xacc2 text transfers*/
short click_count;					/*number of mouse click events from last evnt_multi()*/

event WaitEvent(void)
{
	short x1,y1,d1,d2,d3,d4;
	short x,y,a,b,key_pressed,d6;
	short e;
	event exit_flag;
	Wtype t;
	short window_clicked_in;

	click_count=exit_flag=e=x1=y1=d1=d2=d3=d4=x=y=a=b=key_pressed=d6=0;

	while (exit_flag==0)
	{
#ifndef __USE_GNU
		e=evnt_multi(MU_KEYBD+MU_BUTTON+MU_MESAG,2,1+2+8+16,1,1,x1,y1,a,b,0,d1,d2,d3,d4,
			messB,1,0,&x,&y,&a,&b,&key_pressed,&click_count);
#else
		e=evnt_multi(MU_KEYBD+MU_BUTTON+MU_MESAG,2,1+2+8+16,1,1,x1,y1,a,b,0,d1,d2,d3,d4,
			messB,1,&x,&y,&a,&b,&key_pressed,&click_count);
#endif
		
		if ((e & MU_KEYBD)==MU_KEYBD)
		{
			exit_flag=1;
		}
		if ((e & MU_MESAG)==MU_MESAG)
		{
			exit_flag=process_message(messB);
		}
		if ((e & MU_BUTTON)==MU_BUTTON)
		{
			exit_flag=2;
		}
	}

	if (exit_flag==2)
	{
		window_clicked_in=wind_find(x,y);
		t=windows[window_clicked_in].window_type;
		junk=process_win_dial(window_clicked_in,x,y);
		switch (t)
		{
			case wt_dialog:
				if (junk!=0)
				{
					switch (click_count)
					{
						case 1:
							exit_flag=Get_object_event(windows[window_clicked_in].the_dialog,junk);
							break;
						case 2:
							exit_flag=Get_object_devent(windows[window_clicked_in].the_dialog,junk);
							break;
					}
				} else {
					exit_flag=(event)junk;
				}
				break;
			case wt_drawing:
				if (junk!=0)
				{
					switch (click_count)
					{
						case 1:
							exit_flag=Get_object_event(windows[window_clicked_in].the_dialog,junk);
							break;
						case 2:
							exit_flag=Get_object_devent(windows[window_clicked_in].the_dialog,junk);
							break;
					}
				} else {
					exit_flag=(event)junk;
				}
				break;
		}
	}

	return exit_flag;
}

short enviroment_initialise(void)
{
	short f,i;
	short dummy,w[128];

	AESid=appl_init();

	for(f=0; f<max_dialogs; event_value[f++]=(Elist*)0);
	for(f=0; f<max_windows;	windows[f++].window_type=wt_null);

	wind_get(DESK,WF_WORKXYWH,&scrn_x,&scrn_y,&scrn_w,&scrn_h);
	graf_mouse(ARROW,NULL);

	x_handle = graf_handle(&dummy,&dummy,&dummy,&dummy);
	for (i = 0; i <= 9; w[i++] = 1);w[i] = 2;
	v_opnvwk(w, &x_handle, w);
	vq_extnd(x_handle,1,w);
	scrn_planes=w[4];

	wmi_total_buffering=0;

	XaccTextHandler==NULL;

	return 0;

}

/*==================================================
   Exit from program 
   - close all windows, clean up the av_accessories
  ==================================================*/

short close_down()
{
	OBJECT *menu_loc;
	short f;
/* Close all our windows */
	for (f=1; f<max_windows; f++)
	{
		if ((((((windows[f].window_type==wt_dialog))||(windows[f].window_type==wt_drawing))||(windows[f].window_type==wt_static_menu))||(windows[f].window_type==wt_menu_bar))||(windows[f].window_type==wt_iconified_drawing))
		{
			wind_close(f);
			wind_delete(f);
		};
	}
/* Remove GEM menu bar prior to exitting */
	if (menu!=0)
	{
		rsrc_gaddr(0,menu,&menu_loc);
		menu_bar(menu_loc,1);
	}
	
	v_clsvwk(x_handle);
	appl_exit();
	return 0;
}

