; Ein Beispiel-AutoTake.
; Enthlt diverse Macros fr Projects
;
; hier ggfs. an die eigenen Verhltnisse anpassen
env PURE=d:\pure        ; Pure-C-Verzeichnis
env OBJ=$PURE\obj       ; Pfad fr *.o-Files
env PRGPATH=$PURE\exec  ; Pfad fr ausfhrbare Programme
env TAKE=$PURE\takes    ; Pfad fr Takefiles
env SRC=$PURE\sources   ; Pfad fr Quelltexte
env LIB=$PURE\lib       ; Pfad fr Libraries, Startup-Code
;
env PRGEXT=prg          ; Default-Extension fr Programme
env OPTC=-Y             ; Default-Optionen fr Compiler
env OPTL=-L -G -Y       ; ... Linker
env OPTA=-Y             ; ... Assembler
;
; So kann man das fertige Programm mit "run" starten
alias run $PRGPATH\%%.$PRGEXT $*
;
; ***** Makros fr Project-Files *****
;
macro project
  cls
  echo Project: $0
  env FNREM=%
  fname $0
  env PROJECT=%%
  if !$TAKE\$PROJECT.lnk || time($TAKE\$PROJECT.lnk<$TAKE\$PROJECT.t)
    echo $-O=$PRGPATH\$PROJECT.$PRGEXT >$TAKE\$PROJECT.lnk
    env CREATE=NEW
  else
    env CREATE
  endif
  env BREAK
endm
;
macro use
  if !env(BREAK=TRUE)
    shift
    fname $SHIFT
    fsplit $SHIFT
    if env(FSEXT=c) || env(FSEXT=C)
      if !$OBJ\%%.o || TIME($OBJ\%%.o<%.c)
        $TAKE\compile.t $*
        if $?!=0
          env BREAK=TRUE
        endif
      endif
      if env(CREATE=NEW)
        echo $OBJ\%%.o >>$TAKE\$PROJECT.lnk
      endif
    elsif env(FSEXT=s) || env(FSEXT=S)
      if !$OBJ\%%.o || TIME($OBJ\%%.o<%.s)
        $TAKE\assemble.t
        if $?!=0
          env BREAK=TRUE
        endif
      endif
      if env(CREATE=NEW)
        echo $OBJ\%%.o >>$TAKE\$PROJECT.lnk
      endif
    elsif env(FSEXT=o) || env(FSEXT=O)
      if env(CREATE=NEW)
        echo %.O >>$TAKE\$PROJECT.lnk
      endif
    elsif env(FSEXT=lib) || env(FSEXT=LIB)
      if env(CREATE=NEW)
        echo %.LIB >>$TAKE\$PROJECT.lnk
      endif
    endif
  endif
endm
;
macro link
  if !env(BREAK=TRUE)
    echo Linking "$PROJECT.$PRGEXT"
    ld $OPTL $* -C=$TAKE\$PROJECT.lnk >$OBJ\linker.out
    if $?
      more $OBJ\linker.out
    else
      rm $OBJ\linker.out
    endif
  endif
  fname $FNREM
  env FNREM
  env CREATE
  env BREAK
  env PROJECT
endm
