; Ein Beispiel-AutoTake fr GFA-BASIC
; Enthlt diverse Macros fr Projects
;
; hier ggfs. an die eigenen Verhltnisse anpassen
env GFA=f:\gfa3_6
env OBJ=$GFA\progrms.o       ; Pfad fr *.o-Files
env PRGPATH=$GFA\progrms.prg  ; Pfad fr ausfhrbare Programme
env TAKE=F:\CHATWIN\TAKEFILE    ; Pfad fr Takefiles
env SRC=$GFA\progrms.gfa   ; Pfad fr Quelltexte
env LIB=$GFA\SHELPRGS       ; Pfad fr Libraries, Startup-Code
env G3LIB=F:\GFA3_6\SHELPRGS\GFA3PLIB
env G3WAIT=OFF
env G3MOVE=OFF
;
env PRGEXT=prg          ; Default-Extension fr Programme
;env OPTC=-Y             ; Default-Optionen fr Compiler
;env OPTL=-L -G -Y       ; ... Linker
;env OPTA=-Y             ; ... Assembler
;
; So kann man das fertige Programm mit "run" starten
alias run $PRGPATH/%%.$PRGEXT $*
;
; ***** Makros fr Project-Files *****
;
macro project
  cls
  echo Project: $0
  env FNREM=%
  fname $0
  env PROJECT=%%
  env BREAK
endm
;
macro use
  if !env(BREAK=TRUE)
    shift
    fname $SHIFT
    fsplit $SHIFT
    if env(FSEXT=gfa) || env(FSEXT=GFA)
      if !$OBJ/%%.o || TIME($OBJ/%%.o<%.GFA)
        $TAKE/gfacomp.t $*
        if $?!=0
          env BREAK=TRUE
        endif
      endif
    elsif env(FSEXT=s) || env(FSEXT=S)
      if !$OBJ/%%.o || TIME($OBJ/%%.o<%.s)
        $TAKE/assemble.t
        if $?!=0
          env BREAK=TRUE
        endif
      endif
    elsif env(FSEXT=o) || env(FSEXT=O)
    elsif env(FSEXT=lib) || env(FSEXT=LIB)
    endif
  endif
endm
;
macro link
  if !env(BREAK=TRUE)
    echo Linking "$PROJECT.$PRGEXT"
    ld $OPTL # $OBJ\%%.O >$OBJ/linker.out
    mv $LIB/TEST.PRG $PRGPATH/%%.$PRGEXT
    if $?
      more $OBJ/linker.out
    else
      rm $OBJ/linker.out
      rm $OBJ/%%.O
    endif
  endif
  fname $FNREM
  env FNREM
  env BREAK
  env PROJECT
endm
