


CJPEG(1)                                                 CJPEG(1)


NNAAMMEE
       cjpeg - compress an image file to a JPEG file

SSYYNNOOPPSSIISS
       ccjjppeegg [ _o_p_t_i_o_n_s ] [ _f_i_l_e_n_a_m_e ]


DDEESSCCRRIIPPTTIIOONN
       ccjjppeegg  compresses  the  named  image file, or the standard
       input if no file is named, and produces a  JPEG/JFIF  file
       on  the  standard  output.   The currently supported input
       file formats are: PPM (PBMPLUS color format), PGM (PBMPLUS
       gray-scale  format), BMP, GIF, Targa, and RLE (Utah Raster
       Toolkit format).   (RLE  is  supported  only  if  the  URT
       library is available.)

OOPPTTIIOONNSS
       All   switch   names  may  be  abbreviated;  for  example,
       --ggrraayyssccaallee may be written  --ggrraayy  or  --ggrr.   Most  of  the
       "basic"  switches  can  be abbreviated to as little as one
       letter.  Upper and lower case are equivalent (thus --GGIIFF is
       the  same  as  --ggiiff).  British spellings are also accepted
       (e.g., --ggrreeyyssccaallee), though for brevity these are not  men
       tioned below.

       The basic switches are:

       --qquuaalliittyy _N
              Scale  quantization tables to adjust image quality.
              Quality is 0 (worst) to 100 (best); default is  75.
              (See below for more info.)

       --ggrraayyssccaallee
              Create  monochrome  JPEG file from color input.  Be
              sure  to  use  this  switch  when   compressing   a
              grayscale  GIF  file,  because  ccjjppeegg  isn't bright
              enough to notice  whether  a  GIF  file  uses  only
              shades of gray.  By saying --ggrraayyssccaallee, you'll get a
              smaller JPEG file that takes less time to  process.

       --ooppttiimmiizzee
              Perform  optimization  of  entropy encoding parame
              ters.  Without this,  default  encoding  parameters
              are  used.  --ooppttiimmiizzee usually makes the JPEG file a
              little smaller, but ccjjppeegg runs somewhat slower  and
              needs much more memory.  Image quality and speed of
              decompression are unaffected by --ooppttiimmiizzee.

       --ttaarrggaa Input file is Targa format.  Targa files that  con
              tain an "identification" field will not be automat
              ically recognized by ccjjppeegg; for such files you must
              specify  --ttaarrggaa  to  make  ccjjppeegg treat the input as
              Targa format.  For most Targa files, you won't need
              this switch.



                          30 August 1994                        1





CJPEG(1)                                                 CJPEG(1)


       The  --qquuaalliittyy  switch  lets  you trade off compressed file
       size against  quality  of  the  reconstructed  image:  the
       higher  the quality setting, the larger the JPEG file, and
       the closer the output image will be to the original input.
       Normally  you  want  to  use  the  lowest  quality setting
       (smallest file) that decompresses into something  visually
       indistinguishable  from the original image.  For this pur
       pose the quality setting should be between 50 and 95;  the
       default of 75 is often about right.  If you see defects at
       --qquuaalliittyy 75, then go up 5 or 10 counts at a time until you
       are  happy  with  the  output image.  (The optimal setting
       will vary from one image to another.)

       --qquuaalliittyy 100 will generate a  quantization  table  of  all
       1's,  eliminating loss in the quantization step (but there
       is still information  loss  in  subsampling,  as  well  as
       roundoff  error).   This setting is mainly of interest for
       experimental purposes.  Quality values above about 95  are
       nnoott  recommended  for normal use; the compressed file size
       goes up dramatically for hardly any gain in  output  image
       quality.

       In  the other direction, quality values below 50 will pro
       duce very small files  of  low  image  quality.   Settings
       around  5 to 10 might be useful in preparing an index of a
       large image library, for example.  Try --qquuaalliittyy 2 (or  so)
       for  some  amusing  Cubist effects.  (Note: quality values
       below about 25 generate 2-byte quantization tables,  which
       are considered optional in the JPEG standard.  ccjjppeegg emits
       a warning message when you  give  such  a  quality  value,
       because  some  commercial  JPEG  programs may be unable to
       decode the resulting file.  Use --bbaasseelliinnee if you  need  to
       ensure compatibility at low quality values.)

       Switches for advanced users:

       --ddcctt iinntt
              Use integer DCT method (default).

       --ddcctt ffaasstt
              Use fast integer DCT (less accurate).

       --ddcctt ffllooaatt
              Use  floating-point DCT method.  The floating-point
              method is the most accurate, but will be the  slow
              est  unless  your  machine  has very fast floating-
              point hardware.  Also  note  that  results  of  the
              floating-point  method  may  vary  slightly  across
              machines, while the integer methods should give the
              same  results  everywhere.  The fast integer method
              is much less accurate than the other two.

       --rreessttaarrtt _N
              Emit a JPEG restart marker every  N  MCU  rows,  or



                          30 August 1994                        2





CJPEG(1)                                                 CJPEG(1)


              every  N  MCU blocks if "B" is attached to the num
              ber.  --rreessttaarrtt 00 (the  default)  means  no  restart
              markers.

       --ssmmooootthh _N
              Smooth  the  input  image  to  eliminate  dithering
              noise.  N, ranging from 1  to  100,  indicates  the
              strength  of  smoothing.   0 (the default) means no
              smoothing.

       --mmaaxxmmeemmoorryy _N
              Set limit for amount of memory to use in processing
              large  images.   Value is in thousands of bytes, or
              millions of bytes if "M" is attached to the number.
              For  example,  --mmaaxx  44mm  selects 4000000 bytes.  If
              more space is needed, temporary files will be used.

       --oouuttffiillee _n_a_m_e
              Send  output  image to the named file, not to stan
              dard output.

       --vveerrbboossee
              Enable debug printout.  More --vv's give more output.
              Also, version information is printed at startup.

       --ddeebbuugg Same as --vveerrbboossee.

       The  --rreessttaarrtt  option  inserts  extra markers that allow a
       JPEG decoder to resynchronize after a transmission  error.
       Without  restart  markers, any damage to a compressed file
       will usually ruin the image from the point of the error to
       the  end of the image; with restart markers, the damage is
       usually confined to the portion of the  image  up  to  the
       next  restart  marker.   Of  course,  the  restart markers
       occupy extra space.  We recommend --rreessttaarrtt  11  for  images
       that  will  be transmitted across unreliable networks such
       as Usenet.

       The --ssmmooootthh option filters the input  to  eliminate  fine-
       scale  noise.   This  is  often useful when converting GIF
       files to JPEG: a moderate smoothing factor  of  10  to  50
       gets  rid of dithering patterns in the input file, result
       ing in a smaller JPEG file  and  a  better-looking  image.
       Too  large a smoothing factor will visibly blur the image,
       however.

       Switches for wizards:

       --aarriitthhmmeettiicc
              Use arithmetic coding rather than  Huffman  coding.
              (Not currently supported for legal reasons.)

       --bbaasseelliinnee
              Force  a  baseline JPEG file to be generated.  This



                          30 August 1994                        3





CJPEG(1)                                                 CJPEG(1)


              clamps quantization values to 8 bits  even  at  low
              quality settings.

       --nnooiinntteerrlleeaavvee
              Generate  noninterleaved  JPEG  file  (not yet sup
              ported).

       --qqttaabblleess _f_i_l_e
              Use the quantization tables given in the  specified
              file.   The  file should contain one to four tables
              (64 values each) as plain text.  Comments  preceded
              by '#' may be included in the file.  The tables are
              implicitly numbered 0,1,etc.  If --qquuaalliittyy _N is also
              specified,  the  values  in  the  file  are  scaled
              according to ccjjppeegg's quality scaling curve.

       --qqsslloottss _N_[_,_._._._]
              Select which quantization table  to  use  for  each
              color  component.   By default, table 0 is used for
              luminance and table 1 for chrominance components.

       --ssaammppllee _H_x_V_[_,_._._._]
              Set JPEG sampling factors.  If  you  specify  fewer
              H/V  pairs than there are components, the remaining
              components are set to 1x1  sampling.   The  default
              setting is equivalent to --ssaammppllee 22xx22.

       The  "wizard"  switches  are  intended for experimentation
       with JPEG.  If you don't know what you  are  doing,  ddoonn''tt
       uussee  tthheemm.   You can easily produce files with worse image
       quality and/or poorer compression than you'll get from the
       default  settings.  Furthermore, these switches should not
       be used  when  making  files  intended  for  general  use,
       because  not all JPEG implementations will support unusual
       JPEG parameter settings.

EEXXAAMMPPLLEESS
       This example compresses the PPM file foo.ppm with a  qual
       ity factor of 60 and saves the output as foo.jpg:

              ccjjppeegg --qquuaalliittyy _6_0 _f_o_o_._p_p_m >> _f_o_o_._j_p_g

HHIINNTTSS
       Color  GIF files are not the ideal input for JPEG; JPEG is
       really  intended  for  compressing   full-color   (24-bit)
       images.   In  particular,  don't  try to convert cartoons,
       line drawings, and other images that have only a few  dis
       tinct  colors.   GIF  works great on these, JPEG does not.
       If you want to convert a GIF to JPEG, you  should  experi
       ment  with  ccjjppeegg's  --qquuaalliittyy and --ssmmooootthh options to get a
       satisfactory conversion.  --ssmmooootthh 1100 or so is often  help
       ful.

       Avoid   running   an   image  through  a  series  of  JPEG



                          30 August 1994                        4





CJPEG(1)                                                 CJPEG(1)


       compression/decompression cycles.  Image quality loss will
       accumulate;  after  ten  or  so  cycles  the  image may be
       noticeably worse than it was after one cycle.   It's  best
       to use a lossless format while manipulating an image, then
       convert to JPEG format when you  are  ready  to  file  the
       image away.

       The  --ooppttiimmiizzee option to ccjjppeegg is worth using when you are
       making a "final" version for posting or  archiving.   It's
       also a win when you are using low quality settings to make
       very small JPEG files; the percentage improvement is often
       a lot more than it is on larger files.

EENNVVIIRROONNMMEENNTT
       JJPPEEGGMMEEMM
              If  this  environment variable is set, its value is
              the default memory limit.  The value  is  specified
              as  described  for  the --mmaaxxmmeemmoorryy switch.  JJPPEEGGMMEEMM
              overrides the default value specified when the pro
              gram  was  compiled, and itself is overridden by an
              explicit --mmaaxxmmeemmoorryy.

SSEEEE AALLSSOO
       ddjjppeegg(1), rrddjjppggccoomm(1), wwrrjjppggccoomm(1)
       ppppmm(5), ppggmm(5)
       Wallace, Gregory K.  "The JPEG Still  Picture  Compression
       Standard", Communications of the ACM, April 1991 (vol. 34,
       no. 4), pp. 30-44.

AAUUTTHHOORR
       Independent JPEG Group

BBUUGGSS
       Arithmetic coding is not supported for legal reasons.

       Not all variants of BMP and Targa file  formats  are  sup
       ported.

       The --ttaarrggaa switch is not a bug, it's a feature.  (It would
       be a bug if the Targa format designers had not been  clue
       less.)

       Still not as fast as we'd like.














                          30 August 1994                        5


