MODULE SCSI_Mon;
(****************************************************************************
 *
 * Debugging unter SysMon. Alle SCSI-Kommandos werden angezeigt.
 *
 * $Source: e:\hm2\user\gemar\plugin\RCS\scsi_mon.m,v $
 *
 * $Revision: 1.1 $
 *
 * $Author: S_Engel $
 *
 * $Date: 1995/01/01 20:03:16 $
 *
 * $State: Exp $
 *
 *****************************************************************************
 * History:
 *
 * $Log: scsi_mon.m,v $
 * Revision 1.1  1995/01/01  20:03:16  S_Engel
 * Initial revision
 *
 *
 *
 ****************************************************************************)

IMPORT SYSTEM, CPX;
FROM SYSTEM IMPORT CODE, ADDRESS, BYTE;

IMPORT form;

(* Magic-Lib *)
FROM MagicSys 	IMPORT
								(* Const *) Nil, Null, Bit0, Bit1, Bit2, Bit3, Bit4, Bit5,
														Bit6, Bit7, Bit8, Bit9, Bit10, Bit11, Bit12,
														Bit13, Bit14, Bit15,
								(* Type  *) LOC, Byte, ByteSet, sWORD, sINTEGER, sCARDINAL,
														sBITSET, lINTEGER, lCARDINAL, lWORD, lBITSET;

IMPORT MagicDOS, void;

IMPORT PlugParms, GemarPlugParms;


TYPE

			UChar 			= [0..255];
			tpCmdBlock	= POINTER TO tCmdBlock;
			tCmdBlock 	= RECORD
											Command : UChar;
											Lun 		: UChar;
											Adr 		: LONGCARD;
											Zero		: UChar;
											LenHigh : UChar;
											LenLow	: UChar;
											Flags 	: BYTE; 
										END;

VAR PlugEnv 		: PlugParms.tpPlugEnvironment;
		PlugPrivate : GemarPlugParms.tpPlugParms;
		PlugProcs 	: RECORD
										num  : SHORTINT;
										Proc : ARRAY[0..1] OF PlugParms.tPlugProc;
									END;
		Timer[04BAH]: LONGCARD;


PROCEDURE WriteSysMon(VAR Msg : STRING; Level : SHORTINT);

	BEGIN
(*\ONYX v2.01  29.10.95 23:55*)(*$D-*)
(*16 bytes of MC68030 code*)

CODE(03F2EH,0000CH);

CODE(02F2EH,00008H);

CODE(03F3CH,01069H);

CODE(04E41H);

CODE(0508FH);

(*$D=*)
(*\=
	move.w	12(a6),-(sp)
	move.l	8(a6),-(sp)
	move.w	#4201,-(sp)
	trap		#1
	addq.l	#8,sp
\*)

	END WriteSysMon;

PROCEDURE PrintCmd(pCmd : GemarPlugParms.tpScsiCmd);
VAR Msg 			: ARRAY[0..200] OF CHAR;
		count 		: SHORTCARD;
		CmdBlock	: POINTER TO ARRAY[0..11] OF UChar;
		Time			: LONGCARD;

	BEGIN
		CmdBlock := pCmd^.Cmd;
		Msg := FORM('SCSI-Befehl: handle ', pCmd^.Handle);

		Msg := FORM(Msg, ' Cmd $');
		FOR count := 0 TO pCmd^.CmdLen - 1 DO
			Msg := FORM(Msg, CmdBlock^[count]:2:16:'0', ', ');
		END;
		CASE CmdBlock^[0] OF
			|000H : Msg := FORM(Msg, 'Test Unit Ready ');
			|001H : Msg := FORM(Msg, 'Rezero          ');
			|003H : Msg := FORM(Msg, 'Request Sense   ');
			|008H : Msg := FORM(Msg, 'Read            ');
			|00AH : Msg := FORM(Msg, 'Write           ');
			|010H : Msg := FORM(Msg, 'Write Filemark  ');
			|011H : Msg := FORM(Msg, 'Space           ');
			|012H : Msg := FORM(Msg, 'Inquiry         ');
			|014H : Msg := FORM(Msg, 'Recover Buffer  ');
			|015H : Msg := FORM(Msg, 'Mode Select     ');
			|019H : Msg := FORM(Msg, 'Erase           ');
			|01AH : Msg := FORM(Msg, 'Mode Sense      ');
			|01BH : Msg := FORM(Msg, 'Load            ');
			|01EH : Msg := FORM(Msg, 'Prevent Removal ');
			|025H : Msg := FORM(Msg, 'Read Capacity   ');
			|02BH : Msg := FORM(Msg, 'Locate          ');
			|034H : Msg := FORM(Msg, 'Read Position   ');
			ELSE Msg := FORM(Msg, '(unknown)');
		END;

		Msg := FORM(Msg, ' Buffer $', LONGCARD(pCmd^.Buffer):8:16:'0');
		Msg := FORM(Msg, ' Len $', pCmd^.Transferlen:6:16:'0');
		Msg := FORM(Msg, ' Timeout ', pCmd^.Timeout DIV 200, ',',
																	(pCmd^.Timeout MOD 200 * 2):2:10:'0', ' sec');
		(* und ausgeben *)
		WriteSysMon(Msg, 1);

	END PrintCmd;

(*$K+ $E+ *)
PROCEDURE ScsiIn(pCmd : GemarPlugParms.tpScsiCmd) : SHORTINT;
VAR Msg 	: ARRAY[0..100] OF CHAR;
		ret 	: SHORTINT;
		Time	: LONGCARD;

	BEGIN

		(* Hier sind wir auch im Deinitialisierungsslot! *)
		IF pCmd = SYSTEM.ADDRESS(-1)
			THEN
				WriteSysMon('SCSI_MON: Deinstallierung', 1);
				RETURN 0;
			END;

		(* Hier kann abgefangen werden *)
		PrintCmd(pCmd);

		Time := Timer;
		(* und weiterreichen *)
		ret := PlugPrivate^.ScsiIn(pCmd);
		Time := Timer - Time;
		Msg := FORM(' -> ', ret);
		IF Time >= 20
			THEN
				Msg := FORM(Msg, ' Zeit: ', Time DIV 200, ',', (Time MOD 200 DIV 2):2:10:'0', ' sec');
			ELSE
				Msg := FORM(Msg, ' Zeit: ', Time, ' ticks');
			END;
		WriteSysMon(Msg, 1);
		RETURN ret;

	END ScsiIn;
(*$K= $E+ *)

(*$K+ $E+ *)
PROCEDURE ScsiOut(pCmd : GemarPlugParms.tpScsiCmd) : SHORTINT;
VAR Msg 	: ARRAY[0..100] OF CHAR;
		ret 	: SHORTINT;
		Time	: LONGCARD;

	BEGIN
		(* Hier sind wir auch im Deinitialisierungsslot! *)
		IF pCmd = SYSTEM.ADDRESS(-1)
			THEN
				WriteSysMon('SCSI_MON: Deinstallierung', 1);
				RETURN 0;
			END;

		(* Hier kann abgefangen werden *)
		PrintCmd(pCmd);

		Time := Timer;
		(* und weiterreichen *)
		ret := PlugPrivate^.ScsiOut(pCmd);
		Time := Timer - Time;
		Msg := FORM(' -> ', ret);
		IF Time >= 20
			THEN
				Msg := FORM(Msg, ' Zeit: ', Time DIV 200, ',', (Time MOD 200 DIV 2):2:10:'0', ' sec');
			ELSE
				Msg := FORM(Msg, ' Zeit: ', Time, ' ticks');
			END;
		WriteSysMon(Msg, 1);
		RETURN ret;

	END ScsiOut;
(*$K= $E+ *)


BEGIN
	WriteSysMon('SCSI_MON: Monitor fr SCSI-Zugriffe von GEMAR', 1);

	PlugEnv := PlugParms.tpPlugEnvironment(CPX.pXCPB);
	IF PlugEnv^.Version # 0100H
		THEN
			VOID(form.alert(1, '[3][PlugIn: falsche Parameterversion][Abbruch]'));
			CPX.Return(NIL);
		END;


	PlugPrivate := PlugEnv^.Private;

	IF PlugPrivate^.Version # 0200H
		THEN
			void.I := PlugEnv^.Alert(1, '[3][PlugIn (SCSI):|falsche Parameterversion][Aha]');
			CPX.Return(NIL);
		ELSE
			WITH PlugProcs DO
				num := 2;
				Proc[0] := PlugParms.tPlugProc(ScsiIn);
				Proc[1] := PlugParms.tPlugProc(ScsiOut);
			END;
			CPX.Return(SYSTEM.ADR(PlugProcs));
		END;
END SCSI_Mon.
		
	
	