DEFINITION MODULE PlugParms;
(****************************************************************************
 *
 * Parametermodul fr PlugIns
 *
 * $Source: e:\hm2\lib\se\RCS\plugparm.d,v $
 *
 * $Revision: 1.1 $
 *
 * $Author: S_Engel $
 *
 * $Date: 1995/01/01 19:13:50 $
 *
 * $State: Exp $
 *
 *****************************************************************************
 * History:
 *
 * $Log: plugparm.d,v $
 * Revision 1.1  1995/01/01  19:13:50  S_Engel
 * Initial revision
 *
 *
 *
 ****************************************************************************)

FROM Portab IMPORT tCompiler, Compiler;

IMPORT SYSTEM;

(* Magic-Lib *)
FROM MagicSys   IMPORT
                (* Const *) Nil, Null, Bit0, Bit1, Bit2, Bit3, Bit4, Bit5,
                            Bit6, Bit7, Bit8, Bit9, Bit10, Bit11, Bit12,
                            Bit13, Bit14, Bit15,
                (* Type  *) LOC, Byte, ByteSet, sWORD, sINTEGER, sCARDINAL,
                            sBITSET, lINTEGER, lCARDINAL, lWORD, lBITSET;



CONST ParmVersion = 0100H;         (* Version des Parameterblockes *)
      PathLen     = 512;

TYPE
     (* Umgebung der PlugIns, wird bei der Initialisierung bergeben *)
      tpPlugEnvironment = POINTER TO tPlugEnvironment;
      tPlugEnvironment
        = RECORD
            (* aktuelle Parameterversion = 1.00 = 0100H *)
            Version  : sINTEGER;                          (* Version zeigt Umfang der Parameter an   *)
            Private  : SYSTEM.ADDRESS;                    (* private Parameter fr Modul-Rumpf       *)
            ApplId   : sINTEGER;                          (* Applikationsid des rufenden Programmes  *)
            VDIHandle: sINTEGER;                          (* Workstation des Hauptprogrammes         *)
            PlugPath : POINTER TO ARRAY[0..PathLen-1] OF CHAR;  (* Name und Pfad des PlugIn, kann auch
                                                                   relativ sein                      *)
            (*$K+*)
            Alert    : PROCEDURE(   (* def   *) sINTEGER,
                                 VAR(* msg   *) STRING) : sINTEGER;
            (*$K=*)
          END;

      (*$?Compiler=Haenisch:
        (*$K+   Aufrufer rumt Stack ab *)
       *)
      tPlugProc = PROCEDURE((* par : *) SYSTEM.ADDRESS) : lINTEGER;
      (*$?Compiler=Haenisch:
       (*$K=*)
       *)

      tPlugProcs   = RECORD
                       num    : SHORTINT;     (* Anzahl der Prozeduren *)
                       Procs  : ARRAY[0..MAX(sINTEGER)] OF tPlugProc;
                     END;
      tpPlugProcs  = POINTER TO tPlugProcs;



END PlugParms.