IMPLEMENTATION MODULE PlugIn2;
(****************************************************************************
 *
 * Handler fr Plug-Ins
 * Variante fr GEMPLUS
 *
 * $Source: e:\hm2\lib\se\RCS\plugin.m,v $
 *
 * $Revision: 1.4 $
 *
 * $Author: S_Engel $
 *
 * $Date: 1995/02/10 12:38:00 $
 *
 * $State: Exp $
 *
 *****************************************************************************
 * History:
 *
 * $Log: plugin.m,v $
 * Revision 1.4  1995/02/10  12:38:00  S_Engel
 * *** empty log message ***
 *
 * Revision 1.3  1995/01/01  23:02:18  S_Engel
 * CountPlugs und LoadSlot eingefgt
 *
 * Revision 1.2  1995/01/01  21:59:22  S_Engel
 * ListPlugs gibt das Wildcards nicht mehr vor.
 *
 * Revision 1.1  1995/01/01  19:14:40  S_Engel
 * Initial revision
 *
 *
 *
 ****************************************************************************)

FROM Portab IMPORT tCompiler, Compiler;

FROM SYSTEM IMPORT ADDRESS, TSIZE, CODE, ADR, LOAD, STORE;

IMPORT Storage, Block, void, Directory, MintDirs, Paths;

(* GEMPLUS *)
IMPORT AES, alert, vwk;

(* Magic-Lib *)
FROM MagicSys 	IMPORT
								(* Const *) Nil, Null, Bit0, Bit1, Bit2, Bit3, Bit4, Bit5,
														Bit6, Bit7, Bit8, Bit9, Bit10, Bit11, Bit12,
														Bit13, Bit14, Bit15,
								(* Type  *) LOC, Byte, ByteSet, sWORD, sINTEGER, sCARDINAL,
														sBITSET, lINTEGER, lCARDINAL, lWORD, lBITSET;

IMPORT MagicStrings, MagicTypes, MagicDOS;

IMPORT mtDir;


(* und die Parameterdefinitionen fr PlugIns *)
IMPORT PlugParms;

TYPE	tPlugIn 			= POINTER TO tPlugCarrier;
			tPlugCarrier	= RECORD
												Env 			: PlugParms.tPlugEnvironment;
												mem 			: ADDRESS;
												size			: lCARDINAL;
												proc			: PlugParms.tpPlugProcs;
											END;

			tPH 					= RECORD
												ph_branch 	: sINTEGER;
												ph_tlen 		: lCARDINAL;
												ph_dlen 		: lCARDINAL;
												ph_blen 		: lCARDINAL;
												ph_slen 		: lCARDINAL;
												ph_sres1		: lCARDINAL;
												ph_prgflags : lCARDINAL;
												ph_absflag	: sINTEGER;
											END;



PROCEDURE Reloc(Text : ADDRESS; PH : tPH);

VAR pLC, ReloAdr	: POINTER TO ADDRESS;

		pB						: POINTER TO Byte;


	BEGIN

		(* erstes Relo-Long holen *)

		pLC := Text + ADDRESS(PH.ph_tlen + PH.ph_dlen + PH.ph_slen);


		(* Zeiger auf erste zu relozierende Adresse *)

		IF pLC^ = NIL

			THEN

				RETURN;  (* keine Relotabelle vorhanden *)

			END;


		ReloAdr := pLC^ + Text; 					(* Position der ersten Relokation *)

		ReloAdr^ := ReloAdr^ + Text;			(* relozieren *)


		(* nchstes Relo-Byte dahinter *)

		pB := pLC + ADDRESS(4);

		WHILE CHAR(pB^) # 0C DO

			IF CHAR(pB^) = 1C

				THEN

					ReloAdr := ReloAdr + ADDRESS(254);

				ELSE

					ReloAdr := ReloAdr + VAL(ADDRESS, CHAR(pB^));

					ReloAdr^ := ReloAdr^ + Text;			(* relozieren *)

				END;

			pB := pB + ADDRESS(1);

		END;


	END Reloc;


(*$E+ $K+*)
PROCEDURE AlertCarrier (DefBut : sINTEGER; VAR Msg : STRING) : sINTEGER;

	BEGIN
		RETURN alert.alert(DefBut, Msg);
	END AlertCarrier;
(*$E= $K= *)


PROCEDURE LoadHead(handle : sINTEGER; Identify : ARRAY OF CHAR;

									 VAR Head : tPlugHead) : BOOLEAN;

VAR bytes : lCARDINAL;


	BEGIN

		(* Header holen und kontrollieren *)

		bytes := SIZE(Head);

		MagicDOS.Fread(handle, bytes, ADR(Head));

		IF (bytes # SIZE(Head)) OR (Head.Magic # lCARDINAL('Plug'))

			 OR ((LENGTH(Identify) # 0) AND ~MagicStrings.Equal(Identify, Head.Identify))

			THEN

				RETURN FALSE;

			ELSE

				RETURN TRUE;

			END;


	END LoadHead;


(*-------------------------------------------------------------------------*)
(*- 																																			-*)
(*- Exportierte Funktionen																								-*)
(*- 																																			-*)
(*-------------------------------------------------------------------------*)
VAR ListIdent 		: tIdent;
		ListSlotIdent : tIdent;
		ListProc			: tListProc;
(*$E+*)
PROCEDURE Query(VAR path, name : ARRAY OF CHAR;

								VAR entry : MintDirs.DirEntry) : BOOLEAN;

VAR FileName	: ARRAY[0..512] OF CHAR;

		Head			: tPlugHead;

		handle		: sINTEGER;

		Ok				: BOOLEAN;

		Ext 			: ARRAY[0..10] OF CHAR;


	BEGIN

		(* Extensionkontrolle fr MiNT (Dreaddir-Problem) *)

		Paths.GetExt(name, Ext);

		IF MagicStrings.Equal('PLG', Ext)

			OR MagicStrings.Equal('PLX', Ext)

			THEN

				FileName := FORM(path, name);

				handle := MagicDOS.Fopen(FileName, MagicDOS.Read);


				IF handle < 0

					THEN

						RETURN TRUE;

					END;


				Ok := LoadHead(handle, ListIdent, Head);

				handle := MagicDOS.Fclose(handle);

				IF Ok AND ((LENGTH(ListSlotIdent) = 0) OR MagicStrings.Equal(ListSlotIdent, Head.SlotIdent))

					THEN

						ListProc(Head.Identify, Head.SlotIdent, Head.Info, FileName);

					END;

			END;

		RETURN TRUE;

	END Query;
(*$E=*)


PROCEDURE ListPlugs(Identify, SlotIdent, Path : ARRAY OF CHAR; List : tListProc);


	BEGIN

		MagicStrings.Assign(Identify, ListIdent);

		MagicStrings.Assign(SlotIdent, ListSlotIdent);

		ListProc := List;

		MintDirs.DirQuery(Path, Directory.FileAttrSet{}, Query);

	END ListPlugs;


(*$E+*)
VAR PlugCount : sINTEGER;
PROCEDURE Count(VAR Ident, Slot, Info, Name : ARRAY OF CHAR);

	BEGIN
		INC(PlugCount); (* nur zhlen *)
	END Count;
(*$E=*)

PROCEDURE CountPlugs(Identify, Slot, Path : ARRAY OF CHAR) : sINTEGER;

	BEGIN
		PlugCount := 0;
		ListPlugs(Identify, Slot, Path, Count);
		RETURN PlugCount;
	END CountPlugs;




PROCEDURE Load(Identify, Name : ARRAY OF CHAR; private : ADDRESS;
							 VAR Carrier : tPlugIn; VAR Slot : tIdent) : lINTEGER;
VAR handle		: sINTEGER;
		bytes 		: lCARDINAL;
		InitProc	: PlugParms.tPlugProc;
		ProgHead	: tPH;
		PlugHead	: tPlugHead;

	BEGIN
		Carrier := NIL;
		handle := MagicDOS.Fopen(Name, MagicDOS.Read);

		IF handle < 0
			THEN
				RETURN handle;	(* was auch immer TOS meldet, nach oben durchreichen *)
			END;

		Storage.ALLOCATE(Carrier, TSIZE(tPlugCarrier)
															+ PlugParms.PathLen + 1);
		IF Carrier = NIL
			THEN
				void.I := MagicDOS.Fclose(handle);
				RETURN MagicDOS.ENSMem;
			END;

		(* Parameter fllen *)
		WITH Carrier^.Env DO
			Version 	:= PlugParms.ParmVersion;
			Private 	:= private;
			ApplId		:= AES.global.id;
			VDIHandle := vwk.hdl;
			Alert 		:= AlertCarrier;
			PlugPath	:= Carrier + ADDRESS(TSIZE(tPlugCarrier));
			MagicStrings.Assign(Name, PlugPath^);
		END;

		IF ~LoadHead(handle, Identify, PlugHead)
			THEN
				void.I := MagicDOS.Fclose(handle);
				Storage.DEALLOCATE(Carrier, 0); 			(* Den Carrier wieder freigeben *)
				RETURN MagicDOS.EPLFmt;
			END;



		(* bergabe des Identifiers, Kontrolle mu Aufrufer machen *)
		Slot := PlugHead.SlotIdent;

		(* Programm-Header holen und kontrollieren *)
		bytes := SIZE(ProgHead);
		MagicDOS.Fread(handle, bytes, ADR(ProgHead));
		IF (bytes # SIZE(ProgHead)) OR (ProgHead.ph_branch # 0601AH)
			THEN
				void.I := MagicDOS.Fclose(handle);
				Storage.DEALLOCATE(Carrier, 0); 			(* Den Carrier wieder freigeben *)
				RETURN MagicDOS.EPLFmt;
			END;

		(* Gre des Programmes kurzerhand ber Fseek holen *)
		Carrier^.size := MagicDOS.Fseek(0, handle, MagicDOS.SeekEnd) - 512;

		(* und zum Programm zurckspulen *)
		void.LC := MagicDOS.Fseek(512, handle, MagicDOS.SeekStart);

		(* Speicher fr Programm, zuzuglich BSS-Length *)
		Storage.ALLOCATE(Carrier^.mem, Carrier^.size + ProgHead.ph_blen);
		IF Carrier^.mem = NIL
			THEN
				(* alles freigeben *)
				void.I := MagicDOS.Fclose(handle);
				Storage.DEALLOCATE(Carrier, 0);
				(* und weg *)
				RETURN MagicDOS.ENSMem;
			END;

		(* jetzt die Datei einlesen *)
		bytes := Carrier^.size;
		MagicDOS.Fread(handle, bytes, Carrier^.mem);
		void.I := MagicDOS.Fclose(handle);

		IF bytes # Carrier^.size
			THEN
				(* alles freigeben *)
				Storage.DEALLOCATE(Carrier^.mem, 0);
				Storage.DEALLOCATE(Carrier, 0);
				(* und weg *)
				RETURN MagicDOS.EReadF;
			END;

		(* relozieren *)
		IF ProgHead.ph_absflag = 0
			THEN
				Reloc(Carrier^.mem + ADDRESS(01CH), ProgHead);
			END;

		(* BSS lschen *)
		Block.Clear(Carrier^.mem + ADDRESS(01CH) + ProgHead.ph_tlen
								+ ProgHead.ph_dlen, ProgHead.ph_blen);

		(* jetzt noch zur Initialisierung rufen *)
		InitProc := PlugParms.tPlugProc(Carrier^.mem);


(********* Hier mu fr MM2 der Aufruf angepat werden **********)
		Carrier^.proc := PlugParms.tpPlugProcs(InitProc(ADR(Carrier^.Env)));

		IF LONGINT(Carrier^.proc) = 0
			THEN
				(* Will nicht, also freigeben *)
				Storage.DEALLOCATE(Carrier^.mem, 0);
				Storage.DEALLOCATE(Carrier, 0);
				RETURN -1;
			ELSE
				RETURN 0;
			END;
	END Load;


PROCEDURE LoadPath(Identify, Path, Name : ARRAY OF CHAR; private : ADDRESS;

									 VAR Carrier : tPlugIn; VAR Slot : tIdent) : lINTEGER;

VAR PlugName : ARRAY[0..512] OF CHAR;


	BEGIN

		MagicStrings.Assign(Path, PlugName);

		MagicStrings.Append(Name, PlugName);

		RETURN Load(Identify, PlugName, private, Carrier, Slot);

	END LoadPath;


(*$E+*)
VAR PlugName : ARRAY[0..512] OF CHAR;
PROCEDURE Name(VAR Ident, Slot, Info, Name : ARRAY OF CHAR);


	BEGIN

		(* uns interessiert nur das erste *)

		IF LENGTH(PlugName) = 0

			THEN

				MagicStrings.Assign(Name, PlugName);

			END;

	END Name;
(*$E=*)

PROCEDURE LoadSlot(Identify, Slot, Path : ARRAY OF CHAR; private : ADDRESS; VAR Carrier : tPlugIn) : lINTEGER;

VAR dummy : tIdent;


	BEGIN

		PlugName := '';

		ListPlugs(Identify, Slot, Path, Name);

		RETURN Load(Identify, PlugName, private, Carrier, dummy);

	END LoadSlot;



PROCEDURE Free(VAR Carrier : tPlugIn);


	BEGIN

		IF Carrier # NIL

			THEN

				(* wir bitten zur deinitialisierung *)

				void.LI := Call(Carrier, 0, ADDRESS(-1));


				(* und wech mit dem Zeuch *)

				Storage.DEALLOCATE(Carrier^.mem, 0);

				Storage.DEALLOCATE(Carrier, 0);

				Carrier := NIL;

			END;

	END Free;


PROCEDURE Call(Carrier : tPlugIn; num : sINTEGER; Parm : ADDRESS) : lINTEGER;


	BEGIN

		IF (Carrier = NIL) OR (Carrier^.mem = NIL) OR (Carrier^.proc^.num < num)

			THEN

				RETURN MAX(lINTEGER);

			ELSE

(******** an MM2 anpassen *********)

				RETURN Carrier^.proc^.Procs[num](Parm);

			END;

	END Call;


END PlugIn2.
		
	
	