MODULE No_SCSI;
(****************************************************************************
 *
 * Alle SCSI-Kommandos werden abgefangen und ignoriert.
 *
 *
 * $Source: e:\hm2\user\gemar\plugin\RCS\no_scsi.m,v $
 *
 * $Revision: 1.1 $
 *
 * $Author: S_Engel $
 *
 * $Date: 1995/01/01 20:03:06 $
 *
 * $State: Exp $
 *
 *****************************************************************************
 * History:
 *
 * $Log: no_scsi.m,v $
 * Revision 1.1  1995/01/01  20:03:06  S_Engel
 * Initial revision
 *
 *
 *
 ****************************************************************************)


IMPORT SYSTEM, System, CPX;
FROM SYSTEM IMPORT CODE;

(* Standard HM2-Libs *)
IMPORT Block, form;

(* Magic-Lib *)
FROM MagicSys 	IMPORT
								(* Const *) Nil, Null, Bit0, Bit1, Bit2, Bit3, Bit4, Bit5,
														Bit6, Bit7, Bit8, Bit9, Bit10, Bit11, Bit12,
														Bit13, Bit14, Bit15,
								(* Type  *) LOC, Byte, ByteSet, sWORD, sINTEGER, sCARDINAL,
														sBITSET, lINTEGER, lCARDINAL, lWORD, lBITSET;
IMPORT MagicDOS;

(* Magic-Tools *)

(* Eigene Libs *)
IMPORT Scsi2, ScsiCmd, void;

(* Projektlibs *)
IMPORT PlugParms, GemarPlugParms;




TYPE
			UChar 			= [0..255];
			tpCmdBlock	= POINTER TO tCmdBlock;
			tCmdBlock 	= RECORD
											Command : UChar;
											Lun 		: UChar;
											Adr 		: LONGCARD;
											Zero		: UChar;
											LenHigh : UChar;
											LenLow	: UChar;
											Flags 	: SYSTEM.BYTE;
										END;

VAR PlugEnv 		: PlugParms.tpPlugEnvironment;
		PlugPrivate : GemarPlugParms.tpPlugParms;
		PlugProcs 	: RECORD
										num  : SHORTINT;
										Proc : ARRAY[0..1] OF PlugParms.tPlugProc;
									END;
		Timer[04BAH]: LONGCARD;

(*$G-*)
CONST InquiryData = ScsiCmd.InquiryType{
											01,
											SYSTEM.BYTE(0),
											SYSTEM.BYTE(0),
											SYSTEM.BYTE(0),
											32,
											SYSTEM.BYTE(0),
											{SYSTEM.BYTE(0) BY 2},
											'Nichts  ',
											'                ',
											'0000'
											};
(*$G=*)
TYPE SenseType = RECORD
									 Head : Scsi2.tParmHead;
									 Desc : Scsi2.tBlockDesc;
								 END;

CONST  SenseData = SenseType{
															{
															 0,
															 0,
															 BYTESET{},
															 8
															},
															{0,
															 512
															}
														};

(*$K+ $E+ *)
PROCEDURE ScsiIn(pCmd : GemarPlugParms.tpScsiCmd) : SHORTINT;
VAR Msg 	: ARRAY[0..100] OF CHAR;
		ret 	: SHORTINT;
		Time	: LONGCARD;

	BEGIN
		(* Hier sind wir auch im Deinitialisierungsslot! *)
		IF pCmd = SYSTEM.ADDRESS(-1)
			THEN
				(* hier eventuelle Deinstallationen durchfhren *)
				RETURN 0;
			END;


		(* Hier kann zB das Kommando ausgewertet werden *)
		CASE tpCmdBlock(pCmd^.Cmd)^.Command OF
			|012H : (* Inquiry *)
							Block.Move(SYSTEM.ADR(InquiryData), pCmd^.Buffer, pCmd^.Transferlen);
			|01AH : (* Mode Sense *)
							Block.Move(SYSTEM.ADR(SenseData), pCmd^.Buffer, pCmd^.Transferlen);

			ELSE		Block.Clear(pCmd^.Buffer, pCmd^.Transferlen);

		END;


		RETURN 0;

	END ScsiIn;
(*$K= $E+ *)

(*$K+ $E+ *)
PROCEDURE ScsiOut(pCmd : GemarPlugParms.tpScsiCmd) : SHORTINT;
VAR Msg 	: ARRAY[0..100] OF CHAR;
		ret 	: SHORTINT;
		Time	: LONGCARD;

	BEGIN
		(* Hier sind wir auch im Deinitialisierungsslot! *)
		IF pCmd = SYSTEM.ADDRESS(-1)
			THEN
				(* hier eventuelle Deinstallationen durchfhren *)
				RETURN 0;
			END;

		(* Hier kann das Kommando ausgewertet werden *)
		CASE tpCmdBlock(pCmd^.Cmd)^.Command OF
			ELSE
		END;

		RETURN 0;

	END ScsiOut;
(*$K= $E+ *)


BEGIN

	PlugEnv := PlugParms.tpPlugEnvironment(CPX.pXCPB);
	IF PlugEnv^.Version # 0100H
		THEN
			VOID(form.alert(1, '[3][PlugIn: falsche Parameterversion][Abbruch]'));
			CPX.Return(NIL);
		END;

	PlugPrivate := PlugEnv^.Private;

	IF PlugPrivate^.Version # 0200H
		THEN
			void.I := PlugEnv^.Alert(1, '[3][PlugIn (SCSI):|falsche Parameterversion][Aha]');
			CPX.Return(NIL);
		ELSE
			WITH PlugProcs DO
				num := 2;
				Proc[0] := PlugParms.tPlugProc(ScsiIn);
				Proc[1] := PlugParms.tPlugProc(ScsiOut);
			END;
			CPX.Return(SYSTEM.ADR(PlugProcs));
		END;
END No_SCSI.
		
	
	