MODULE NCR6342;
(****************************************************************************
 *
 * Abfangen von Write Filemark fr NCR 6343-ADP-CNTLR6343
 * Der Controller meldet Recovered Erros, die whrend des gelaufenene Backups
 * aufgetreten sind, beim Schreiben des Filemarks.
 * Dies fhrt in GEMAR zum Abbruch des Backup.
 *
 * Mit diesem PlugIn wird ein Fehler beim Schreiben des Filemark ignoriert.
 *
 * $Source: /dev/e/hm2/user/gemar/plugin\RCS\NCR6342.M,v $
 *
 * $Revision: 1.1 $
 *
 * $Author: S_Engel $
 *
 * $Date: 1995/01/01 21:29:36 $
 *
 * $State: Exp $
 *
 *****************************************************************************
 * History:
 *
 * $Log: NCR6342.M,v $
 * Revision 1.1  1995/01/01  21:29:36  S_Engel
 * Initial revision
 *
 *
 *
 ****************************************************************************)




IMPORT SYSTEM, CPX;
FROM SYSTEM IMPORT CODE, ADDRESS, BYTE;

IMPORT form;

(* Magic-Lib *)
FROM MagicSys 	IMPORT
								(* Const *) Nil, Null, Bit0, Bit1, Bit2, Bit3, Bit4, Bit5,
														Bit6, Bit7, Bit8, Bit9, Bit10, Bit11, Bit12,
														Bit13, Bit14, Bit15,
								(* Type  *) LOC, Byte, ByteSet, sWORD, sINTEGER, sCARDINAL,
														sBITSET, lINTEGER, lCARDINAL, lWORD, lBITSET;

IMPORT MagicDOS, void;

IMPORT PlugParms, GemarPlugParms;


TYPE
			UChar 			= [0..255];
			tpCmdBlock	= POINTER TO tCmdBlock;
			tCmdBlock 	= RECORD
											Command : UChar;
											Lun 		: UChar;
											Adr 		: LONGCARD;
											Zero		: UChar;
											LenHigh : UChar;
											LenLow	: UChar;
											Flags 	: BYTE; 
										END;

VAR PlugEnv 		: PlugParms.tpPlugEnvironment;
		PlugPrivate : GemarPlugParms.tpPlugParms;
		PlugProcs 	: RECORD
										num  : SHORTINT;
										Proc : ARRAY[0..1] OF PlugParms.tPlugProc;
									END;
		Timer[04BAH]: LONGCARD;


(*$K+ $E+ *)
PROCEDURE ScsiIn(pCmd : GemarPlugParms.tpScsiCmd) : SHORTINT;
VAR Msg 	: ARRAY[0..100] OF CHAR;
		ret 	: SHORTINT;
		Time	: LONGCARD;

	BEGIN
		(* Hier sind wir auch im Deinitialisierungsslot! *)
		IF pCmd = SYSTEM.ADDRESS(-1)
			THEN
				(* hier eventuelle Deinstallationen durchfhren *)
				RETURN 0;
			END;


		(* Hier kann zB das Kommando ausgewertet werden *)
		CASE tpCmdBlock(pCmd^.Cmd)^.Command OF
			|10H : (* Write Filemark abfangen *)
				ret := PlugPrivate^.ScsiIn(pCmd);
				IF ret = 2
					THEN
						(* Behauptung: Das war nur der dmliche Streamer *)
						ret := 0;
					END;
			ELSE
				ret := PlugPrivate^.ScsiIn(pCmd);
		END;


		RETURN ret;

	END ScsiIn;
(*$K= $E+ *)

(*$K+ $E+ *)
PROCEDURE ScsiOut(pCmd : GemarPlugParms.tpScsiCmd) : SHORTINT;
VAR Msg 	: ARRAY[0..100] OF CHAR;
		ret 	: SHORTINT;
		Time	: LONGCARD;

	BEGIN
		(* Hier sind wir auch im Deinitialisierungsslot! *)
		IF pCmd = SYSTEM.ADDRESS(-1)
			THEN
				(* hier eventuelle Deinstallationen durchfhren *)
				RETURN 0;
			END;

		(* Hier kann das Kommando ausgewertet werden *)
		CASE tpCmdBlock(pCmd^.Cmd)^.Command OF
			ELSE
				ret := PlugPrivate^.ScsiOut(pCmd);
		END;

		RETURN ret;

	END ScsiOut;
(*$K= $E+ *)


BEGIN


	PlugEnv := PlugParms.tpPlugEnvironment(CPX.pXCPB);

	IF PlugEnv^.Version # 0100H

		THEN

			VOID(form.alert(1, '[3][PlugIn: falsche Parameterversion][Abbruch]'));

			CPX.Return(NIL);

		END;


	PlugPrivate := PlugEnv^.Private;


	IF PlugPrivate^.Version # 0200H

		THEN

			void.I := PlugEnv^.Alert(1, '[3][PlugIn (SCSI):|falsche Parameterversion][Aha]');

			CPX.Return(NIL);

		ELSE

			WITH PlugProcs DO

				num := 2;

				Proc[0] := PlugParms.tPlugProc(ScsiIn);

				Proc[1] := PlugParms.tPlugProc(ScsiOut);

			END;

			CPX.Return(SYSTEM.ADR(PlugProcs));

		END;
END NCR6342.
		
	
	