MODULE Inquiry;

(****************************************************************************
 *
 * SCSI-PlugIn fr GEMAR
 * Inquiry vortuschen
 *
 * $Source$
 *
 * $Revision$
 *
 * $Author$
 *
 * $Date$
 *
 * $State$
 *
 *****************************************************************************
 * History:
 *
 * $Log$
 *
 *
 ****************************************************************************)



(* Systemabhngiges *)
(* IMPLEMENTATION FR  >>> Hnisch-Modula-2 <<< *)
(*                                              *)
(* Durchgefhrt von Steffen Engel               *)
(*                                              *)
(*$S-   Stack-Checks                            *)
(*$I-   keine Variablen-Initialisierung         *)
(*$V-   keine arithmetischen Kontrollen         *)
(*$T-   kein Bereichstest                       *)
(*$Y-   keine Laufzeittests auf RETURN und CASE *)
(*                                              *)
(*----------------------------------------------*)

IMPORT SYSTEM, System;
FROM SYSTEM IMPORT BYTE;

IMPORT CPX;

(* Standard HM2-Libs *)
IMPORT form, Block;

(* Magic-Lib *)
FROM MagicSys   IMPORT
                (* Const *) Nil, Null, Bit0, Bit1, Bit2, Bit3, Bit4, Bit5,
                            Bit6, Bit7, Bit8, Bit9, Bit10, Bit11, Bit12,
                            Bit13, Bit14, Bit15,
                (* Type  *) LOC, Byte, ByteSet, sWORD, sINTEGER, sCARDINAL,
                            sBITSET, lINTEGER, lCARDINAL, lWORD, lBITSET;

(* Magic-Tools *)

(* Eigene Libs *)
IMPORT C_Port;

(* Projektlibs *)

IMPORT void;

IMPORT PlugParms, GemarPlugParms;


TYPE

      UChar       = [0..255];
      tpCmdBlock  = POINTER TO tCmdBlock;
      tCmdBlock   = RECORD
                      Command : UChar;
                      Lun     : UChar;
                      Adr     : SHORTCARD;
                      Len     : UChar;
                      Flags   : BYTE;
                    END;  

VAR PlugEnv     : PlugParms.tpPlugEnvironment;
    PlugPrivate : GemarPlugParms.tpPlugParms;
    PlugProcs   : RECORD
                    num  : SHORTINT;
                    Proc : ARRAY[0..1] OF PlugParms.tPlugProc;
                  END;


PROCEDURE Max(a, b : LONGCARD) : LONGCARD;


  BEGIN

    IF a > b

      THEN

        RETURN a;

      ELSE

        RETURN b;

      END;

  END Max;
PROCEDURE Min(a, b : LONGCARD) : LONGCARD;


  BEGIN

    IF a < b

      THEN

        RETURN a;

      ELSE

        RETURN b;

      END;

  END Min;


PROCEDURE Inquiry(SCmd : tpCmdBlock; pCmd : GemarPlugParms.tpScsiCmd) : SHORTINT;
VAR tInq  :  RECORD
               Device          : C_Port.UChar;
               DeviceQualifier : BYTE;
               VersionFlags    : BYTE;
               FormatFlags     : BYTE;
               AdditionalLen   : C_Port.UChar;
               Res1            : BYTE;
               Reserved        : ARRAY[6..7] OF BYTE;
               Vendor          : ARRAY[0..7] OF CHAR;
               Product         : ARRAY[0..15] OF CHAR;
               RevionsData     : ARRAY[0..3] OF CHAR;
             END;

  BEGIN
    WITH tInq DO
      Device := 1;
      DeviceQualifier := BYTE(0);
      VersionFlags := BYTE(0);
      FormatFlags := BYTE(0);
      Res1 := BYTE(0);
      AdditionalLen := VAL(C_Port.UChar, SIZE(tInq)-5);
      Reserved[6] := BYTE(0);
      Reserved[7] := BYTE(0);
      Vendor := 'unknown';
      Vendor[7] := ' ';
      Product := ' (PlugIn)      ';
      Product[15] := ' ';
      RevionsData := '000';
      RevionsData[3] := ' ';
    END;
    Block.Move(SYSTEM.ADR(tInq), pCmd^.Buffer, Min(SIZE(tInq), pCmd^.Transferlen));
    RETURN 0;
  END Inquiry;

(*$K+ $E+ *)
PROCEDURE ScsiIn(pCmd : GemarPlugParms.tpScsiCmd) : SHORTINT;
VAR SCmd : tpCmdBlock;

  BEGIN
    (* in dem Slot wird auch deinitialisiert *)
    IF pCmd = SYSTEM.ADDRESS(-1)
      THEN
        RETURN 0;
      END;

    (* Hier kann abgefangen werden *)
    SCmd := tpCmdBlock(pCmd^.Cmd);

    CASE SCmd^.Command OF
      |12H: RETURN Inquiry(SCmd, pCmd);
      ELSE
        RETURN PlugPrivate^.ScsiIn(pCmd);
    END;
  END ScsiIn;
(*$K= $E+ *)

(*$K+ $E+ *)
PROCEDURE ScsiOut(pCmd : GemarPlugParms.tpScsiCmd) : SHORTINT;
VAR SCmd : tpCmdBlock;

  BEGIN
    SCmd := tpCmdBlock(pCmd^.Cmd);
    (* Hier kann abgefangen werden *)
    CASE SCmd^.Command OF
      ELSE
        RETURN PlugPrivate^.ScsiOut(pCmd);
    END;
  END ScsiOut;
(*$K= $E+ *)



BEGIN

  PlugEnv := PlugParms.tpPlugEnvironment(CPX.pXCPB);
  IF PlugEnv^.Version # PlugParms.ParmVersion
    THEN
      VOID(form.alert(1, '[3][PlugIn: falsche Parameterversion][Abbruch]'));
      CPX.Return(NIL);
    END;

  PlugPrivate := PlugEnv^.Private;

  IF PlugPrivate^.Version # 0200H
    THEN
      void.I := PlugEnv^.Alert(1, '[3][PlugIn (Space):|falsche Parameterversion][Aha]');
      CPX.Return(NIL);
    ELSE
      WITH PlugProcs DO
        num := 2;
        Proc[0] := PlugParms.tPlugProc(ScsiIn);
        Proc[1] := PlugParms.tPlugProc(ScsiOut);
      END;

      CPX.Return(SYSTEM.ADR(PlugProcs));
    END;

END Inquiry.
