 include "prtequ.h"

*
* Xerox 4020 Color print driver
*
CR	equ	$d
LF	equ	$a
FF	equ	$c
ESC	equ	$1b

 SECTION printer,CODE,PUBLIC
***************************************************************
***************************************************************
***************************************************************
dumbentry:
	clr.l	d0
	rts

	dc.l	"PRNT"
	dc.w	200

*
* distribute the calls to the appropriate routines
*
x4020c:
	move.l	a0,table
	lsl.w	#2,d0
	lea	prntbl,a1
	move.l	0(a1,d0.w),a1
	jmp	(a1)

*
* identify who I am, and set up who I like to speak to.
*
p_ident:
	move.l	#driver,pdrvrnm(a0)	;pointer to string for driver name
	move.w	#PARALLEL+ASCENDING,device(a0)
prtok:	moveq	#1,d0
	rts

*
* initialize the table of printer specific routines
*
p_init:	clr.b	pdl(a0)			;no page description language
	clr.b	pmult(a0)		;automatically print mulitiple copies?
	clr.b	pman(a0)		;handle manual feed?
	move.b	#PRT_CMYK,ptype(a0)	;printer type?

	move.l	sendout(a0),send+2	;self-modifing code, tisk, tisk!

*
*

	move.w	pdensity(a0),d0
	cmp.w	#7,d0
	bcs	pint1
	moveq	#6,d0
pint1:	lsl.w	#1,d0

	lea	xdpi_tbl,a1
	move.w	0(a1,d0.w),pxdpi(a0)	;x resolution
	lea	ydpi_tbl,a1
	move.w	0(a1,d0.w),pydpi(a0)	;y resolution
	lea	minl_tbl,a1
	move.w	0(a1,d0.w),pminlft(a0)	;pixels from the left
	lea	minr_tbl,a1
	move.w	0(a1,d0.w),pminrht(a0)	;pixels from the right
	lea	mint_tbl,a1
	move.w	0(a1,d0.w),pmintop(a0)	;pixels down from top
	lea	minb_tbl,a1
	move.w	0(a1,d0.w),pminbot(a0)	;pixels up from bottom
	lea	xover_tbl,a1
	move.w	0(a1,d0.w),pxover(a0)	;percentage of x overlap of dots
	lea	yover_tbl,a1
	move.w	0(a1,d0.w),pyover(a0)	;percentage of y overlap of dots
	lea	rowht_tbl,a1
	move.w	0(a1,d0.w),prowht(a0)	;rows height modula

	move.w	0(a1,d0.w),rowht
	lea	rows_tbl,a1
	move.w	0(a1,d0.w),rows
	lea	grmode_tbl,a1
	move.w	0(a1,d0.w),grmode
	lea	speed_tbl,a1
	move.w	0(a1,d0.w),speed

	lsl.w	#1,d0
	lea	maxw_tbl,a1
	move.l	0(a1,d0.w),pmaxw(a0)	;maximum # pixels across
	lea	maxh_tbl,a1
	move.l	0(a1,d0.w),pmaxh(a0)	;maximum # pixels down

	bra	prtok

*
* going to begin printing a document
*
p_bgndoc:
	tst.w	speed
	bne	pbgn1
	lea	header1,a0		;bidirectional
	jmp	sendline

pbgn1:	lea	header2,a0		;unidirectional
	jmp	sendline

*
* about to start printing of a page
*
p_bgnpage:
	bra	prtok

*
* about to print a new tile for the page
*
p_bgntile:
	bra	prtok

*
* print a block to the printer
*
p_block:
	move.l	table,a0
	move.l	pblockplane(a0),pplane
	move.l	pblockw(a0),d0
	move.w	d0,width
	move.l	pblockptr(a0),a1
	move.l	(a1),a1
	add.l	pblockoff(a0),a1
	move.l	a1,v_base
*
*
	move.w	rows,loop
pblck2:	move.l	v_base,lineptr		;cyan
	move.b	#"<",gcolor
	bsr	putline

	move.l	v_base,lineptr		;magenta
	move.l	pplane,d0
	add.l	d0,lineptr
	move.b	#"4",gcolor
	bsr	putline

	move.l	v_base,lineptr		;yellow
	move.l	pplane,d0
	lsl.l	#1,d0
	add.l	d0,lineptr
	move.b	#"8",gcolor
	bsr	putline

	move.l	v_base,lineptr		;black
	move.l	pplane,d0
	lsl.l	#1,d0
	add.l	pplane,d0
	add.l	d0,lineptr
	move.b	#"0",gcolor
	bsr	putline

	moveq	#0,d0
	move.w	width,d0
	add.l	d0,v_base
	move.b	#ESC,d0
	bsr	send
	move.b	#"k",d0
	bsr	send
	move.b	#"2",d0
	bsr	send
	subq.w	#1,loop
	bne	pblck2
*
	move.b	#ESC,d0
	bsr	send
	move.b	#"k",d0
	bsr	send
	move.b	#"1",d0
	bra	send

**************************************

putline:
	move.l	lineptr,a0
	move.w	#0,twidth
	move.w	#3,d1
ptln0:	move.w	width,d0
ptln1:	tst.b	-1(a0,d0.w)
	bne	ptln2
	subq.w	#1,d0
	bne	ptln1
ptln2:	cmp.w	twidth,d0
	blt	ptln3
	move.w	d0,twidth
ptln3:	move.w	rows,d3
	mulu	width,d3
	add.l	d3,a0
	dbf	d1,ptln0
*
	tst.w	twidth
	beq	prtok

	move.w	#4,count
print1:	move.b	#ESC,d0
	bsr	send
	move.b	#"g",d0
	bsr	send
	move.b	gcolor,d0
	bsr	send
	add.b	#1,gcolor

	moveq	#0,d0
	move.w	twidth,d0		;send number of graphic bytes to follow
	tst.w	grmode
	beq	prnt1
	addq.w	#1,d0
	lsr.w	#1,d0
prnt1:	divu	#100,d0
	or.b	#"0",d0
	move.l	d0,-(sp)
	bsr	send
	move.l	(sp)+,d0
	eor.w	d0,d0
	swap	d0
	divu	#10,d0
	or.b	#"0",d0
	move.l	d0,-(sp)
	bsr	send
	move.l	(sp)+,d0
	swap	d0
	or.b	#"0",d0
	bsr	send
	move.b	#",",d0
	bsr	send

print2:	move.w	twidth,d7                 ;length of the data in byte
	move.l	lineptr,a0
print4:	tst.w	grmode
	beq	prt1

	move.w	(a0)+,d1
	move.w	#15,d2
	move.w	#7,d3
	moveq	#0,d0
prt5:	btst	d2,d1
	beq	prt6
	bset	d3,d0
prt6:	subq.w	#1,d2
	btst	d2,d1
	beq	prt7
	bset	d3,d0
prt7:	subq.w	#1,d2
	dbf	d3,prt5
	bra	prt2

prt1:	move.b	(a0)+,d0

prt2:	move.w	d7,-(sp)
	move.l	a0,-(sp)
	bsr	send
	move.l	(sp)+,a0
	move.w	(sp)+,d7
	tst.w	grmode
	beq	prt3
	subq.w	#2,d7
	bgt	print4
	bra	prt4
prt3:	subq.w	#1,d7
	bgt	print4

prt4:	moveq	#0,d0
	move.w	width,d0
	add.l	d0,lineptr

	subq.w	#1,count
	bne	print1

	move.w	speed,d0
	mulu	#65535,d0
wait:	mulu	#10,d1
	divu	#10,d1
	mulu	#10,d1
	divu	#10,d1
	dbf	d0,wait
	rts


************************************
*
* just finished describing current tile
*
p_endtile:
	bra	prtok

*
* just finished describing all tiles for this page
*
p_endpage:
	bra	prtok

*
* finished printing the document
*
p_enddoc:
	bra	prtok

***************************************************
***	these are the send routines for the	***
***	dot matrix driver.			***
***************************************************
sendline:
	move.b	(a0)+,d0
	beq	prtok
	move.l	a0,-(sp)
	bsr	send
	move.l	(sp)+,a0
	bra	sendline

send:	jmp	$ffffff

***********************************
***				***
***********************************
 SECTION printer,DATA,PUBLIC

prntbl:	dc.l	prtok,prtok,prtok,prtok,p_init
	dc.l	p_bgndoc,p_bgnpage,p_bgntile
	dc.l	p_block
	dc.l	p_endtile,p_endpage,p_enddoc
	dc.l	prtok,p_ident


xdpi_tbl:	dc.w	120,120,240,240,240,240,240
ydpi_tbl:	dc.w	120,240,240,240,240,240,240
minl_tbl:	dc.w	30,30,60,60,60,60,60
minr_tbl:	dc.w	30,30,60,60,60,60,60
mint_tbl:	dc.w	0,0,0,0,0,0,0
minb_tbl:	dc.w	0,0,0,0,0,0,0
maxw_tbl:	dc.l	960,960,1920,1920,1920,1920,1920
maxh_tbl:	dc.l	0,0,0,0,0,0,0
xover_tbl:	dc.w	0,0,50,50,50,50,50
yover_tbl:	dc.w	0,50,50,50,50,50,50
rowht_tbl:	dc.w	4,8,8,8,8,8,8
rows_tbl:	dc.w	1,2,2,2,2,2,2
grmode_tbl:	dc.w	0,0,1,1,1,1,1
speed_tbl:	dc.w	0,1,1,1,1,1,1


driver:		dc.b	"Xerox 4020 Color v2.0",0
header1:	dc.b	ESC,"we",ESC,$2f,0
header2:	dc.b	ESC,"we",ESC,$5c,0

 SECTION printer,BSS,PUBLIC
table:		ds.l	1
twidth:		ds.w	1
pixel:		ds.w	1
v_base:		ds.l	1
lineptr:	ds.l	1
width:		ds.w	1
pplane:		ds.l	1
count:		ds.w	1
loop:		ds.w	1
grmode:		ds.w	1
rows:		ds.w	1
rowht:		ds.w	1
gcolor:		ds.w	1
speed:		ds.w	1
