
 Include "pdlequ.h"

*
* Tektronix 4693D Color Image Printer Device
*
CR	equ	$d
LF	equ	$a
FF	equ	$c
ESC	equ	$1b
DC2	equ	$12

*
*
 SECTION tek4693,CODE,PUBLIC
*
***************************************************************
***************************************************************
***************************************************************
dumbentry:
	clr.l	d0
	rts

	dc.l	"PRNT"
	dc.w	200

*
*
* distribute the calls the the appropriate routines
*
tek4693:
	move.l	a0,table
	lsl.w	#2,d0
	lea	prntbl,a1
	move.l	0(a1,d0.w),a1
	jmp	(a1)

*
* identify who I am, and set up who I like to speak to.
*
p_ident:
	move.l	#driver,pdrvrnm(a0)	;pointer to string for driver name
	move.w	#$4000+ASCENDING+PARALLEL,device(a0)
prtok:	moveq	#1,d0
rrts:	rts

*
* initialize the table of printer specific routines
*
p_init:
	clr.b	pdl(a0)			;no page description language
	move.b	#0,pmult(a0)		;automatically print mulitiple copies?
	move.b	#0,pman(a0)		;handle manual feed?
	move.b	#PRT_CMYK,ptype(a0)	;printer type?
	move.l	sendout(a0),send+2	;self-modifing code, tisk, tisk!

*
* pminlft(?) and pmaxw must be evenly divisible by 16
* this is the part that should be worked out
*

	move.w	pdensity(a0),d0
	cmp.w	#7,d0
	bcs	pint1
	moveq	#6,d0
pint1:	lsl.w	#1,d0

	lea	xdpi_tbl,a1
	move.w	0(a1,d0.w),pxdpi(a0)	;x resolution
	lea	ydpi_tbl,a1
	move.w	0(a1,d0.w),pydpi(a0)	;y resolution
	lea	minl_tbl,a1
	move.w	0(a1,d0.w),pminlft(a0)	;pixels from the left
	lea	minr_tbl,a1
	move.w	0(a1,d0.w),pminrht(a0)	;pixels from the right
	lea	mint_tbl,a1
	move.w	0(a1,d0.w),pmintop(a0)	;pixels down from top
	lea	minb_tbl,a1
	move.w	0(a1,d0.w),pminbot(a0)	;pixels up from bottom
	lea	xover_tbl,a1
	move.w	0(a1,d0.w),pxover(a0)	;percentage of x overlap of dots
	lea	yover_tbl,a1
	move.w	0(a1,d0.w),pyover(a0)	;percentage of y overlap of dots
	lea	rowht_tbl,a1
	move.w	0(a1,d0.w),prowht(a0)	;rows height modula

	lsl.w	#1,d0
	lea	maxw_tbl,a1
	move.l	0(a1,d0.w),pmaxw(a0)	;maximum # pixels across
	lea	maxh_tbl,a1
	move.l	0(a1,d0.w),pmaxh(a0)	;maximum # pixels down
	bra	prtok

*
* going to begin printing a document
*
p_bgndoc:
	move.b	#$3,d0
	bsr	dsend
	move.b	#$5,d0
	bra	dsend


*
* about to start printing of a page
*
p_bgnpage:
	bra	prtok

*
* about to print a new tile for the page

*	$14		BCMY
*	$d4 length of header  (20)
*	 11010100
*	$xxxx width in pixels
*	 11xxxxxx high order
*	 10xxxxxx low order
*	$xxxx height in pixels
*	 11xxxxxx high order
*	 10xxxxxx low order
*	$c1 communication method (Handshaking)
*	$c1 ($c1=1 copy) copies
*	$c1 pixel shape (rectangular)
*	$a0 width to height
*	$da pixel format (BCMY)
*	$c1 pixel ordering (left to right scan)
*	$c1 image sizing (do not change size)
*	$c1 image rendering (use closest eight colors)
*	$c1 color conversion (do no corrections)
*	$c1 image color manipulation (do no adjustments)
*	$c1 black&white inversion (do no color exchange)
*	$c3 hard copy orientation (portrait centered)
*	$c080 output media (use printer defaults)
*	$xx checksum ($80 + 7 bit checksum)
*	$02 eol
*
p_bgntile:
	clr.b	chksum

	move.b	#$14,d0
	bsr	csend
	move.b	#$d4,d0
	bsr	csend

	move.l	table,a0
	move.l	PPageWidth(a0),d0
	and.w	#%111111000000,d0
	lsr.w	#6,d0
	or.w	#%11000000,d0
	bsr	csend
	move.l	table,a0
	move.l	PPageWidth(a0),d0
	and.w	#%111111,d0
	or.w	#%10000000,d0
	bsr	csend

	move.l	table,a0
	move.l	PPageHeight(a0),d0
	and.w	#%111111000000,d0
	lsr.w	#6,d0
	or.w	#%11000000,d0
	bsr	csend
	move.l	table,a0
	move.l	PPageHeight(a0),d0
	and.w	#%111111,d0
	or.w	#%10000000,d0
	bsr	csend

	move.b	#$c1,d0
	bsr	csend
	move.l	table,a0
	move.w	pcopies(a0),d0
	or.b	#$c0,d0
	bsr	csend
	move.b	#$c1,d0
	bsr	csend
	move.b	#$a0,d0
	bsr	csend
	move.b	#$da,d0
	bsr	csend
	move.b	#$c1,d0
	bsr	csend
	move.b	#$c1,d0
	bsr	csend
	move.b	#$c1,d0
	bsr	csend
	move.b	#$c1,d0
	bsr	csend
	move.b	#$c1,d0
	bsr	csend
	move.b	#$c1,d0
	bsr	csend
	move.b	#$c3,d0
	bsr	csend
	move.b	#$c0,d0
	bsr	csend
	move.b	#$80,d0
	bsr	csend
	move.b	chksum,d0
	or.b	#$80,d0
	bsr	dsend
	move.b	#$02,d0
	bra	dsend

csend:	add.b	d0,chksum
dsend:	bsr	send
	move.l	d0,-(sp)
	move.w	#30,d1
ds0:	move.w	#10000,d0
ds1:	mulu	#10,d0
	divu	#10,d0
	dbf	d0,ds1
	dbf	d1,ds0
	move.l	(sp)+,d0
	rts

*
* send a line to the printer
*
p_block:
	move.l	table,a0
	move.l	pblockh(a0),d0
	lea	string,a0
	jsr	itoa
	lea	string,a0
	jsr	putmessage

	move.l	table,a0
	move.l	pblockw(a0),d0
	move.w	d0,width
	move.l	pblockplane(a0),pplane
	move.l	pblockptr(a0),a1
	move.l	(a1),a1
	add.l	pblockoff(a0),a1
	move.l	a1,v_base
*
*	move.w	width,d0
*	move.l	v_base,a0
*n1:	tst.b	-1(a0,d0.w)
*	bne	putln2
*	subq.w	#1,d0
*	bne	putln1
*	moveq	#1,d0
*n2:	move.w	d0,twidth

* pixel  1   0
* bit  76543210
*      BCMYBCMY

	move.w	width,d1
	lsl.w	#3,d1
	move.l	v_base,a0
	moveq	#7,d2
putln3:	moveq	#0,d0

	move.l	a0,a1

	btst	d2,(a1)		;cyan pixel 0
	beq	ptln10
	bset	#2,d0
ptln10:	add.l	pplane,a1
	btst	d2,(a1)		;magenta pixel 0
	beq	ptln11
	bset	#1,d0
ptln11:	add.l	pplane,a1
	btst	d2,(a1)		;yellow pixel 0
	beq	ptln12
	bset	#0,d0
ptln12:	add.l	pplane,a1
	btst	d2,(a1)		;black pixel 0
	beq	ptln13
	bset	#3,d0
ptln13:

	dbf	d2,ptln1
	addq.l	#1,a0
	moveq	#7,d2
ptln1:	move.l	a0,a1

	btst	d2,(a1)		;cyan pixel 1
	beq	ptln20
	bset	#6,d0
ptln20:	add.l	pplane,a1
	btst	d2,(a1)		;magenta pixel 1
	beq	ptln21
	bset	#5,d0
ptln21:	add.l	pplane,a1
	btst	d2,(a1)		;yellow pixel 1
	beq	ptln22
	bset	#4,d0
ptln22:	add.l	pplane,a1
	btst	d2,(a1)		;black pixel 1
	beq	ptln23
	bset	#7,d0
ptln23:	dbf	d2,ptln2
	addq.l	#1,a0
	moveq	#7,d2
ptln2:	move.l	a0,-(sp)
	move.w	d1,-(sp)
	move.w	d2,-(sp)
	bsr	send
	move.w	(sp)+,d2
	move.w	(sp)+,d1
	move.l	(sp)+,a0
	subq.w	#2,d1
	bhi	putln3

	move.b	#$02,d0		;eol
	bsr	send
	bra	prtok

*
* just finished describing current tile
*
p_endtile:
	move.b	#$01,d0		;eot
	bra	dsend

*
* just finished describing all tiles for this page
*
p_endpage:
	bra	prtok

*
* finished printing the document
*
p_enddoc:
	move.b	#$03,d0
	bra	send




itoa:	bsr	itoa1
	clr.b	(a0)
	rts

itoa1:	and.l	#$ffff,d0
	cmp.l	#10,d0
	bcs	itoa2
	divu	#10,d0
	swap	d0
	move.w	d0,-(sp)
	swap	d0
	bsr	itoa1
	move.w	(sp)+,d0

itoa2:	or.b	#"0",d0
	move.b	d0,(a0)+
	rts


putmessage:
	move.l	table,a1		;put string a0 up in dialogbox
	move.l	printstat(a1),a1
	jmp	(a1)


***************************************************
***	these are the send routines for the	***
***	dot matrix driver.			***
***************************************************
*
sendline:
	move.b	(a0)+,d0
	beq	prtok
	move.l	a0,-(sp)
	bsr	send
	move.l	(sp)+,a0
	bra	sendline
*
*
sendn:	cmp.w	#10,d0
	bcs	sdn1
	and.l	#$ffff,d0
	divu	#10,d0
	swap	d0
	move.w	d0,-(sp)
	swap	d0
	bsr	sendn
	move.w	(sp)+,d0
sdn1:	or.b	#"0",d0
*
*	bra	send
*
*
send:	jmp	$ffffff


***********************************
***				***
***********************************
 SECTION tek4693,DATA,PUBLIC

prntbl:	dc.l	prtok,prtok,prtok,prtok,p_init
	dc.l	p_bgndoc,p_bgnpage,p_bgntile
	dc.l	p_block
	dc.l	p_endtile,p_endpage,p_enddoc
	dc.l	prtok,p_ident


xdpi_tbl:	dc.w	300,300,300,300,300,300,300
ydpi_tbl:	dc.w	300,300,300,300,300,300,300
minl_tbl:	dc.w	55,55,55,55,55,55,55
minr_tbl:	dc.w	55,55,55,55,55,55,55
maxw_tbl:	dc.w	2432,2432,2432,2432,2432,2432,2432
maxh_tbl:	dc.w	0,0,0,0,0,0,0
mint_tbl:	dc.w	0,0,0,0,0,0,0
minb_tbl:	dc.w	0,0,0,0,0,0,0
xover_tbl:	dc.w	0,0,0,0,0,0,0
yover_tbl:	dc.w	0,0,0,0,0,0,0
rowht_tbl:	dc.w	1,1,1,1,1,1,1


driver:		dc.b	"Tektronix 4693D v2.1.0 beta",0

 SECTION tek4693,BSS,PUBLIC

table:		ds.l	1

v_base:		ds.l	1
width:		ds.w	1
pplane:		ds.l	1
chksum:		ds.w	1
count:		ds.w	1
string:		ds.b	100
