 include "prtequ.h"

*
* Okimate Color driver
*
BLACK	equ	"0"
CYAN	equ	"3"
MAGENTA	equ	"5"
YELLOW	equ	"6"

CR	equ	$d
LF	equ	$a
FF	equ	$c
ESC	equ	$1b

 SECTION printer,CODE,PUBLIC
***************************************************************
***************************************************************
***************************************************************
dumbentry:
	clr.l	d0
	rts

	dc.l	"PRNT"
	dc.w	200

*
* distribute the calls to the appropriate routines
*
oki:	move.l	a0,table
	lsl.w	#2,d0
	lea	prntbl,a1
	move.l	0(a1,d0.w),a1
	jmp	(a1)

*
* identify who I am, and set up who I like to speak to.
*
p_ident:
	move.l	#driver,pdrvrnm(a0)	;pointer to string for driver name
	move.w	#PARALLEL+ASCENDING,device(a0)
prtok:	moveq	#1,d0
	rts

*
* initialize the table of printer specific routines
*
p_init:	clr.b	pdl(a0)			;no page description language
	clr.b	pmult(a0)		;automatically print mulitiple copies?
	clr.b	pman(a0)		;handle manual feed?
	move.b	#PRT_CMYK,ptype(a0)	;printer type?

	move.l	sendout(a0),send+2	;self-modifing code, tisk, tisk!

*
* pminlft and pmaxw must be evenly divisible by 16
* this is the part that should be worked out
*

	move.w	pdensity(a0),d0
	cmp.w	#7,d0
	bcs	pint1
	moveq	#6,d0
pint1:	lsl.w	#1,d0

	lea	xdpi_tbl,a1
	move.w	0(a1,d0.w),pxdpi(a0)	;x resolution
	lea	ydpi_tbl,a1
	move.w	0(a1,d0.w),pydpi(a0)	;y resolution
	lea	minl_tbl,a1
	move.w	0(a1,d0.w),pminlft(a0)	;pixels from the left
	lea	minr_tbl,a1
	move.w	0(a1,d0.w),pminrht(a0)	;pixels from the right
	lea	mint_tbl,a1
	move.w	0(a1,d0.w),pmintop(a0)	;pixels down from top
	lea	minb_tbl,a1
	move.w	0(a1,d0.w),pminbot(a0)	;pixels up from bottom
	lea	xover_tbl,a1
	move.w	0(a1,d0.w),pxover(a0)	;percentage of x overlap of dots
	lea	yover_tbl,a1
	move.w	0(a1,d0.w),pyover(a0)	;percentage of y overlap of dots
	lea	rowht_tbl,a1
	move.w	0(a1,d0.w),prowht(a0)	;rows height modula

	move.w	0(a1,d0.w),rowht
	lea	rows_tbl,a1
	move.w	0(a1,d0.w),rows
	lea	grmode_tbl,a1
	move.w	0(a1,d0.w),grmode

	lsl.w	#1,d0
	lea	maxw_tbl,a1
	move.l	0(a1,d0.w),pmaxw(a0)	;maximum # pixels across
	lea	maxh_tbl,a1
	move.l	0(a1,d0.w),pmaxh(a0)	;maximum # pixels down

	bra	prtok

*
* going to begin printing a document
*
p_bgndoc:
	bra	prtok

*
* about to start printing of a page
*
p_bgnpage:
	bra	prtok

*
* about to print a new tile for the page
*
p_bgntile:
	bra	prtok

*
* print a block to the printer
*
p_block:
	move.l	table,a0
	move.l	pblockplane(a0),pplane
	move.l	pblockw(a0),d0
	move.w	d0,width
	move.l	pblockptr(a0),a1
	move.l	(a1),a1
	add.l	pblockoff(a0),a1
	move.l	a1,v_base

	move.w	rows,count
printl:	lea	setcolor,a0		;yellow
	bsr	sendline
	move.b	#YELLOW,d0
	bsr	send
	move.l	v_base,lineptr
	move.l	pplane,d0
	lsl.l	#1,d0
	add.l	d0,lineptr
	bsr	putline
	lea	setcolor,a0		;magenta
	bsr	sendline
	move.b	#MAGENTA,d0
	bsr	send
	move.l	v_base,lineptr
	move.l	pplane,d0
	add.l	d0,lineptr
	bsr	putline
	lea	setcolor,a0		;cyan
	bsr	sendline
	move.b	#CYAN,d0
	bsr	send
	move.l	v_base,lineptr
	bsr	putline
	lea	setcolor,a0		;black
	bsr	sendline
	move.b	#BLACK,d0
	bsr	send
	move.l	v_base,lineptr
	move.l	pplane,d0
	lsl.l	#1,d0
	add.l	pplane,d0
	add.l	d0,lineptr
	bsr	putline

	moveq	#0,d0
	move.w	width,d0
	add.l	d0,v_base
	subq.w	#1,count
	bne	printl
*
	move.b	#ESC,d0			;line spacing to 1/144"
	bsr	send
	move.b	#"J",d0
	bsr	send
	move.b	#16,d0
	bra	send


**************************************

putline:
	move.l	lineptr,a0
	clr.w	twidth
	move.w	#23,d1
print0:	move.w	width,d0
print1:	tst.b	-1(a0,d0.w)
	bne	print2
	subq.w	#1,d0
	bne	print1

print2:	cmp.w	twidth,d0
	blt	print3
	move.w	d0,twidth
print3:	add.w	width,a0
	dbf	d1,print0

	tst.w	twidth
	beq	wspace

	lea	setgr,a0
	bsr	sendline
	move.w	grmode,d0
	bsr	send
	move.w	twidth,d0		;send number of graphic rows to follow
	lsl.w	#3,d0
	bsr	send
	move.w	twidth,d0
	lsr.w	#5,d0
	bsr	send

print4:	move.w	#7,pixel
print6:	move.w	#3,bytes
	move.l	lineptr,a0
print5:	move.w	pixel,d4
	moveq	#7,d1
	moveq	#0,d0
s1:	btst	d4,(a0)
	beq 	s2
	bset	d1,d0
s2:	add.w	width,a0
	dbf	d1,s1
	move.l	a0,-(sp)
	bsr	send
	move.l	(sp)+,a0

	subq.w	#1,bytes
	bne	print5
	sub.w	#1,pixel
	bcc	print6
	add.l	#1,lineptr
	subq.w	#1,twidth
	bne	print4
*
wspace:	move.w	#CR,d0
	bra	send

************************************
*
* just finished describing current tile
*
p_endtile:
	move.l	table,a0
	move.l	pblockh(a0),d0
	mulu	#216,d0
	divu	pydpi(a0),d0
	move.w	d0,scroll
pend1:	tst.b	scroll
	beq	pend2
	move.b	#ESC,d0
	bsr	send
	move.b	#"J",d0
	bsr	send
	move.b	#255,d0
	bsr	send
	sub.w	#255,scroll
	bra	pend1
pend2:	tst.w	scroll
	beq	prtok
	move.b	#ESC,d0
	bsr	send
	move.b	#"J",d0
	bsr	send
	move.w	scroll,d0
	bra	send

*
* just finished describing all tiles for this page
*
p_endpage:
	bra	prtok

*
* finished printing the document
*
p_enddoc:
	bra	prtok

*
* user requested stop
*
p_break:
	bra	p_endtile

***************************************************
***	these are the send routines for the	***
***	dot matrix driver.			***
***************************************************
sendline:
	move.b	(a0)+,d0
	beq	prtok
	move.l	a0,-(sp)
	bsr	send
	move.l	(sp)+,a0
	bra	sendline

send:	jmp	$ffffff

***********************************
***				***
***********************************
 SECTION printer,DATA,PUBLIC

prntbl:	dc.l	prtok,prtok,prtok,prtok,p_init
	dc.l	p_bgndoc,p_bgnpage,p_bgntile
	dc.l	p_block
	dc.l	p_endtile,p_endpage,p_enddoc
	dc.l	p_break,p_ident


xdpi_tbl:	dc.w	60,60,120,120,180,180,180
ydpi_tbl:	dc.w	216,216,216,216,216,216,216
minl_tbl:	dc.w	16,16,32,32,48,48,48
minr_tbl:	dc.w	16,16,32,32,48,48,48
mint_tbl:	dc.w	0,0,0,0,0,0,0
minb_tbl:	dc.w	0,0,0,0,0,0,0
maxw_tbl:	dc.l	480,480,960,960,1280,1280,1280
maxh_tbl:	dc.l	0,0,0,0,0,0,0
xover_tbl:	dc.w	0,0,30,30,70,70,70
yover_tbl:	dc.w	33,33,33,33,33,33,33
rowht_tbl:	dc.w	24,24,24,24,24,24,24
rows_tbl:	dc.w	1,1,1,1,1,1,1
grmode_tbl:	dc.w	32,32,33,33,34,34,34

driver:		dc.b	"ST Okimate Color v2.0 beta",0
setcolor:	dc.b	ESC,"X",0
setgr:		dc.b	ESC,"*",0

 SECTION printer,BSS,PUBLIC
table:		ds.l	1
twidth:		ds.w	1
pixel:		ds.w	1
v_base:		ds.l	1
bytes:		ds.w	1
aaa:		ds.l	1
keep:		ds.w	1
lineptr:	ds.l	1
width:		ds.w	1
pplane:		ds.l	1
count:		ds.w	1
grmode:		ds.w	1
rows:		ds.w	1
rowht:		ds.w	1
scroll:		ds.w	1
