 include "pdlequ.h"
 include "equ.h"

*
* these equates are for the postscript driver
*
CR	equ	$d
LF	equ	$a
FF	equ	$c
ESC	equ	$1b
QUOTE	equ	$22
BACK	equ	"\\"

 SECTION printer,CODE,PUBLIC
***************************************************************
***************************************************************
***************************************************************
dumbentry:
	clr.l	d0
	rts

	dc.l	"PRNT"
	dc.w	201

*
* distribute the calls the the appropriate routines
*
postscrp:
	move.l	a0,table
	cmp.w	#10,d0
	bcs	ps1
	cmp.l	#-2,mfpage
	beq	rrts
	cmp.l	#-2,mapage
	beq	rrts
ps1:	lsl.w	#2,d0
	lea	prntbl,a1
	move.l	0(a1,d0.w),a1
	jmp	(a1)

*******************************************************************
***								***
*******************************************************************
*
* identify who I am, and set up who I like to speak to, and
*  load in my device driver
*
p_ident:
	move.l	#driver,pdrvrnm(a0)	;pointer to string for driver name
	move.w	#SERIAL+ASCENDING,device(a0)
prtok:	moveq	#1,d0
rrts:	rts


*******************************************************************
***								***
*******************************************************************
*
* initialize the table of printer specific routines
*
p_init:
	move.b	#1,pmult(a0)		;automatically print mulitiple copies?
	move.l	curfm(a0),curfmetric
	move.l	curft(a0),curfont
	move.l	ftlist(a0),fontlist
	move.l	ftoff(a0),fontoff
	move.l	textattr(a0),attribute
	move.l	sendout(a0),send+2	;self-modifing code, tisk, tisk!
	move.b	#1,pdl(a0)		;a page description language printer
	move.w	#72,pxdpi(a0)		;x resolution
	move.w	#72,pydpi(a0)		;y resolution
	clr.w	pxover(a0)
	clr.w	pyover(a0)
	move.w	#1,prowht(a0)

*
* pminlft and pmaxw must be evenly divisible by 16
*
	move.w	#0,pminlft(a0)		;pixels from the left
	move.w	#0,pminrht(a0)		;pixels from the right
	move.w	#0,pmintop(a0)		;pixels down from top
	move.w	#0,pminbot(a0)		;pixels up from bottom
	move.l	#72000,pmaxw(a0)	;maximum # pixels across
	move.l	#0,pmaxh(a0)		;maximum # pixels down
	move.b	#1,pman(a0)		;handle manual feed?
	move.w	#%1000000000011100,pfont(a0)	;which font types
	bra	prtok

*******************************************************************
***								***
*******************************************************************
*
* going to begin printing a document
*
p_bgndoc:
	clr.b	downflag
	clr.b	colorprt
	clr.b	auto_unload

	lea	clrstr,a1
	bsr	matchstr
	beq	pbgn0
	move.b	#1,colorprt

pbgn0:	lea	austr,a1
	bsr	matchstr
	beq	pbgn1
	move.b	#3,auto_unload

pbgn1:	lea	pustr,a1
	bsr	matchstr
	beq	pbgn1e
	or.b	#2,auto_unload

pbgn1e:	move.l	#-1,bleedh
	move.l	#-1,bleedv
	lea	bldstr,a1
	bsr	matchstr
	beq	pbgn5
	bsr	getnum
	move.l	d0,bleedh
	move.l	d0,bleedv
	cmp.b	#",",(a0)+
	bne	pbgn5
	bsr	getnum
	move.l	d0,bleedv

pbgn5:	move.l	#-1,mfreq
	move.w	#1,mfcount
	clr.w	mfcur
	lea	freqstr,a1
	bsr	matchstr
	beq	pbgn2
	clr.w	mfcount
	bra	pbgn1b

pbgn1a:	move.b	(a0)+,d0
	cmp.b	#",",d0
	beq	pbgn1b
	cmp.b	#"]",d0
	beq	pbgn2
	bra	pbgn1a

pbgn1b:	cmp.b	#"-",(a0)
	bne	pbgn1c
	lea	mfreq,a1
	move.w	mfcount,d0
	lsl.w	#2,d0
	move.l	#-1,0(a1,d0.w)
	addq.w	#1,mfcount
	bra	pbgn1a

pbgn1c:	cmp.b	#"s",(a0)
	bne	pbgn1d
	lea	mfreq,a1
	move.w	mfcount,d1
	lsl.w	#2,d1
	move.l	#-2,0(a1,d1.w)
	addq.w	#1,mfcount
	bra	pbgn1a

pbgn1d:	cmp.b	#"9",(a0)
	bhi	pbgn1a
	cmp.b	#"0",(a0)
	bcs	pbgn1a
	lea	mfreq,a1
	move.w	mfcount,d1
	lsl.w	#2,d1
	move.l	a0,0(a1,d1.w)
	addq.w	#1,mfcount
	bra	pbgn1a

pbgn2:	move.l	#-1,mangle
	move.w	#1,macount
	clr.w	macur
	lea	anglestr,a1
	bsr	matchstr
	beq	pbgn3
	clr.w	macount
	bra	pbgn2b

pbgn2a:	move.b	(a0)+,d0
	cmp.b	#",",d0
	beq	pbgn2b
	cmp.b	#"]",d0
	beq	pbgn3
	bra	pbgn2a

pbgn2b:	cmp.b	#"-",(a0)
	bne	pbgn2c
	lea	mangle,a1
	move.w	macount,d0
	lsl.w	#2,d0
	move.l	#-1,0(a1,d0.w)
	addq.w	#1,macount
	bra	pbgn2a

pbgn2c:	cmp.b	#"s",(a0)
	bne	pbgn2d
	lea	mangle,a1
	move.w	macount,d1
	lsl.w	#2,d1
	move.l	#-2,0(a1,d1.w)
	addq.w	#1,macount
	bra	pbgn2a

pbgn2d:	cmp.b	#"9",(a0)
	bhi	pbgn2a
	cmp.b	#"0",(a0)
	bcs	pbgn2a
	lea	mangle,a1
	move.w	macount,d1
	lsl.w	#2,d1
	move.l	a0,0(a1,d1.w)
	addq.w	#1,macount
	bra	pbgn2a

pbgn3:	bsr	nofonts

*
*
*
	lea	_comments,a0
	bsr	sendline

	lea	_bbcomment,a0
	bsr	sendline

	moveq	#0,d0
	moveq	#0,d1
	bsr	send2n

	move.l	table,a0
	move.l	PDocumentW(a0),d0
	move.l	PDocumentH(a0),d1
	bsr	send2n

	bsr	sendcrlf

	lea	_npcomment,a0
	bsr	sendline

	lea	_dfcomment,a0
	bsr	sendline

	lea	_dnfcomment,a0
	bsr	sendline

	lea	_dsfcomment,a0
	bsr	sendline

	lea	_prolog,a0
	bra	sendline

nofonts:
	move.l	table,a0
	move.w	pfont(a0),d0
	move.l	ftcnt(a0),a1
	move.w	(a1),d7
	move.l	ftlist(a0),a1
	move.l	(a1),a1
	move.l	(a1),a1
	bra	pbgnd3
pbgnd1:	move.w	ft_Type(a1),d1
	btst	d1,d0
	beq	pbgnd2
	clr.w	ft_Flag(a1)
pbgnd2:	lea	ft_Sizeof(a1),a1
pbgnd3:	dbf	d7,pbgnd1
	rts

***********************************
***				***
***********************************
matchstr:
	move.l	table,a2
	move.l	prtspcl(a2),a2
mstr0:	move.l	a2,a0
	move.l	a1,a3
	tst.b	(a0)
	beq	rrts		;no match, return eq
mstr1:	cmp.b	(a0)+,(a3)+
	bne	mstr2
	tst.b	(a3)
	bne	mstr1
	moveq	#1,d0
	rts			;return neq, a match
mstr2:	addq.l	#1,a2
	bra	mstr0


***********************************
***				***
***********************************
getnum:	moveq	#0,d0
gnum1:	cmp.b	#"9",(a0)
	bhi	rrts
	cmp.b	#"0",(a0)
	bcs	rrts
	mulu	#10,d0
	move.b	(a0)+,d1
	sub.b	#"0",d1
	and.w	#$ff,d1
	add.w	d1,d0
	bra	gnum1

*******************************************************************
***								***
*******************************************************************
*
* about to start printing of a page
*
p_bgnpage:
	move.w	pcyan(a0),p_cyan
	move.w	pmagenta(a0),p_magenta
	move.w	pyellow(a0),p_yellow
	move.w	pblack(a0),p_black

	lea	mfreq,a0
	move.w	mfcur,d0
	cmp.w	mfcount,d0
	bcs	pbp1
	clr.w	mfcur
	moveq	#0,d0
pbp1:	lsl.w	#2,d0
	move.l	0(a0,d0.w),mfpage
	addq.w	#1,mfcur

	lea	mangle,a0
	move.w	macur,d0
	cmp.w	macount,d0
	bcs	pbp2
	clr.w	macur
	moveq	#0,d0
pbp2:	lsl.w	#2,d0
	move.l	0(a0,d0.w),mapage
	addq.w	#1,macur

	cmp.l	#-2,mapage
	beq	rrts
	cmp.l	#-2,mfpage
	beq	rrts

	lea	_bgnpage,a0
	bra	sendline

*******************************************************************
***								***
*******************************************************************
*
* about to print a new tile for the page
*
p_bgntile:
	cmp.l	#-2,mapage
	beq	rrts
	cmp.l	#-2,mfpage
	beq	rrts

	btst	#1,auto_unload
	beq	btpu1
	lea	_bgnpgu,a0
	jsr	sendline

btpu1:	move.l	table,a0
	move.l	VDocumentH(a0),d0
	tst.b	pland(a0)
	beq	bgt1
	move.l	VDocumentW(a0),d0
bgt1:	move.l	d0,yinvert

	lea	_bgntile,a0
	bsr	sendline

	move.b	#"(",d0
	bsr	send
	move.l	table,a0
	lea	pagetitle(a0),a0
	bsr	sendline
	move.b	#")",d0
	bsr	send
	bsr	sendcrlf

	move.l	table,a0
	move.w	psepmode(a0),d0
	bsr	sendi

	move.w	p_cyan,d0
	move.w	p_magenta,d1
	bsr	send2i

	move.l	table,a0
	move.w	p_yellow,d0
	move.w	p_black,d1
	bsr	send2i

	move.l	table,a0
	moveq	#0,d0
	move.b	prvrs(a0),d0
	bsr	sendi

	move.l	table,a0
	moveq	#0,d0
	move.b	pmirror(a0),d0
	bsr	sendi

	move.l	table,a0
	moveq	#0,d0
	move.b	pcrop(a0),d0
	bsr	sendi

	move.l	table,a0
	moveq	#0,d0
	move.b	pmanual(a0),d0
	bsr	sendi

	move.l	table,a1
	moveq	#0,d0
	move.b	pland(a1),d0
	bsr	sendi

	move.l	table,a0
	move.w	pscale(a0),d0		;x-scale
	move.w	d0,d1			;y-scale
	bsr	send2i

	move.l	table,a0
	move.w	pminlft(a0),d0
	move.w	pmintop(a0),d1
	bsr	send2i

	move.l	table,a0
	move.l	PDocumentW(a0),d0
	move.l	PDocumentH(a0),d1
	bsr	send2n

	move.l	table,a0
	move.l	PPageLeft(a0),d0
	move.l	PPageTop(a0),d1
	bsr	send2n

	move.l	table,a0
	move.l	PPageWidth(a0),d0
	move.l	PPageHeight(a0),d1
	bsr	send2n

	move.l	bleedh,d0
	move.l	bleedv,d1
	bsr	send2n

	cmp.l	#-2,mfpage
	beq	spclf
	cmp.l	#-1,mfpage
	beq	spclf
	move.l	mfpage,a0
sfq1:	move.b	(a0)+,d0
	cmp.b	#".",d0
	beq	sfq2
	cmp.b	#"0",d0
	bcs	sfq3
	cmp.b	#"9",d0
	bhi	sfq3
sfq2:	move.l	a0,-(sp)
	jsr	send
	move.l	(sp)+,a0
	bra	sfq1
sfq3:	move.b	#" ",d0
	bsr	send
	bra	setfq
spclf:	move.w	mfpage+2,d0
	bsr	sendi

setfq:	cmp.l	#-2,mapage
	beq	spcla
	cmp.l	#-1,mapage
	beq	spcla
	move.l	mapage,a0
saq1:	move.b	(a0)+,d0
	cmp.b	#".",d0
	beq	saq2
	cmp.b	#"0",d0
	bcs	saq3
	cmp.b	#"9",d0
	bhi	saq3
saq2:	move.l	a0,-(sp)
	jsr	send
	move.l	(sp)+,a0
	bra	saq1
saq3:	move.b	#" ",d0
	bsr	send
	bra	setan

spcla:	move.w	mapage+2,d0
	bsr	sendi

setan:	move.l	table,a0
	move.w	pcopies(a0),d0
	bsr	sendi

	lea	_bgntile2,a0
	bra	sendline


*******************************************************************
***								***
*******************************************************************
*
* just finished describing current tile
*
p_endtile:
	cmp.l	#-2,mapage
	beq	rrts
	cmp.l	#-2,mfpage
	beq	rrts

	btst	#1,auto_unload
	beq	etpgu1
	bsr	flushfont
	bsr	nofonts
etpgu1:	lea	_endtile,a0
	bsr	sendline

	btst	#1,auto_unload
	beq	rrts
	move.l	#$7fffffff,curx
	move.l	#$7fffffff,cury
	lea	_endpgu,a0
	bra	sendline

*******************************************************************
***								***
*******************************************************************
*
* just finished describing all tiles for this page
*
p_endpage:
	cmp.l	#-2,mapage
	beq	rrts
	cmp.l	#-2,mfpage
	beq	rrts

	lea	_endpage,a0
	bra	sendline

*******************************************************************
***								***
*******************************************************************
p_enddoc:
	lea	_enddoc,a0
	bra	sendline


*******************************************************************
***								***
*******************************************************************
p_break:
	move.b	#4,d0
	bra	send



*******************************************************************
***								***
*******************************************************************
setcolor:
	move.w	pblockx(a0),cyan
	move.w	pblocky(a0),magenta
	move.w	pblockw(a0),yellow
	move.w	pblockh(a0),black

	move.w	pblockptr(a0),cintensity
	bra	prtok


*******************************************************************
***								***
*******************************************************************
rotate:
	clr.b	bgnstyle
	clr.b	endstyle
	move.w	pblockw(a0),d0
	move.w	pblockh(a0),d1
	bsr	send2i
	move.l	table,a0
	move.l	pblockx(a0),d0
	move.l	pblocky(a0),d1
	bsr	sendxy
	lea	_setscl,a0
	bra	sendline


*******************************************************************
***								***
*******************************************************************
setfill:
	move.w	pblockx(a0),fillstyle	;fill style

	move.w	fillstyle,d0
	tst.b	d0
	bpl	setfl1
	and.w	#$7f,d0
	bra	setfl2
setfl1:	lea	f_tbl,a0
	move.b	0(a0,d0.w),d0		;if minus, then use a pattern
	bmi	setfl4
*
* (color/grey) shade fill
*
setfl2:	tst.b	colorprt
	beq	setfl3
	move.l	table,a0
	tst.w	psepmode(a0)
	bne	setfl3
*
* color shade fill
*
	move.w	d0,-(sp)
	mulu	cyan,d0
	divu	#100,d0
	bsr	sendi
	move.w	(sp),d0
	mulu	magenta,d0
	divu	#100,d0
	bsr	sendi
	move.w	(sp),d0
	mulu	yellow,d0
	divu	#100,d0
	bsr	sendi
	move.w	(sp)+,d0
	mulu	black,d0
	divu	#100,d0
	bsr	sendi
	lea	_setcmyk,a0
	bra	sendline
*
* grey shade fill
*
setfl3:	mulu	cintensity,d0
	divu	#100,d0
	bsr	sendi
	lea	_setshade,a0
	bra	sendline
*
* pattern fill
*
setfl4:	and.w	#$7f,d0
	lsl.w	#5,d0
	move.l	table,a0
	move.l	fillpat(a0),a0
	add.w	d0,a0
	move.l	a0,-(sp)
	move.b	#"<",d0
	bsr	send
	move.l	(sp)+,a0
	lea	32(a0),a0
	move.w	#15,d7
setfl5:	move.b	-2(a0),d0
	move.w	d7,-(sp)
	move.l	a0,-(sp)
	bsr	sendh
	move.l	(sp),a0
	move.b	-1(a0),d0
	subq.l	#2,a0
	move.l	a0,(sp)
	bsr	sendh
	move.l	(sp)+,a0
	move.w	(sp)+,d7
	dbf	d7,setfl5
	move.b	#">",d0
	bsr	send
	move.b	#" ",d0
	bsr	send
	move.w	cintensity,d0
	bsr	sendi
	lea	_setpattern,a0
	bra	sendline


*******************************************************************
***								***
*******************************************************************
setline:
	move.l	table,a0
	move.b	pblockh(a0),bgnstyle
	move.b	pblockh+1(a0),endstyle
	move.w	pblockw(a0),linewidth
	move.w	pblockx(a0),linestyle

	move.w	#100,d0
	bsr	setfl2			;set solid fill (current color)
	move.w	linewidth,d0		;line width
	bsr	sendi
	move.l	table,a0
	cmp.w	#7,linestyle
	bne	stln1
	bsr	setul
stln1:	move.w	linestyle,d0
	lsl.w	#2,d0
	lea	lwdash,a0
	move.l	0(a0,d0.w),a0
	bsr	sendline
	lea	_setline,a0
	bra	sendline


*
* set up user defined line style
*
setul:	lea	lwd7+1,a0
	moveq	#0,d7

	move.l	table,a1
	move.l	linepat(a1),a1
	move.w	14(a1),d0
	bmi	stul2
	beq	stul69
stul1:	lsl.w	#1,d0
	bpl	stul1
stul2:	cmp.w	#$ffff,d0
	beq	stul69
	move.w	#15,d1
	moveq	#0,d2
	moveq	#1,d3
stul3:	lsl.w	#1,d0
	bcc	stul5
	bset	#0,d3
	beq	stul4
	addq.w	#1,d2
	dbf	d1,stul3
	bsr	stulnum
	bra	stul69

stul5:	bclr	#0,d3
	bne	stul4
	addq.w	#1,d2
	dbf	d1,stul3
	bsr	stulnum
	bra	stul69

stul4:	bsr	stulnum
	dbf	d1,stul3

stul69:	move.b	#"]",(a0)+
	clr.b	(a0)
	rts

stulnum:
	addq.w	#1,d7
	cmp.w	#11,d7
	bcc	stuln2

	mulu	#5,d2
	cmp.b	#10,d2
	bcs	stuln1
	move.b	#"1",(a0)+
stuln0:	sub.b	#10,d2
	cmp.b	#10,d2
	bcs	stuln1
	addq.b	#1,-1(a0)
	bra	stuln0
stuln1:	or.b	#"0",d2
	move.b	d2,(a0)+
	move.b	#"0",(a0)+
	move.b	#" ",(a0)+
	moveq	#1,d2
stuln2:	rts


*******************************************************************
***								***
*******************************************************************
newpath:
	clr.b	eflag
	clr.b	bflag
	lea	_newpath,a0
	bra	sendline


*******************************************************************
***								***
*******************************************************************
closepath:
	clr.b	eflag
	clr.b	bflag
	lea	_closepath,a0
	bra	sendline


*******************************************************************
***								***
*******************************************************************
fillpath:
	lea	_fillpath,a0
	bra	sendline


*******************************************************************
***								***
*******************************************************************
strokepath:
	cmp.b	#2,eflag
	bne	strkp1

	moveq	#0,d0
	move.b	endstyle,d0
	bsr	sendi
	move.l	ex1,d0
	move.l	ey1,d1
	bsr	sendxy
	move.l	ex2,d0
	move.l	ey2,d1
	bsr	sendxy
	clr.b	eflag
	lea	_doendstroke,a0
	bra	sendline

strkp1:	lea	_strokepath,a0
	bra	sendline


*******************************************************************
***								***
*******************************************************************
moveto:	move.l	pblockx(a0),d0
	move.l	pblocky(a0),d1
	tst.b	endstyle
	beq	mvto1

	move.l	d0,ex1
	move.l	d1,ey1
	move.b	#1,eflag

mvto1:	tst.b	bgnstyle
	beq	mvto2

	move.l	d0,bx1
	move.l	d1,by1
	move.b	#1,bflag
	rts

mvto2:	bsr	sendxy
	lea	_moveto,a0
	bra	sendline


*******************************************************************
***								***
*******************************************************************
lineto:	cmp.b	#1,bflag
	bne	lnto1

	moveq	#0,d0
	move.b	bgnstyle,d0
	bsr	sendi
	move.l	bx1,d0
	move.l	by1,d1
	bsr	sendxy
	move.l	table,a0
	move.l	pblockx(a0),d0
	move.l	pblocky(a0),d1
	bsr	sendxy
	lea	_dobgnmoveto,a0
	bsr	sendline
	clr.b	bflag
	move.l	table,a0

lnto1:	tst.b	endstyle
	beq	lnto2
	cmp.b	#2,eflag
	bne	lnto3
	move.l	ex1,d0
	move.l	ey1,d1
	bsr	sendxy
	lea	_lineto,a0
	bsr	sendline
	move.l	table,a0

lnto3:	move.l	ex1,ex2
	move.l	ey1,ey2
	move.l	pblockx(a0),ex1
	move.l	pblocky(a0),ey1
	move.b	#2,eflag
	rts

lnto2:	move.l	pblockx(a0),d0
	move.l	pblocky(a0),d1
	bsr	sendxy
	lea	_lineto,a0
	bra	sendline


*******************************************************************
***								***
*******************************************************************
curveto:
	tst.b	bflag
	beq	crvto1

	move.l	bx1,d0
	move.l	by1,d1
	bsr	sendxy
	lea	_moveto,a0
	bsr	sendline
	clr.b	bflag
	move.l	table,a0

crvto1:	cmp.b	#2,eflag
	bne	crvto2
	move.l	ex1,d0
	move.l	ey1,d1
	bsr	sendxy
	lea	_lineto,a0
	bsr	sendline
	move.l	table,a0
	move.b	#1,eflag
	move.l	table,a0
*
*
crvto2:	move.l	pblockx(a0),d0
	move.l	pblocky(a0),d1
	bsr	sendxy
	move.l	table,a0
	move.l	pblockw(a0),d0
	move.l	pblockh(a0),d1
	bsr	sendxy
	move.l	table,a0
	move.l	pblockptr(a0),d0
	move.l	pblockoff(a0),d1
	bsr	sendxy
	lea	_curveto,a0
	bra	sendline


*******************************************************************
***								***
*******************************************************************
arcto:	move.l	pblockx(a0),d0
	move.l	pblocky(a0),d1
	bsr	sendxy
	move.l	table,a0
	move.l	pblockw(a0),d0
	move.l	pblockh(a0),d1
	bsr	send2n
	move.l	table,a0
	move.w	pblockptr(a0),d0
	move.w	pblockptr+2(a0),d1
	bsr	send2i
	lea	_arcto,a0
	bra	sendline



*******************************************************************
***								***
*******************************************************************
arcnto:
	move.l	pblockx(a0),d0
	move.l	pblocky(a0),d1
	bsr	sendxy
	move.l	table,a0
	move.l	pblockw(a0),d0
	move.l	pblockh(a0),d1
	bsr	send2n
	move.l	table,a0
	move.w	pblockptr(a0),d0
	move.w	pblockptr+2(a0),d1
	bsr	send2i
	lea	_arcnto,a0
	bra	sendline




*******************************************************************
***								***
*******************************************************************
*
* routines for putting text
*
putchar:
	cmp.w	#1,curfmtype
	beq	putchafm

	move.l	curfont,a0
	tst.l	(a0)
	beq	rrts

	bsr	putwidth

	cmp.w	#3,curftype
	bne	putch3
*
* .PSF putchar routines
*
	move.l	curfont,a0
	move.l	(a0),a0
	move.l	(a0),a0
	lea	PS_LOOKUP(a0),a0
	move.w	(a0)+,count
	bra	ptpsf4
ptpsf1:	move.b	(a0),d0
	cmp.b	pchar,d0
	bne	ptpsf3
	move.l	a0,-(sp)

	move.b	1(a0),char
	move.w	2(a0),d1
	move.w	4(a0),-(sp)
	move.l	attribute,a1

	move.l	xpoint(a1),d0
	bsr	Muls1632
	move.w	curpsxpoint,d2
	bsr	Divs1648
	move.w	#7200,d1
	bsr	Muls1632
	move.w	curpsxdpi,d2
	bsr	Divs1648

	add.l	pcx,d0
	move.l	d0,cx

	move.l	ypoint(a1),d0
	move.w	(sp)+,d1
	bsr	Muls1632
	move.w	curpsypoint,d2
	bsr	Divs1648
	move.w	#7200,d1
	bsr	Muls1632
	move.w	curpsydpi,d2
	bsr	Divs1648

	move.l	pattr,d2
	btst	#UPSIDE,d2
	beq	ptpsf2
	neg.l	d0
ptpsf2:	add.l	pcy,d0
	move.l	d0,cy

	bsr	drwchar

	move.l	(sp)+,a0
ptpsf3:	addq.l	#6,a0
ptpsf4:	subq.w	#1,count
	bcc	ptpsf1
	rts
*
* .DMF putchar routines
*
putch3:	cmp.w	#2,curftype
	bne	putch4

	move.l	curfont,a0
	move.l	(a0),a0
	move.l	(a0),a0
	lea	DM_LOOKUP(a0),a0
	move.w	(a0)+,count
	bra	ptdmf4
ptdmf1:	move.b	(a0),d0
	cmp.b	pchar,d0
	bne	ptdmf3
	move.l	a0,-(sp)

	move.b	1(a0),char
	move.w	2(a0),d1
	move.w	4(a0),-(sp)
	move.l	attribute,a1

	move.l	xpoint(a1),d0
	bsr	Muls1632
	move.w	curpsxpoint,d2
	bsr	Divs1648
	move.w	#7200,d1
	bsr	Muls1632
	move.w	curpsxdpi,d2
	bsr	Divs1648

	add.l	pcx,d0
	move.l	d0,cx

	move.l	ypoint(a1),d0
	move.w	(sp)+,d1
	bsr	Muls1632
	move.w	curpsypoint,d2
	bsr	Divs1648
	move.w	#7200,d1
	bsr	Muls1632
	move.w	curpsydpi,d2
	bsr	Divs1648

	move.l	pattr,d2
	btst	#UPSIDE,d2
	beq	ptdmf2
	neg.l	d0
ptdmf2:	add.l	pcy,d0
	move.l	d0,cy

	bsr	drwchar

	move.l	(sp)+,a0
ptdmf3:	addq.l	#6,a0
ptdmf4:	subq.w	#1,count
	bcc	ptdmf1
	rts

*
* Adobe Type 1 .pfb putchar routine
*
putch4:	cmp.w	#4,curftype
	bne	rrts

	lea	t1index,a0
	moveq	#0,d0
	move.b	pchar,d0
	move.b	0(a0,d0.w),char
	move.l	pcx,cx
	move.l	pcy,cy

	bra	drwchar

*
* Adobe Type 1 .pfb w/ .afm putchar routine
*
putchafm:
	bsr	putwidth
	move.l	curfmetric,a0
	move.l	(a0),a0
	move.l	(a0),a0
	move.l	FM_FONT(a0),a0
	move.l	(a0),a0
	lea	PS_LOOKUP(a0),a0
	move.w	(a0)+,count
	bra	ptdmf4



putwidth:
	move.l	table,a1
	move.l	pblockw(a1),pwidth
	move.b	pblockptr(a1),pchar
	move.l	pblockx(a1),pcx
	move.l	pblocky(a1),pcy
	move.l	pattr,d0
	and.l	#%0011111001000000,d0
	beq	rrts

	move.l	pwidth,d0
	bsr	sendn

	move.l	pcx,d0
	move.l	pcy,d1
	cmp.l	curx,d0
	bne	putch1
	cmp.l	cury,d1
	bne	putch1
*
*
	lea	_puta1,a0
	bra	sendline
*
*
putch1:	move.l	pcx,d0
	move.l	pcy,d1
	bsr	sendxy

	move.l	pcx,curx
	move.l	pcy,cury

	lea	_puta2,a0
	bra	sendline

*
*
*

drwchar:
	move.b	#"(",d0
	bsr	send
	move.b	char,d0
	cmp.b	#127,d0
	bcc	dooct
	cmp.b	#32,d0
	bcs	dooct
	cmp.b	#"(",d0
	beq	drwc1
	cmp.b	#")",d0
	beq	drwc1
	cmp.b	#BACK,d0
	bne	drwc2
drwc1:	move.b	#BACK,d0
	bsr	send
	move.b	char,d0
drwc2:	bsr	send
drwc3:	move.b	#")",d0
	bsr	send
	move.b	#" ",d0
	bsr	send

	move.l	cx,d0
	move.l	cy,d1
	cmp.l	curx,d0
	bne	drwc4
	cmp.l	cury,d1
	bne	drwc4
*
*
	move.l	pwidth,d0
	bsr	sendn

	move.l	cx,d0
	move.l	cy,d1
	add.l	pwidth,d0
	move.l	d0,curx
	move.l	d1,cury

	lea	_putc1,a0
	bra	sendline
*
*
drwc4:	move.l	pwidth,d0
	bsr	sendn

	move.l	cx,d0
	move.l	cy,d1
	bsr	sendxy

	move.l	cx,d0
	move.l	cy,d1
	add.l	pwidth,d0
	move.l	d0,curx
	move.l	d1,cury

	lea	_putc2,a0
	bra	sendline


dooct:	move.b	d0,d1
	move.b	d0,d2
	lsr.b	#6,d0
	lsr.b	#3,d1
	and.b	#7,d0
	and.b	#7,d1
	and.b	#7,d2
	or.b	#"0",d0
	or.b	#"0",d1
	or.b	#"0",d2
	move.b	#BACK,array
	move.b	d0,array+1
	move.b	d1,array+2
	move.b	d2,array+3
	clr.b	array+4
	lea	array,a0
	bsr	sendline
	bra	drwc3


*******************************************************************
***								***
*******************************************************************
* curftype -
* 1 bitmap
* 2 outline
* 3 psf
* 4 type 1 pgs internal
*

setfont:
	move.l	table,a0
	move.l	fmlist(a0),a1
	move.l	(a1),a1
	move.l	(a1),a1
	move.l	fmoff(a0),a0
	add.l	(a0),a1
	move.w	fm_Type(a1),curfmtype

	move.l	table,a0
	move.l	ftlist(a0),a1
	move.l	(a1),a1
	move.l	(a1),a1
	move.l	ftoff(a0),a0
	add.l	(a0),a1
	move.w	ft_XDpi(a1),curpsxdpi
	move.w	ft_YDpi(a1),curpsydpi
	move.w	ft_XPoint+2(a1),curpsxpoint
	move.w	ft_YPoint+2(a1),curpsypoint

	move.w	ft_Type(a1),d0
	move.w	d0,curftype

	cmp.w	#1,curfmtype
	bne	setfnt0
	cmp.w	#4,d0
	beq	setfnt0
	bra	setfnt0
*
* Type 3 with AFM
*
	rts

	move.l	curfont,a0		;is the font available (disk errors?)
	tst.l	(a0)
	beq	rrts			;no- return
	move.l	(a0),a0
	move.l	(a0),a0
*
	bsr	downloadit		;does it need to be downloaded?
	beq	stps9			;-no

	move.l	curfont,a0
	move.l	(a0),a0
	move.l	(a0),a0

	lea	PS_FNAME(a0),a0		;it's out on disk under the name
	move.l	table,a1		;in PS_FNAME, let's open it
	move.l	openfnt(a1),a1
	jsr	(a1)
stps1:	move.l	table,a1		;read a chunk of the font
	move.l	readfnt(a1),a1
	jsr	(a1)
	tst.l	d0
	beq	stps9			;-no more to read and send
	move.l	d0,d7
	bra	stps3
stps2:	move.b	(a0)+,d0		;and start sending the chunk down
	beq	stpsf9
	move.l	d7,-(sp)
	move.l	a0,-(sp)
	bsr	send
	move.l	(sp)+,a0
	move.l	(sp)+,d7
stps3:	dbf	d7,stps2
	bra	stps1
*
stps9:	move.l	curfont,a0		;the font is down there, let's
	move.l	(a0),a0			;set it as our current font.
	move.l	(a0),a0
	lea	PS_NAME(a0),a0
	move.l	a0,-(sp)
	move.b	#"(",d0
	bsr	send
	move.l	(sp)+,a0
	bsr	sendline
	move.b	#")",d0
	bsr	send
	move.b	#" ",d0
	bsr	send
*
*
	move.l	attribute,a0			;set the size
	move.l	xpoint(a0),d0
	move.l	ypoint(a0),d1
	bsr	send2n
*
*
	move.l	fontoff,a0
	move.l	(a0),d0
	move.l	fontlist,a0			;set the attributes
	move.l	(a0),a0				;to imitate
	move.l	(a0),a0
	add.l	d0,a0
	move.l	ft_Attrb(a0),d0

	eor.l	#$ffffffff,d0
	move.l	attribute,a0
	and.l	attr(a0),d0
	move.l	d0,pattr
	bsr	sendi
*
*
	lea	_setfp,a0			;and set it
	bra	sendline
*
* end of setfont routines for Type3's with .AFM
*


setfnt0:
	cmp.w	#3,d0
	bne	setfnt1

*
* PageStream .PSF font
*

	move.l	curfont,a0		;is the font available (disk errors?)
	tst.l	(a0)
	beq	rrts			;no- return
	move.l	(a0),a0
	move.l	(a0),a0

	tst.b	PS_FNAME(a0)		;is it a downloadable font?
	beq	stpsf9			;-no
*
	bsr	downloadit		;does it need to be downloaded?
	beq	stpsf9			;-no

	move.l	curfont,a0
	move.l	(a0),a0
	move.l	(a0),a0
	cmp.w	#$0723,PS_FNAME(a0)	;is the downloadable disk based
	beq	stpsf5			;-no, merged into the .psf

	lea	PS_FNAME(a0),a0		;-yes, it's out on disk under the name
	move.l	table,a1		;in PS_FNAME, let's open it
	move.l	openfnt(a1),a1
	jsr	(a1)
stpsf1:	move.l	table,a1		;read a chunk of the font
	move.l	readfnt(a1),a1
	jsr	(a1)
	tst.l	d0
	beq	stpsf9			;-no more to read and send
	move.l	d0,d7
	bra	stpsf3
stpsf2:	move.b	(a0)+,d0		;and start sending the chunk down
	beq	stpsf9
	move.l	d7,-(sp)
	move.l	a0,-(sp)
	bsr	send
	move.l	(sp)+,a0
	move.l	(sp)+,d7
stpsf3:	dbf	d7,stpsf2
	bra	stpsf1
*
stpsf5:	move.l	PS_FNAME+6(a0),d7	;the .ps is merged into the .psf
	add.l	PS_FNAME+2(a0),a0
stpsf6:	move.b	(a0)+,d0		;send it on down
	beq	stpsf9
	move.l	d7,-(sp)
	move.l	a0,-(sp)
	bsr	send
	move.l	(sp)+,a0
	move.l	(sp)+,d7
	subq.l	#1,d7
	bne	stpsf6
*
stpsf9:	move.l	curfont,a0		;the font is down there, let's
	move.l	(a0),a0			;set it as our current font.
	move.l	(a0),a0
	lea	PS_NAME(a0),a0
	move.l	a0,-(sp)
	move.b	#"(",d0
	bsr	send
	move.l	(sp)+,a0
	bsr	sendline
	move.b	#")",d0
	bsr	send
	move.b	#" ",d0
	bsr	send
*
*
	move.l	attribute,a0			;set the size
	move.l	xpoint(a0),d0
	move.l	ypoint(a0),d1
	bsr	send2n
*
*
	move.l	fontoff,a0
	move.l	(a0),d0
	move.l	fontlist,a0			;set the attributes
	move.l	(a0),a0				;to imitate
	move.l	(a0),a0
	add.l	d0,a0
	move.l	ft_Attrb(a0),d0

	eor.l	#$ffffffff,d0
	move.l	attribute,a0
	and.l	attr(a0),d0
	move.l	d0,pattr
	bsr	sendi
*
*
	lea	_setfp,a0			;and set it
	bra	sendline
*
* end of setfont routines for .psf's
*

*
*
*
setfnt1:
	cmp.w	#2,d0
	bne	setfnt2

*
* PageStream .DMF font
*

	move.l	curfont,a0		;is the font available (disk errors?)
	tst.l	(a0)
	beq	rrts			;no- return
	move.l	(a0),a0
	move.l	(a0),a0

*
	bsr	downloadit
	beq	stdmf10

	lea	dmfstr1,a0		;header
	bsr	sendline

	move.w	#1,char
stdmf1:	bsr	dmfinuse
	beq	stdmf2
	lea	dmfstr2,a0		;"Mx "
	bsr	sendline
	move.w	char,d0
	bsr	sendi
	move.l	curfmetric,a0
	move.l	(a0),a0
	move.l	(a0),a0
	lea	FM_CWIDTH(a0),a0
	move.w	char,d1
	lsl.w	#1,d1
	moveq	#0,d0
	move.w	0(a0,d1.w),d0
	divu	#10,d0
	bsr	sendi
	lea	dmfstr3,a0		;"put",CR,LF
	bsr	sendline
stdmf2:	addq.b	#1,char+1
	bne	stdmf1

	move.w	#1,char
stdmf3:	bsr	dmfinuse
	beq	stdmf4
	lea	dmfstr4,a0		; "Encoding "
	bsr	sendline
	move.w	char,d0
	bsr	sendi
	move.b	#"/",d0
	bsr	send
	move.w	char,d0
	bsr	sendi
	lea	dmfstr3,a0		; "put",CR,LF
	bsr	sendline
stdmf4:	addq.b	#1,char+1
	bne	stdmf3


	move.w	#1,char
stdmf5:	bsr	dmfinuse
	beq	stdmf9
	lea	dmfstr5,a0		; "CharacterDefs /"
	bsr	sendline
	move.w	char,d0
	bsr	sendi
	lea	dmfstr6,a0		; CR,LF,"{ "
	bsr	sendline

	move.l	curfont,a0
	move.l	(a0),a0
	move.l	(a0),a0
	add.l	DM_BBOX(a0),a0
	move.w	char,d0
	lsl.w	#2,d0
	move.w	0(a0,d0.w),char_cx
	move.w	2(a0,d0.w),char_cy

	move.l	curfont,a0
	move.l	(a0),a0
	move.l	(a0),a0
	add.l	DM_CSET(a0),a0

	move.l	#512,d1
	move.w	char,d0
	lsl.w	#1,d0
	beq	stdmf6
	moveq	#0,d1
	move.w	-2(a0,d0.w),d1
stdmf6:	moveq	#0,d2
	move.w	0(a0,d0.w),d2
	move.l	a0,a1
	add.l	d1,a0
	add.l	d2,a1
	move.l	a1,endp

stdmf7:	cmp.l	endp,a0
	bcc	stdmf8
	move.w	(a0)+,d0
	lea	dmftbl,a1
	jsr	0(a1,d0.w)
	move.l	charpath,a0
	bra	stdmf7

stdmf8:	lea	dmfstr7,a0		; "} put",CR,LF
	bsr	sendline
stdmf9:	addq.b	#1,char+1
	bne	stdmf5

	lea	dmfstr8,a0
	bsr	sendline
	bsr	dmfname
	lea	dmfstr9,a0
	bsr	sendline
*
stdmf10:
	move.b	#"(",d0
	bsr	send
	bsr	dmfname
	move.b	#")",d0
	bsr	send
	move.b	#" ",d0
	bsr	send
*
*
	move.l	attribute,a0			;set the size
	move.l	xpoint(a0),d0
	move.l	ypoint(a0),d1
	bsr	send2n

*
*
	move.l	fontoff,a0
	move.l	(a0),d0
	move.l	fontlist,a0			;set the attributes
	move.l	(a0),a0				;to imitate
	move.l	(a0),a0
	add.l	d0,a0
	move.l	ft_Attrb(a0),d0
	eor.l	#$ffffffff,d0
	move.l	attribute,a0
	and.l	attr(a0),d0
	move.l	d0,pattr
	bsr	sendi
*
*
	lea	_setfp,a0			;and set it
	bra	sendline


dmfinuse:
	move.l	curfont,a0
	move.l	(a0),a0
	move.l	(a0),a0
	add.l	DM_CSET(a0),a0

	move.w	#512,d1
	move.w	char,d0
	lsl.w	#1,d0
	beq	dmfiu1
	move.w	-2(a0,d0.w),d1
dmfiu1:	move.w	0(a0,d0.w),d2
	sub.w	d1,d2
	rts


dmfname:
	move.l	table,a1
	move.l	ftlist(a1),a0
	move.l	(a0),a0
	move.l	(a0),a0
	move.l	ftoff(a1),a1
	add.l	(a1),a0
	lea	fm_Name(a0),a0

dmfnm1:	move.b	(a0)+,d0
	beq	rrts
	cmp.b	#" ",d0
	beq	dmfnm1
	cmp.b	#".",d0
	beq	dmfnm1
	move.l	a0,-(sp)
	bsr	send
	move.l	(sp)+,a0
	bra	dmfnm1


dmftbl:
	bra.w	bnewp
	bra.w	bclosep
	bra.w	bfillp
	bra.w	bstrokep
	bra.w	bmoveto
	bra.w	blineto
	bra.w	bcurveto
	bra.w	barc
	bra.w	barcn

bnewp:	move.l	a0,charpath
	lea	dmfnp,a0
	bra	sendline

bclosep:
	move.l	a0,charpath
	lea	dmfcp,a0
	bra	sendline

bfillp:	move.l	a0,charpath
	lea	dmffp,a0
	bra	sendline

bstrokep:
	move.l	a0,charpath
	lea	dmfsp,a0
	bra	sendline

bmoveto:
	bsr	gsxy
	lea	dmfmt,a0
	bra	sendline

blineto:
	bsr	gsxy
	lea	dmflt,a0
	bra	sendline

bcurveto:
	bsr	gsxy
	move.l	charpath,a0
	bsr	gsxy
	move.l	charpath,a0
	bsr	gsxy
	lea	dmfct,a0
	bra	sendline

barc:	lea	12(a0),a0
	move.l	a0,charpath
	rts

barcn:	lea	12(a0),a0
	move.l	a0,charpath
	rts

gsxy:	move.w	(a0)+,d0
	move.w	(a0)+,d1
	move.l	a0,charpath
	sub.w	char_cx,d0
	sub.w	char_cy,d1
	neg.w	d1
	ext.l	d0
	ext.l	d1
	bsr	send2n


*
*
*
setfnt2:
	cmp.w	#4,d0
	bne	rrts

*
* Adobe .PFB font
*
	move.l	curfont,a0		;is the font available (disk errors?)
	tst.l	(a0)
	beq	rrts			;no- return
	move.l	(a0),a0
	move.l	(a0),a0

	bsr	downloadit
	beq	stpfb10
*
	move.l	table,a1			;set the attributes
	move.l	ftlist(a1),a0			;to imitate
	move.l	(a0),a0
	move.l	(a0),a0
	move.l	ftoff(a1),a1
	add.l	(a1),a0

	lea	ft_FName(a0),a0
	move.l	table,a1
	move.l	openfnt(a1),a1
	jsr	(a1)
	clr.l	plane
	clr.w	crlfcnt

stpfb1:	bsr	read			;adobe chunk identifier
	beq	stpfb10
	cmp.b	#$80,d0
	bne	stpfb10
	bsr	read			;type of chunk it is
	beq	stpfb10
	move.b	d0,array+4

	bsr	read			;length (intel format :-(
	beq	stpfb10
	move.b	d0,array+3
	bsr	read
	beq	stpfb10
	move.b	d0,array+2
	bsr	read
	beq	stpfb10
	move.b	d0,array+1
	bsr	read
	beq	stpfb10
	move.b	d0,array

	cmp.b	#1,array+4
	beq	stpfb2
	cmp.b	#2,array+4
	beq	stpfb3
	bra	stpfb10

*
* send data as is
*
stpfb2:	bsr	read
	beq	stpfb10			;premature end
	bsr	send
	subq.l	#1,array
	bhi	stpfb2
	clr.w	crlfcnt
	bra	stpfb1

*
* send data as hex equivalant
*
stpfb3:	bsr	read
	beq	stpfb10			;premature end
	bsr	sendh

	addq.w	#2,crlfcnt
	cmp.w	#250,crlfcnt
	bcs	stpfb4
	clr.w	crlfcnt
	bsr	sendcrlf

stpfb4:	subq.l	#1,array
	bhi	stpfb3
	bra	stpfb1


*
stpfb10:
	move.b	#"(",d0
	bsr	send

	move.l	curfont,a0
	move.l	(a0),a0
	move.l	(a0),a0
	lea	PF_NAME(a0),a0
	bsr	sendline

	move.b	#")",d0
	bsr	send
	move.b	#" ",d0
	bsr	send

	move.l	attribute,a0			;set the size
	move.l	xpoint(a0),d0
	move.l	ypoint(a0),d1
	bsr	send2n

	move.l	fontoff,a0
	move.l	(a0),d0
	move.l	fontlist,a0			;set the attributes
	move.l	(a0),a0				;to imitate
	move.l	(a0),a0
	add.l	d0,a0
	move.l	ft_Attrb(a0),d0
	eor.l	#$ffffffff,d0
	move.l	attribute,a0
	and.l	attr(a0),d0
	move.l	d0,pattr
	bsr	sendi

	lea	_setfp,a0			;and set it
	bra	sendline

*
*
*
read:	subq.l	#1,plane
	bcs	getchunk
	move.l	pptr,a0
	move.b	(a0)+,d0
	move.l	a0,pptr
	moveq	#1,d1
	rts

getchunk:
	move.l	table,a1
	move.l	readfnt(a1),a1
	jsr	(a1)
	move.l	d0,plane
	beq	rrts
	move.l	a0,pptr
	bra	read

*
*
*
downloadit:
	move.l	table,a1		;is it already been downloaded?
	move.l	ftlist(a1),a2
	move.l	(a2),a2
	move.l	(a2),a2
	move.l	ftoff(a1),a1
	add.l	(a1),a2
	tst.w	ft_Flag(a2)
	bne	rtndl			;yes, it's already been downloaded
	move.w	#1,ft_Flag(a2)		;no, let's downloaded, but first...
*
	btst	#0,auto_unload		;if we are auto-unloading
	beq	rtdl			; -no
	bsr	flushfont		;then flush the last downloaded font

	lea	_bgnfnt,a0		;and mark this one to be flushed
	bsr	sendline		;next time through here
	move.l	table,a1
	move.l	ftoff(a1),a1
	move.l	(a1),downoff
	bset	#0,downflag
rtdl:	moveq	#1,d0
	rts
rtndl:	moveq	#0,d0
	rts

*******************************************************************
***								***
*******************************************************************
puteps:
	move.l	table,a0
	cmp.w	#2,psepmode(a0)
	bne	peps1
	cmp.w	#$ffff,p_black
	bne	rrts
	move.w	p_cyan,d0
	or.w	p_magenta,d0
	or.w	p_yellow,d0
	bne	rrts

peps1:	move.l	table,a0
	move.l	pblockx(a0),d0
	move.l	pblocky(a0),d1
	bsr	send2n			;width/height in 7200ths
	move.l	table,a0
	move.l	pblockptr(a0),a0
	move.l	(a0),a0
	move.l	eps_Width(a0),d0
	move.l	eps_Height(a0),d1
	bsr	send2n			;original width in 7200ths
	move.l	table,a0
	move.l	pblockptr(a0),a0
	move.l	(a0),a0
	move.l	eps_Sizeof(a0),d0
	move.l	eps_Sizeof+4(a0),d1
	bsr	send2n			;lower left
	move.l	table,a0
	move.l	pblockptr(a0),a0
	move.l	(a0),a0
	move.l	eps_Sizeof+8(a0),d0
	move.l	eps_Sizeof+12(a0),d1
	bsr	send2n			;upper right

	lea	_bgneps,a0
	bsr	sendline

	move.l	table,a0
	cmp.w	#1,psepmode(a0)
	bne	mseps0
*
*
	lea	cyanplate,a2
	cmp.w	#$ffff,p_cyan
	beq	sepps1

	lea	magentaplate,a2
	cmp.w	#$ffff,p_magenta
	beq	sepps1

	lea	yellowplate,a2
	cmp.w	#$ffff,p_yellow
	beq	sepps1

	lea	blackplate,a2
	cmp.w	#$ffff,p_black
	bne	mseps0

sepps1:	bsr	fndeps
	beq	mseps0

	move.l	a1,-(sp)

	lea	includestr,a0
	bsr	sendline
	move.l	(sp)+,a1

sepps2:	move.b	(a1)+,d0
	beq	sepps2
	cmp.b	#CR,d0
	beq	sepps3
	cmp.b	#LF,d0
	beq	sepps3
	move.l	a1,-(sp)
	bsr	send
	move.l	(sp)+,a1
	bra	sepps2
sepps3:	move.b	#QUOTE,d0
	bsr	send
	bsr	sendcrlf
	bra	mseps9

*
*
mseps0:	move.l	table,a0
	move.l	pblockptr(a0),a0
	move.l	(a0),a0
	move.l	eps_DataLen(a0),d1
	sub.l	#16,d1
	bcs	mseps9
	lea	eps_Sizeof+16(a0),a0
	bra	mseps3
mseps1:	move.b	(a0)+,d0

	cmp.l	#4,d1
	bcc	mseps2
	cmp.b	#6,d0
	bcs	mseps3
mseps2:	movem.l	d1/a0,-(sp)
	bsr	send
	movem.l	(sp)+,d1/a0
mseps3:	subq.l	#1,d1
	bcc	mseps1


mseps9:	lea	_endeps,a0
	bra	sendline


*******************
***		***
*******************
fndeps:	move.l	pblockptr(a0),a0
	move.l	(a0),a0
	move.l	eps_DataLen(a0),d0
	sub.l	#16,d0
	bcs	fndps4
	lea	eps_Sizeof+16(a0),a0
fndps1:	move.l	a2,a3
	move.l	a0,a1
fndps2:	tst.b	(a3)
	beq	fndps4
	cmp.b	(a3)+,(a1)+
	beq	fndps2
	addq.l	#1,a0
	subq.l	#1,d0
	bhi	fndps1
	moveq	#0,d1
	rts

fndps4:	moveq	#1,d1
	rts

*******************************************************************
***								***
*******************************************************************
getbpp:	bra.w	pal_bpp
	bra.w	bw_bpp
	bra.w	rgb_bpp
	bra.w	rgbw_bpp
	bra.w	cmy_bpp
	bra.w	cmyk_bpp


pal_bpp:
	moveq	#4,d0
	rts

rgbw_bpp:
cmyk_bpp:
	divu	#4,d0
	bra	bw_bpp

cmy_bpp:
rgb_bpp:
	divu	#3,d0
bw_bpp:	cmp.w	#2,d0
	bcs	rrts
	cmp.w	#4,d0
	bcc	bp2
	moveq	#4,d0
	rts
bp2:	moveq	#8,d0
	rts


putbmp:	move.l	table,a0
	move.l	pblockptr(a0),a1	;handle to bit map header
	move.l	(a1),a1			;ptr to bit map header
	move.w	pc_Type(a1),d1
	lsl.w	#2,d1
	move.w	pc_BitPln(a1),d0
	jsr	getbpp(pc,d1.w)
	move.w	d0,bpp
	clr.w	bcnt
	clr.w	bdata

	move.w	pc_Type(a1),d0
	cmp.w	#1,psepmode(a0)
	bne	bp4
	bset	#4,d0
	bra	bp7

bp4:	cmp.w	#2,psepmode(a0)
	bne	bp5
	bset	#3,d0
	bset	#4,d0
	bra	bp7

bp5:	tst.b	colorprt
	beq	bp7
	cmp.w	#PC_BW,d0
	beq	bp7

	bset	#3,d0

bp7:	move.w	d0,pmode

	move.w	pc_W(a1),d0		;pixels wide
	move.w	pc_H(a1),d1		;pixels high
	jsr	send2i
	move.w	bpp,d0			;bits/pixel
	jsr	sendi

	move.l	table,a0
	move.l	pblockx(a0),d0
	move.l	pblocky(a0),d1
	bsr	send2n

	move.l	table,a0
	move.l	pblockptr(a0),a1
	move.l	(a1),a1
	move.w	pc_SFreq(a1),d0
	bsr	sendi

	move.l	table,a0
	move.l	pblockptr(a0),a1
	move.l	(a1),a1
	move.w	pc_SAngle(a1),d0
	bsr	sendi

	move.w	pmode,d0
	and.w	#%11000,d0
	cmp.w	#%01000,d0
	bne	bwpic
	lea	_putrgbpic,a0
	bra	dopic
bwpic:	lea	_putpic,a0
dopic:	bsr	sendline

	move.l	table,a0
	move.l	pblockptr(a0),a0	;handle to bit map header
	move.l	(a0),a0			;ptr to bit map header

	move.w	pc_W(a0),w
	move.w	pc_H(a0),h
	move.w	pc_Width(a0),pwidth
	move.w	pc_BitPln(a0),bitpln
	move.w	pwidth,d0
	mulu	h,d0
	move.l	d0,plane
	lea	pc_Sizeof(a0),a1
	move.l	a1,palptr
	add.l	pc_Ptr(a0),a0

*
* start of row
*
putp1:	move.l	a0,picptr
	moveq	#7,d7
	move.w	w,count
	clr.w	crlfcnt

putp2:	move.l	a0,pptr
	move.w	d7,pixel

*
*
*
	move.w	pmode,d0
	lsl.w	#2,d0
	jsr	pic_bw(pc,d0.w)

*
*
*
	move.l	pptr,a0
	move.w	pixel,d7
	dbf	d7,putp6
	moveq	#7,d7
	addq.l	#1,a0
putp6:	subq.w	#1,count
	bne	putp2

	bsr	lastpixel

	move.l	picptr,a0
	add.w	pwidth,a0
	subq.w	#1,h
	bne	putp1

	rts

*
*
*
pic_bw:

*
* bw output
*
	bra.w	pal_bw
	bra.w	bw_bw
	bra.w	rgb_bw
	bra.w	rgbw_bw
	bra.w	cmy_bw
	bra.w	cmyk_bw
	bra.w	rrts
	bra.w	rrts
*
* color output
*
	bra.w	pal_rgb
	bra.w	bw_rgb
	bra.w	rgb_rgb
	bra.w	rgbw_rgb
	bra.w	cmy_rgb
	bra.w	cmyk_rgb
	bra.w	rrts
	bra.w	rrts
*
* separation
*
	bra.w	pal_sep
	bra.w	bw_sep
	bra.w	rgb_sep
	bra.w	rgbw_sep
	bra.w	cmy_sep
	bra.w	cmyk_sep
	bra.w	rrts
	bra.w	rrts
*
* spot color
*
	bra.w	pal_mec
	bra.w	bw_mec
	bra.w	rgb_mec
	bra.w	rgbw_mec
	bra.w	cmy_mec
	bra.w	cmyk_mec
	bra.w	rrts
	bra.w	rrts




pal_bw:	moveq	#0,d0
	moveq	#0,d2
	move.w	bitpln,d1
	bra	pbw3
pbw1:	btst	d7,(a0)
	beq	pbw2
	bset	d2,d0
pbw2:	add.l	plane,a0
	addq.w	#1,d2
pbw3:	dbf	d1,pbw1

*
* color number in d0
*

	move.l	palptr,a0
	mulu	#pl_Sizeof,d0
	add.l	d0,a0

	move.w	pl_Red(a0),d0
	move.w	pl_Green(a0),d1
	move.w	pl_Blue(a0),d2
	mulu	#19661,d0		;$4ccd
	mulu	#38666,d1		;$970a
	mulu	#7209,d2		;$1c29
	add.l	d1,d0
	add.l	d2,d0
	swap	d0

	bra	sendpixel


pal_rgb:
	moveq	#0,d0
	moveq	#0,d2
	move.w	bitpln,d1
	bra	prgb3
prgb1:	btst	d7,(a0)
	beq	prgb2
	bset	d2,d0
prgb2:	add.l	plane,a0
	addq.w	#1,d2
prgb3:	dbf	d1,prgb1

*
* color number in d0
*

	move.l	palptr,a0
	mulu	#pl_Sizeof,d0
	add.l	d0,a0

	move.w	pl_Red(a0),d0
	move.w	pl_Blue(a0),-(sp)
	move.w	pl_Green(a0),-(sp)
	bsr	sendpixel
	move.w	(sp)+,d0
	bsr	sendpixel
	move.w	(sp)+,d0
	bra	sendpixel

pal_sep:
	moveq	#0,d0
	moveq	#0,d2
	move.w	bitpln,d1
	bra	psep3
psep1:	btst	d7,(a0)
	beq	psep2
	bset	d2,d0
psep2:	add.l	plane,a0
	addq.w	#1,d2
psep3:	dbf	d1,psep1

*
* color number in d0
*
	move.l	palptr,a0
	mulu	#pl_Sizeof,d0
	add.l	d0,a0
	tst.w	pl_ScreenColor(a0)
	bmi	palwht
	move.w	pl_Red(a0),d0
	move.w	pl_Green(a0),d1
	move.w	pl_Blue(a0),d2

	neg.w	d0
	neg.w	d1
	neg.w	d2
	add.w	#65535,d0
	add.w	#65535,d1
	add.w	#65535,d2
	bsr	cmy_to_cmyk
	and.w	p_cyan,d0
	and.w	p_magenta,d1
	and.w	p_yellow,d2
	and.w	p_black,d3
	add.w	d0,d3
	add.w	d1,d3
	add.w	d2,d3
	move.w	#65535,d0
	sub.w	d3,d0
	bra	sendpixel

palwht:	move.w	#65535,d0
	bra	sendpixel


bw_bw:	moveq	#0,d0
	moveq	#0,d2
	moveq	#1,d3
	move.w	bitpln,d1
	bra	bbw3
bbw1:	btst	d7,(a0)
	beq	bbw2
	bset	d2,d0
bbw2:	add.l	plane,a0
	addq.w	#1,d2
	lsl.w	#1,d3
bbw3:	dbf	d1,bbw1

	subq.w	#1,d3
	mulu	#65535,d0
	divu	d3,d0
	neg.w	d0
	add.w	#65535,d0
	bra	sendpixel



bw_rgb:	moveq	#0,d0
	moveq	#0,d2
	moveq	#1,d3
	move.w	bitpln,d1
	bra	brgb3
brgb1:	btst	d7,(a0)
	beq	brgb2
	bset	d2,d0
brgb2:	add.l	plane,a0
	addq.w	#1,d2
	lsl.w	#1,d3
brgb3:	dbf	d1,brgb1

	subq.w	#1,d3
	mulu	#65535,d0
	divu	d3,d0
	move.w	d0,-(sp)
	bsr	sendpixel
	move.w	(sp),d0
	bsr	sendpixel
	move.w	(sp)+,d0
	bra	sendpixel

bw_sep:	moveq	#0,d0
	moveq	#0,d2
	moveq	#1,d3
	move.w	bitpln,d1
	bra	bsep3
bsep1:	btst	d7,(a0)
	beq	bsep2
	bset	d2,d0
bsep2:	add.l	plane,a0
	addq.w	#1,d2
	lsl.w	#1,d3
bsep3:	dbf	d1,bsep1

	subq.w	#1,d3
	mulu	#65535,d0
	divu	d3,d0
*
;	move.w	d0,d1
;	mulu	cyan,d1
;	divu	#10000,d1
;	and.w	p_cyan,d1
;	move.w	d1,d2
;
;	move.w	d0,d1
;	mulu	magenta,d1
;	divu	#10000,d1
;	and.w	p_magenta,d1
;	add.w	d1,d2
;
;	move.w	d0,d1
;	mulu	yellow,d1
;	divu	#10000,d1
;	and.w	p_yellow,d1
;	add.w	d1,d2
;
;	move.w	d0,d1
;	mulu	black,d1
;	divu	#10000,d1
;	and.w	p_black,d1
;	add.w	d1,d2
;
;	move.w	#65535,d0
;	sub.w	d2,d0

	and.w	p_black,d0
	neg.w	d0
	add.w	#65535,d0

	bra	sendpixel


rgb_bw:	moveq	#0,d0
	moveq	#0,d2
	moveq	#1,d3
	move.w	bitpln,d1
	bra	rbr3
rbr1:	btst	d7,(a0)
	beq	rbr2
	bset	d2,d0
rbr2:	add.l	plane,a0
	addq.w	#1,d2
	lsl.w	#1,d3
rbr3:	subq.w	#3,d1
	bcc	rbr1
	subq.w	#1,d3
	mulu	#65535,d0
	divu	d3,d0
	move.w	d0,-(sp)		;blue

	moveq	#0,d0
	moveq	#0,d2
	move.w	bitpln,d1
	bra	rbg3
rbg1:	btst	d7,(a0)
	beq	rbg2
	bset	d2,d0
rbg2:	add.l	plane,a0
	addq.w	#1,d2
rbg3:	subq.w	#3,d1
	bcc	rbg1
	subq.w	#1,d3
	mulu	#65535,d0
	divu	d3,d0
	move.w	d0,-(sp)		;green

	moveq	#0,d0
	moveq	#0,d2
	move.w	bitpln,d1
	bra	rbb3
rbb1:	btst	d7,(a0)
	beq	rbb2
	bset	d2,d0
rbb2:	add.l	plane,a0
	addq.w	#1,d2
rbb3:	subq.w	#3,d1
	bcc	rbb1
	subq.w	#1,d3
	mulu	#65535,d0
	divu	d3,d0			;red
	move.w	(sp)+,d1
	move.w	(sp)+,d2

	mulu	#19661,d0
	mulu	#38666,d1
	mulu	#7209,d2
	add.l	d1,d0
	add.l	d2,d0
	swap	d0

	bra	sendpixel


rgb_rgb:
	moveq	#0,d0
	moveq	#0,d2
	moveq	#1,d3
	move.w	bitpln,d1
	bra	rrr3
rrr1:	btst	d7,(a0)
	beq	rrr2
	bset	d2,d0
rrr2:	add.l	plane,a0
	addq.w	#1,d2
	lsl.w	#1,d3
rrr3:	subq.w	#3,d1
	bcc	rrr1
	subq.w	#1,d3
	mulu	#65535,d0
	divu	d3,d0
	move.w	d0,-(sp)		;blue

	moveq	#0,d0
	moveq	#0,d2
	move.w	bitpln,d1
	bra	rrg3
rrg1:	btst	d7,(a0)
	beq	rrg2
	bset	d2,d0
rrg2:	add.l	plane,a0
	addq.w	#1,d2
rrg3:	subq.w	#3,d1
	bcc	rrg1
	subq.w	#1,d3
	mulu	#65535,d0
	divu	d3,d0
	move.w	d0,-(sp)		;green

	moveq	#0,d0
	moveq	#0,d2
	move.w	bitpln,d1
	bra	rrb3
rrb1:	btst	d7,(a0)
	beq	rrb2
	bset	d2,d0
rrb2:	add.l	plane,a0
	addq.w	#1,d2
rrb3:	subq.w	#3,d1
	bcc	rrb1
	subq.w	#1,d3
	mulu	#65535,d0
	divu	d3,d0			;red
	bsr	sendpixel
	move.w	(sp)+,d0		;green
	bsr	sendpixel
	move.w	(sp)+,d0		;blue
	bra	sendpixel

rgb_sep:
	moveq	#0,d0
	moveq	#0,d2
	moveq	#1,d3
	move.w	bitpln,d1
	bra	rsr3
rsr1:	btst	d7,(a0)
	beq	rsr2
	bset	d2,d0
rsr2:	add.l	plane,a0
	addq.w	#1,d2
	lsl.w	#1,d3
rsr3:	subq.w	#3,d1
	bcc	rsr1
	subq.w	#1,d3
	mulu	#65535,d0
	divu	d3,d0
	move.w	d0,-(sp)		;blue

	moveq	#0,d0
	moveq	#0,d2
	move.w	bitpln,d1
	bra	rsg3
rsg1:	btst	d7,(a0)
	beq	rsg2
	bset	d2,d0
rsg2:	add.l	plane,a0
	addq.w	#1,d2
rsg3:	subq.w	#3,d1
	bcc	rsg1
	subq.w	#1,d3
	mulu	#65535,d0
	divu	d3,d0
	move.w	d0,-(sp)		;green

	moveq	#0,d0
	moveq	#0,d2
	move.w	bitpln,d1
	bra	rsb3
rsb1:	btst	d7,(a0)
	beq	rsb2
	bset	d2,d0
rsb2:	add.l	plane,a0
	addq.w	#1,d2
rsb3:	subq.w	#3,d1
	bcc	rsb1
	subq.w	#1,d3
	mulu	#65535,d0
	divu	d3,d0			;red

	move.w	(sp)+,d1
	move.w	(sp)+,d2

	neg.w	d0
	neg.w	d1
	neg.w	d2
	add.w	#65535,d0
	add.w	#65535,d1
	add.w	#65535,d2
	bsr	cmy_to_cmyk
	and.w	p_cyan,d0
	and.w	p_magenta,d1
	and.w	p_yellow,d2
	and.w	p_black,d3
	add.w	d0,d3
	add.w	d1,d3
	add.w	d2,d3
	move.w	#65535,d0
	sub.w	d3,d0
	bra	sendpixel


rgbw_bw:
rgbw_rgb:
rgbw_sep:

cmy_bw:
cmy_rgb:
cmy_sep:

cmyk_bw:
cmyk_rgb:
cmyk_sep:

dowhite:
	move.w	#65535,d0
	bra	sendpixel


pal_mec:
	tst.w	p_cyan
	bne	dowhite
	tst.w	p_magenta
	bne	dowhite
	tst.w	p_yellow
	bne	dowhite
	cmp.w	#10000,p_black
	bcs	dowhite
	bra	pal_bw

bw_mec:
	tst.w	p_cyan
	bne	dowhite
	tst.w	p_magenta
	bne	dowhite
	tst.w	p_yellow
	bne	dowhite
	cmp.w	#10000,p_black
	bcs	dowhite
	bra	bw_bw

rgb_mec:
	tst.w	p_cyan
	bne	dowhite
	tst.w	p_magenta
	bne	dowhite
	tst.w	p_yellow
	bne	dowhite
	cmp.w	#10000,p_black
	bcs	dowhite
	bra	rgb_bw

rgbw_mec:
	tst.w	p_cyan
	bne	dowhite
	tst.w	p_magenta
	bne	dowhite
	tst.w	p_yellow
	bne	dowhite
	cmp.w	#10000,p_black
	bcs	dowhite
	bra	rgbw_bw

cmy_mec:
	tst.w	p_cyan
	bne	dowhite
	tst.w	p_magenta
	bne	dowhite
	tst.w	p_yellow
	bne	dowhite
	cmp.w	#10000,p_black
	bcs	dowhite
	bra	cmy_bw

cmyk_mec:
	tst.w	p_cyan
	bne	dowhite
	tst.w	p_magenta
	bne	dowhite
	tst.w	p_yellow
	bne	dowhite
	cmp.w	#10000,p_black
	bcs	dowhite
	bra	cmyk_bw


***************************************************
***						***
***************************************************
cmy_to_cmyk:
	move.w	d0,d3
	cmp.w	d3,d1
	bcc	ctc1
	move.w	d1,d3
ctc1:	cmp.w	d3,d2
	bcc	ctc2
	move.w	d2,d3
ctc2:	cmp.w	#65535,d3
	beq	ctcblk
	move.w	d3,-(sp)
	mulu	#50,d3			;ucr
	divu	#100,d3
	sub.w	d3,d0
	sub.w	d3,d1
	sub.w	d3,d2
	move.w	(sp)+,d3

	mulu	d3,d3			;gcr
	divu	#65535,d3
	rts

ctcblk:	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	move.w	#65535,d3
	rts
*
*
sendpixel:
	move.b	bdata,d2
	move.w	bpp,d1
	lsl.b	d1,d2
	and.l	#$ffff,d0
	lsl.l	d1,d0
	swap	d0
	or.b	d2,d0
	add.w	bcnt,d1
	cmp.w	#8,d1
	beq	sndpx1
	move.w	d1,bcnt
	move.b	d0,bdata
	rts
sndpx1:	clr.w	bcnt
	clr.w	bdata
	bsr	sendh
	addq.w	#2,crlfcnt
	cmp.w	#250,crlfcnt
	bcs	rrts
	clr.w	crlfcnt
	bra	sendcrlf

lastpixel:
	move.w	bcnt,d1
	beq	lstpx1
	move.b	bdata,d0
	neg.w	d1
	add.w	#8,d1
	lsl.b	d1,d0
	bsr	sendh
	clr.w	bcnt
	clr.w	bdata
lstpx1:	bra	sendcrlf



*******************************************************************
***								***
*******************************************************************
flushfont:
	btst	#0,auto_unload
	beq	rrts
	bclr	#0,downflag
	beq	rrts
	move.l	table,a1
	move.l	ftlist(a1),a2
	move.l	(a2),a2
	move.l	(a2),a2
	add.l	downoff,a2
	clr.w	ft_Flag(a2)
	move.l	#$7fffffff,curx
	move.l	#$7fffffff,cury
	lea	_endfnt,a0
	bra	sendline


*******************************************************************
***								***
*******************************************************************


Divs1648:
	move.l	table,a0
	move.l	divs1648(a0),a0
	jmp	(a0)

Muls1632:
	move.l	table,a0
	move.l	muls1632(a0),a0
	jmp	(a0)

*
* these are the send routines for the
* page description driver.
*
sendcrlf:
	move.b	#CR,d0
	bsr	send
	move.b	#LF,d0
	bra	send
*
sendh:	move.w	d0,-(sp)
	lsr.b	#4,d0
	bsr	rc1
	move.w	(sp)+,d0
rc1:	and.w	#$f,d0
	lea	hex,a0
	move.b	0(a0,d0.w),d0
	bra	send
*
*
sendline:
	move.b	(a0)+,d0
	beq	rrts
	move.l	a0,-(sp)
	bsr	send
	move.l	(sp)+,a0
	bra	sendline
*
*
send2n:	move.l	d1,-(sp)
	bsr	sendn
	move.l	(sp)+,d0
	bra	sendn

*
send2i:	move.w	d1,-(sp)
	bsr	sendi
	move.w	(sp)+,d0
	bra	sendi
*
sendxy:	move.l	d1,-(sp)
	bsr	sendn
	move.l	yinvert,d0
	sub.l	(sp)+,d0
	bra	sendn
*
* fall into sendn
*
sendi:	and.l	#$ffff,d0
sendn:	tst.l	d0
	bpl	snd0

	move.l	d0,-(sp)
	move.b	#"-",d0
	bsr	send
	move.l	(sp)+,d0
	neg.l	d0

snd0:	move.l	d0,d1
	moveq	#0,d0
	move.l	#10000000,d2
	bsr	snd1
	move.l	#1000000,d2
	bsr	snd1
	move.l	#100000,d2
	bsr	snd1
	move.l	#10000,d2
	bsr	snd1
	move.l	#1000,d2
	bsr	snd1
	move.l	#100,d2
	bsr	snd1
	move.l	#10,d2
	bsr	snd1
	or.b	#"0",d1
	move.b	d1,d0
	bsr	send
	move.b	#$20,d0
	bra	send		;send a space


snd1:	cmp.l	d2,d1
	bcs	snd2
	sub.l	d2,d1
	addq.w	#1,d0
	bra	snd1
snd2:	tst.w	d0
	beq	snd3
	move.l	d1,-(sp)
	or.b	#"0",d0
	bsr	send
	move.l	(sp)+,d1
	move.b	#"0",d0
snd3:	rts

*
*

send:	jmp	$ffffff

*
*
*******************************************************************
***								***
*******************************************************************

 SECTION printer,DATA,PUBLIC


prntbl:	dc.l	prtok,prtok,prtok,prtok,p_init
	dc.l	p_bgndoc,p_bgnpage,p_bgntile
	dc.l	prtok
	dc.l	p_endtile,p_endpage,p_enddoc
	dc.l	p_break,p_ident
*
	dc.l	setfill		;10
	dc.l	setline		;11
	dc.l	newpath		;12
 	dc.l	closepath	;13
	dc.l	fillpath	;14
	dc.l	strokepath	;15
	dc.l	moveto		;16
	dc.l	lineto		;17
	dc.l	curveto		;18
	dc.l	arcto		;19
	dc.l	arcnto		;20
	dc.l	prtok
	dc.l	prtok
	dc.l	setcolor	;23
	dc.l	rotate		;24
	dc.l	setfont		;25
	dc.l	prtok
	dc.l	prtok
	dc.l	prtok
	dc.l	prtok
	dc.l	putchar		;30
	dc.l	putbmp		;31
	dc.l	puteps		;32


*
*
*
lwdash:	dc.l	lwd1,lwd1,lwd2,lwd3,lwd4,lwd5,lwd6,lwd7
lwd1:	dc.b	"[]",0
lwd2:	dc.b	"[600 200]",0
lwd3:	dc.b	"[100 300]",0
lwd4:	dc.b	"[400 150 100 150]",0
lwd5:	dc.b	"[400 400]",0
lwd6:	dc.b	"[200 150 100 100 50 150]",0
lwd7:	dc.b	"[",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0


******
******
*
*
f_tbl:	dc.b	0,$80+1,12,25,37,50,62,75,87,100
	dc.b	$80+10,$80+11,$80+12,$80+13,$80+14
	dc.b	$80+15,$80+16,$80+17,$80+18,$80+19
	dc.b	$80+20,$80+21,$80+22,$80+23,$80+24
	dc.b	$80+25,$80+26,$80+27,$80+28,$80+29
	dc.b	$80+30,$80+31,$80+32,$80+33,$80+34
	dc.b	$80+35,$80+36,$80+37,$80+38,$80+39


_bgnpage:	dc.b	"% Begin Page",CR,LF,0
_endpage:	dc.b	"% End Page",CR,LF,CR,LF,0
_bgntile:	dc.b	"% Begin Tile",CR,LF,0
_bgntile2:	dc.b	"begintile",CR,LF,0
_endtile:	dc.b	"endtile",CR,LF
		dc.b	"showpage",CR,LF
		dc.b	"% End Tile",CR,LF,0

_setscl:	dc.b	"setscl",CR,LF,0
_newpath:	dc.b	"NW",CR,LF,0
_moveto:	dc.b	"MT",CR,LF,0
_lineto:	dc.b	"LT",CR,LF,0
_curveto:	dc.b	"CRV",CR,LF,0
_arcto:		dc.b	"AT",CR,LF,0
_arcnto:	dc.b	"AN",CR,LF,0
_closepath:	dc.b	"CP",CR,LF,0
_setshade:	dc.b	"SHADE",CR,LF,0
_setcmyk:	dc.b	"CMYK",CR,LF,0
_setpattern:	dc.b	"PTRN",CR,LF,0
_setline:	dc.b	" LTYPE",CR,LF,0
_fillpath:	dc.b	"MF",CR,LF,0
_strokepath:	dc.b	"MS",CR,LF,0
_bgnfnt:	dc.b	"/PgsFontSave save def",CR,LF,0
_endfnt:	dc.b	"PgsFontSave restore omatrix setmatrix",CR,LF,0
_bgnpgu:	dc.b	"/PgsPageSave save def",CR,LF,0
_endpgu:	dc.b	"PgsPageSave restore",CR,LF,0

_dobgnmoveto:	dc.b	"BS",CR,LF,0
_doendstroke:	dc.b	"ES",CR,LF,0

_putc1:		dc.b	"r",CR,LF,0
_putc2:		dc.b	"p",CR,LF,0
_puta1:		dc.b	"a ",0
_puta2:		dc.b	"b ",0
_setfp:		dc.b	"setfp",CR,LF,0
_putpic:	dc.b	"putpic",CR,LF,0
_putrgbpic:	dc.b	"putrgbpic",CR,LF,0
_bgneps:	dc.b	"bgneps",CR,LF,0
_endeps:	dc.b	"endeps",CR,LF,0

_enddoc:
 dc.b "%%Trailer",CR,LF
 dc.b "end",CR,LF
 dc.b "%%EOF",CR,LF
 dc.b 4,0

_comments:
 dc.b "%!PS-Adobe-2.0",CR,LF
 dc.b "%%Title: Unknown",CR,LF
 dc.b "%%Creator: PageStream v2.0",CR,LF
 dc.b "%%CreationDate: Not Available",CR,LF
 dc.b "%%For: Who Created This Document",CR,LF
 dc.b "%%Routing: How To Route Document Back",CR,LF
 dc.b "%%ProofMode: Substitute",CR,LF
 dc.b 0

_bbcomment: dc.b "%%BoundingBox:",0
_npcomment: dc.b "%%Pages: Unknown",CR,LF,0
_dfcomment: dc.b "%%DocumentFonts:",CR,LF,0
_dnfcomment: dc.b "%%DocumentNeededFonts:",CR,LF,0
_dsfcomment: dc.b "%%DocumentSuppliedFonts:",CR,LF,0

_prolog:
 dc.b "%%EndComments",CR,LF
 dc.b CR,LF
 dc.b "%%BeginProlog",CR,LF
 dc.b "/AsphaltDict dup 150 dict def load begin",CR,LF
 dc.b CR,LF
 dc.b "%",CR,LF
 dc.b "% some redefinitions",CR,LF
 dc.b "%",CR,LF
 dc.b "/bdef {bind def} bind def",CR,LF
 dc.b "/xdef {exch def} bind def",CR,LF
 dc.b "/dmatrix matrix def",CR,LF
 dc.b "/cmatrix matrix def",CR,LF
 dc.b "/omatrix matrix def",CR,LF
 dc.b CR,LF
 dc.b "%",CR,LF
 dc.b "% drawing definitions",CR,LF
 dc.b "%",CR,LF
 dc.b CR,LF
 dc.b "/sclm [0 0 0 0 0 0] def",CR,LF
 dc.b "/setscl {",CR,LF
 dc.b "  /deltay exch neg def",CR,LF
 dc.b "  /deltax exch neg def",CR,LF
 dc.b "  100 div /twist xdef",CR,LF
 dc.b "  100 div /slant xdef",CR,LF
 dc.b "  cmatrix setmatrix deltax neg deltay neg translate",CR,LF
 dc.b "  sclm 0 twist cos put",CR,LF
 dc.b "  sclm 1 twist sin put",CR,LF
 dc.b "  sclm 2 slant sin neg put",CR,LF
 dc.b "  sclm 3 slant cos put",CR,LF
 dc.b "  sclm concat",CR,LF
 dc.b "  /omatrix omatrix currentmatrix def",CR,LF
 dc.b "} bdef",CR,LF
 dc.b CR,LF
 dc.b "/scl {",CR,LF
 dc.b " deltay add exch",CR,LF
 dc.b " deltax add exch",CR,LF
 dc.b "} bdef",CR,LF
 dc.b CR,LF
 dc.b "/NW {newpath} bdef",CR,LF
 dc.b "/MT {scl moveto} bdef",CR,LF
 dc.b "/LT {scl lineto} bdef",CR,LF
 dc.b "/CRV {scl 6 2 roll scl 6 2 roll scl 6 2 roll curveto} bdef",CR,LF
 dc.b CR,LF
 dc.b "/AT {",CR,LF
 dc.b "  100 div /eang xdef 100 div /bang xdef",CR,LF
 dc.b "  /yscl xdef /xscl xdef scl translate",CR,LF
 dc.b "  xscl yscl scale 0 0 1 bang eang",CR,LF
 dc.b "  arc omatrix setmatrix",CR,LF
 dc.b "} bdef",CR,LF
 dc.b CR,LF
 dc.b "/AN {",CR,LF
 dc.b "  100 div /eang xdef 100 div /bang xdef",CR,LF
 dc.b "  /yscl xdef /xscl xdef scl translate",CR,LF
 dc.b "  xscl yscl scale 0 0 1 bang eang",CR,LF
 dc.b "  arcn omatrix setmatrix",CR,LF
 dc.b "} bdef",CR,LF
 dc.b CR,LF
 dc.b "/CP {closepath} bdef",CR,LF
 dc.b CR,LF
 dc.b "/LTYPE {0 setdash setlinewidth} bdef",CR,LF
 dc.b "/MF {gsave eofill grestore} bdef",CR,LF
 dc.b "/MS {gsave stroke grestore} bdef",CR,LF
 dc.b CR,LF
 dc.b "%",CR,LF
 dc.b "%",CR,LF
 dc.b "%",CR,LF
 dc.b "/cropmark {",CR,LF
 dc.b "  /ydir xdef",CR,LF
 dc.b "  /xdir xdef",CR,LF
 dc.b "  /cbv xdef",CR,LF
 dc.b "  /cbh xdef",CR,LF
 dc.b "  moveto",CR,LF
 dc.b "  cbh 6 add xdir mul 0 rmoveto",CR,LF
 dc.b "  20 xdir mul 0 rlineto",CR,LF
 dc.b "  cbh 26 add neg xdir mul cbv 6 add ydir mul rmoveto",CR,LF
 dc.b "  0 20 ydir mul rlineto stroke",CR,LF
 dc.b "} def",CR,LF
 dc.b CR,LF
 dc.b "/regmark {",CR,LF
 dc.b "  10 0 360 arc",CR,LF
 dc.b "  4 0 rmoveto",CR,LF
 dc.b "  -28 0 rlineto",CR,LF
 dc.b "  14 14 rmoveto",CR,LF
 dc.b "  0 -28 rlineto stroke",CR,LF
 dc.b "} def",CR,LF
 dc.b CR,LF
 dc.b CR,LF
 dc.b "%",CR,LF
 dc.b "% tilestring sepmode cyan magenta yellow black",CR,LF
 dc.b "% negative mirror cropmarks manualfeed landscape xscale yscale",CR,LF
 dc.b "% leftclip topclip documentwidth documentheight tilex tiley tilew tileh",CR,LF
 dc.b "% bleedh bleedv frequency angle copies BEGINTILE",CR,LF
 dc.b "%",CR,LF
 dc.b "/begintile {",CR,LF
 dc.b "  /#copies xdef",CR,LF
 dc.b "  /cangle xdef",CR,LF
 dc.b "  /cfreq xdef",CR,LF
 dc.b "  /bleedv xdef",CR,LF
 dc.b "  /bleedh xdef",CR,LF
 dc.b "  /tileh xdef",CR,LF
 dc.b "  /tilew xdef",CR,LF
 dc.b "  /tiley xdef",CR,LF
 dc.b "  /tilex xdef",CR,LF
 dc.b "  /doch xdef",CR,LF
 dc.b "  /docw xdef",CR,LF
 dc.b "  /leftclip xdef",CR,LF
 dc.b "  /topclip xdef",CR,LF
 dc.b "  /docyscl xdef",CR,LF
 dc.b "  /docxscl xdef",CR,LF
 dc.b "  /landscape xdef",CR,LF
 dc.b "  /manual xdef",CR,LF
 dc.b "  /cropmarks xdef",CR,LF
 dc.b "  /mirror xdef",CR,LF
 dc.b "  /negative xdef",CR,LF
 dc.b "  /pblack xdef",CR,LF
 dc.b "  /pyellow xdef",CR,LF
 dc.b "  /pmagenta xdef",CR,LF
 dc.b "  /pcyan xdef",CR,LF
 dc.b "  /psepmode xdef",CR,LF
 dc.b "  /tilename xdef",CR,LF
 dc.b CR,LF
 dc.b "  /dmatrix dmatrix currentmatrix def",CR,LF
 dc.b CR,LF
 dc.b "  statusdict /setpageparams known",CR,LF
 dc.b "   {",CR,LF
 dc.b "    mirror 1 eq {statusdict /mirrorprint known {statusdict /mirrorprint true put /mirror 0 def}if }if",CR,LF
 dc.b "    negative 1 eq {statusdict /negativeprint known {statusdict /negativeprint true put /negative 0 def}if }if",CR,LF
 dc.b "    statusdict begin tileh tilew cropmarks 1 eq {72 add exch 72 add exch}if 0 0 setpageparams end",CR,LF
 dc.b "    leftclip topclip translate",CR,LF
 dc.b "   } if",CR,LF
 dc.b "  leftclip topclip translate",CR,LF
 dc.b "  mirror 1 eq {docw 0 translate -1 1 scale} if",CR,LF
 dc.b "  negative 1 eq {{1 exch sub} settransfer newpath clippath 1 setgray fill} if",CR,LF
 dc.b "  manual 1 eq {statusdict /manualfeed known {statusdict /manualfeed true put}if }if",CR,LF
 dc.b "  tilex neg tiley neg translate",CR,LF
 dc.b CR,LF
 dc.b "  cropmarks 1 eq {",CR,LF
 dc.b "    bleedh 0 ge {/bh bleedh def /bv bleedv def}{/bh 0 def /bv 0 def}ifelse",CR,LF
 dc.b "    mirror 0 eq {bh 36 add bv 36 add translate}{bh 36 add neg bv 36 add translate}ifelse",CR,LF
 dc.b "    gsave",CR,LF
 dc.b "    0 setgray [] 0 setdash .3 setlinewidth",CR,LF
 dc.b "    tilex tiley bh bv -1 -1 cropmark",CR,LF
 dc.b "    tilex tilew add tiley bh bv 1 -1 cropmark",CR,LF
 dc.b "    tilex tilew add tiley tileh add bh bv 1 1 cropmark",CR,LF
 dc.b "    tilex tiley tileh add bh bv -1 1 cropmark",CR,LF
 dc.b "    tilew 2 div tilex add 18 tiley add tileh add bv add regmark",CR,LF
 dc.b "    tilew 2 div tilex add -18 tiley add bv sub regmark",CR,LF
 dc.b "    /Courier findfont 8 scalefont setfont",CR,LF
 dc.b "    tilex 14 sub bh sub 18 tiley add moveto",CR,LF
 dc.b "    90 rotate tilename show grestore",CR,LF
 dc.b "  } if",CR,LF
 dc.b CR,LF
 dc.b "  bleedh 0 ge {",CR,LF
 dc.b "    tilex bleedh sub tiley bleedv sub moveto",CR,LF
 dc.b "    tilex tilew add bleedh add tiley bleedv sub lineto",CR,LF
 dc.b "    tilex tilew add bleedh add tiley tileh add bleedv add lineto",CR,LF
 dc.b "    tilex bleedh sub tiley tileh add bleedv add lineto",CR,LF
 dc.b "    clip",CR,LF
 dc.b "  } if",CR,LF
 dc.b CR,LF
 dc.b "  landscape 1 eq {-90 rotate doch neg 0 translate} if",CR,LF
 dc.b "  docxscl 10000.0 div docyscl 10000.0 div scale",CR,LF
 dc.b CR,LF
 dc.b "  currentscreen /dproc xdef /dangle xdef /dfreq xdef",CR,LF
 dc.b "  /dtrans currenttransfer def",CR,LF
 dc.b CR,LF
 dc.b "  cangle 10000 gt {/cangle dangle def} if",CR,LF
 dc.b "  cfreq 10000 gt {/cfreq dfreq def} if",CR,LF
 dc.b "  cfreq cangle /dproc load setscreen",CR,LF
 dc.b "  /cmatrix cmatrix currentmatrix def",CR,LF
 dc.b CR,LF
 dc.b " psepmode 0 eq {systemdict /setcmykcolor known not",CR,LF
 dc.b "   {/setcmykcolor",CR,LF
 dc.b "    {1 sub 4 1 roll 3 {3 index add neg dup 0 lt{pop 0}if 3 1 roll}",CR,LF
 dc.b "     repeat setrgbcolor pop} bdef}",CR,LF
 dc.b "  if} if",CR,LF
 dc.b " psepmode 1 eq {",CR,LF
 dc.b "  pcyan 0 ne {/setcmykcolor {pop pop pop 1 exch sub setgray}bdef} if",CR,LF
 dc.b "  pmagenta 0 ne {/setcmykcolor {pop pop 1 exch sub setgray pop}bdef} if",CR,LF
 dc.b "  pyellow 0 ne {/setcmykcolor {pop 1 exch sub setgray pop pop}bdef} if",CR,LF
 dc.b "  pblack 0 ne {/setcmykcolor {1 exch sub setgray pop pop pop}bdef} if",CR,LF
 dc.b " } if",CR,LF
 dc.b " psepmode 2 eq {/setcmykcolor {",CR,LF
 dc.b "  pblack 10000 div eq exch",CR,LF
 dc.b "  pyellow 10000 div eq and exch",CR,LF
 dc.b "  pmagenta 10000 div eq and exch",CR,LF
 dc.b "  pcyan 10000 div eq and {0 setgray}{1 setgray}ifelse}bdef} if",CR,LF
 dc.b CR,LF
 dc.b "} bdef",CR,LF
 dc.b CR,LF
 dc.b "%",CR,LF
 dc.b "%",CR,LF
 dc.b "%",CR,LF
 dc.b "/endtile {",CR,LF
 dc.b "  manual 1 eq {statusdict /manualfeed known {statusdict /manualfeed false put}if } if",CR,LF
 dc.b "  dmatrix setmatrix",CR,LF
 dc.b "} bdef",CR,LF
 dc.b CR,LF
 dc.b "%",CR,LF
 dc.b "% routines for setting halftone/pattern fill",CR,LF
 dc.b "%",CR,LF
 dc.b "/bpspotfunction {",CR,LF
 dc.b "    /yindex exch 1 add 8 mul cvi def",CR,LF
 dc.b "    /xindex exch 1 add 8 mul cvi def",CR,LF
 dc.b CR,LF
 dc.b "    bstring yindex 2 mul xindex 8 idiv add get",CR,LF
 dc.b "    1 7 xindex 8 mod sub bitshift",CR,LF
 dc.b "    and 0 ne {1} {0} ifelse",CR,LF
 dc.b "} bdef",CR,LF
 dc.b CR,LF
 dc.b "%",CR,LF
 dc.b "%",CR,LF
 dc.b "%",CR,LF
 dc.b "/PTRN {",CR,LF
 dc.b "  /shade xdef",CR,LF
 dc.b "  /bstring xdef",CR,LF
 dc.b CR,LF
 dc.b "  /cellsz 1536.0 def",CR,LF ;768
 dc.b CR,LF
 dc.b "  negative 1 eq {0 1 31 {bstring exch dup bstring exch get 255 exch sub put} for} if",CR,LF
 dc.b "  /spotfunction /bpspotfunction load def",CR,LF
 dc.b "  /m cellsz dup matrix scale cmatrix matrix concatmatrix def",CR,LF
 dc.b "  1 0 m dtransform /y1 xdef /x1 xdef",CR,LF
 dc.b CR,LF
 dc.b "  m 2 get m 1 get mul m 0 get m 3 get mul sub 0 gt",CR,LF
 dc.b "   {",CR,LF
 dc.b "    /spotfunction /proc1 { neg } cvlit def",CR,LF
 dc.b "    /proc2 /spotfunction load cvlit def",CR,LF
 dc.b "    proc1 length proc2 length add array",CR,LF
 dc.b "    dup 0 proc1 putinterval",CR,LF
 dc.b "    dup proc1 length proc2 putinterval",CR,LF
 dc.b "    cvx",CR,LF
 dc.b "    def",CR,LF
 dc.b "   } if",CR,LF
 dc.b CR,LF
 dc.b "   72 0 matrix defaultmatrix dtransform dup mul exch dup mul add sqrt",CR,LF
 dc.b "   x1 dup mul y1 dup mul add sqrt div  % new screen frequency",CR,LF
 dc.b "   y1 x1 atan              % new screen angle",CR,LF
 dc.b "   /spotfunction load      % new screen procedure",CR,LF
 dc.b "  setscreen",CR,LF
 dc.b "  {} settransfer",CR,LF
 dc.b CR,LF
 dc.b "  /onbits 0 def",CR,LF
 dc.b "  0 1 255",CR,LF
 dc.b "   {",CR,LF
 dc.b "    dup 8 idiv bstring exch get exch",CR,LF
 dc.b "     1 exch 7 exch 8 mod sub bitshift",CR,LF
 dc.b "     and 0 ne {/onbits onbits 1 add def} if",CR,LF
 dc.b "   } for",CR,LF
 dc.b "  1 onbits 256 div shade mul 10000 div sub setgray",CR,LF
 dc.b "} bdef",CR,LF
 dc.b CR,LF
 dc.b "%",CR,LF
 dc.b "%",CR,LF
 dc.b "%",CR,LF
 dc.b "/SHADE {",CR,LF
 dc.b "  /shade xdef",CR,LF
 dc.b "  cfreq cangle /dproc load setscreen",CR,LF
 dc.b "  /dtrans load settransfer",CR,LF
 dc.b "  1 shade 10000 div sub setgray",CR,LF
 dc.b "} bdef",CR,LF
 dc.b CR,LF
 dc.b "%",CR,LF
 dc.b "%",CR,LF
 dc.b "%",CR,LF
 dc.b "/CMYK {",CR,LF
 dc.b "  /k xdef",CR,LF
 dc.b "  /y xdef",CR,LF
 dc.b "  /m xdef",CR,LF
 dc.b "  /c xdef",CR,LF
 dc.b "  c 10000 div m 10000 div y 10000 div k 10000 div setcmykcolor",CR,LF
 dc.b "} bdef",CR,LF
 dc.b CR,LF
 dc.b CR,LF
 dc.b "%",CR,LF
 dc.b "% pixelw pixelh bitsperpixel picx picy pfreq pangle PUTPIC",CR,LF
 dc.b "%",CR,LF
 dc.b "/putpic {",CR,LF
 dc.b "  /pangle xdef",CR,LF
 dc.b "  /pfreq xdef",CR,LF
 dc.b "  /ysize xdef",CR,LF
 dc.b "  /xsize xdef",CR,LF
 dc.b "  /bpp xdef",CR,LF
 dc.b "  /h xdef",CR,LF
 dc.b "  /w xdef",CR,LF
 dc.b CR,LF
 dc.b "  pfreq 10000 lt {pfreq}{cfreq} ifelse",CR,LF
 dc.b "  pangle 10000 lt {pangle}{cangle} ifelse",CR,LF
 dc.b "  /dproc load setscreen",CR,LF
 dc.b "  xsize 2 div neg ysize 2 div neg translate",CR,LF
 dc.b "  xsize ysize scale",CR,LF
 dc.b "  /picstr 1 string def",CR,LF
 dc.b CR,LF
 dc.b "  w h bpp [w 0 0 h neg 0 h] {currentfile picstr readhexstring pop} image",CR,LF
 dc.b "} bdef",CR,LF
 dc.b CR,LF
 dc.b "%",CR,LF
 dc.b "% pixelw pixelh bitsperpixel picx picy pfreq pangle PUTRGBPIC",CR,LF
 dc.b "%",CR,LF
 dc.b "/putrgbpic {",CR,LF
 dc.b "  /pangle xdef",CR,LF
 dc.b "  /pfreq xdef",CR,LF
 dc.b "  /ysize xdef",CR,LF
 dc.b "  /xsize xdef",CR,LF
 dc.b "  /bpp xdef",CR,LF
 dc.b "  /h xdef",CR,LF
 dc.b "  /w xdef",CR,LF
 dc.b CR,LF
 dc.b "  pfreq 10000 lt {pfreq}{cfreq} ifelse",CR,LF
 dc.b "  pangle 10000 lt {pangle}{cangle} ifelse",CR,LF
 dc.b "  /dproc load setscreen",CR,LF
 dc.b "  xsize 2 div neg ysize 2 div neg translate",CR,LF
 dc.b "  xsize ysize scale",CR,LF
 dc.b "  /picstr 1 string def",CR,LF
 dc.b CR,LF
 dc.b "  w h bpp [w 0 0 h neg 0 h]  {currentfile picstr readhexstring pop} false 3 colorimage",CR,LF
 dc.b "} bdef",CR,LF
 dc.b CR,LF
 dc.b "%",CR,LF
 dc.b "% newx newy origx origy llx lly urx ury BGNEPS",CR,LF
 dc.b "%",CR,LF
 dc.b "/bgneps {",CR,LF
 dc.b "  /ury xdef",CR,LF
 dc.b "  /urx xdef",CR,LF
 dc.b "  /lly xdef",CR,LF
 dc.b "  /llx xdef",CR,LF
 dc.b "  /origy xdef",CR,LF
 dc.b "  /origx xdef",CR,LF
 dc.b "  /newy xdef",CR,LF
 dc.b "  /newx xdef",CR,LF
 dc.b "  100 newx origx div mul 100 newy origy div mul scale",CR,LF
 dc.b "  urx llx add -2 div ury lly add -2 div translate",CR,LF
 dc.b "  /PgsEpsSave save def /showpage {} bdef",CR,LF
 dc.b "  llx lly moveto llx ury lineto urx ury lineto urx lly lineto clip",CR,LF
 dc.b "  newpath [] 0 setdash 1 setlinewidth 0 setgray",CR,LF
 dc.b "} bdef",CR,LF
 dc.b CR,LF
 dc.b "/endeps {PgsEpsSave restore} bdef",CR,LF
 dc.b CR,LF
 dc.b CR,LF
 dc.b "/doendstyle {",CR,LF
 dc.b "  scl /taily exch def /tailx exch def",CR,LF
 dc.b "  scl /tipy exch def /tipx exch def",CR,LF
 dc.b "  gsave newpath 1 eq",CR,LF
 dc.b "  {",CR,LF
 dc.b "    /halfhead currentlinewidth dup 125 gt {1.5}{2} ifelse mul def",CR,LF
 dc.b "    /headlength halfhead 5 mul def",CR,LF
 dc.b "    /dx tipx tailx sub def",CR,LF
 dc.b "    /dy tipy taily sub def",CR,LF
 dc.b "    /arrowlength dx dx mul dy dy mul add sqrt def",CR,LF
 dc.b "    /angle dy dx atan def",CR,LF
 dc.b "    /base arrowlength headlength sub def",CR,LF
 dc.b "    tailx taily translate",CR,LF
 dc.b "    angle rotate",CR,LF
 dc.b "    base halfhead neg moveto",CR,LF
 dc.b "    arrowlength 0 lineto",CR,LF
 dc.b "    base halfhead lineto",CR,LF
 dc.b "    closepath fill",CR,LF
 dc.b "    base 0 transform",CR,LF
 dc.b "  }",CR,LF
 dc.b "  {",CR,LF
 dc.b "    tipx tipy currentlinewidth 2 div 0 360 arc fill",CR,LF
 dc.b "    tipx tipy transform",CR,LF
 dc.b "  } ifelse",CR,LF
 dc.b "  grestore itransform} bdef",CR,LF
 dc.b "  /BS {doendstyle moveto} bdef",CR,LF
 dc.b "  /ES {doendstyle lineto MS} bdef",CR,LF
 dc.b CR,LF
 dc.b CR,LF
 dc.b "%",CR,LF
 dc.b "% font xpoint ypoint attribute SETFP",CR,LF
 dc.b "%",CR,LF
 dc.b "/sfpm [0 0 0 0 0 0] def",CR,LF
 dc.b "/setfp {",CR,LF
 dc.b "  /curattr xdef /curypoint xdef /curxpoint xdef /curfont xdef",CR,LF
; dc.b CR,LF
; dc.b "  curfont ==",CR,LF
 dc.b CR,LF
 dc.b "  sfpm 0 curxpoint put",CR,LF
 dc.b "  sfpm 3 curypoint put",CR,LF
 dc.b "  curfont findfont sfpm",CR,LF
 dc.b "  dup 2 0 put",CR,LF
 dc.b "  2 curattr and 0 ne {dup 2 curypoint 3 div put} if",CR,LF
 dc.b "  16 curattr and 0 ne {dup 2 curypoint 3 div neg put} if",CR,LF
 dc.b "  128 curattr and 0 ne {dup 0 curxpoint neg put} if",CR,LF
 dc.b "  256 curattr and 0 ne {dup 3 curypoint neg put} if",CR,LF
 dc.b "  makefont setfont",CR,LF
 dc.b "} bdef",CR,LF
 dc.b CR,LF
 dc.b "%",CR,LF
 dc.b "% cwidth A",CR,LF
 dc.b "%",CR,LF
 dc.b "/a {/cwidth xdef",CR,LF
 dc.b CR,LF
 dc.b "% reverse",CR,LF
 dc.b " 64 curattr and 0 ne",CR,LF
 dc.b "  {gsave 0 curypoint .75 mul rmoveto cwidth 0 rlineto",CR,LF
 dc.b "   0 curypoint neg rlineto cwidth neg 0 rlineto closepath fill grestore",CR,LF
 dc.b "   gsave 1 setgray } if",CR,LF
 dc.b CR,LF
 dc.b "% underline",CR,LF
 dc.b " 512 curattr and 0 ne",CR,LF
 dc.b "  {curypoint 40 div setlinewidth [] 0 setdash",CR,LF
 dc.b "   gsave 0 curypoint .05 mul neg rmoveto",CR,LF
 dc.b "   cwidth 0 rlineto stroke grestore} if",CR,LF
 dc.b CR,LF
 dc.b "% double underline",CR,LF
 dc.b " 4096 curattr and 0 ne",CR,LF
 dc.b "  {curypoint 40 div setlinewidth [] 0 setdash",CR,LF
 dc.b "   gsave 0 curypoint .05 mul neg rmoveto",CR,LF
 dc.b "   cwidth 0 rlineto stroke grestore",CR,LF
 dc.b "   gsave 0 curypoint .15 mul neg rmoveto",CR,LF
 dc.b "   cwidth 0 rlineto stroke grestore} if",CR,LF
 dc.b CR,LF
 dc.b "% strike through",CR,LF
 dc.b " 8192 curattr and 0 ne",CR,LF
 dc.b "  {curypoint 40 div setlinewidth [] 0 setdash",CR,LF
 dc.b "   gsave 0 curypoint .3 mul rmoveto",CR,LF
 dc.b "   cwidth 0 rlineto stroke grestore} if",CR,LF
 dc.b "%",CR,LF
 dc.b " 64 curattr and 0 ne",CR,LF
 dc.b "   {grestore} if",CR,LF
 dc.b CR,LF
 dc.b " } bdef",CR,LF
 dc.b CR,LF
 dc.b "%",CR,LF
 dc.b "% cwidth newx newy B",CR,LF
 dc.b "%",CR,LF
 dc.b "/b {newpath scl moveto a} bdef",CR,LF
 dc.b CR,LF
 dc.b "%",CR,LF
 dc.b "% cchar cwidth R",CR,LF
 dc.b "%",CR,LF
 dc.b "/r {/cwidth xdef /cchar xdef",CR,LF
 dc.b CR,LF
 dc.b "gsave",CR,LF
 dc.b CR,LF
 dc.b "curattr 0 eq {cchar show}",CR,LF
 dc.b "{",CR,LF
 dc.b "% reverse",CR,LF
 dc.b " 64 curattr and 0 ne",CR,LF
 dc.b "   {1 setgray} if",CR,LF
 dc.b CR,LF
 dc.b "% shadow",CR,LF
 dc.b " 4 curattr and 0 ne",CR,LF
 dc.b "  {curypoint 160 div setlinewidth [] 0 setdash",CR,LF
 dc.b "   32 curattr and 0 ne",CR,LF
 dc.b "  {64 curattr and 0 ne",CR,LF
 dc.b "   {gsave .5 setgray curxpoint 12 div curypoint 12 div neg rmoveto cchar show grestore",CR,LF
 dc.b "    gsave cchar show grestore}",CR,LF
 dc.b "   {gsave currentgray 1 add .5 mul setgray curxpoint 12 div curypoint 12 div neg rmoveto cchar show grestore",CR,LF
 dc.b "    gsave cchar show grestore} ifelse",CR,LF
 dc.b "   }",CR,LF
 dc.b CR,LF
 dc.b "  {64 curattr and 0 ne",CR,LF
 dc.b "   {gsave curxpoint 12 div curypoint 12 div neg rmoveto cchar show grestore",CR,LF
 dc.b "    gsave 0 setgray cchar show grestore",CR,LF
 dc.b "    gsave cchar true charpath stroke grestore}",CR,LF
 dc.b "   {gsave curxpoint 12 div curypoint 12 div neg rmoveto cchar show grestore",CR,LF
 dc.b "    gsave 1 setgray cchar show grestore",CR,LF
 dc.b "    gsave cchar true charpath stroke grestore} ifelse",CR,LF
 dc.b "   } ifelse",CR,LF
 dc.b "  } if",CR,LF
 dc.b CR,LF
 dc.b "% outline",CR,LF
 dc.b " 8 curattr and 0 ne",CR,LF
 dc.b "  {curypoint 160 div setlinewidth [] 0 setdash",CR,LF
 dc.b "   64 curattr and 0 eq {gsave 1 setgray cchar show grestore} if",CR,LF
 dc.b "   gsave cchar true charpath stroke grestore} if",CR,LF
 dc.b CR,LF
 dc.b "% light",CR,LF
 dc.b " 32 curattr and 0 ne",CR,LF
 dc.b "  {64 curattr and 0 ne {.5} {currentgray 1 add .5 mul} ifelse setgray} if",CR,LF
 dc.b CR,LF
 dc.b "% mirror",CR,LF
 dc.b " 128 curattr and 0 ne",CR,LF
 dc.b "  {cchar stringwidth pop neg 0 rmoveto} if",CR,LF
 dc.b CR,LF
 dc.b "% upside down",CR,LF
 dc.b " 256 curattr and 0 ne",CR,LF
 dc.b "  {0 curypoint .6 mul rmoveto} if",CR,LF
 dc.b CR,LF
 dc.b "%",CR,LF
 dc.b " curattr 12 and 0 eq",CR,LF
 dc.b "  { curattr 1 and 0 ne",CR,LF
 dc.b "    {curxpoint 48 div dup neg -10 exch",CR,LF
 dc.b "      {gsave 0 rmoveto cchar show grestore} for}",CR,LF
 dc.b "    {cchar show}ifelse",CR,LF
 dc.b "  }if",CR,LF
 dc.b "} ifelse",CR,LF
 dc.b CR,LF
 dc.b " grestore cwidth 0 rmoveto} bdef",CR,LF
 dc.b CR,LF
 dc.b "%",CR,LF
 dc.b "% cchar cwidth newx newy P",CR,LF
 dc.b "%",CR,LF
 dc.b "/p {newpath scl moveto r} bdef",CR,LF
 dc.b CR,LF
 dc.b "end",CR,LF
 dc.b "%%EndProlog",CR,LF
 dc.b CR,LF
 dc.b "AsphaltDict begin",CR,LF
 dc.b 0


;%%BeginDocument: Not Available
;%%EndDocument
;
;%%BeginFont: PostScript Downloaded FontName
;%%EndFont
;
;%%BeginProcessColor: Cyan
;%%EndProcessColor
;
;%%BeginCustomColor: EllenRed
;%%CMYKCustomColor: cyan magenta yellow black EllenRed
;%%EndCustomColor
;
;%%Page: label ordinal
;%%PageFonts:
;%%BeginPageSetup
;%%EndPageSetup
;
;%%BeginObject:
;%%EndObject
;
;%%PageTrailer
;
;%%Trailer
;%followed by the clean-up code

dmfstr1:
 dc.b "% COPYRIGHT 1988-1990",CR,LF
 dc.b "% Soft-Logik Publishing Corp",CR,LF
 dc.b "%  11131 F South Towne Sq.",CR,LF
 dc.b "%  St. Louis  MO  63123",CR,LF
 dc.b "%  (314) 894-8608",CR,LF
 dc.b "% No Reproduction, In Whole Or Part, Without Permission.",CR,LF
 dc.b CR,LF
 dc.b "/BuildCharDict 20 dict def",CR,LF
 dc.b "/KazFont 14 dict def",CR,LF
 dc.b "KazFont begin",CR,LF
 dc.b "/WidthFactor 1.0 def",CR,LF
 dc.b "/FontType 3 def",CR,LF
 dc.b "/FontMatrix [.001 0 0 .001 0 0] def",CR,LF
 dc.b "/FontBBox [-75 -200 1238 800] def",CR,LF
 dc.b "/Mx 256 array def",CR,LF
 dc.b "0 1 255 {Mx exch 0 put} for",CR,LF
 dc.b "/Encoding 256 array def",CR,LF
 dc.b "0 1 255 {Encoding exch /.notdef put} for",CR,LF
 dc.b "/CharacterDefs 257 dict def",CR,LF
 dc.b "CharacterDefs /.notdef {} put",CR,LF
 dc.b 0


dmfstr2:	dc.b	"Mx ",0
dmfstr3:	dc.b	"put",CR,LF,0
dmfstr4:	dc.b	"Encoding ",0
dmfstr5:	dc.b	"CharacterDefs /",0
dmfstr6:	dc.b	CR,LF,"{ ",0
dmfstr7:	dc.b	"} put",CR,LF,0
dmfnp:	dc.b	"n",CR,LF,0
dmfcp:	dc.b	"e",CR,LF,0
dmffp:	dc.b	"f",CR,LF,0
dmfsp:	dc.b	"s",CR,LF,0
dmfmt:	dc.b	"m",CR,LF,0
dmflt:	dc.b	"l",CR,LF,0
dmfct:	dc.b	"c",CR,LF,0
dmfa:	dc.b	"a",CR,LF,0
dmfan:	dc.b	"an",CR,LF,0

dmfstr8:
 dc.b "/BuildChar",CR,LF
 dc.b "{BuildCharDict begin",CR,LF
 dc.b "/char exch def",CR,LF
 dc.b "/fontdict exch def",CR,LF
 dc.b "/width fontdict /Mx get char get def",CR,LF
 dc.b "/charname fontdict /Encoding get char get def",CR,LF
 dc.b "/charproc fontdict /CharacterDefs get charname get def",CR,LF
 dc.b CR,LF
 dc.b "width 0 0 -200 1333 800 setcachedevice",CR,LF
 dc.b CR,LF
 dc.b "gsave",CR,LF
 dc.b "/f {eofill} def",CR,LF
 dc.b "/s {stroke} def",CR,LF
 dc.b "/n {newpath} def",CR,LF
 dc.b "/e {closepath} def",CR,LF
 dc.b "/m {transform round exch round exch itransform moveto} def",CR,LF
 dc.b "/l {transform round exch round exch itransform lineto} def",CR,LF
 dc.b "/c {transform round exch round exch itransform 6 2 roll",CR,LF
 dc.b "transform round exch round exch itransform 6 2 roll",CR,LF
 dc.b "transform round exch round exch itransform 6 2 roll",CR,LF
 dc.b "curveto} def",CR,LF
 dc.b "/a {arc} def",CR,LF
 dc.b "/an {arcn} def",CR,LF
 dc.b "0 setlinecap 0 setlinejoin 48 setlinewidth .5 setflat charproc",CR,LF
 dc.b "grestore",CR,LF
 dc.b "end",CR,LF
 dc.b "} def",CR,LF
 dc.b "end",CR,LF,CR,LF,"/"
 dc.b 0

dmfstr9:
 dc.b " KazFont definefont pop",CR,LF
 dc.b 0


t1index:
	dc.b	$00,$01,$02,$03,$04,$05,$06,$07
	dc.b	$08,$09,$0a,$0b,$0c,$0d,$0e,$0f
	dc.b	$10,$11,$12,$13,$14,$15,$16,$17
	dc.b	$18,$19,$1a,$1b,$1c,$1d,$1e,$1f
	dc.b	$20,$21,$22,$23,$24,$25,$26,$27
	dc.b	$28,$29,$2a,$2b,$2c,$2d,$2e,$2f
	dc.b	$30,$31,$32,$33,$34,$35,$36,$37
	dc.b	$38,$39,$3a,$3b,$3c,$3d,$3e,$3f
	dc.b	$40,$41,$42,$43,$44,$45,$46,$47
	dc.b	$48,$49,$4a,$4b,$4c,$4d,$4e,$4f
	dc.b	$50,$51,$52,$53,$54,$55,$56,$57
	dc.b	$58,$59,$5a,$5b,$5c,$5d,$5e,$5f
	dc.b	$60,$61,$62,$63,$64,$65,$66,$67
	dc.b	$68,$69,$6a,$6b,$6c,$6d,$6e,$6f
	dc.b	$70,$71,$72,$73,$74,$75,$76,$77
	dc.b	$78,$79,$7a,$7b,$7c,$7d,$7e,$7f
	dc.b	$80,$81,$82,$83,$84,$85,$86,$87
	dc.b	$88,$89,$8a,$8b,$8c,$8d,$8e,$8f
	dc.b	$90,$91,$92,$93,$94,$95,$96,$97
	dc.b	$98,$99,$9a,$9b,$9c,$9d,$9e,$9f
	dc.b	$a0,$a1,$a2,$a3,$a4,$a5,$a6,$a7
	dc.b	$a8,$aa,$ba,$ab,$b7,$b1,$d0,$bc
	dc.b	$b0,$b1,$b2,$b3,$b4,$b5,$b6,$b7
	dc.b	$b8,$b9,$ba,$bb,$bc,$bd,$be,$bf
	dc.b	$c0,$c1,$c2,$c3,$c4,$c5,$c6,$c7
	dc.b	$c8,$c9,$ca,$cb,$cc,$cd,$ce,$cf
	dc.b	$d0,$d1,$d2,$d3,$d4,$d5,$d6,$d7
	dc.b	$d8,$d9,$da,$db,$dc,$dd,$de,$df
	dc.b	$e0,$e1,$e2,$e3,$e4,$e5,$e6,$e7
	dc.b	$e8,$e9,$ea,$eb,$ec,$ed,$ee,$ef
	dc.b	$f0,$f1,$f2,$f3,$f4,$f5,$f6,$f7
	dc.b	$f8,$f9,$fa,$fb,$fc,$fd,$fe,$ff

*
*
hex:		dc.b	"0123456789ABCDEF"

austr:		dc.b	"auto-unload",0
pustr:		dc.b	"page-unload",0
freqstr:	dc.b	"f[",0
anglestr:	dc.b	"a[",0
clrstr:		dc.b	"color",0
bldstr:		dc.b	"bleed[",0


cyanplate:	dc.b	"%%CyanPlate: ",0
magentaplate:	dc.b	"%%MagentaPlate: ",0
yellowplate:	dc.b	"%%YellowPlate: ",0
blackplate:	dc.b	"%%BlackPlate: ",0
includestr:	dc.b	"%%IncludeFile: ",QUOTE,0

driver:		dc.b	"PostScript v2.1.13",0

 SECTION printer,BSS,PUBLIC
array:		ds.w	20
table:		ds.l	1
yinvert:	ds.l	1
v_base:		ds.l	1
w:		ds.w	1
h:	 	ds.w	1
pwidth:		ds.l	1
plane:		ds.l	1
bitpln:		ds.w	1
palptr:		ds.l	1
picptr:		ds.l	1
pixel:		ds.w	1
pmode:		ds.w	1
pptr:		ds.l	1
count:		ds.w	1
attribute:	ds.l	1
curfmetric:	ds.l	1
curfont:	ds.l	1
curftype:	ds.w	1
curfmtype:	ds.w	1
fontlist:	ds.l	1
fontoff:	ds.l	1
curpsxdpi:	ds.w	1
curpsydpi:	ds.w	1
curpsxpoint:	ds.w	1
curpsypoint:	ds.w	1

f_hndl:		ds.w	1
pattr:		ds.l	1
cyan:		ds.w	1
magenta:	ds.w	1
yellow:		ds.w	1
black:		ds.w	1
p_cyan:		ds.w	1
p_magenta:	ds.w	1
p_yellow:	ds.w	1
p_black:	ds.w	1
cintensity:	ds.w	1
*
cx:		ds.l	1
cy:		ds.l	1
pcx:		ds.l	1
pcy:		ds.l	1
char:		ds.b	1
pchar:		ds.b	1
*
compress:	ds.b	256
packptr:	ds.l	1
packlen:	ds.w	1
packbyte:	ds.w	1
packcount:	ds.w	1
*
curx:		ds.l	1
cury:		ds.l	1

bpp:		ds.w	1
bcnt:		ds.w	1
bdata:		ds.w	1

linestyle:	ds.w	1
linewidth:	ds.w	1
fillstyle:	ds.w	1
bgnstyle:	ds.b	1
endstyle:	ds.b	1
bflag:		ds.b	1
eflag:		ds.b	1
downflag:	ds.b	1
auto_unload:	ds.b	1
colorprt:	ds.b	1
		ds.b	1
downoff:	ds.l	1
bx1:		ds.l	1
by1:		ds.l	1
bx2:		ds.l	1
by2:		ds.l	1
ex1:		ds.l	1
ey1:		ds.l	1
ex2:		ds.l	1
ey2:		ds.l	1

mfreq:		ds.l	10
mangle:		ds.l	10
macount:	ds.w	1
mfcount:	ds.w	1
mfcur:		ds.w	1
macur:		ds.w	1
mfpage:		ds.l	1
mapage:		ds.l	1

char_cx:	ds.w	1
char_cy:	ds.w	1
charpath:	ds.l	1
endp:		ds.l	1
crlfcnt:	ds.w	1
bleedv:		ds.l	1
bleedh:		ds.l	1


; 2.1.12 - fixed problem with EPS files
; 2.1.13 - fixed crop&regmark bleed standoff
