.macro CODE
	.text
.endm

.macro SECTION name,type,model
	\type
.endm


*
pdrvrnm		equ	0
device		equ	pdrvrnm+4	;who to send to
pdl		equ	device+2	;does it drive a page description language
ptype		equ	pdl+1		;type of output device (b/w, color,etc..)
pman		equ	ptype+1		;can it print manual feed?
pmanual		equ	pman+1		;print manual feed
pmult		equ	pmanual+1	;can it automatically print mulitiple copies?
unused1		equ	pmult+1		;unused byte

pcopies		equ	unused1+1	;number of copies to print
pxdpi		equ	pcopies+2	;x resolution
pydpi		equ	pxdpi+2		;y resolution
pxover		equ	pydpi+2		;percentage of x overlap of dots
pyover		equ	pxover+2	;percentage of y overlap of dots
pminlft		equ	pyover+2	;pixels from left edge to start printing
pminrht		equ	pminlft+2
pmintop		equ	pminrht+2		;pixels from top to start printing
pminbot		equ	pmintop+2	;pixels from bottom to end printing
pmaxw		equ	pminbot+2	;maximum # pixels across
pmaxh		equ	pmaxw+4		;maximum # pixels down
prowht		equ	pmaxh+4		;smallest height of print head
pdensity	equ	prowht+2	;print density
sendout		equ	pdensity+2	;ptr to routine to send a byte in d0

pblockx		equ	sendout+4	;x offset to print block at
pblocky		equ	pblockx+4	;y offset to print block at
pblockw		equ	pblocky+4	;width in bytes of block to print
pblockh		equ	pblockw+4	;height of block to print
pblockptr	equ	pblockh+4	;handle to block to print
pblockoff	equ	pblockptr+4
pblockplane	equ	pblockoff+4



*
* printer type's are
*
PRT_PALET	equ	0	;N/A		;RGB pallet only!
PRT_BW		equ	1	;implemented
PRT_RGB		equ	2	;N/A
PRT_RGBW	equ	3	;N/A
PRT_CMY		equ	4	;implemented
PRT_CMYK	equ	5	;implemented

* for special devices
PRT		equ	1

* for normal devices
PARALLEL	equ	1
SERIAL		equ	2
DISK		equ	4

* for both
ASCENDING	equ	16
DESCENDING	equ	32
COLLATE		equ	256
