.macro CODE
	.text
.endm

.macro SECTION name,type,model
	\type
.endm


*
pdrvrnm		equ	0
device		equ	pdrvrnm+4	;who to send to
pdl		equ	device+2	;does it drive a page description language
ptype		equ	pdl+1		;type of output device (b/w, color,etc..)
pman		equ	ptype+1		;can it print manual feed?
pmanual		equ	pman+1		;print manual feed
pmult		equ	pmanual+1	;can it automatically print mulitiple copies?
unused1		equ	pmult+1		;unused byte

pcopies		equ	unused1+1	;number of copies to print
pxdpi		equ	pcopies+2	;x resolution
pydpi		equ	pxdpi+2		;y resolution
pxover		equ	pydpi+2		;percentage of x overlap of dots
pyover		equ	pxover+2	;percentage of y overlap of dots
pminlft		equ	pyover+2	;pixels from left edge to start printing
pminrht		equ	pminlft+2
pmintop		equ	pminrht+2		;pixels from top to start printing
pminbot		equ	pmintop+2	;pixels from bottom to end printing
pmaxw		equ	pminbot+2	;maximum # pixels across
pmaxh		equ	pmaxw+4		;maximum # pixels down
prowht		equ	pmaxh+4		;smallest height of print head
pdensity	equ	prowht+2	;print density
sendout		equ	pdensity+2	;ptr to routine to send a byte in d0

pblockx		equ	sendout+4	;x offset to print block at
pblocky		equ	pblockx+4	;y offset to print block at
pblockw		equ	pblocky+4	;width in bytes of block to print
pblockh		equ	pblockw+4	;height of block to print
pblockptr	equ	pblockh+4	;handle to block to print
pblockoff	equ	pblockptr+4
pblockplane	equ	pblockoff+4

*
* these are used for postscript and other special drivers
*  (don't use them if you don't have to!)
ptile		equ	pblockplane+4	;print tiles
prvrs		equ	ptile+1		;print reversed (write white)
pmirror		equ	prvrs+1		;print mirrored (transparency)
pland		equ	pmirror+1	;print landscape
pcrop		equ	pland+1		;print cropmarks
unused2		equ	pcrop+1		;unused byte

pfont		equ	unused2+1	;type of fonts I understand
pscale		equ	pfont+2		;scale factor in use
psepmode	equ	pscale+2	;0-no sep, 1-color sep, 2-mech sep
pcyan		equ	psepmode+2	;(5 words) color to print (mech/color sep)
pmagenta	equ	pcyan+2
pyellow		equ	pmagenta+2
pblack		equ	pyellow+2
pcolor		equ	pblack+2
*
VPaperW		equ	pcolor+2
VPaperH		equ	VPaperW+4
PPaperW		equ	VPaperH+4
PPaperH		equ	PPaperW+4
*
VDocumentW	equ	PPaperH+4	;total width to be printed
VDocumentH	equ	VDocumentW+4	;total height to be printed
PDocumentW	equ	VDocumentH+4	;total width to be printed
PDocumentH	equ	PDocumentW+4	;total height to be printed
*
PPageLeft	equ	PDocumentH+4	;current left
PPageTop	equ	PPageLeft+4	;current top
PPageWidth	equ	PPageTop+4	;current width
PPageHeight	equ	PPageWidth+4	;current height
*
PBlockLeft	equ	PPageHeight+4
PBlockRight	equ	PBlockLeft+4
PBlockTop	equ	PBlockRight+4
PBlockBottom	equ	PBlockTop+4
PBlockWidth	equ	PBlockBottom+4
PBlockHeight	equ	PBlockWidth+4
*
VLeft		equ	PBlockHeight+4
VTop		equ	VLeft+4
PLeft		equ	VTop+4
PTop		equ	PLeft+4
*
blocks		equ	PTop+4
blkcnt		equ	blocks+2
tilex		equ	blkcnt+2
tiley		equ	tilex+2
*
fillpat		equ	tiley+2		;ptr to fill patterns
linepat		equ	fillpat+4	;ptr to fill patterns
prtspcl		equ	linepat+4	;ptr to special string
openfnt		equ	prtspcl+4	;ptr to open font file routine
readfnt		equ	openfnt+4	;ptr to read font. Returns d0 (length), a0 (ptr)
fmlist		equ	readfnt+4	;ptr to font metrics list
fmcnt		equ	fmlist+4
fmoff		equ	fmcnt+4
curfm		equ	fmoff+4
ftlist		equ	curfm+4
ftcnt		equ	ftlist+4
ftoff		equ	ftcnt+4
curft		equ	ftoff+4
textattr	equ	curft+4		;ptr to text attributes
msgport		equ	textattr+4
createport	equ	msgport+4
closeport	equ	createport+4
printstat	equ	closeport+4

m_alloc		equ	printstat+4
m_realloc	equ	m_alloc+4
m_grow		equ	m_realloc+4
m_shrink	equ	m_grow+4
m_delete	equ	m_shrink+4

mulu1632	equ	m_delete+4
mulu3232	equ	mulu1632+4
divu1648	equ	mulu3232+4
divu3248	equ	divu1648+4
divu3264	equ	divu3248+4

muls1632	equ	divu3264+4
muls3232	equ	muls1632+4
divs1648	equ	muls3232+4
divs3248	equ	divs1648+4
divs3264	equ	divs3248+4

pfseek		equ	divs3264+4
fopenr		equ	pfseek+4
fopenw		equ	fopenr+4
fclose		equ	fopenw+4
fread		equ	fclose+4
fwrite		equ	fread+4
fsize		equ	fwrite+4
fseek		equ	fsize+4
setpath		equ	fseek+4
ppppath		equ	setpath+4
prtnpath	equ	ppppath+4

pagetitle	equ	prtnpath+4	;string for title to current page


font	equ	0
attr	equ	4
xpoint	equ	8
ypoint	equ	12


*
* printer type's are
*
PRT_PALET	equ	0	;N/A		;RGB pallet only!
PRT_BW		equ	1	;implemented
PRT_RGB		equ	2	;N/A
PRT_RGBW	equ	3	;N/A
PRT_CMY		equ	4	;implemented
PRT_CMYK	equ	5	;implemented

* for special devices
PRT		equ	1

* for normal devices
PARALLEL	equ	1
SERIAL		equ	2
DISK		equ	4

* for both
ASCENDING	equ	16
DESCENDING	equ	32
COLLATE		equ	256
