 include "prtequ.h"

*
* Okidate Microline 182 print driver
*
CR	equ	$d
LF	equ	$a
FF	equ	$c
ESC	equ	$1b
FS	equ	$1c

 SECTION printer,CODE,PUBLIC
***************************************************************
***************************************************************
***************************************************************
dumbentry:
	clr.l	d0
	rts

	dc.l	"PRNT"
	dc.w	200

*
* distribute the calls to the appropriate routines
*
oki182:	move.l	a0,table
	lsl.w	#2,d0
	lea	prntbl,a1
	move.l	0(a1,d0.w),a1
	jmp	(a1)

*
* identify who I am, and set up who I like to speak to.
*
p_ident:
	move.l	#driver,pdrvrnm(a0)	;pointer to string for driver name
	move.w	#PARALLEL+ASCENDING,device(a0)
prtok:	moveq	#1,d0
	rts

*
* initialize the table of printer specific routines
*
p_init:	clr.b	pdl(a0)			;no page description language
	clr.b	pmult(a0)		;automatically print mulitiple copies?
	clr.b	pman(a0)		;handle manual feed?
	move.b	#PRT_BW,ptype(a0)	;printer type?
	move.l	sendout(a0),send+2	;self-modifing code, tisk, tisk!

*
* pminlft and pmaxw must be evenly divisible by 16
* this is the part that should be worked out
*

	move.w	pdensity(a0),d0
	cmp.w	#7,d0
	bcs	pint1
	moveq	#6,d0
pint1:	lsl.w	#1,d0

	lea	xdpi_tbl,a1
	move.w	0(a1,d0.w),pxdpi(a0)	;x resolution
	lea	ydpi_tbl,a1
	move.w	0(a1,d0.w),pydpi(a0)	;y resolution
	lea	minl_tbl,a1
	move.w	0(a1,d0.w),pminlft(a0)	;pixels from the left
	lea	minr_tbl,a1
	move.w	0(a1,d0.w),pminrht(a0)	;pixels from the right
	lea	mint_tbl,a1
	move.w	0(a1,d0.w),pmintop(a0)	;pixels down from top
	lea	minb_tbl,a1
	move.w	0(a1,d0.w),pminbot(a0)	;pixels up from bottom
	lea	xover_tbl,a1
	move.w	0(a1,d0.w),pxover(a0)	;percentage of x overlap of dots
	lea	yover_tbl,a1
	move.w	0(a1,d0.w),pyover(a0)	;percentage of y overlap of dots
	lea	rowht_tbl,a1
	move.w	0(a1,d0.w),prowht(a0)	;rows height modula

	move.w	0(a1,d0.w),rowht
	lea	rows_tbl,a1
	move.w	0(a1,d0.w),rows
	lea	grmode_tbl,a1
	move.w	0(a1,d0.w),grmode

	lsl.w	#1,d0
	lea	maxw_tbl,a1
	move.w	0(a1,d0.w),pmaxw(a0)	;maximum # pixels across
	lea	maxh_tbl,a1
	move.w	0(a1,d0.w),pmaxh(a0)	;maximum # pixels down

	bra	prtok

*
* going to begin printing a document
*
p_bgndoc:
	move.b	#ESC,d0
	bsr	send
	move.b	#"-",d0
	bsr	send
	move.b	#FS,d0
	bra	send

*
* about to start printing of a page
*
p_bgnpage:
	bra	prtok

*
* about to print a new tile for the page
*
p_bgntile:
	bra	prtok

*
* print a block to the printer
*
p_block:
	move.l	table,a0
	move.l	pblockw(a0),d0
	move.w	d0,width
	move.l	pblockptr(a0),a1
	move.l	(a1),a1
	add.l	pblockoff(a0),a1
	move.l	a1,v_base
*
*
	move.w	rows,count
pblck2:	move.l	v_base,lineptr
	bsr	putline
	moveq	#0,d0
	move.w	width,d0
	add.l	d0,v_base
	subq.w	#1,count
	bne	pblck2
*
	move.b	#ESC,d0
	bsr	send
	move.b	#"%",d0
	bsr	send
	move.b	#"9",d0
	bsr	send
	move.w	#14,d0
	sub.w	rows,d0
	bsr	send
	move.b	#CR,d0
	bsr	send
	move.b	#LF,d0
	bra	send

**************************************

putline:
	move.l	lineptr,a0
	move.w	#0,twidth
	move.w	#6,d1
print0:	move.w	width,d0
print1:	tst.b	-1(a0,d0.w)
	bne	print2
	subq.w	#1,d0
	bne	print1
print2:	cmp.w	twidth,d0
	blt	print3
	move.w	d0,twidth
print3:	move.w	rows,d3
pri1:	add.w	width,a0
	sub.w	#1,d3
	bgt	pri1
	dbf	d1,print0
*
	tst.w	twidth
	beq	endline

	move.w	grmode,d0
	bsr	send
	move.b	#3,d0
	bsr	send

	move.w	twidth,d2                 ;length of the data in byte
print4:	move.w	d2,-(sp)
	moveq	#7,d4
print6:	move.w	d4,pixel
	moveq	#0,d1
	moveq	#0,d0
	move.l	lineptr,a0
s1:	btst	d4,(a0)
	beq 	s2
	bset	d1,d0
s2:
	move.w	rows,d3
pri2:	add.w	width,a0
	sub.w	#1,d3
	bgt	pri2

	addq.w	#1,d1
	cmp.w	#7,d1
	bcs	s1

	cmp.b	#3,d0
	bne	.1
	bsr	send
	move.b	#3,d0
.1:	bsr	send
*
	move.w	pixel,d4
	dbf	d4,print6

	add.l	#1,lineptr
	move.w	(sp)+,d2
	subq.w	#1,d2
	bgt	print4

	move.b	#3,d0
	bsr	send
	move.b	#2,d0
	bsr	send

endline:
	move.b	#ESC,d0
	bsr	send
	move.b	#"%",d0
	bsr	send
	move.b	#"9",d0
	bsr	send
	move.b	#1,d0
	bsr	send
	move.b	#CR,d0
	bsr	send
	move.b	#LF,d0
	bra	send

************************************
*
* just finished describing current tile
*
p_endtile:
	move.l	table,a0
	move.l	pblockh(a0),d0
	mulu	#144,d0
	divu	pydpi(a0),d0
	move.w	d0,scroll
pend1:	tst.b	scroll
	beq	pend2
	move.b	#ESC,d0
	bsr	send
	move.b	#"%",d0
	bsr	send
	move.b	#"9",d0
	bsr	send
	move.b	#255,d0
	bsr	send
	sub.w	#255,scroll
	bra	pend1
pend2:	tst.w	scroll
	beq	prtok
	move.b	#ESC,d0
	bsr	send
	move.b	#"%",d0
	bsr	send
	move.b	#"9",d0
	bsr	send
	move.w	scroll,d0
	bra	send
	
*
* just finished describing all tiles for this page
*
p_endpage:
	bra	prtok

*
* finished printing the document
*
p_enddoc:
	bra	prtok

*
* user requested stop
*
p_break:
	bra	p_endtile

***************************************************
***	these are the send routines for the	***
***	dot matrix driver.			***
***************************************************
sendline:
	move.b	(a0)+,d0
	beq	prtok
	move.l	a0,-(sp)
	bsr	send
	move.l	(sp)+,a0
	bra	sendline

send:	jmp	$ffffff

***********************************
***				***
***********************************
 SECTION printer,DATA,PUBLIC

prntbl:	dc.l	prtok,prtok,prtok,prtok,p_init
	dc.l	p_bgndoc,p_bgnpage,p_bgntile
	dc.l	p_block
	dc.l	p_endtile,p_endpage,p_enddoc
	dc.l	p_break,p_ident


xdpi_tbl:	dc.w	60,60,72,72,103,103,103
ydpi_tbl:	dc.w	72,144,72,144,72,144,144
minl_tbl:	dc.w	15,15,18,18,25,25,25
minr_tbl:	dc.w	15,15,18,18,25,25,25
mint_tbl:	dc.w	0,0,0,0,0,0,0
minb_tbl:	dc.w	0,0,0,0,0,0,0
maxw_tbl:	dc.l	480,480,576,576,824,824,824
maxh_tbl:	dc.l	0,0,0,0,0,0,0
xover_tbl:	dc.w	0,0,20,20,40,40,40
yover_tbl:	dc.w	0,50,0,50,0,50,50
rowht_tbl:	dc.w	7,14,7,14,7,14,14
rows_tbl:	dc.w	1,2,1,2,1,2,2
grmode_tbl:	dc.w	$1e,$1e,$1c,$1c,$1d,$1d,$1d


driver:		dc.b	"Okidate ML-84 v2.0 beta",0

 SECTION printer,BSS,PUBLIC
table:		ds.l	1
twidth:		ds.w	1
pixel:		ds.w	1
v_base:		ds.l	1
lineptr:	ds.l	1
width:		ds.w	1
count:		ds.w	1
grmode:		ds.w	1
rows:		ds.w	1
rowht:		ds.w	1
scroll:		ds.w	1
