 include "prtequ.h"

*
* Sharp JX-730 color print driver
*
CR	equ	$d
LF	equ	$a
FF	equ	$c
ESC	equ	$1b

 SECTION printer,CODE,PUBLIC
***************************************************************
***************************************************************
***************************************************************
dumbentry:
	clr.l	d0
	rts

	dc.l	"PRNT"
	dc.w	200

*
* distribute the calls to the appropriate routines
*
jx730:	move.l	a0,table
	lsl.w	#2,d0
	lea	prntbl,a1
	move.l	0(a1,d0.w),a1
	jmp	(a1)

*
* identify who I am, and set up who I like to speak to.
*
p_ident:
	move.l	#driver,pdrvrnm(a0)	;pointer to string for driver name
	move.w	#PARALLEL+ASCENDING,device(a0)
prtok:	moveq	#1,d0
	rts

*
* initialize the table of printer specific routines
*
p_init:
	clr.b	pdl(a0)			;no page description language
	clr.b	pmult(a0)		;automatically print mulitiple copies?
	clr.b	pman(a0)		;handle manual feed?
	move.b	#PRT_CMYK,ptype(a0)	;printer type?

	move.l	sendout(a0),send+2	;self-modifing code, tisk, tisk!

*
*

	move.w	pdensity(a0),d0
	cmp.w	#7,d0
	bcs	pint1
	moveq	#6,d0
pint1:	lsl.w	#1,d0

	lea	xdpi_tbl,a1
	move.w	0(a1,d0.w),pxdpi(a0)	;x resolution
	lea	ydpi_tbl,a1
	move.w	0(a1,d0.w),pydpi(a0)	;y resolution
	lea	minl_tbl,a1
	move.w	0(a1,d0.w),pminlft(a0)	;pixels from the left
	lea	minr_tbl,a1
	move.w	0(a1,d0.w),pminrht(a0)	;pixels from the right
	lea	mint_tbl,a1
	move.w	0(a1,d0.w),pmintop(a0)	;pixels down from top
	lea	minb_tbl,a1
	move.w	0(a1,d0.w),pminbot(a0)	;pixels up from bottom
	lea	xover_tbl,a1
	move.w	0(a1,d0.w),pxover(a0)	;percentage of x overlap of dots
	lea	yover_tbl,a1
	move.w	0(a1,d0.w),pyover(a0)	;percentage of y overlap of dots
	lea	rowht_tbl,a1
	move.w	0(a1,d0.w),prowht(a0)	;rows height modula

	lsl.w	#1,d0
	lea	maxw_tbl,a1
	move.l	0(a1,d0.w),pmaxw(a0)	;maximum # pixels across
	lea	maxh_tbl,a1
	move.l	0(a1,d0.w),pmaxh(a0)	;maximum # pixels down
	bra	prtok

*
* going to begin printing a document
*
p_bgndoc:
	bra	prtok

*
* about to start printing of a page
*
p_bgnpage:
	bra	prtok

*
* about to print a new tile for the page
*
p_bgntile:
	bra	prtok

*
* print a block to the printer
*
p_block:
	move.l	table,a0
	move.l	pblockplane(a0),pplane
 	move.l	pblockw(a0),d0
	move.w	d0,width
	move.l	pblockptr(a0),a1
	move.l	(a1),a1
	add.l	pblockoff(a0),a1
	move.l	a1,v_base
*
*
	move.l	v_base,lineptr		;cyan
	move.b	#$3c,gcolor
	bsr	putline

	move.l	v_base,lineptr		;magenta
	move.l	pplane,d0
	add.l	d0,lineptr
	move.b	#$34,gcolor
	bsr	putline

	move.l	v_base,lineptr		;yellow
	move.l	pplane,d0
	lsl.l	#1,d0
	add.l	d0,lineptr
	move.b	#$38,gcolor
	bsr	putline

	move.l	v_base,lineptr		;black
	move.l	pplane,d0
	lsl.l	#1,d0
	add.l	pplane,d0
	add.l	d0,lineptr
	move.b	#$30,gcolor
	bsr	putline

*
	move.b	#ESC,d0
	bsr	send
	move.b	#"A",d0
	bra	send

**************************************

putline:
	move.l	lineptr,a0
	move.w	#0,twidth
	move.w	#3,d1
.0:	move.w	width,d0
.1:	tst.b	-1(a0,d0.w)
	bne	.2
	subq.w	#1,d0
	bne	.1
.2:	cmp.w	twidth,d0
	blt	.3
	move.w	d0,twidth
.3:	add.w	width,a0
	dbf	d1,.0
*
	tst.w	twidth
	beq	prtok

	move.w	#4,count
print1:	move.b	#ESC,d0
	bsr	send
	move.b	#"I",d0
	bsr	send
	move.b	gcolor,d0
	bsr	send
	add.b	#1,gcolor

	moveq	#0,d0
	move.w	twidth,d0		;send number of graphic bytes to follow
	divu	#100,d0
	or.b	#"0",d0
	move.l	d0,-(sp)
	bsr	send
	move.l	(sp)+,d0
	eor.w	d0,d0
	swap	d0
	divu	#10,d0
	or.b	#"0",d0
	move.l	d0,-(sp)
	bsr	send
	move.l	(sp)+,d0
	swap	d0
	or.b	#"0",d0
	bsr	send

print2:	move.w	twidth,d7                 ;length of the data in byte
	move.l	lineptr,a0
print4:	move.b	(a0)+,d0
	move.w	d7,-(sp)
	move.l	a0,-(sp)
	bsr	send
	move.l	(sp)+,a0
	move.w	(sp)+,d7
	subq.w	#1,d7
	bgt	print4

	moveq	#0,d0
	move.w	width,d0
	add.l	d0,lineptr

	subq.w	#1,count
	bne	print1
	bra	prtok


************************************
*
* just finished describing current tile
*
p_endtile:
	bra	prtok

*
* just finished describing all tiles for this page
*
p_endpage:
	bra	prtok

*
* finished printing the document
*
p_enddoc:
	bra	prtok

***************************************************
***	these are the send routines for the	***
***	dot matrix driver.			***
***************************************************
sendline:
	move.b	(a0)+,d0
	beq	prtok
	move.l	a0,-(sp)
	bsr	send
	move.l	(sp)+,a0
	bra	sendline

send:	jmp	$ffffff


***********************************
***				***
***********************************
 SECTION printer,DATA,PUBLIC

prntbl:	dc.l	prtok,prtok,prtok,prtok,p_init
	dc.l	p_bgndoc,p_bgnpage,p_bgntile
	dc.l	p_block
	dc.l	p_endtile,p_endpage,p_enddoc
	dc.l	prtok,p_ident


xdpi_tbl:	dc.w	180,180,180,180,180,180,180
ydpi_tbl:	dc.w	180,180,180,180,180,180,180
minl_tbl:	dc.w	30,30,30,30,30,30,30
minr_tbl:	dc.w	30,30,30,30,30,30,30
mint_tbl:	dc.w	0,0,0,0,0,0,0
minb_tbl:	dc.w	0,0,0,0,0,0,0
maxw_tbl:	dc.l	2448,2448,2448,2448,2448,2448,2448
maxh_tbl:	dc.l	0,0,0,0,0,0,0
xover_tbl:	dc.w	0,0,0,0,0,0,0
yover_tbl:	dc.w	0,0,0,0,0,0,0
rowht_tbl:	dc.w	4,4,4,4,4,4,4


driver:		dc.b	"Sharp JX-730 v2.0.1",0

 SECTION printer,BSS,PUBLIC
table:		ds.l	1
twidth:		ds.w	1
pixel:		ds.w	1
v_base:		ds.l	1
lineptr:	ds.l	1
width:		ds.w	1
pplane:		ds.l	1
count:		ds.w	1
loop:		ds.w	1
gcolor:		ds.w	1
