 include "pdlequ.h"
 
***************************
*   IMG File printer      *
***************************


 SECTION printer,CODE,PUBLIC
************************************

dumbentry:
	clr.l	d0
	rts

	dc.l	"PRNT"
	dc.w	200



****************************************************
* distribute the calls to the appropriate routines *
****************************************************
fx80:	move.l	a0,table
	lsl.w	#2,d0
	lea	prntbl,a1
	move.l	0(a1,d0.w),a1
	jmp	(a1)


*********************************************************
* identify who I am, and set up who I like to speak to. *
*********************************************************
p_ident:
	move.l	#driver,pdrvrnm(a0)	;pointer to string for driver name
	move.w	#DISK+ASCENDING,device(a0)
prtok:	moveq	#1,d0
	rts


******************************************************
* initialize the table of printer specific routines  *
******************************************************
p_init:	clr.b	pdl(a0)			;no page description language
	clr.b	pmult(a0)		;automatically print mulitiple copies?
	clr.b	pman(a0)		;handle manual feed?
	move.b	#PRT_BW,ptype(a0)	;b&w file only

        move.l	sendout(a0),send+2	;self-modifing code, tisk, tisk!

*
* pminlft and pmaxw must be evenly divisible by 16
* this is the part that should be worked out
*

	move.w	pdensity(a0),d0
	cmp.w	#7,d0
	bcs	pint1
	moveq	#6,d0
pint1:	lsl.w	#1,d0

	lea	xdpi_tbl,a1
	move.w	0(a1,d0.w),pxdpi(a0)	;x resolution
        move.w  0(a1,d0.w),xdpi         ;save for later
	lea	ydpi_tbl,a1
	move.w	0(a1,d0.w),pydpi(a0)	;y resolution
        move.w  0(a1,d0.w),ydpi         ;save for later
	lea	minl_tbl,a1
	move.w	0(a1,d0.w),pminlft(a0)	;pixels from the left
        lea	minr_tbl,a1
	move.w	0(a1,d0.w),pminrht(a0)	;pixels from the right
	lea	maxw_tbl,a1
	move.w	0(a1,d0.w),pmaxw(a0)	;maximum # pixels across
        lea	maxh_tbl,a1
	move.l	0(a1,d0.w),pmaxh(a0)	;maximum # pixels down
	lea	mint_tbl,a1
	move.w	0(a1,d0.w),pmintop(a0)	;pixels down from top
	lea	minb_tbl,a1
	move.w	0(a1,d0.w),pminbot(a0)	;pixels up from bottom
	lea	xover_tbl,a1
	move.w	0(a1,d0.w),pxover(a0)	;percentage of x overlap of dots
	lea	yover_tbl,a1
	move.w	0(a1,d0.w),pyover(a0)	;percentage of y overlap of dots
	lea	rowht_tbl,a1
	move.w	0(a1,d0.w),prowht(a0)	;rows height modula
	move.w	0(a1,d0.w),rowht
	lea	rows_tbl,a1
	move.w	0(a1,d0.w),rows
        
	bra	prtok


**************************************
* going to begin printing a document *
**************************************
p_bgndoc:
	bra	prtok


**************************************
* about to start printing of a page  *
**************************************
p_bgnpage:
        move.l  table,a0

        move.l  PPageWidth(a0),d0
        move.l  d0,d1
        addq.l  #7,d1
        lsr.l   #3,d1
        btst    #0,d1
        beq     bp0
        addq.l  #1,d1    
bp0:    move.l  d0,imgx                 ;imgx = # bytes in row
        move.l  PPageHeight(a0),imgy    ;imgy = # rows in page
        
        clr.l   cbuf
        move.l  imgx,d0
        lsl.l   #1,d0
        clr.l   d1
        clr.l   d2
        move.l  m_alloc(a0),a0
        jsr     (a0)
        beq     bp1
        move.l  a0,cbuf
        
bp1:    move.b  #0,d0                   ;Put IMG file header
        bsr     send
        move.b  #1,d0
        bsr     send
        move.b  #0,d0
        bsr     send
        move.b  #8,d0
        bsr     send
        move.b  #0,d0
        bsr     send
        move.b  #1,d0
        bsr     send
        
        move.b  #0,d0                   ;code length (1=byte)
        bsr     send
        move.b  #1,d0
        bsr     send
        
        clr.l   d0                      ;output width in microns
        clr.l   d1
        move.w  #25500,d0
        move.w  xdpi,d1
        divu    d1,d0
        move.w  d0,whold
        lsr.w   #8,d0
        bsr     send
        move.w  whold,d0
        and.w   #$00ff,d0
        bsr     send
        
        clr.l   d0                      ;output height in microns
        clr.l   d1
        move.w  #25500,d0
        move.w  ydpi,d1
        divu    d1,d0
        move.w  d0,whold
        lsr.w   #8,d0
        bsr     send
        move.w  whold,d0
        and.w   #$00ff,d0
        bsr     send
        
        move.l  table,a0
        move.l  PPageWidth(a0),d0
        move.l  d0,whold
        lsr.w   #8,d0
        bsr     send
        move.l  whold,d0
        and.l   #$000000ff,d0
        bsr     send
        
        move.l  imgy,d0                 ;output image height in pixels
        move.l  d0,whold
        lsr.w   #8,d0
        bsr     send
        move.l  whold,d0
        and.l   #$000000ff,d0
        bsr     send                
        
	bra	prtok


******************************************
* about to print a new tile for the page *
******************************************
p_bgntile:
	bra	prtok


********************************
* print a block to the printer *
********************************
p_block:
	move.l	table,a0
	move.l	pblockw(a0),width
        move.l  pblockplane(a0),pplane
	move.l	pblockptr(a0),a1
	move.l	(a1),a1
	add.l	pblockoff(a0),a1
        move.l  a1,a0
        
        tst.l   cbuf                    ;is a compression buffer available?
        beq     nocomp                  ;no, so don't compress output file
        
        clr.l   ulen
        move.l  width,d0
        bsr     compit
        move.l  cbuf,a0
        move.l  (a0),a0
        move.l  d0,d1
        
cm1:    move.b  (a0)+,d0                ;output data in compression buffer
        move.l  d1,-(sp)
        move.l  a0,-(sp)
        bsr     send
        move.l  (sp)+,a0
        move.l  (sp)+,d1
        subq.l  #1,d1
        bne     cm1
        bra     putln1
        
        ;divu    #0,d7
        
nocomp:	move.l  a0,-(sp)
        clr.l   d0
        move.b  #$80,d0                 ;send packet header ($80)
        bsr     send
        move.l  #255,d0
        cmp.l   #255,width              ;default length to 255
        bcc     nc2                     ;is there that much left?
        move.l  width,d0                ;no, so only do what is left
nc2:    move.l  d0,-(sp)
        bsr     send
        move.l  (sp)+,d0
        move.l  d0,d1
        sub.l   d1,width
        move.l  (sp)+,a0

nc3:    move.b	(a0)+,d0
	move.l	a0,-(sp)
        move.l  d1,-(sp)
	bsr	send
        move.l  (sp)+,d1
	move.l	(sp)+,a0
	subq.l	#1,d1
	bne	nc3
        
        tst.l   width
        bne     nocomp
        
        ;btst    #0,width
        ;beq     putln4
        ;move.b  #0,d0           ;make sure to end on a word
        ;bsr     send
                
putln1:	bra	prtok
       

*****************************************  
* just finished describing current tile *
*****************************************
p_endtile:
        bra     prtok


****************************************************
* just finished describing all tiles for this page *
****************************************************
p_endpage:
        tst.l   cbuf
        beq     ep1
        
        move.l  table,a1
        move.l  m_delete(a1),a1
        move.l  cbuf,a0
        jsr     (a1)
        clr.l   cbuf
        
ep1:	bra	prtok


************************************
* finished printing the document   *
************************************
p_enddoc:
	bra	prtok


***************************
* user stopped printing   *
***************************
p_break:
	bra	p_endtile


***************************************************
***	these are the send routines for the	***
***	dot matrix driver.			***
***************************************************
sendline:
	move.b	(a0)+,d0
	beq	prtok
	move.l	a0,-(sp)
	bsr	send
	move.l	(sp)+,a0
	bra	sendline
        
************************************
*  send byte in d0 out to printer  *
************************************
send:	jmp	$ffffff         ;address is modified to be send(a0)
                                ;by init code


************************************************
**   compress the data going to the file      **
************************************************
compit:
        ;divu    #0,d7
        move.l  cbuf,a2         ;get address of compression buffer
        move.l  (a2),a2
        clr.l   d1              ;zero out the length counter
        clr.l   d3              ;zero out the total length counter
        
cmpt2:  subq.l  #1,d0           ;am I out of data yet? (exit when d0 = -1)
        bmi     cmpt3           ;yes
        
        move.b  (a0)+,d2        ;get a byte from the input data
        cmp.b   #$ff,d2
        beq     brun
        
        cmp.b   #$00,d2
        beq     wrun
        
        ;uncompressed run
urun:   lea     ubuf,a3         ;stuff uncompressed byte into ubuf
        move.l  ulen,d4
        move.b  d2,0(a3,d4.l)
        addq.l  #1,ulen
        cmp.l   #255,ulen       ;have I filled the ubuf?
        bcs     cmpt2           ;no, so keep going
        bsr     urun1           ;yes, so output the ubuf
        btst    #31,d0          ;did I finish a row?
        beq     cmpt2           ;no, so get another
        bra     cmpt3           ;get out
        
        ;mini-subroutine to output the ubuf
urun1:  tst.l   ulen            ;any data to output?
        beq     urun3           ;no, so exit
        move.b  #$80,(a2)+      ;output code for uncompressed run
        move.l  ulen,d4         ;output length of uncompressed run
        move.b  d4,(a2)+
        subq.l  #1,d4
        lea     ubuf,a3         ;output uncompressed run bytes
urun2:  move.b  (a3)+,(a2)+
        dbf     d4,urun2
        add.l   #2,d3           ;add 2 for codes to total length
        add.l   ulen,d3         ;add in for the bytes output to total length
        clr.l   ulen            ;reset string length for next urun
urun3:  rts

        ;$ff run
brun:   bsr     urun1           ;output ubuf if any data is there
brun0:  cmp.b   (a0),d2
        bne.s   brun1
        
        subq.l  #1,d0
        bmi     brun1
        move.b  (a0)+,d2
        
        add.b   #1,d1           ;add 1 to the length
        cmp.b   #126,d1         ;have i done the max count yet?
        bcs.s   brun0           ;no, so keep checking

brun1:  add.b   #1,d1           ;output compressed data
        or.b    #$80,d1
        move.b  d1,(a2)+        ;output the code for a $FF run
        addq.l  #1,d3           ;add one to the total length counter
        clr.l   d1
        btst    #31,d0
        beq     cmpt2
        bra     cmpt3

        ;$00 run
wrun:   bsr     urun1           ;output ubuf if any data is there
wrun0:  cmp.b   (a0),d2
        bne.s   wrun1
        
        subq.l  #1,d0
        bmi     wrun1
        move.b  (a0)+,d2
        
        add.b   #1,d1           ;add 1 to the length
        cmp.b   #126,d1         ;have i done the max count yet?
        bcs.s   wrun0           ;no, so keep going

wrun1:  add.b   #1,d1           ;output compressed data
        move.b  d1,(a2)+        ;output the code for a $00 run
        addq.l  #1,d3           ;add one to the total length counter
        clr.l   d1
        btst    #31,d0
        beq     cmpt2           ;go get another byte     
        
cmpt3:  bsr     urun1           ;output ubuf if any data is there
        move.l  d3,d0
        rts
                                

***********************************
***				***
***********************************
 SECTION printer,DATA,PUBLIC

prntbl:	dc.l	prtok,prtok,prtok,prtok,p_init
	dc.l	p_bgndoc,p_bgnpage,p_bgntile
	dc.l	p_block
	dc.l	p_endtile,p_endpage,p_enddoc
	dc.l	p_break,p_ident

xdpi_tbl:       dc.w    72,75,100,150,200,300,2540
ydpi_tbl:       dc.w    72,75,100,150,200,300,2540
minl_tbl:	dc.w	0,0,0,0,0,0,0
minr_tbl:	dc.w	0,0,0,0,0,0,0
;maxw_tbl:	dc.w	432,624,640,864,1280,1712,2560
maxw_tbl:       dc.w    0,0,0,0,0,0,0
maxh_tbl:       dc.w    0,0,0,0,0,0,0
mint_tbl:	dc.w	0,0,0,0,0,0,0
minb_tbl:	dc.w	0,0,0,0,0,0,0
xover_tbl:	dc.w	0,0,0,0,0,0,0
yover_tbl:	dc.w	0,0,0,0,0,0,0
rowht_tbl:	dc.w	1,1,1,1,1,1,1
rows_tbl:	dc.w	1,1,1,1,1,1,1

driver:		dc.b	"IMG File v2.0.0",0


 SECTION printer,BSS,PUBLIC
table:		ds.l	1
twidth:		ds.w	1
pixel:		ds.w	1
lineptr:	ds.l	1
width:		ds.l	1
count:		ds.w	1
rows:		ds.w	1
rowht:		ds.w	1
xdpi:           ds.w    1
imgx:           ds.l    1
imgy:           ds.l    1
pplane:         ds.l    1
whold:          ds.w    1
ydpi:           ds.w    1
cbuf:           ds.l    1
ulen:           ds.l    1
ubuf:           ds.b    256

********************************** changes *****************************
;
;       version 2.0.0
;
;       - initial release

