 include "pdlequ.h"

*
* HP ThinkJet print driver
*
CR	equ	$d
LF	equ	$a
FF	equ	$c
ESC	equ	$1b
DC2	equ	$12

 SECTION printer,CODE,PUBLIC
***************************************************************
***************************************************************
***************************************************************
dumbentry:
	clr.l	d0
	rts

	dc.l	"PRNT"
	dc.w	201

*
* distribute the calls the the appropriate routines
*
hpthink:
	move.l	a0,table
	lsl.w	#2,d0
	lea	prntbl,a1
	move.l	0(a1,d0.w),a1
	jmp	(a1)

*
* identify who I am, and set up who I like to speak to.
*
p_ident:
	move.l	#driver,pdrvrnm(a0)	;pointer to string for driver name
	move.w	#PARALLEL+ASCENDING,device(a0)
prtok:	moveq	#1,d0
rrts:	rts

*
* initialize the table of printer specific routines
*
p_init:	move.l	#driver,pdrvrnm(a0)	;pointer to string for driver name
	clr.b	pdl(a0)			;no page description language
	clr.b	pmult(a0)		;automatically print mulitiple copies?
	clr.b	pman(a0)		;handle manual feed?
	move.b	#PRT_BW,ptype(a0)	;printer type?

	move.l	sendout(a0),send+2	;self-modifing code, tisk, tisk!


*
* pminlft and pmaxw must be evenly divisible by 16
* this is the part that should be worked out
*

	move.w	pdensity(a0),d0
	cmp.w	#7,d0
	bcs	pint1
	moveq	#6,d0
pint1:	lsl.w	#1,d0

	lea	xdpi_tbl,a1
	move.w	0(a1,d0.w),pxdpi(a0)	;x resolution
	lea	ydpi_tbl,a1
	move.w	0(a1,d0.w),pydpi(a0)	;y resolution
	lea	minl_tbl,a1
	move.w	0(a1,d0.w),pminlft(a0)	;pixels from the left
	lea	minr_tbl,a1
	move.w	0(a1,d0.w),pminrht(a0)	;pixels from the right
	lea	mint_tbl,a1
	move.w	0(a1,d0.w),pmintop(a0)	;pixels down from top
	lea	minb_tbl,a1
	move.w	0(a1,d0.w),pminbot(a0)	;pixels up from bottom
	lea	xover_tbl,a1
	move.w	0(a1,d0.w),pxover(a0)	;percentage of x overlap of dots
	lea	yover_tbl,a1
	move.w	0(a1,d0.w),pyover(a0)	;percentage of y overlap of dots
	lea	rowht_tbl,a1
	move.w	0(a1,d0.w),prowht(a0)	;rows height modula
	move.w	0(a1,d0.w),rowht
	lea	rows_tbl,a1
	move.w	0(a1,d0.w),rows

	lsl.w	#1,d0
	lea	maxw_tbl,a1
	move.l	0(a1,d0.w),pmaxw(a0)	;maximum # pixels across
	lea	maxh_tbl,a1
	move.l	0(a1,d0.w),pmaxh(a0)	;maximum # pixels down
	lea	grmode_tbl,a1
	move.l	0(a1,d0.w),grmode
	bra	prtok

*
* going to begin printing a document
*
p_bgndoc:
	bra	prtok

*
* about to start printing of a page
*
p_bgnpage:
	bra	prtok


*
* about to print a new tile for the page
*
p_bgntile:
	move.l	grmode,a0		;set the density
	bra	sendline


*
* print a block to the printer
*
p_block:
	move.l	table,a0
	move.l	pblockw(a0),width
	move.l	pblockptr(a0),a1
	move.l	(a1),a1
	add.l	pblockoff(a0),a1
	move.l	a1,v_base

	move.l	width,d0
	move.l	v_base,a0
putln1:	tst.b	-1(a0,d0.l)
	bne	putln2
	subq.l	#1,d0
	bne	putln1
	moveq	#1,d0
putln2:	move.l	d0,twidth

	lea	bgnline,a0		;start raster graphics transfer
	bsr	sendline		; with # of bytes to follow
	move.l	twidth,d0
	bsr	sendn
	move.b	#"W",d0
	bsr	send
*
	move.l	twidth,d1
	move.l	v_base,a0
putln3:	move.b	(a0)+,d0
	move.l	a0,-(sp)
	move.l	d1,-(sp)
	bsr	send
	move.l	(sp)+,d1
	move.l	(sp)+,a0
	subq.l	#1,d1
	bne	putln3
	bra	prtok

*
* just finished describing current tile
*
p_endtile:
	lea	endtile,a0
	bra	sendline

*
* just finished describing all tiles for this page
*
p_endpage:
	bra	prtok

*
* finished printing the document
*
p_enddoc:
	bra	prtok

p_abort:
	bra	p_endtile

***************************************************
***	these are the send routines for the	***
***	dot matrix driver.			***
***************************************************
*
sendline:
	move.b	(a0)+,d0
	beq	prtok
	move.l	a0,-(sp)
	bsr	send
	move.l	(sp)+,a0
	bra	sendline
*
*
sendn:	cmp.w	#10,d0
	bcs	sdn1
	and.l	#$ffff,d0
	divu	#10,d0
	swap	d0
	move.w	d0,-(sp)
	swap	d0
	bsr	sendn
	move.w	(sp)+,d0
sdn1:	or.b	#"0",d0
*
*	bra	send
*
*
send:	jmp	$ffffff
*
*
***********************************
***				***
***********************************
 SECTION printer,DATA,PUBLIC

prntbl:	dc.l	prtok,prtok,prtok,prtok,p_init
	dc.l	p_bgndoc,p_bgnpage,p_bgntile
	dc.l	p_block
	dc.l	p_endtile,p_endpage,p_enddoc
	dc.l	p_abort,p_ident


xdpi_tbl:	dc.w	96,192,192,192,192,192,192
ydpi_tbl:	dc.w	96,96,96,96,96,96,96
minl_tbl:	dc.w	23,48,48,48,48,48,48
minr_tbl:	dc.w	23,48,48,48,48,48,48
mint_tbl:	dc.w	0,0,0,0,0,0,0
minb_tbl:	dc.w	0,0,0,0,0,0,0
maxw_tbl:	dc.l	640,1280,1280,1280,1280,1280,1280
maxh_tbl:	dc.l	0,0,0,0,0,0,0
xover_tbl:	dc.w	0,0,0,0,0,0,0
yover_tbl:	dc.w	0,0,0,0,0,0,0
rowht_tbl:	dc.w	1,1,1,1,1,1,1
rows_tbl:	dc.w	1,1,1,1,1,1,1
grmode_tbl:	dc.l	rstr1a,rstr1b,rstr1b,rstr1b,rstr1b,rstr1b,rstr1b


driver:		dc.b	"HP ThinkJet Beta v2.1.0",0


rstr1a:	dc.b	ESC,"*r640S",0	;for 96 dpi
rstr1b:	dc.b	ESC,"*r1280S",0	;for 192 dpi

bgnline:	dc.b	ESC,"*b",0
endtile:	dc.b	ESC,"*rB",0

 SECTION printer,BSS,PUBLIC
table:		ds.l	1
twidth:		ds.l	1
v_base:		ds.l	1
width:		ds.l	1
rows:		ds.w	1
rowht:		ds.w	1
grmode:		ds.l	1
papertype:	ds.w	1
