 include "prtequ.h"
 
*
* HP PaintJet color print driver
*
CR	equ	$d
LF	equ	$a
FF	equ	$c
ESC	equ	$1b
DC2	equ	$12

 SECTION printer,CODE,PUBLIC
***************************************************************
***************************************************************
***************************************************************
dumbentry:
	clr.l	d0
	rts

	dc.l	"PRNT"
	dc.w	200

*
* distribute the calls the the appropriate routines
*
hplaser:
	move.l	a0,table
	lsl.w	#2,d0
	lea	prntbl,a1
	move.l	0(a1,d0.w),a1
	jmp	(a1)

*
* identify who I am, and set up who I like to speak to.
*
p_ident:
	move.l	#driver,pdrvrnm(a0)	;pointer to string for driver name
	move.w	#PARALLEL+ASCENDING,device(a0)
prtok:	moveq	#1,d0
	rts

*
* initialize the table of printer specific routines
*
p_init:	move.l	#driver,pdrvrnm(a0)	;pointer to string for driver name
	clr.b	pdl(a0)			;no page description language
	move.b	#0,pmult(a0)		;automatically print mulitiple copies?
	move.b	#0,pman(a0)		;handle manual feed?
	move.b	#PRT_CMYK,ptype(a0)	;printer type?

	move.l	sendout(a0),send+2	;self-modifing code, tisk, tisk!


*
* pminlft and pmaxw must be evenly divisible by 16
* this is the part that should be worked out
*

	move.w	pdensity(a0),d0
	cmp.w	#7,d0
	bcs	pint1
	moveq	#6,d0
pint1:	lsl.w	#1,d0

	lea	xdpi_tbl,a1
	move.w	0(a1,d0.w),pxdpi(a0)	;x resolution
	lea	ydpi_tbl,a1
	move.w	0(a1,d0.w),pydpi(a0)	;y resolution
	lea	minl_tbl,a1
	move.w	0(a1,d0.w),pminlft(a0)	;pixels from the left
        lea	minr_tbl,a1
	move.w	0(a1,d0.w),pminrht(a0)	;pixels from the right
	lea	mint_tbl,a1
	move.w	0(a1,d0.w),pmintop(a0)	;pixels down from top
	lea	minb_tbl,a1
	move.w	0(a1,d0.w),pminbot(a0)	;pixels up from bottom
	lea	xover_tbl,a1
	move.w	0(a1,d0.w),pxover(a0)	;percentage of x overlap of dots
	lea	yover_tbl,a1
	move.w	0(a1,d0.w),pyover(a0)	;percentage of y overlap of dots
	lea	rowht_tbl,a1
	move.w	0(a1,d0.w),prowht(a0)	;rows height modula

	lsl.w	#1,d0
	lea	grmode_tbl,a1
	move.l	0(a1,d0.w),grmode
	lea	maxw_tbl,a1
	move.l	0(a1,d0.w),pmaxw(a0)	;maximum # pixels across
        lea	maxh_tbl,a1
	move.l	0(a1,d0.w),pmaxh(a0)	;maximum # pixels down
	bra	prtok

*
* going to begin printing a document
*
p_bgndoc:
	move.l	grmode,a0
	bsr	sendline
	lea	colorpal,a0
	bsr	sendline
	lea	bgnmode,a0
	bra	sendline

*
* about to start printing of a page
*
p_bgnpage:
	bra	prtok

*
* about to print a new tile for the page
*
p_bgntile:
	bra	prtok

*
* print a block to the printer
*
p_block:
	move.l	table,a0
	move.l	pblockw(a0),d0
        move.w  d0,width
	move.l	pblockplane(a0),pplane
	move.l	pblockptr(a0),a1
	move.l	(a1),a1
	add.l	pblockoff(a0),a1
	move.l	a1,v_base
*
* YMCK
	move.l	v_base,v_ptr		;yellow
	move.l	pplane,d0
	lsl.l	#1,d0
	add.l	d0,v_ptr
	bsr	putline

	move.l	v_base,v_ptr		;magenta
	move.l	pplane,d0
	add.l	d0,v_ptr
	bsr	putline

	move.l	v_base,v_ptr		;cyan
	bsr	putline

	move.l	v_base,v_ptr		;black
	move.l	pplane,d0
	lsl.l	#1,d0
	add.l	pplane,d0
	add.l	d0,v_ptr
	bsr	putline

	lea	endline,a0
	bra	sendline
        
        
**********************************
**                              **
**********************************
putline:
	move.w	width,d0
	move.l	v_ptr,a0
putln1:	tst.b	-1(a0,d0.w)
	bne	putln2
	subq.w	#1,d0
	bne	putln1
	moveq	#1,d0

putln2: move.l  v_ptr,a0
        bsr     compit
        
        move.w	d0,twidth
        
        lea     compress,a0             ;turn data compression on
        bsr     sendline
        
	lea	grfstart,a0
	bsr	sendline
	move.w	twidth,d0
	bsr	sendn
	move.b	#"V",d0
	bsr	send        
*
        move.w	twidth,d1
        lea     buffer,a0
        
putln3:	move.b	(a0)+,d0
	move.l	a0,-(sp)
	move.w	d1,-(sp)
	bsr	send
	move.w	(sp)+,d1
	move.l	(sp)+,a0
	subq.w	#1,d1
	bne	putln3
	bra	prtok


******************************************
* just finished describing current tile **
******************************************
p_endtile:
	bra	prtok

p_break:
	bra	p_endtile

*****************************************************
* just finished describing all tiles for this page **
*****************************************************
p_endpage:
	bra	prtok


***********************************
* finished printing the document **
***********************************
p_enddoc:
	lea	cleanup,a0
	bra	sendline


***************************************************
***	these are the send routines for the	***
***	dot matrix driver.			***
***************************************************
*
sendline:
	move.b	(a0)+,d0
	beq	prtok
	move.l	a0,-(sp)
	bsr	send
	move.l	(sp)+,a0
	bra	sendline
*
*
sendn:	cmp.w	#10,d0
	bcs	sdn1
	and.l	#$ffff,d0
	divu	#10,d0
	swap	d0
	move.w	d0,-(sp)
	swap	d0
	bsr	sendn
	move.w	(sp)+,d0
sdn1:	or.b	#"0",d0
*
*	bra	send
*
*
send:	jmp	$ffffff
*
*

************************************************
**   compress the data going to the printer   **
************************************************
compit:
        lea     buffer,a2       ;get address of buffer
        moveq   #0,d1           ;zero out the length counter
        moveq   #0,d3           ;zero out the total length counter
        
cmpt2:  move.b  (a0)+,d2        ;get pattern byte from string
        subq.w  #1,d0           ;subtract 1 from the string length (twidth)
        beq.s   cmpt3
        
        cmp.b   (a0),d2
        bne.s   cmpt3
        
        add.b   #1,d1           ;add 1 to the length
        cmp.b   #255,d1         ;have i done the max count yet?
        bne.s   cmpt2

cmpt3:  move.b  d1,(a2)+        ;store the length
        clr.b   d1              ;reset the length to 0
        move.b  d2,(a2)+        ;store the pattern byte
        addq.w  #2,d3           ;add two the the total length
        tst.w   d0              ;have i done the whole row yet?
        bne.s   cmpt2           ;no
        
        move.w  d3,d0
        rts
        
***********************************
***				***
***********************************
 SECTION printer,DATA,PUBLIC

prntbl:	dc.l	prtok,prtok,prtok,prtok,p_init
	dc.l	p_bgndoc,p_bgnpage,p_bgntile
	dc.l	p_block
	dc.l	p_endtile,p_endpage,p_enddoc
	dc.l	p_break,p_ident


xdpi_tbl:	dc.w	90,180,180,180,180,180,180
ydpi_tbl:	dc.w	90,180,180,180,180,180,180
minl_tbl:	dc.w	45,90,90,90,90,90,90
minr_tbl:	dc.w	45,90,90,90,90,90,90
maxw_tbl:	dc.l	720,1440,1440,1440,1440,1440,1440
maxh_tbl:	dc.l	0,0,0,0,0,0,0
mint_tbl:	dc.w	0,0,0,0,0,0,0
minb_tbl:	dc.w	0,0,0,0,0,0,0
xover_tbl:	dc.w	0,0,0,0,0,0,0
yover_tbl:	dc.w	0,0,0,0,0,0,0
rowht_tbl:	dc.w	1,1,1,1,1,1,1
grmode_tbl:	dc.l	rez1,rez2,rez2,rez2,rez2,rez2,rez2


driver:	dc.b	"HP PaintJet Color Comp. v2.0",0


rez1:	dc.b	ESC,"E"
	dc.b	ESC,"*t90R"		;90 DPI
	dc.b	ESC,"*r720S"		;720 pixels wide max
	dc.b	ESC,"*r4U"		;4 bitplane mode
	dc.b	ESC,"*b1M"		;unencoded bitmap
	dc.b	0

rez2:	dc.b	ESC,"E"
	dc.b	ESC,"*t180R"		;180 DPI
	dc.b	ESC,"*r1440S"		;1440 pixels wide max
	dc.b	ESC,"*r4U"		;4 bitplane mode
	dc.b	ESC,"*b1M"		;unencoded bitmap
	dc.b	0


bgnmode:	dc.b	ESC,"*r0A",0	;graphics mode
endline:	dc.b	ESC,"*b0W",0
cleanup:	dc.b	ESC,"*r0B",0
grfstart:	dc.b	ESC,"*b",0
nocomp:         dc.b    ESC,"*b0M",0
compress:       dc.b    ESC,"*b1M",0

*
* Esc "*v",n,"I"
* Esc "*v",red,"A"
* Esc "*v",green,"B"
* Esc "*v",blue,"C"
*
colorpal:
	dc.b	ESC,"*v90A"
	dc.b	ESC,"*v88B"
	dc.b	ESC,"*v85C"
	dc.b	ESC,"*v0I"		;#0 white

	dc.b	ESC,"*v89A"
	dc.b	ESC,"*v83B"
	dc.b	ESC,"*v13C"
	dc.b	ESC,"*v1I"		;#1 yellow

	dc.b	ESC,"*v53A"
	dc.b	ESC,"*v5B"
	dc.b	ESC,"*v25C"
	dc.b	ESC,"*v2I"		;#2 magenta

	dc.b	ESC,"*v53A"
	dc.b	ESC,"*v8B"
	dc.b	ESC,"*v14C"
	dc.b	ESC,"*v3I"		;#3 red

	dc.b	ESC,"*v2A"
	dc.b	ESC,"*v22B"
	dc.b	ESC,"*v64C"
	dc.b	ESC,"*v4I"		;#4 cyan

	dc.b	ESC,"*v3A"
	dc.b	ESC,"*v26B"
	dc.b	ESC,"*v22C"
	dc.b	ESC,"*v5I"		;#5 green

	dc.b	ESC,"*v4A"
	dc.b	ESC,"*v4B"
	dc.b	ESC,"*v29C"
	dc.b	ESC,"*v6I"		;#6 blue

	dc.b	ESC,"*v4A"
	dc.b	ESC,"*v4B"
	dc.b	ESC,"*v6C"
	dc.b	ESC,"*v7I"		;#7 black

	dc.b	ESC,"*v4A"
	dc.b	ESC,"*v4B"
	dc.b	ESC,"*v6C"
	dc.b	ESC,"*v8I"		;#8 black

	dc.b	ESC,"*v4A"
	dc.b	ESC,"*v4B"
	dc.b	ESC,"*v6C"
	dc.b	ESC,"*v9I"		;#9 black

	dc.b	ESC,"*v4A"
	dc.b	ESC,"*v4B"
	dc.b	ESC,"*v6C"
	dc.b	ESC,"*v10I"		;#10 black

	dc.b	ESC,"*v4A"
	dc.b	ESC,"*v4B"
	dc.b	ESC,"*v6C"
	dc.b	ESC,"*v11I"		;#11 black

	dc.b	ESC,"*v4A"
	dc.b	ESC,"*v4B"
	dc.b	ESC,"*v6C"
	dc.b	ESC,"*v12I"		;#12 black

	dc.b	ESC,"*v4A"
	dc.b	ESC,"*v4B"
	dc.b	ESC,"*v6C"
	dc.b	ESC,"*v13I"		;#13 black

	dc.b	ESC,"*v4A"
	dc.b	ESC,"*v4B"
	dc.b	ESC,"*v6C"
	dc.b	ESC,"*v14I"		;#14 black

	dc.b	ESC,"*v4A"
	dc.b	ESC,"*v4B"
	dc.b	ESC,"*v6C"
	dc.b	ESC,"*v15I"		;#15 black

	dc.b	0


 SECTION printer,BSS,PUBLIC
table:		ds.l	1
twidth:		ds.w	1
v_base:		ds.l	1
v_ptr:		ds.l	1
width:		ds.w	1
pplane:		ds.l	1
count:		ds.w	1
rows:		ds.w	1
rowht:		ds.w	1
grmode:		ds.l	1
scroll:		ds.w	1
buffer:         ds.b    1024
