*	this is the equates file
*
* document structure - each document has a memory block for it's document
*  structure, which has a memory block for the object table structure, and
*  a memory block for the group list.  The memory handle to this structure is
*  store in w_tbl structure as memhndl
*
whandle	equ	0		;long	;the handle of this doc's window
wmp	equ	whandle+4	;long	;this windows message port
wnext	equ	wmp		;long	;for the ST next window
wgadget	equ	wmp+4		;long	;gadget memory
wtype	equ	wgadget+4	;byte	;1 for document, 3 for clone
changed	equ	wtype+1		;byte	;has the document been edited?
wname	equ	changed+1	;30 chr	;null terminated window name (title on window)
wpath	equ	wname+30	;200chr	;this document's directory

left	equ	wpath+200	;word	;the actual inside dimensions of the window
top	equ	left+2		;word	;  for this document.  Usually the same as
width	equ	top+2		;word	;  plft,ptop,pwdth,pht.
height	equ	width+2		;word

wlft	equ	height+2	;word	;the portion of the page we can see
wtop	equ	wlft+4		;word	;  in the screen window.
wrht	equ	wtop+4		;word
wbtm	equ	wrht+4		;word

plft	equ	wbtm+4		;word	;the physical portion of the screen the 3600dpi
ptop	equ	plft+2		;word	;  counterparts (wlft,wtop,wrht,wbtm)
pwdth	equ	ptop+2		;word
pht	equ	pwdth+2		;word

dleft	equ	pht+2		;long
dtop	equ	dleft+4		;long
dright	equ	dtop+4		;long
dbottom	equ	dright+4	;long

vscale	equ	dbottom+4	;word	;the current viewing scale (% * 100)
uscale	equ	vscale+2	;word	;the user viewing scale (% * 100)
zscale	equ	uscale+2	;word	;the last zoom scale (% * 100)
xhitzone	equ	zscale+2	;long	;used to scale x-coords to the screen
yhitzone	equ	xhitzone+4	;long	;used to scale y-coords to the screen
pagew	equ	yhitzone+4	;long	;the width of the document
pageh	equ	pagew+4		;long	;the height of the document
hbleed	equ	pageh+4		;long	;horizontal page bleed
vbleed	equ	hbleed+4	;long	;vertical page bleed
docflag	equ	vbleed+4	;word	;landscape or portait / single or double sided
PAGEMODE	equ	3	;bits 0 & 1
DOUBLE		equ	3
UGRID		equ	5
UGUIDES		equ	6
UINSMODE	equ	7

mode	equ	docflag+2		;byte	;which toolbox mode this document is in
dmode	equ	mode+1		;byte	;which drawing object mode this doc is in
vflag	equ	dmode+1		;byte	;which viewing modes are on (rulers, etc)
SRULER		equ	0
STABS		equ	1
SPICTURE	equ	2
SOUTLINE	equ	3
SGRID		equ	4
SGUIDES		equ	5
SROUTE		equ	6
vmode	equ	vflag+1		;byte	;which view mode document is in
*					0=full page
*					1=50%
*					2=100%
*					3=200%
*					4=full width
*					5=user scale

obj_tbl	equ	vmode+1		;long	;object table memory handle
group	equ	obj_tbl+4	;long	;group list memory handle

numobj	equ	group+4		;word	;number of entries in the object table struct
pgoff	equ	numobj+2	;word	;the starting page number for this doc -1
lcurpg	equ	pgoff+2		;word
rcurpg	equ	lcurpg+2	;word
curpage	equ	rcurpg+2	;word	;the current page number viewing
prevpage	equ	curpage+2	;word	;previous page number viewed

mrkflag	equ	prevpage+2	;byte	;set if text is marked
csrflag	equ	mrkflag+1	;byte	;set if cursor is placed

csrcol	equ	csrflag+1	;word	;column where cursor lies
csroff	equ	csrcol+2	;long	;offset into column(csrcol) for cursor position
csrloff	equ	csroff+4	;long	;offset into line table for cursor
csrch	equ	csrloff+4	;long	;cursor ch
csrcv	equ	csrch+4		;long	;cursor cv
csrht	equ	csrcv+4		;long	;cursor height
csrtch	equ	csrht+4		;long	;cursor ch
csrtcv	equ	csrtch+4	;long	;cursor cv

mrkcol1	equ	csrtcv+4	;word	;column that hilight begins in
mrkcol2	equ	mrkcol1+2	;word	;column that hilight ends in
mrkch1	equ	mrkcol2+2	;long	;hilights ch start
mrkch2	equ	mrkch1+4	;long	;hilights ch end
mrkoff1	equ	mrkch2+4	;long	;offset into column(mrkcol1) for bgn of hilight
mrkoff2	equ	mrkoff1+4	;long	;offset into column(mrkcol2) for end of hilight
mrklof1	equ	mrkoff2+4	;long	;offset into lntable for beginning of hilight
mrklof2	equ	mrklof1+4	;long	;offset into lntable for end of hilight

*	  must be in this order
dc_Defines	equ	mrklof2+4
dc_Font		equ	dc_Defines+4	;font
dc_Attrb	equ	dc_Font+4	;attributes
dc_XPoint	equ	dc_Attrb+4	;x point size
dc_YPoint	equ	dc_XPoint+4	;y point size
dc_Spacing	equ	dc_YPoint+4	;character spacing
dc_Lead		equ	dc_Spacing+2	;leading amount, or auto leading offset
dc_BMod		equ	dc_Lead+2	;baseline offset
dc_PIndent	equ	dc_BMod+2	;paragraph indent/outdent
dc_LIndent	equ	dc_PIndent+2	;left indent
dc_RIndent	equ	dc_LIndent+2	;right indent
dc_Tag		equ	dc_RIndent+2	;tag
dc_Justify	equ	dc_Tag+1	;line justify/paragraph format
dc_CFStyle	equ	dc_Justify+1	;character fill style
dc_CFColor	equ	dc_CFStyle+1	;character fill color
dc_CLStyle	equ	dc_CFColor+1	;character line style
dc_CLColor	equ	dc_CLStyle+1	;character line color
dc_CLWidth	equ	dc_CLColor+1	;character line width
*
cs_Defines	equ	dc_CLWidth+2
cs_Font		equ	cs_Defines+4	;font
cs_Attrb	equ	cs_Font+4	;attributes
cs_XPoint	equ	cs_Attrb+4	;x point size
cs_YPoint	equ	cs_XPoint+4	;y point size
cs_Spacing	equ	cs_YPoint+4	;character spacing
cs_Lead		equ	cs_Spacing+2	;leading amount, or auto leading offset
cs_BMod		equ	cs_Lead+2	;baseline offset
cs_PIndent	equ	cs_BMod+2	;paragraph indent/outdent
cs_LIndent	equ	cs_PIndent+2	;left indent
cs_RIndent	equ	cs_LIndent+2	;right indent
cs_Tag		equ	cs_RIndent+2	;tag
cs_Justify	equ	cs_Tag+1	;line justify/paragraph format
cs_CFStyle	equ	cs_Justify+1	;character fill style
cs_CFColor	equ	cs_CFStyle+1	;character fill color
cs_CLStyle	equ	cs_CFColor+1	;character line style
cs_CLColor	equ	cs_CLStyle+1	;character line color
cs_CLWidth	equ	cs_CLColor+1	;character line width

*	  to here
super	equ	cs_CLWidth+2		;amount to superscript by
subs	equ	super+2			;amount to subscript by

pindent		equ	subs+2		;amount for paragraph indent
poutdent	equ	pindent+2	;amount for paragraph outdent

mngreek	equ	poutdent+2	;minimum point size shown correctly
mxgreek	equ	mngreek+4	;maximum point size shown correctly


lwdth	equ	mxgreek+4	;current line width
ltype	equ	lwdth+2		;current line type
lcolor	equ	ltype+1		;current line color
ftype	equ	lcolor+1	;current fill type
fcolor	equ	ftype+1		;current fill color
lbgn	equ	fcolor+1	;current beginning line type
lend	equ	lbgn+1		;current ending line type

gridw	equ	lend+1		;document grid width
gridh	equ	gridw+2		;document grid height
ufill	equ	gridh+2		;user definable fill pattern
uline	equ	ufill+32	;user definable line type

mstrpg	equ	uline+2
*
*
*
*
*
l_hg	equ	mstrpg+128	;32 longs	;vertical guides table
l_vg	equ	l_hg+128	;32 longs	;horizontal guides table
r_hg	equ	l_vg+128
r_vg	equ	r_hg+128
tagnumber	equ	r_vg+128
tagtable	equ	tagnumber+2
clrtable	equ	tagtable+4
dc_Sizeof	equ	clrtable+512


*
* this is the data structure for pictures. the first few bytes have a
* similar purpose as those of the document structure
*
pi_CX1		equ	vmode+1		;current outside window dimensions
pi_CY1		equ	pi_CX1+2
pi_CX2		equ	pi_CY1+2
pi_CY2		equ	pi_CX2+2
pi_OX1		equ	pi_CY2+2	;previous outside window dimensions
pi_OY1		equ	pi_OX1+2
pi_OX2		equ	pi_OY1+2
pi_OY2		equ	pi_OX2+2

pi_Type		equ	pi_CX1+20
pi_SFreq	equ	pi_Type+2	;screen frequency
pi_SAngle	equ	pi_SFreq+2	;screen angle
pi_SSpot	equ	pi_SAngle+2	;spot function
pi_SMap		equ	pi_SSpot+2	;mapping function
pi_XDpi		equ	pi_SMap+258	;x dots per inch
pi_YDpi		equ	pi_XDpi+2	;y dots per inch
pi_W		equ	pi_YDpi+2	;pixels wide
pi_H		equ	pi_W+2		;pixels high
pi_Width	equ	pi_H+2		;words wide
pi_BitPln	equ	pi_Width+2	;number of bit planes
pi_Palet	equ	pi_BitPln+2	;color pallet entries (8 bytes per)
pi_Ptr		equ	pi_Palet+2	;offset to bit map data

pi_DScale	equ	pi_Ptr+4
pi_DW		equ	pi_DScale+2
pi_DH		equ	pi_DW+2
pi_DWidth	equ	pi_DH+2
pi_DBitPln	equ	pi_DWidth+2
pi_DPtr		equ	pi_DBitPln+2

pi_Sizeof	equ	pi_DPtr+4


***
***
* equates for the tag table
tg_Defines	equ	0
tg_Name		equ	tg_Defines+4
TG_NAMELEN	equ	27
tg_Font		equ	tg_Name+28
tg_Attrb	equ	tg_Font+4
tg_XPoint	equ	tg_Attrb+4
tg_YPoint	equ	tg_XPoint+4
tg_Spacing	equ	tg_YPoint+4
tg_Lead		equ	tg_Spacing+2
tg_BMod		equ	tg_Lead+2
tg_PIndent	equ	tg_BMod+2
tg_LIndent	equ	tg_PIndent+2
tg_RIndent	equ	tg_LIndent+2
tg_unused	equ	tg_RIndent+2
tg_Justify	equ	tg_unused+1
tg_CFStyle	equ	tg_Justify+1
tg_CFColor	equ	tg_CFStyle+1
tg_CLStyle	equ	tg_CFColor+1
tg_CLColor	equ	tg_CLStyle+1
tg_CLWidth	equ	tg_CLColor+1
tg_Sizeof	equ	tg_CLWidth+2

* tf_Defines values are
*
TG_FONT		equ	0
TG_ATTRB	equ	1
TG_POINT	equ	2
TG_SPACING	equ	3
TG_LEAD		equ	4
TG_BMOD		equ	5
TG_PINDENT	equ	6
TG_INDENT	equ	7
TG_TAG		equ	8
TG_JUSTIFY	equ	9
TG_CFSTYLE	equ	10
TG_CFCOLOR	equ	11
TG_CLSTYLE	equ	12
TG_CLCOLOR	equ	13
TG_CLWIDTH	equ	14

***
***
* equates for the color table

cl_Name		equ	0		;23 char (nul terminated)
cl_Type		equ	cl_Name+24
cl_Cyan		equ	cl_Type+2
cl_Magenta	equ	cl_Cyan+2
cl_Yellow	equ	cl_Magenta+2
cl_Black	equ	cl_Yellow+2
cl_Map		equ	cl_Black+2
cl_Sizeof	equ	cl_Map+2
CL_NAMELEN	equ	cl_Type-cl_Name

* colortype bits
MECHANICAL	equ	15

***
***

ob_Page		equ	0		;the page this object is located on
ob_Left		equ	ob_Page+2
ob_Top		equ	ob_Left+4
ob_Right	equ	ob_Top+4
ob_Bottom	equ	ob_Right+4
ob_Type		equ	ob_Bottom+4
ob_Flag		equ	ob_Type+1
ob_Slant	equ	ob_Flag+1	;the degrees of slant for this object
ob_Twist	equ	ob_Slant+2	;the degrees of twist
ob_LWidth	equ	ob_Twist+2	;width of line draw
ob_LType	equ	ob_LWidth+2	;line type
ob_LColor	equ	ob_LType+1	;line color
ob_FType	equ	ob_LColor+1	;fill type
ob_FColor	equ	ob_FType+1	;fill color
ob_LBegin	equ	ob_FColor+1	;line begin style
ob_LEnd		equ	ob_LBegin+1	;line end style

ob_Ptr		equ	ob_LEnd+1	;memory handle for grp,col,txt,pic,free/poly
ob_BAngle	equ	ob_LEnd+1	;beginning angle for circle(arc),ellipse(earc)
ob_EAngle	equ	ob_BAngle+2	;ending angle for circle(arc),ellipse(earc)
ob_XRadius	equ	ob_LEnd+1	;x radius for corner of box(rbox),square(rsqr)
ob_YRadius	equ	ob_XRadius+2	;y radius for corner of box(rbox),square(rsqr)
ob_HStandOff	equ	ob_YRadius+2	;textwrap left/right standoff
ob_VStandOff	equ	ob_HStandOff+2	;textwrap top/bottom standoff
ob_SizeOf	equ	ob_VStandOff+2


*object flags defined as:
*
FLOWTEXT	equ	7		;and mask (bits 0,1,&2)
PUBLISHED	equ	5
GROUPED		equ	6
LOCKED		equ	7
*	bit 0-2 text flow mode
*
*	bit 6  grouped bit - if set then the object is in a group, and is
*				not selectable.  just the group objects it
*				belongs to is selectable.
*	bit 7  locked bit  - if set then the object can not be moved,sized,etc
*

tgroup	equ	0	;  group
tcol	equ	4	;  columns
ttxt	equ	8	;  text line
tpic	equ	12	;  picture
tpoly	equ	16	;  polygon
tfree	equ	20	;  freehand
tbox	equ	24	;  box/rounded corner box
tsqr	equ	28	;  square box/rounded corner square
thvln	equ	32	;  horizontal/vertical line
tdln	equ	36	;  diagonal line
tcir	equ	40	;  circle/arc
telp	equ	44	;  ellipse/elliptical arc
teps	equ	48	;  encapsulated postscript

* column structure - every column has a structure like this allocated for it.
*   it is not an array, but a seperate memory block for each column.
*   the memory handle for the column structure is kept in optr in the
*   object structure for this column.
*
cm_Lock		equ	0
cm_Version	equ	cm_Lock+8
cm_Next		equ	cm_Version+4	;next column object number in link (-1 if none)
cm_Prev		equ	cm_Next+2	;prev column object number in link (-1 if none)
cm_LCalc	equ	cm_Prev+2	;flag set if line table needs to be recalced
cm_QCalc	equ	cm_LCalc+1	;flag set if q-table needs to be recalced
cm_LHandle	equ	cm_QCalc+1	;this columns line table handle
cm_QHandle	equ	cm_LHandle+4	;this columns q-table handle
cm_THandle	equ	cm_QHandle+4	;text block handle (and for all others linked)
cm_TOffset	equ	cm_THandle+4	;offset into text block for this column
cm_Left		equ	cm_TOffset+4	;left edge of column (same as Olft)
cm_Top		equ	cm_Left+4	;top edge of column (same as Otop)
cm_Right	equ	cm_Top+4	;right edge of column (same as Orht)
cm_Bottom	equ	cm_Right+4	;bottom edge of column (same as Obtm)
cm_Flag		equ	cm_Bottom+4
cm_unused	equ	cm_Flag+2

CM_OVERFLOW	equ	0
CM_PARA		equ	1

* these attributes describe the attributes of the start of this column.
* the attributes in the first line table entry for this column will be the
* same as these, the only differance is that the line table is purgable, and
* I need to keep them in a "safe" place.
cm_Font		equ	cm_unused+6	;font
cm_Attrb	equ	cm_Font+4	;attributes
cm_XPoint	equ	cm_Attrb+4	;x point size
cm_YPoint	equ	cm_XPoint+4	;y point size
cm_Spacing	equ	cm_YPoint+4	;character spacing
cm_Lead		equ	cm_Spacing+2	;fixed leading /auto leading offset
cm_BMod		equ	cm_Lead+2	;baseline offset
cm_PIndent	equ	cm_BMod+2	;paragraph indent
cm_LIndent	equ	cm_PIndent+2	;left indent
cm_RIndent	equ	cm_LIndent+2	;right indent
cm_Tag		equ	cm_RIndent+2	;tag
cm_Justify	equ	cm_Tag+1	;line justify
cm_CFStyle	equ	cm_Justify+1	;character fill style
cm_CFColor	equ	cm_CFStyle+1	;character fill color
cm_CLStyle	equ	cm_CFColor+1	;character line style
cm_CLColor	equ	cm_CLStyle+1	;character line color
cm_CLWidth	equ	cm_CLColor+1	;character line width

cm_Tabs		equ	cm_CLWidth+2
cm_Sizeof	equ	cm_Tabs+84	;20 tabs + 0

* $00       character 0
* $01       cariage return
* $02       invisible manual hyphen
* $03       visible manual hyphen
* $04       invisible auto hyphen
* $05       visible auto hyphen
* $06       jump to next tab stop
* $07       page number command
* $08       begin conditional
* $09       end conditional
* $0a       forced end of column
CMD_CH0		equ	$00
CMD_CR		equ	$01
CMD_IMH		equ	$02
CMD_VMH		equ	$03
CMD_IAH		equ	$04
CMD_VAH		equ	$05
CMD_TAB		equ	$06
CMD_PGN		equ	$07
CMD_BGNC	equ	$08
CMD_ENDC	equ	$09
CMD_FEOC	equ	$0a


* $10 xx    tag               (byte)
* $11 xx    justify mode      (byte)
* $12 xx    fill style        (byte)
* $13 xx    fill color        (byte)
* $14 xx    line style        (byte)
* $15 xx    line color        (byte)
* $16 xx    line width        (word)

CMD_TAG		equ	$10
CMD_JST		equ	$11
CMD_CFS		equ	$12
CMD_CFC		equ	$13
CMD_CLS		equ	$14
CMD_CLC		equ	$15
CMD_CLW		equ	$16

* $20 xxxx  font              (long)
* $21 xxxx  attributes        (long)
* $22 xxxx  character spacing (word)
* $23 xxxx  line spacing      (word)
* $24 xxxx  baseline offset   (word)
* $25 xxxx  paragraph indent  (word)
* $26 xxxx  manual kern       (word)
* $27 xxxx  auto kern         (word)
CMD_F		equ	$20
CMD_AT		equ	$21
CMD_CSP		equ	$22
CMD_LSP		equ	$23
CMD_BMOD	equ	$24
CMD_PIN		equ	$25
CMD_MKRN	equ	$26
CMD_AKRN	equ	$27


* $40 xxxx yyyy  x/y point             (2 longs)
* $41 xxxx yyyy  left/right indent     (2 words)
CMD_PT		equ	$40
CMD_IN		equ	$41


*	attrb commands
BOLD    equ	0	;bit
ITALICS equ	1	;bit
SHADOW  equ	2	;bit
OUTLINE equ	3	;bit
BCKSLNT equ	4	;bit
LIGHT   equ	5	;bit
RVRS    equ	6	;bit
MIRROR  equ	7	;bit
UPSIDE  equ	8	;bit
UNDER   equ	9	;bit
WORDU   equ	10	;bit
CHARU	equ	11	;bit
DOUBLEU equ	12	;bit
STRIKE  equ	13	;bit
* bits 16-19 bold levels (0-15 levels)
*  0  normal bold/light (not specified)
*  1  extra-ultra light
*  3  extra-light
*  5  light (same as 0?)
*  7  normal (book? medium?)
*  8  medium
*  9  bold (same as 0?)
*  11 extra bold
*  13 black
*  15 heavy!!
* bits 20-23 condensed levels (0-15 levels)
*  0  normal (uncondensed)
*  1  extra condensed
*  3  condensed
*  5  normal (same as 0?)
*  7  expanded
*  9  extra expanded
* bits 24-26 size levels (0-7 levels)
*  0  normal size
*  1  small
*  2  medium (normal, same as 0?)
*  3  large
* bit 27 - caps
*  (bit 27 & bits24-26=1 means small caps!)
* bits 28-31 special attribute numbers (0-15 values)


*	justify command
*	  0 = block left
*	  1 = center
*	  2 = block right
*	  3 = character justify
*	  4 = word justify
*	  5 = auto justify


* line table structure
*  memory handle to this structure is stored in the column structure
*  under cltbl.  The line table is an array, with a line table structure
*  entry for every line of text.  It's possible that a single horizontal
*  strip of text is broken into two line table entries if the text needs to
*  flow around an object placed on top of the column.  The end of the table
*  is denoted by ltop = -1.  The size of each entry in the line table is
*  34 bytes.
*

ln_Offset	equ	0		;offset from column offset to text
ln_Left		equ	ln_Offset+4	;left edge of this line
ln_Top		equ	ln_Left+4	;top edge of this line
ln_Right	equ	ln_Top+4	;right edge of this line
ln_Bottom	equ	ln_Right+4	;bottom edge of this line
ln_CJust	equ	ln_Bottom+4	;character justification amount.
ln_WJust	equ	ln_CJust+2	;word justification amount.
*	  must be in this order
ln_Font		equ	ln_WJust+2	;these character attributes are
ln_Attrb	equ	ln_Font+4	;  identical to the column attributes
ln_XPoint	equ	ln_Attrb+4	;  but they are the attributes for
ln_YPoint	equ	ln_XPoint+4	;  the start of this line.
ln_Spacing	equ	ln_YPoint+4
ln_Lead		equ	ln_Spacing+2
ln_BMod		equ	ln_Lead+2
ln_PIndent	equ	ln_BMod+2
ln_LIndent	equ	ln_PIndent+2
ln_RIndent	equ	ln_LIndent+2
ln_Tag		equ	ln_RIndent+2
ln_Justify	equ	ln_Tag+1
ln_CFStyle	equ	ln_Justify+1
ln_CFColor	equ	ln_CFStyle+1
ln_CLStyle	equ	ln_CFColor+1
ln_CLColor	equ	ln_CLStyle+1
ln_CLWidth	equ	ln_CLColor+1

ln_Sizeof	equ	ln_CLWidth+2		;length of line table
*	  to here


*
* picture objects
*
pc_Lock		equ	0
pc_Version	equ	pc_Lock+8
pc_Type		equ	pc_Version+4
pc_SFreq	equ	pc_Type+2	;screen frequency
pc_SAngle	equ	pc_SFreq+2	;screen angle
pc_SSpot	equ	pc_SAngle+2	;spot function
pc_SMap		equ	pc_SSpot+2	;mapping function
pc_XDpi		equ	pc_SMap+258	;x dots per inch
pc_YDpi		equ	pc_XDpi+2	;y dots per inch
pc_W		equ	pc_YDpi+2	;pixels wide
pc_H		equ	pc_W+2		;pixels high
pc_Width	equ	pc_H+2		;words wide
pc_BitPln	equ	pc_Width+2	;number of bit planes
pc_Palet	equ	pc_BitPln+2	;color pallet entries (8 bytes per)
pc_Ptr		equ	pc_Palet+2	;offset to bit map data

pc_DScale	equ	pc_Ptr+4
pc_DW		equ	pc_DScale+2
pc_DH		equ	pc_DW+2
pc_DWidth	equ	pc_DH+2
pc_DBitPln	equ	pc_DWidth+2
pc_DPtr		equ	pc_DBitPln+2

pc_Sizeof	equ	pc_DPtr+4



*
* where pc_Type's are
*
PC_PALET	equ	0		;rgb defined only know
PC_BW		equ	1
PC_RGB		equ	2
PC_RGBW		equ	3
PC_CMY		equ	4
PC_CMYK		equ	5

*
* RGB color pallet equates
*
pl_Red		equ	0			;red
pl_Green	equ	pl_Red+2		;green
pl_Blue		equ	pl_Green+2		;blue
pl_ScreenColor	equ	pl_Blue+2		;screen color

pl_Sizeof	equ	pl_ScreenColor+2	;size of color pallet entries



*
* polygon info
*
ply_Length	equ	0
ply_Width	equ	ply_Length+4
ply_Height	equ	ply_Width+4
ply_XScale	equ	ply_Height+4
ply_YScale	equ	ply_XScale+2
ply_Count	equ	ply_YScale+2
ply_Sizeof	equ	ply_Count+2


NEWPATH		equ	0
CLOSEPATH	equ	4
FILLPATH	equ	8
STROKEPATH	equ	12
MOVETO		equ	16
LINETO		equ	20
CURVETO		equ	24
ARCTO		equ	28
ARCNTO		equ	32


*
* encapsulated postscript object
*
eps_Type	equ	0
eps_Width	equ	eps_Type+2
eps_Height	equ	eps_Width+4
eps_PicPtr	equ	eps_Height+4
eps_PlyPtr	equ	eps_PicPtr+4
eps_DataLen	equ	eps_PlyPtr+4
eps_Sizeof	equ	eps_DataLen+4





* offsets into the font metric list
*
fm_Flag		equ	0
fm_Type		equ	fm_Flag+2
fm_Family	equ	fm_Type+2
fm_Attrb	equ	fm_Family+4
fm_XPoint	equ	fm_Attrb+4
fm_YPoint	equ	fm_XPoint+4
fm_XDpi		equ	fm_YPoint+4
fm_YDpi		equ	fm_XDpi+2
fm_Name		equ	fm_YDpi+2
fm_SName	equ	fm_Name+48
fm_FName	equ	fm_SName+32
fm_Directory	equ	fm_FName+24
fm_FontN	equ	fm_Directory+2
fm_SymSet	equ	fm_FontN+4
fm_Metrics	equ	fm_SymSet+2
fm_Sizeof	equ	fm_Metrics+4

* offsets into the font list
*
ft_Flag		equ	0
ft_Type		equ	ft_Flag+2
ft_Family	equ	ft_Type+2
ft_Attrb	equ	ft_Family+4
ft_XPoint	equ	ft_Attrb+4
ft_YPoint	equ	ft_XPoint+4
ft_XDpi		equ	ft_YPoint+4
ft_YDpi		equ	ft_XDpi+2
ft_FName	equ	ft_YDpi+2
ft_Directory	equ	ft_FName+24
ft_FontN	equ	ft_Directory+2
ft_SymSet	equ	ft_FontN+4
ft_Handle	equ	ft_SymSet+2
ft_Sizeof	equ	ft_Handle+4


fd_DName	equ	0
fd_Sizeof	equ	fd_DName+256

*
* offsets into font equivelent table
*
eq_Type		equ	0
eq_Font1	equ	eq_Type+2
eq_Font2	equ	eq_Font1+4
eq_SizeOf	equ	eq_Font2+4

FONTEQUIV	equ	0
FONTREPLC	equ	1


*
* offsets into font style table
*
fs_Type		equ	0
fs_Font		equ	fs_Type+2
fs_Style	equ	fs_Font+4
fs_Name		equ	fs_Style+4
fs_Sizeof	equ	fs_Name+16

FONTSYMBOL	equ	0
FONTSTYLE	equ	1

*
* compugraphic fontlist table
*
cg_FontN	equ	0
cg_FName	equ	cg_FontN+4
cg_Directory	equ	cg_FName+24
cg_Offset	equ	cg_Directory+2
cg_Length	equ	cg_Offset+4
cg_Bucket	equ	cg_Length+2
cg_Sizeof	equ	cg_Bucket+2


*
*
*
FM_MAGIK	equ	0
FM_TYPE		equ	FM_MAGIK+2
FM_FONT		equ	FM_TYPE+2
FM_ATTRB	equ	FM_FONT+2
FM_XPOINT	equ	FM_ATTRB+2
FM_YPOINT	equ	FM_XPOINT+2
FM_XDPI		equ	FM_YPOINT+2
FM_YDPI		equ	FM_XDPI+2
FM_NAME		equ	FM_YDPI+2
FM_CWIDTH	equ	FM_NAME+32
FM_KRNCNT	equ	FM_CWIDTH+512
FM_KRNPRS	equ	FM_KRNCNT+2


FT_MAGIK	equ	0
FT_TYPE		equ	FT_MAGIK+2
FT_FONT		equ	FT_TYPE+2
FT_ATTRB	equ	FT_FONT+2
FT_XPOINT	equ	FT_ATTRB+2
FT_YPOINT	equ	FT_XPOINT+2
FT_XDPI		equ	FT_YPOINT+2
FT_YDPI		equ	FT_XDPI+2
FT_BSLN		equ	FT_YDPI+2
FT_HT		equ	FT_BSLN+2
FT_CSET		equ	FT_HT+2


DM_MAGIK	equ	0
DM_TYPE		equ	DM_MAGIK+2
DM_FONT		equ	DM_TYPE+2
DM_ATTRB	equ	DM_FONT+2
DM_XPOINT	equ	DM_ATTRB+2
DM_YPOINT	equ	DM_XPOINT+2
DM_XDPI		equ	DM_YPOINT+2
DM_YDPI		equ	DM_XDPI+2
DM_ULPOS	equ	DM_YDPI+2
DM_ULTHICK	equ	DM_ULPOS+2
DM_BBOX		equ	DM_ULTHICK+2
DM_CSET		equ	DM_BBOX+4
DM_LOOKUP	equ	DM_CSET+4

PF_MAGIK	equ	0
PF_TYPE		equ	PF_MAGIK+2
PF_FONT		equ	PF_TYPE+2
PF_ATTRB	equ	PF_FONT+2
PF_XPOINT	equ	PF_ATTRB+2
PF_YPOINT	equ	PF_XPOINT+2
PF_XDPI		equ	PF_YPOINT+2
PF_YDPI		equ	PF_XDPI+2
PF_ULPOS	equ	PF_YDPI+2
PF_ULTHICK	equ	PF_ULPOS+2
PF_NAME		equ	PF_ULTHICK+2
PF_TOPBLUES	equ	PF_NAME+48
PF_BTMBLUES	equ	PF_TOPBLUES+40
PF_FTOPBLUES	equ	PF_BTMBLUES+40
PF_FBTMBLUES	equ	PF_FTOPBLUES+40
PF_BSCALE	equ	PF_FBTMBLUES+40
PF_BSHIFT	equ	PF_BSCALE+2
PF_BFUZZ	equ	PF_BSHIFT+2
PF_STDHW	equ	PF_BFUZZ+2
PF_STDVW	equ	PF_STDHW+40
PF_STEMSNAPH	equ	PF_STDVW+40
PF_STEMSNAPV	equ	PF_STEMSNAPH+40
PF_FORCEBOLD	equ	PF_STEMSNAPV+40
PF_OBLIQUE	equ	PF_FORCEBOLD+2
PF_COFFSET	equ	PF_OBLIQUE+2
PF_CSET		equ	PF_COFFSET+4
PF_SOFFSET	equ	PF_CSET+1024
PF_SSET		equ	PF_SOFFSET+4
PF_SLENGTH	equ	PF_SSET+4
PF_SIZEOF	equ	PF_SLENGTH+4


PS_MAGIK	equ	0
PS_TYPE		equ	PS_MAGIK+2
PS_FONT		equ	PS_TYPE+2
PS_ATTRB	equ	PS_FONT+2
PS_XPOINT	equ	PS_ATTRB+2
PS_YPOINT	equ	PS_XPOINT+2
PS_XDPI		equ	PS_YPOINT+2
PS_YDPI		equ	PS_XDPI+2
PS_ULPOS	equ	PS_YDPI+2
PS_ULTHICK	equ	PS_ULPOS+2
PS_NAME		equ	PS_ULTHICK+2
PS_FNAME	equ	PS_NAME+48
PS_LOOKUP	equ	PS_FNAME+18


*
* memory management stuff
*
PURGABLE	equ	1
CHIP		equ	$8000

*
* keyboard stuff
*
LRSHIFT	equ	$03		; and mask
CNTRL	equ	2		; bit number
LRALT	equ	$08		; and mask
;LRAMIGA	equ	$c0
