.include "prtequ.h"

*
* SLM804 print driver
*
CR	equ	$d
LF	equ	$a
FF	equ	$c
ESC	equ	$1b
DC2	equ	$12

	.text
***************************************************************
***************************************************************
***************************************************************
dumbentry:
	clr.l	d0
	rts

	dc.l	"PRNT"
	dc.w	201

*
* distribute the calls to the appropriate routines
*
slm804:	lsl.w	#2,d0
	lea	prntbl,a1
	move.l	0(a1,d0.w),a1
	jmp	(a1)


*
* identify who I am, and set up who I like to speak to.
*
p_ident:
	move.l	#driver,pdrvrnm(a0)	;pointer to string for driver name
	move.w	#PARALLEL+ASCENDING,device(a0)
prtok:	moveq	#1,d0
rrts:	rts

*
* initialize the table of printer specific routines
*
p_init:	move.l	#driver,pdrvrnm(a0)	;pointer to string for driver name
	clr.b	pdl(a0)			;not a page description language driver
	move.b	#1,pmult(a0)		;automatically print mulitiple copies?
	clr.b	pman(a0)		;handle manual feed?
	move.b	#PRT_BW,ptype(a0)	;printer type?

	move.w	#0,pxover(a0)		;percentage of x overlap of dots
	move.w	#0,pyover(a0)		;percentage of y overlap of dots
	move.w	#1,prowht(a0)		;smallest height of print head

	move.l	sendout(a0),send+2	;self-modifing code, tisk, tisk!

*
* pminlft and pmaxw must be evenly divisible by 16
*
	move.w	pdensity(a0),d0
	cmp.w	#7,d0
	bcs	pint1
	moveq	#6,d0
pint1:	lsl.w	#1,d0

	lea	scl_tbl,a1
	move.w	0(a1,d0.w),scale
	lea	xdpi_tbl,a1
	move.w	0(a1,d0.w),pxdpi(a0)	;x resolution
	lea	ydpi_tbl,a1
	move.w	0(a1,d0.w),pydpi(a0)	;y resolution
	lea	minl_tbl,a1
	move.w	0(a1,d0.w),pminlft(a0)	;pixels from the left
	lea	minr_tbl,a1
	move.w	0(a1,d0.w),pminrht(a0)	;pixels from the right
	lea	mint_tbl,a1
	move.w	0(a1,d0.w),pmintop(a0)	;pixels down from top
	lea	minb_tbl,a1
	move.w	0(a1,d0.w),pminbot(a0)	;pixels up from bottom

	lsl.w	#1,d0
	lea	maxw_tbl,a1
	move.l	0(a1,d0.w),pmaxw(a0)	;maximum # pixels across
	lea	maxh_tbl,a1
	move.l	0(a1,d0.w),pmaxh(a0)	;maximum # pixels down
	bra	prtok

*
* going to begin printing a document
*
p_bgndoc:
	bra	prtok

*
* about to start printing of a page
*
p_bgnpage:
	bra	prtok

*
* about to print a new tile for the page
*
p_bgntile:
	bra	prtok

*
* print a block to the printer
*
p_block:
	move.l	pblockptr(a0),a1
	move.l	(a1),s_form
	clr.w	s_xmin
	clr.w	s_ymin
	move.l	pblockw(a0),d0
	move.w	d0,s_nxln
	lsl.w	#3,d0
	move.w	d0,b_width
	move.l	pblockh(a0),d0
	move.w	d0,b_height
	clr.l	pblockh(a0)

	clr.w	d_xmin
	move.l	pblocky(a0),d0
	move.w	d0,d_ymin


	move.w	scale,sclfactor		;vary this depending on draft/final

	move.w	pcopies(a0),tcopy

block1:	move.b	#ESC,d0
	jsr	send
	move.b	#DC2,d0
	jsr	send
	move.b	#"G",d0
	jsr	send
	move.l	#s_form,temp
	move.b	temp,d0
	jsr	sendh
	move.b	temp+1,d0
	jsr	sendh
	move.b	temp+2,d0
	jsr	sendh
	move.b	temp+3,d0
	jsr	sendh
	move.b	#$20,d0			;space
	jsr	send
	move.b	#FF,d0
	jsr	send

	subq.w	#1,tcopy
	bhi	block1
	bra	prtok

*
* just finished describing current tile
*
p_endtile:
	bra	prtok

*
* just finished describing all tiles for this page
*
p_endpage:
	bra	prtok

*
* finished printing the document
*
p_enddoc:
	bra	prtok

***************************************************
***	these are the send routines for the	***
***	dot matrix driver.			***
***************************************************
*
*
sendh:	move.w	d0,-(sp)
	lsr.b	#4,d0
	jsr	rc1
	move.w	(sp)+,d0
rc1:	and.w	#$f,d0
	lea	hex,a0
	move.b	0(a0,d0.w),d0
	jmp	send
*
*
sendline:
	move.b	(a0)+,d0
	beq	prtok
	move.l	a0,-(sp)
	jsr	send
	move.l	(sp)+,a0
	bra	sendline
*
*
sendn:	cmp.w	#10,d0
	bcs	sdn1
	and.l	#$ffff,d0
	divu	#10,d0
	swap	d0
	move.w	d0,-(sp)
	swap	d0
	jsr	sendn
	move.w	(sp)+,d0
sdn1:	or.b	#"0",d0
	jmp	send
*
*
send:	jmp	$ffffff
*
*
***********************************
***				***
***********************************
	.data

prntbl:	dc.l	prtok,prtok,prtok,prtok,p_init
	dc.l	p_bgndoc,p_bgnpage,p_bgntile
	dc.l	p_block
	dc.l	p_endtile,p_endpage,p_enddoc
	dc.l	prtok,p_ident

scl_tbl:	dc.w	4,2,1,1,2,1,1
xdpi_tbl:	dc.w	75,150,300,300,75,300,300
ydpi_tbl:	dc.w	75,150,300,300,150,300,300
minl_tbl:	dc.w	20,40,80,80,20,80,80
minr_tbl:	dc.w	20,40,80,80,20,80,80
mint_tbl:	dc.w	14,28,56,56,28,56,56
minb_tbl:	dc.w	14,28,56,56,28,56,56
maxw_tbl:	dc.l	600,1200,2400,2400,600,2400,2400
maxh_tbl:	dc.l	0,0,0,0,0,0,0,0

s_form:		dc.l	0
s_xmin:		dc.w	0
s_ymin:		dc.w	0
s_nxln:		dc.w	0
b_width:	dc.w	0
b_height:	dc.w	0
d_xmin:		dc.w	0
d_ymin:		dc.w	0
sclfactor:	dc.w	0


driver:		dc.b	"Atari SLM804 laser v2.0",0
hex:		dc.b	"0123456789ABCDEF"

	.bss
temp:		ds.l	1
tcopy:		ds.w	1
scale:		ds.w	1

