 include "prtequ.h"

*
* HP DeskJet print driver
*
CR	equ	$d
LF	equ	$a
FF	equ	$c
ESC	equ	$1b
DC2	equ	$12

 SECTION printer,CODE,PUBLIC
***************************************************************
***************************************************************
***************************************************************
dumbentry:
	clr.l	d0
	rts

	dc.l	"PRNT"
	dc.w	200

*
* distribute the calls the the appropriate routines
*
hpdesk:
	move.l	a0,table
	lsl.w	#2,d0
	lea	prntbl,a1
	move.l	0(a1,d0.w),a1
	jmp	(a1)

*
* identify who I am, and set up who I like to speak to.
*
p_ident:
	move.l	#driver,pdrvrnm(a0)	;pointer to string for driver name
	move.w	#PARALLEL+ASCENDING,device(a0)
prtok:	moveq	#1,d0
	rts

*
* initialize the table of printer specific routines
*
p_init:	move.l	#driver,pdrvrnm(a0)	;pointer to string for driver name
	clr.b	pdl(a0)			;no page description language
	clr.b	pmult(a0)		;automatically print mulitiple copies?
	clr.b	pman(a0)		;handle manual feed?
	move.b	#PRT_BW,ptype(a0)	;printer type?

	move.l	sendout(a0),send+2	;self-modifing code, tisk, tisk!


*
* pminlft and pmaxw must be evenly divisible by 16
* this is the part that should be worked out
*

	move.w	pdensity(a0),d0
	cmp.w	#7,d0
	bcs	pint1
	moveq	#6,d0
pint1:	lsl.w	#1,d0

	lea	xdpi_tbl,a1
	move.w	0(a1,d0.w),pxdpi(a0)	;x resolution
	lea	ydpi_tbl,a1
	move.w	0(a1,d0.w),pydpi(a0)	;y resolution
	lea	minl_tbl,a1
	move.w	0(a1,d0.w),pminlft(a0)	;pixels from the left
	lea	minr_tbl,a1
	move.w	0(a1,d0.w),pminrht(a0)	;pixels from the right
	lea	mint_tbl,a1
	move.w	0(a1,d0.w),pmintop(a0)	;pixels down from top
	lea	minb_tbl,a1
	move.w	0(a1,d0.w),pminbot(a0)	;pixels up from bottom
	lea	xover_tbl,a1
	move.w	0(a1,d0.w),pxover(a0)	;percentage of x overlap of dots
	lea	yover_tbl,a1
	move.w	0(a1,d0.w),pyover(a0)	;percentage of y overlap of dots
	lea	rowht_tbl,a1
	move.w	0(a1,d0.w),prowht(a0)	;rows height modula
	move.w	0(a1,d0.w),rowht
	lea	rows_tbl,a1
	move.w	0(a1,d0.w),rows

	lsl.w	#1,d0
	lea	maxw_tbl,a1
	move.l	0(a1,d0.w),pmaxw(a0)	;maximum # pixels across
	lea	maxh_tbl,a1
	move.l	0(a1,d0.w),pmaxh(a0)	;maximum # pixels down
	lea	grmode_tbl,a1
	move.l	0(a1,d0.w),grmode
	bra	prtok

*
* going to begin printing a document
*
p_bgndoc:
	tst.b	pmanual(a0)		;manual paper feed?
	bne	pmanfeed
*
	lea	rstr8a,a0		;paper tray feed
	bra	sendline
*
pmanfeed:
	lea	rstr8b,a0		;manual paper feed
	bra	sendline

*
* about to start printing of a page
*
p_bgnpage:
	bra	prtok

*
* about to print a new tile for the page
*
p_bgntile:
	move.l	grmode,a0		;set the density
	bsr	sendline

	move.l	table,a0
	move.w	pcopies(a0),d0

	bsr	sendn
	move.b	#"X",d0
	bsr	send

	lea	rstr2,a0		;set to top posistion
	bsr	sendline

	lea	rstr4,a0		;start raster graphics at current
	bra	sendline		;posistion

*
* print a block to the printer
*
p_block:
	move.l	table,a0
	move.l	pblockw(a0),width
	move.l	pblockptr(a0),a1
	move.l	(a1),a1
	add.l	pblockoff(a0),a1
	move.l	a1,v_base

	move.l	width,d0
	move.l	v_base,a0
putln1:	tst.b	-1(a0,d0.l)
	bne	putln2
	subq.l	#1,d0
	bne	putln1
	moveq	#1,d0
putln2:	move.l	d0,twidth

	lea	rstr5,a0		;start raster graphics transfer
	bsr	sendline		; with # of bytes to follow
	move.l	twidth,d0
	bsr	sendn
	move.b	#"W",d0
	bsr	send
*
	move.l	twidth,d1
	move.l	v_base,a0
putln3:	move.b	(a0)+,d0
	move.l	a0,-(sp)
	move.l	d1,-(sp)
	bsr	send
	move.l	(sp)+,d1
	move.l	(sp)+,a0
	subq.l	#1,d1
	bne	putln3
	bra	prtok
*

*
* just finished describing current tile
*
p_endtile:
	lea	rstr6,a0
	bsr	sendline
	lea	rstr7,a0		;print the page (multiple copies)
	bra	sendline

*
* just finished describing all tiles for this page
*
p_endpage:
	bra	prtok

*
* finished printing the document
*
p_enddoc:
	bra	prtok

***************************************************
***	these are the send routines for the	***
***	dot matrix driver.			***
***************************************************
*
sendline:
	move.b	(a0)+,d0
	beq	prtok
	move.l	a0,-(sp)
	bsr	send
	move.l	(sp)+,a0
	bra	sendline
*
*
sendn:	cmp.w	#10,d0
	bcs	sdn1
	and.l	#$ffff,d0
	divu	#10,d0
	swap	d0
	move.w	d0,-(sp)
	swap	d0
	bsr	sendn
	move.w	(sp)+,d0
sdn1:	or.b	#"0",d0
*
*	bra	send
*
*
send:	jmp	$ffffff
*
*
***********************************
***				***
***********************************
 SECTION printer,DATA,PUBLIC

prntbl:	dc.l	prtok,prtok,prtok,prtok,p_init
	dc.l	p_bgndoc,p_bgnpage,p_bgntile
	dc.l	p_block
	dc.l	p_endtile,p_endpage,p_enddoc
	dc.l	prtok,p_ident


xdpi_tbl:	dc.w	75,100,150,300,300,300,300
ydpi_tbl:	dc.w	75,100,150,300,300,300,300
minl_tbl:	dc.w	20,26,40,80,80,80,80
minr_tbl:	dc.w	20,26,40,80,80,80,80
mint_tbl:	dc.w	14,19,28,56,56,56,56
minb_tbl:	dc.w	14,19,28,56,56,56,56
maxw_tbl:	dc.l	600,800,1200,2400,2400,2400,2400
maxh_tbl:	dc.l	0,0,0,0,0,0,0
xover_tbl:	dc.w	0,0,0,0,0,0,0
yover_tbl:	dc.w	0,0,0,0,0,0,0
rowht_tbl:	dc.w	1,1,1,1,1,1,1
rows_tbl:	dc.w	1,1,1,1,1,1,1
grmode_tbl:	dc.l	rstr1d,rstr1c,rstr1b,rstr1a,rstr1a,rstr1a,rstr1a


driver:		dc.b	"HP DeskJet v2.0",0


rstr1a:	dc.b	ESC,"*t300R",ESC,"&l0E",ESC,"&l",0	;for 300 dpi
rstr1b:	dc.b	ESC,"*t150R",ESC,"&l0E",ESC,"&l",0	;for 150 dpi
rstr1c:	dc.b	ESC,"*t100R",ESC,"&l0E",ESC,"&l",0	;for 100 dpi
rstr1d:	dc.b	ESC,"*t75R",ESC,"&l0E",ESC,"&l",0	;for 75 dpi

rstr2:	dc.b	ESC,"&a135V",ESC,"&a0H",0		;posistion in upper left
rstr4:	dc.b	ESC,"*r1A",0
rstr5:	dc.b	ESC,"*b",0
rstr6:	dc.b	ESC,"*rB",0
rstr7:	dc.b	ESC,"E",0

rstr8a:	dc.b	ESC,"&l1H",0				;paper tray feed
rstr8b:	dc.b	ESC,"&l2H",0				;manual paper feed

 SECTION printer,BSS,PUBLIC
table:		ds.l	1
twidth:		ds.l	1
v_base:		ds.l	1
width:		ds.l	1
rows:		ds.w	1
rowht:		ds.w	1
grmode:		ds.l	1
