 include "prtequ.h"

*
* Canon Bubble-Jet 130e print driver
*
CR	equ	$d
LF	equ	$a
FF	equ	$c
ESC	equ	$1b
FS	equ	$1c
BACK	equ	"\\"

 SECTION printer,CODE,PUBLIC
***************************************************************
***************************************************************
***************************************************************
dumbentry:
	clr.l	d0
rrts:	rts

	dc.l	"PRNT"
	dc.w	200

*
* distribute the calls to the appropriate routines
*
BJ130e:	move.l	a0,table
	lsl.w	#2,d0
	lea	prntbl,a1
	move.l	0(a1,d0.w),a1
	jmp	(a1)

*
* identify who I am, and set up who I like to speak to.
*
p_ident:
	move.l	#driver,pdrvrnm(a0)	;pointer to string for driver name
	move.w	#PARALLEL+ASCENDING,device(a0)
prtok:	moveq	#1,d0
	rts

*
* initialize the table of printer specific routines
*
p_init:	clr.b	pdl(a0)			;no page description language
	clr.b	pmult(a0)		;automatically print mulitiple copies?
	clr.b	pman(a0)		;handle manual feed?
	move.b	#PRT_BW,ptype(a0)	;printer type?

	move.l	sendout(a0),send+2	;self-modifing code, tisk, tisk!
*
* pminlft and pmaxw must be evenly divisible by 16
* this is the part that should be worked out
*

	move.w	pdensity(a0),d0
	cmp.w	#7,d0
	bcs	pint1
	moveq	#6,d0
pint1:	lsl.w	#1,d0

	lea	xdpi_tbl,a1
	move.w	0(a1,d0.w),pxdpi(a0)	;x resolution
	lea	ydpi_tbl,a1
	move.w	0(a1,d0.w),pydpi(a0)	;y resolution
	lea	minl_tbl,a1
	move.w	0(a1,d0.w),pminlft(a0)	;pixels from the left
	lea	minr_tbl,a1
	move.w	0(a1,d0.w),pminrht(a0)	;pixels from the right
	lea	mint_tbl,a1
	move.w	0(a1,d0.w),pmintop(a0)	;pixels down from top
	lea	minb_tbl,a1
	move.w	0(a1,d0.w),pminbot(a0)	;pixels up from bottom
	lea	xover_tbl,a1
	move.w	0(a1,d0.w),pxover(a0)	;percentage of x overlap of dots
	lea	yover_tbl,a1
	move.w	0(a1,d0.w),pyover(a0)	;percentage of y overlap of dots
	lea	rowht_tbl,a1
	move.w	0(a1,d0.w),prowht(a0)	;rows height modula

	lea	grmode_tbl,a1
	move.w	0(a1,d0.w),grmode

	lsl.w	#1,d0
	lea	maxw_tbl,a1
	move.l	0(a1,d0.w),pmaxw(a0)	;maximum # pixels across
	lea	maxh_tbl,a1
	move.l	0(a1,d0.w),pmaxh(a0)	;maximum # pixels down
	bra	prtok


*
* going to begin printing a document
*
p_bgndoc:
	bra	prtok

*
* about to start printing of a page
*
p_bgnpage:
	lea	bgnpage,a0
	bsr	sendline
	moveq	#4,d0
	bsr	send
	moveq	#0,d0
	bsr	send
	moveq	#0,d0
	bsr	send
	moveq	#0,d0
	bsr	send
	move.w	#180,d0
	bsr	send
	moveq	#0,d0
	bsr	send

	bra	prtok

*
* about to print a new tile for the page
*
p_bgntile:
	bra	prtok

*
* print a block to the printer
*
p_block:
	move.l	table,a0
	move.l	pblockw(a0),d0
	move.w	d0,width
	move.l	pblockptr(a0),a1
	move.l	(a1),a1
	add.l	pblockoff(a0),a1
	move.l	a1,v_base

*
*print the block
*
printt:	move.l	v_base,lineptr
	bsr	putline			;first 48

	lea	linefeed,a0
	bra	sendline


**************************************
putline:
	move.l	lineptr,a0
	clr.w	twidth
	move.w	#47,d1
print0:	move.w	width,d0
print1:	tst.b	-1(a0,d0.w)
	bne	print2
	subq.w	#1,d0
	bne	print1
print2:	cmp.w	twidth,d0
	bls	print3
	move.w	d0,twidth
print3:	add.w	width,a0
	dbf	d1,print0
	tst.w	twidth
	beq	rrts

*
	lea	setgr,a0
	bsr	sendline
	move.w	twidth,d0		;send number of graphic bytes to follow
	mulu	#48,d0
	addq.w	#1,d0
	bsr	send
	move.w	twidth,d0	
	mulu	#48,d0
	addq.w	#1,d0
	lsr.w	#8,d0
	bsr	send
	move.w	grmode,d0
	bsr	send

	move.w	twidth,d2                 ;length of the data in byte
print4:	move.w	d2,twidth
	moveq	#7,d4
print6:	move.w	d4,pixel
	moveq	#5,d3
	move.l	lineptr,a0
print5:	move.w	d3,bytes
	moveq	#7,d1
	moveq	#0,d0
*
s1:	btst	d4,(a0)
	beq 	s2
	bset	d1,d0
s2:	add.w	width,a0
	dbf	d1,s1
	move.l	a0,-(sp)
	bsr	send
	move.l	(sp)+,a0
*
	move.w	pixel,d4
	move.w	bytes,d3
	dbf	d3,print5
*
	move.w	pixel,d4
	dbf	d4,print6
*
	add.l	#1,lineptr
	move.w	twidth,d2
	subq.w	#1,d2
	bgt	print4
*
	bra	prtok

************************************
*
* just finished describing current tile
*
p_endtile:
	move.l	table,a0
	move.l	pblockh(a0),d0
	rts
*
* just finished describing all tiles for this page
*
p_endpage:
	bra	prtok

*
* finished printing the document
*
p_enddoc:
	bra	prtok

*
* user requested stop
*
p_break:
	bra	p_endtile

***************************************************
***	these are the send routines for the	***
***	dot matrix driver.			***
***************************************************
sendline:
	move.b	(a0)+,d0
	beq	prtok
	move.l	a0,-(sp)
	bsr	send
	move.l	(sp)+,a0
	bra	sendline

send:	jmp	$ffffff

***********************************
***				***
***********************************
 SECTION printer,DATA,PUBLIC

prntbl:	dc.l	prtok,prtok,prtok,prtok,p_init
	dc.l	p_bgndoc,p_bgnpage,p_bgntile
	dc.l	p_block
	dc.l	p_endtile,p_endpage,p_enddoc
	dc.l	p_break,p_ident

xdpi_tbl:	dc.w	120,180,240,360,360,360,360
ydpi_tbl:	dc.w	360,360,360,360,360,360,360
minl_tbl:	dc.w	30,45,60,90,90,90,90
minr_tbl:	dc.w	30,45,60,90,90,90,90
mint_tbl:	dc.w	0,0,0,0,0,0,0
minb_tbl:	dc.w	0,0,0,0,0,0,0
maxw_tbl:	dc.l	960,1440,1920,2880,2880,2880,2880
maxh_tbl:	dc.l	0,0,0,0,0,0,0
xover_tbl:	dc.w	0,0,0,0,0,0,0
yover_tbl:	dc.w	0,0,0,0,0,0,0
rowht_tbl:	dc.w	48,48,48,48,48,48,48
grmode_tbl:	dc.w	13,14,15,16,16,16,16


driver:		dc.b	"Canon BJ130e v2.0.4 beta",0
setgr:		dc.b	ESC,"[g",0
bgnpage:	dc.b	ESC,"[",BACK,0
linefeed:	dc.b	CR,ESC,"J",24,0

 SECTION printer,BSS,PUBLIC
table:		ds.l	1
twidth:		ds.w	1
pixel:		ds.w	1
v_base:		ds.l	1
bytes:		ds.w	1
lineptr:	ds.l	1
width:		ds.w	1
count:		ds.w	1
grmode:		ds.w	1
rowht:		ds.w	1
scroll:		ds.w	1

; v2.0.4 fixed problem of line spacing to far?
;
; v2.0.3 was reseting lineptr to top after each byte was sent in a row. fixed
;
; v2.0.2 fixed problem of sending length down that was 1/8 what it needed
;  to be.
