 include "prtequ.h"

*
* Ansi x3.64 print driver
*
CR	equ	$d
LF	equ	$a
FF	equ	$c
ESC	equ	$1b


 SECTION printer,CODE,PUBLIC
***************************************************************
***************************************************************
***************************************************************
dumbentry:
	clr.l	d0
	rts

	dc.l	"PRNT"
	dc.w	200
*
*
* distribute the calls the the appropriate routines
*
ansi:	move.l	a0,table
	lsl.w	#2,d0
	lea	prntbl,a1
	move.l	0(a1,d0.w),a1
	jmp	(a1)

*
* identify who I am, and set up who I like to speak to.
*
p_ident:
	move.l	#driver,pdrvrnm(a0)	;pointer to string for driver name
	move.w	#PARALLEL+ASCENDING,device(a0)
prtok:	moveq	#1,d0
	rts

*
* initialize the table of printer specific routines
*
p_init:	move.l	#driver,pdrvrnm(a0)	;pointer to string for driver name
	clr.b	pdl(a0)			;no page description language
	clr.b	pmult(a0)		;automatically print mulitiple copies?
	clr.b	pman(a0)		;handle manual feed?
	move.b	#PRT_BW,ptype(a0)	;printer type?
	move.l	sendout(a0),send+2	;self-modifing code, tisk, tisk!

*
* pminlft and pmaxw must be evenly divisible by 16
* this is the part that should be worked out
*

	move.w	pdensity(a0),d0
	cmp.w	#7,d0
	bcs	pint1
	moveq	#6,d0
pint1:	lsl.w	#1,d0

	lea	xdpi_tbl,a1
	move.w	0(a1,d0.w),pxdpi(a0)	;x resolution
	lea	ydpi_tbl,a1
	move.w	0(a1,d0.w),pydpi(a0)	;y resolution

	lea	minl_tbl,a1
	move.w	0(a1,d0.w),pminlft(a0)	;pixels from the left
	lea	minr_tbl,a1
	move.w	0(a1,d0.w),pminrht(a0)	;pixels from the right
	lea	mint_tbl,a1
	move.w	0(a1,d0.w),pmintop(a0)	;pixels down from top
	lea	minb_tbl,a1
	move.w	0(a1,d0.w),pminbot(a0)	;pixels up from bottom
	lea	xover_tbl,a1
	move.w	0(a1,d0.w),pxover(a0)	;percentage of x overlap of dots
	lea	yover_tbl,a1
	move.w	0(a1,d0.w),pyover(a0)	;percentage of y overlap of dots
	lea	rowht_tbl,a1
	move.w	0(a1,d0.w),prowht(a0)	;rows height modula

	move.w	0(a1,d0.w),rowht
	lea	rows_tbl,a1
	move.w	0(a1,d0.w),rows
	lsl.w	#1,d0
	lea	grmode_tbl,a1
	move.l	0(a1,d0.w),grmode
	lea	maxw_tbl,a1
	move.l	0(a1,d0.w),pmaxw(a0)	;maximum # pixels across
	lea	maxh_tbl,a1
	move.l	0(a1,d0.w),pmaxh(a0)	;maximum # pixels down
	bra	prtok


*
* going to begin printing a document
*
p_bgndoc:
	lea	bgndoc,a0
	bra	sendline

*
* about to start printing of a page
*
p_bgnpage:
	bra	prtok

*
* about to print a new tile for the page
*
p_bgntile:
	move.l	grmode,a0		;set the density
	bra	sendline

*
* print a block to the printer
*
p_block:
	move.l	table,a0
	move.l	pblockw(a0),d0
	move.w	d0,width
	move.l	pblockptr(a0),a1
	move.l	(a1),a1
	add.l	pblockoff(a0),a1
	move.l	a1,v_base

	move.w	width,d0
	move.l	v_base,a0
putln1:	tst.b	-1(a0,d0.w)
	bne	putln2
	subq.w	#1,d0
	bne	putln1
	moveq	#1,d0
putln2:	move.w	d0,twidth

*
	move.w	twidth,d1
	move.l	v_base,a0
putln3:	cmpi.b	#ESC,(a0)
	beq	putln4
	cmpi.b	#CR,(a0)
	beq	putln4
	cmpi.b	#LF,(a0)
	beq	putln4
	cmpi.b	#FF,(a0)
	bne	putln5

putln4:	move.l	a0,-(sp)
	move.w	d1,-(sp)
	move.b	#ESC,d0
	bsr	send
	move.w	(sp)+,d1
	move.l	(sp)+,a0
putln5:	move.b	(a0)+,d0
	move.l	a0,-(sp)
	move.w	d1,-(sp)
	bsr	send
	move.w	(sp)+,d1
	move.l	(sp)+,a0
	subq.w	#1,d1
	bne	putln3
	lea	endline,a0
	bra	sendline
*

*
* just finished describing current tile
*
p_endtile:
	lea	endtile,a0
	bra	sendline

*
* just finished describing all tiles for this page
*
p_endpage:
	bra	prtok

*
* finished printing the document
*
p_enddoc:
	bra	prtok

***************************************************
***	these are the send routines for the	***
***	dot matrix driver.			***
***************************************************
*
sendline:
	move.b	(a0)+,d0
	beq	prtok
	move.l	a0,-(sp)
	bsr	send
	move.l	(sp)+,a0
	bra	sendline
*
*
sendn:	cmp.w	#10,d0
	bcs	sdn1
	and.l	#$ffff,d0
	divu	#10,d0
	swap	d0
	move.w	d0,-(sp)
	swap	d0
	bsr	sendn
	move.w	(sp)+,d0
sdn1:	or.b	#"0",d0
*
*	bra	send
*
*
send:	jmp	$ffffff
*
*
***********************************
***				***
***********************************
 SECTION printer,DATA,PUBLIC
prntbl:	dc.l	prtok,prtok,prtok,prtok,p_init
	dc.l	p_bgndoc,p_bgnpage,p_bgntile
	dc.l	p_block
	dc.l	p_endtile,p_endpage,p_enddoc
	dc.l	prtok,p_ident


xdpi_tbl:	dc.w	60,75,100,150,300,300,300
ydpi_tbl:	dc.w	60,75,100,150,300,300,300
minl_tbl:	dc.w	15,20,26,40,80,80,80
minr_tbl:	dc.w	15,20,26,40,80,80,80
mint_tbl:	dc.w	11,14,19,28,56,56,56,56
minb_tbl:	dc.w	11,14,19,28,56,56,56,56
maxw_tbl:	dc.l	480,600,800,1200,2400,2400,2400
maxh_tbl:	dc.l	0,0,0,0,0,0,0
xover_tbl:	dc.w	0,0,0,0,0,0,0
yover_tbl:	dc.w	0,0,0,0,0,0,0
rowht_tbl:	dc.w	1,1,1,1,1,1,1
rows_tbl:	dc.w	1,1,1,1,1,1,1
grmode_tbl:	dc.l	res60,res75,res100,res150,res300,res300,res300

driver:		dc.b	"QMS Kiss ansi3.64 beta",0

bgndoc:		dc.b	ESC,"[1r",0
endline:	dc.b	ESC,"C",0
endtile:	dc.b	ESC,"\\",0

res60:		dc.b	ESC,"P3;1;0;0;5;5}",0
res75:		dc.b	ESC,"P3;1;0;0;4;4}",0
res100:		dc.b	ESC,"P3;1;0;0;3;3}",0
res150:		dc.b	ESC,"P3;1;0;0;2;2}",0
res300:		dc.b	ESC,"P3;1;0;0;1;1}",0

 SECTION printer,BSS,PUBLIC
table:	ds.l	1
twidth:	ds.w	1
v_base:	ds.l	1
width:	ds.w	1
count:	ds.w	1
rows:	ds.w	1
rowht:	ds.w	1
grmode:	ds.l	1
