unit Headers;
{Declarations unit for ICONHCKR.PAS.
 Authored by William Brooks for Cub Lea 28/6/97.
 All comments except those in curly braces are those
 of the author.}

interface

const
  IMAGE_DOS_SIGNATURE    = $5A4D;      (* MZ *)
  IMAGE_OS2_SIGNATURE    = $454E;      (* NE *)
  IMAGE_OS2_SIGNATURE_LE = $454C;      (* LE *)
  IMAGE_VXD_SIGNATURE    = $454C;      (* LE *)
  IMAGE_NT_SIGNATURE     = $00004550;  (* PE00 *)

type
  TMZHeader = packed record
    e_Magic    : Word;                      (* Magic Number - MZ *)
    e_cblp     : Word;                      (* Bytes on late page of file *)
    e_cp       : Word;                      (* Pages in file *)
    e_crlc     : Word;                      (* Relocations *)
    e_cparhdr  : Word;                      (* Size of header in paragraphs *)
    e_minalloc : Word;                      (* Minimum extra paragraphs needed *)
    e_maxalloc : Word;                      (* Maximum extra paragraphs needed *)
    e_ss       : Word;                      (* Initial (relative) SS value *)
    e_sp       : Word;                      (* Initial SP value *)
    e_csum     : Word;                      (* Checksum *)
    e_ip       : Word;                      (* Initial IP value *)
    e_cs       : Word;                      (* Initial (relative) CS value *)
    e_lfarlc   : Word;                      (* File Address of relocation tables *)
    e_ovno     : Word;                      (* Overlay number *)
    e_res      : Array [ 0 .. 3 ] of Word;  (* Reserved Words *)
    e_oemid    : Word;                      (* OEM identifier (for e_oeminfo) *)
    e_oeminfo  : Word;                      (* OEM information; e_oemid specific *)
    e_res2     : Array [ 0 .. 9 ] of Word;  (* Reserved words *)
    e_lfanew   : LongInt;                   (* File address of new exe header *)
  end;

type
  TNEHeader = packed record
    ne_magic        : Word;                     (* Magic number NE *)
    ne_ver          : Byte;                     (* Version Number *)
    ne_rev          : Byte;                     (* Revision Number *)
    ne_enttab       : Word;                     (* Offset of Entry Table *)
    ne_cbenttab     : Word;                     (* Number of bytes in Entry Table *)
    ne_crc          : LongInt;                  (* Checksum of whole of file *)
    ne_flags        : Word;                     (* Flag word *)
    ne_autodata     : Word;                     (* Automatic data segment number *)
    ne_heap         : Word;                     (* Initial heap allocation *)
    ne_stack        : Word;                     (* Initial stack allocation *)
    ne_csip         : LongInt;                  (* Initial CS:IP setting *)
    ne_sssp         : LongInt;                  (* Initial SS:SP setting *)
    ne_cseg         : Word;                     (* Count of file segements *)
    ne_cmod         : Word;                     (* Entries in Module Reference Table *)
    ne_cbnrestab    : Word;                     (* Size of non-resident name table *)
    ne_segtab       : Word;                     (* Offset of segment table *)
    ne_rsrctab      : Word;                     (* Offset of resource table *)
    ne_restab       : Word;                     (* Offset of resident name table *)
    ne_modtab       : Word;                     (* Offset of module reference table *)
    ne_imptab       : Word;                     (* Offset of imported names table *)
    ne_nrestab      : LongInt;                  (* Offset of non-resident names table - relative to entire file *)
    ne_cmovent      : Word;                     (* Count of moveable entries *)
    ne_align        : Word;                     (* Segment alignment shift count *)
    ne_cres         : Word;                     (* Count of resource segments *)
    ne_exetyp       : Byte;                     (* Target Operating System *)
    ne_flagsothers  : Byte;                     (* Other .EXE flags *)
    ne_pretthunks   : Word;                     (* Offset to return thunks *)
    ne_psegrefbytes : Word;                     (* Offset to segment reference bytes *)
    ne_swaparea     : Word;                     (* Minimum code swap area size *)
    ne_expver       : Word;                     (* Expected Windows version number *)
  end;

type
  PIMAGE_FILE_HEADER = ^TIMAGE_FILE_HEADER;
  TIMAGE_FILE_HEADER = packed record
    Machine              : WORD;
    NumberOfSections     : WORD;
    TimeDateStamp        : LONGINT;
    PointerToSymbolTable : LONGINT;
    NumberOfSymbols      : LONGINT;
    SizeOfOptionalHeader : WORD;
    Characteristics      : WORD;
  end;

type
  PIMAGE_DATA_DIRECTORY = ^TIMAGE_DATA_DIRECTORY;
  TIMAGE_DATA_DIRECTORY = packed record
    VirtualAddress : LONGINT;
    Size           : LONGINT;
  end;

const
  IMAGE_NUMBEROF_DIRECTORY_ENTRIES = 16;

type
  PIMAGE_OPTIONAL_HEADER = ^TIMAGE_OPTIONAL_HEADER;
  TIMAGE_OPTIONAL_HEADER = packed record
    Magic                       : WORD;
    MajorLinkerVersion          : BYTE;
    MinorLinkerVersion          : BYTE;
    SizeOfCode                  : LONGINT;
    SizeOfInitializedData       : LONGINT;
    SizeOfUninitializedData     : LONGINT;
    AddressOfEntryPoint         : LONGINT;
    BaseOfCode                  : LONGINT;
    BaseOfData                  : LONGINT;
    ImageBase                   : LONGINT;
    SectionAlignment            : LONGINT;
    FileAlignment               : LONGINT;
    MajorOperatingSystemVersion : WORD;
    MinorOperatingSystemVersion : WORD;
    MajorImageVersion           : WORD;
    MinorImageVersion           : WORD;
    MajorSubsystemVersion       : WORD;
    MinorSubsystemVersion       : WORD;
    Win32VersionValue           : LONGINT;
    SizeOfImage                 : LONGINT;
    SizeOfHeaders               : LONGINT;
    CheckSum                    : LONGINT;
    Subsystem                   : WORD;
    DllCharacteristics          : WORD;
    SizeOfStackReserve          : LONGINT;
    SizeOfStackCommit           : LONGINT;
    SizeOfHeapReserve           : LONGINT;
    SizeOfHeapCommit            : LONGINT;
    LoaderFlags                 : LONGINT;
    NumberOfRvaAndSizes         : LONGINT;
    DataDirectory               : Array [ 0 .. (IMAGE_NUMBEROF_DIRECTORY_ENTRIES - 1)] of TIMAGE_DATA_DIRECTORY;
  end;

type
  PIMAGE_NT_HEADERS = ^TIMAGE_NT_HEADERS;
  TIMAGE_NT_HEADERS = packed record
    Signature      : LONGINT;
    FileHeader     : TIMAGE_FILE_HEADER;
    OptionalHeader : TIMAGE_OPTIONAL_HEADER;
  end;

const
  IMAGE_DIRECTORY_ENTRY_EXPORT         = 0;   
  IMAGE_DIRECTORY_ENTRY_IMPORT         = 1;   
  IMAGE_DIRECTORY_ENTRY_RESOURCE       = 2;   
  IMAGE_DIRECTORY_ENTRY_EXCEPTION      = 3;   
  IMAGE_DIRECTORY_ENTRY_SECURITY       = 4;   
  IMAGE_DIRECTORY_ENTRY_BASERELOC      = 5;   
  IMAGE_DIRECTORY_ENTRY_DEBUG          = 6;   
  IMAGE_DIRECTORY_ENTRY_COPYRIGHT      = 7;
  IMAGE_DIRECTORY_ENTRY_GLOBALPTR      = 8;   
  IMAGE_DIRECTORY_ENTRY_TLS            = 9;   
  IMAGE_DIRECTORY_ENTRY_LOAD_CONFIG    = 10;  
  IMAGE_DIRECTORY_ENTRY_BOUND_IMPORT   = 11;  
  IMAGE_DIRECTORY_ENTRY_IAT            = 12;  

const
  IMAGE_SIZEOF_SHORT_NAME = 8;

type
  PIMAGE_SECTION_HEADER = ^TIMAGE_SECTION_HEADER;
  TIMAGE_SECTION_HEADER = packed record
    Name                 : Array [ 0 .. (IMAGE_SIZEOF_SHORT_NAME - 1) ] of CHAR;
    VirtualSize          : LONGINT;
    VirtualAddress       : LONGINT;
    SizeOfRawData        : LONGINT;
    PointerToRawData     : LONGINT;
    PointerToRelocations : LONGINT;
    PointerToLinenumbers : LONGINT;
    NumberOfRelocations  : WORD;
    NumberOfLinenumbers  : WORD;
    Characteristics      : LONGINT;
  end;

const
  IMAGE_SIZEOF_SECTION_HEADER = 40;

type
  PIMAGE_RESOURCE_DIRECTORY = ^TIMAGE_RESOURCE_DIRECTORY;
  TIMAGE_RESOURCE_DIRECTORY = packed record
    Characteristics      : LONGINT;
    TimeDateStamp        : LONGINT;
    MajorVersion         : WORD;
    MinorVersion         : WORD;
    NumberOfNamedEntries : WORD;
    NumberOfIDEntries    : WORD;
  end;

const
  IMAGE_RESOURCE_NAME_IS_STRING    = $80000000;
  IMAGE_RESOURCE_DATA_IS_DIRECTORY = $80000000;

type
  PIMAGE_RESOURCE_DIRECTORY_ENTRY = ^TIMAGE_RESOURCE_DIRECTORY_ENTRY;
  TIMAGE_RESOURCE_DIRECTORY_ENTRY = packed record
    Name   : LONGINT;
    Offset : LONGINT;
  end;

type
  PIMAGE_RESOURCE_DATA_ENTRY = ^TIMAGE_RESOURCE_DATA_ENTRY;
  TIMAGE_RESOURCE_DATA_ENTRY = packed record
    OffsetToData : LONGINT;
    Size         : LONGINT;
    CodePage     : LONGINT;
    Reserved     : LONGINT;
  end;

type
  PICON_HEADER = ^TICON_HEADER;
  TICON_HEADER = packed record
    wReserved : WORD;
    wType     : WORD;
    wCount    : WORD;
  end;

type
  PFILE_ICON_HEADER = ^TFILE_ICON_HEADER;
  TFILE_ICON_HEADER = packed record
    wReserved : WORD;
    wType     : WORD;
    wCount    : INTEGER;
  end;

type
  TICON_RESOURCE = packed record
    bWidth       : BYTE;
    bHeight      : BYTE;
    bColorCount  : BYTE;
    bReserved    : BYTE;
    wPlanes      : WORD;
    wBitCount    : WORD;
    lBytesInRes  : LONGINT;
    wNameOrdinal : WORD;
  end;

type
  TFILE_ICON_RESOURCE = packed record
    bWidth       : BYTE;
    bHeight      : BYTE;
    bColorCount  : BYTE;
    bReserved    : BYTE;
    wPlanes      : WORD;
    wBitCount    : WORD;
    lBytesInRes  : LONGINT;
    lImageOffset : LONGINT;
  end;

implementation
{


   DW   Alignment shift count for resource data.

   A table of resource type information blocks follows. The following
   is the format of each type information block:

        DW  Type ID. This is an integer type if the high-order bit is
            set (8000h); otherwise, it is an offset to the type string,
            the offset is relative to the beginning of the resource
            table. A zero type ID marks the end of the resource type
            information blocks.

        DW  Number of resources for this type.

        DD  Reserved.

        A table of resources for this type follows. The following is
        the format of each resource (8 bytes each):

            DW  File offset to the contents of the resource data,
                relative to beginning of file. The offset is in terms
                of the alignment shift count value specified at
                beginning of the resource table.

            DW  Length of the resource in the file (in bytes).

            DW  Flag word.
                0010h = MOVEABLE  Resource is not fixed.
                0020h = PURE      Resource can be shared.
                0040h = PRELOAD   Resource is preloaded.

            DW  Resource ID. This is an integer type if the high-order
                bit is set (8000h), otherwise it is the offset to the
                resource string, the offset is relative to the
                beginning of the resource table.

            DD  Reserved.

   Resource type and name strings are stored at the end of the
   resource table. Note that these strings are NOT null terminated and
   are case sensitive.

   DB   Length of the type or name string that follows. A zero value
        indicates the end of the resource type and name string, also
        the end of the resource table.

   DB   ASCII text of the type or name string.
}
end.
