## Makefile for compiling GNU touch from GNU fileutils 3.12
##   using Microsoft C compiler under MS-DOS
## Author: Cosmin Truta, Babes-Bolyai University, Cluj-Napoca, Romania, 1995
## Note: this makefile must be in the "fileutils-3.12/src" directory
##   and it assumes a unix-type "sed" program

CL = cl

CLOPT = -Ox -Os

TOUCH_OBJS = \
 touch.obj \
 version.obj \
 argmatch.obj \
 error.obj \
 ftruncat.obj \
 fullwrit.obj \
 getdate.obj \
 getopt.obj \
 getopt1.obj \
 posixtm.obj \
 saferead.obj

touch.exe: config.h system.h safe-stat.h $(TOUCH_OBJS)
	$(CL) $(CLOPT) $(TOUCH_OBJS)

.c.obj:
	$(CL) -c $(CLOPT) -DHAVE_CONFIG_H -I. -I..\lib $<

config.h: config.dos
	copy config.dos config.h

system.h: pathmax.h

argmatch.c:
	copy ..\lib\argmatch.c argmatch.c

error.c:
	copy ..\lib\error.c error.c

ftruncat.c:
	copy ..\lib\ftruncate.c ftruncat.c

fullwrit.c:
	copy ..\lib\full-write.c fullwrit.c

getdate.c:
	copy ..\lib\getdate.c getdate.c

getopt.c:
	copy ..\lib\getopt.c getopt.c

getopt1.c:
	copy ..\lib\getopt1.c getopt1.c

posixtm.c:
	sed /#define.YYDEBUG.1/s/1/0/ ..\lib\posixtm.c > posixtm.c

saferead.c:
	copy ..\lib\safe-read.c saferead.c

pathmax.h:
	echo /***/ > pathmax.h

safe-stat.h:
	echo /***/ > safe-stat.h

