'
'                ---  selftest.bas ---
'
'  SELFTEST requires two serial ports on the same computer. The
'  program transmits a test string on one port (FirstCOM) and
'  receives on a second port (SecondCOM), where the two ports are
'  connected via a null modem adapter. The received string is tested
'  against the transmit string (they should be idenical).
'
'  Connect the two serial ports (on a single computer) together
'  using a null modem cable. Be sure to modify the configuration
'  section for non-standard PC ports or to setup your multiport
'  board. Note that many multiport boards are either Digiboard or
'  BOCA board compatible.
'
'  Both ports can be the same port.
'
'  To run from the VB IDE, type:
'
'       VBDOS /LPCL4VB.QLB SELFTEST.BAS
'

'$INCLUDE: 'PCL4VB.BI'

DECLARE SUB ErrorCheck(BYVAL Code AS INTEGER)
DECLARE SUB ShutDown(FirstCOM AS INTEGER, SecondCOM AS INTEGER)

CONST PC = 1
CONST DB = 2
CONST BB = 3

' Serial I/O buffers

RxBuf256One$ = STRING$(256+16,0)
RxBuf256Two$ = STRING$(256+16,0)
TxBuf256One$ = STRING$(256+16,0)
TxBuf256Two$ = STRING$(256+16,0)

' Global Variables

DIM BaudCode AS INTEGER
DIM TestString AS STRING
DIM TestLength AS INTEGER
DIM FirstCOM AS INTEGER
DIM SecondCOM AS INTEGER
DIM Port AS INTEGER
DIM ComLimit AS INTEGER
DIM C AS INTEGER
DIM TheSwitch AS INTEGER
DIM LibVer AS INTEGER
DIM I AS INTEGER
DIM L AS INTEGER
DIM Code AS INTEGER
DIM BufSeg AS INTEGER
DIM PARMS AS STRING
DIM ARGS(10) AS STRING
DIM NARGS AS INTEGER
DIM X AS STRING
DIM Rates(9) AS STRING
DIM UartString(4) AS STRING

' initialize

BaudCode = -1
TheSwitch = 0
TestString = "This is a test string ABCDEFGHIJKLMNOPQRSTUVWXYZ"

Rates$(1) = "300"
Rates$(2) = "1200"
Rates$(3) = "2400"
Rates$(4) = "4800"
Rates$(5) = "9600"
Rates$(6) = "19200"
Rates$(7) = "38400"
Rates$(8) = "57600"
Rates$(9) = "115200"

'init UART type strings
UartString(0) = "8250/16450"
UartString(1) = "16550"
UartString(2) = "16650"
UartString(3) = "16750"

' get arguments

NARGS = 0
PARMS = LTRIM$(RTRIM$(COMMAND$)) + " "
DO
   I = INSTR(PARMS, " ")
   L = LEN(PARMS)
   IF I <= 1 THEN EXIT DO
   NARGS = NARGS + 1
   ARGS(NARGS) = UCASE$(LEFT$(PARMS, I - 1))
   PARMS = LTRIM$(MID$(PARMS,I,L-I+1))
LOOP

IF NARGS <> 4 THEN
   PRINT "Usage: selftest {pc|db|bb} 1stCom 2ndCom Baudrate"
   END
END IF

PRINT  "SELFTEST 4.0"
LibVer = SioInfo(ASC("V"))
PRINT "  Lib Ver : "; LTRIM$(STR$(LibVer \ 16)); ".";
PRINT LTRIM$(STR$(LibVer MOD 16))
PRINT "  TX Intr : ";
IF SioInfo(ASC("I")) <> 0 THEN
   PRINT "enabled."
ELSE
   PRINT "not enabled."
END IF
IF ARGS(1) = "PC" THEN TheSwitch = PC
IF ARGS(1) = "DB" THEN TheSwitch = DB
IF ARGS(1) = "BB" THEN TheSwitch = BB

IF TheSwitch = 0 THEN
   PRINT "Must specify 'PC', 'DB' or 'BB' as 1st argument"

   PRINT "1st arg ='";ARGS(1);"'"

   PRINT "EG:  SELFTEST PC 1 4"
   END
END IF
IF TheSwitch = PC THEN ComLimit = COM4
IF TheSwitch = DB THEN ComLimit = COM8
IF TheSwitch = BB THEN ComLimit = COM16

FirstCOM = VAL(ARGS(2)) -1
SecondCOM = VAL(ARGS(3)) -1
PRINT " FirstCOM : COM";(1+FirstCOM)
PRINT "SecondCOM : COM";(1+SecondCOM)

'Get baud code
FOR I = 1 TO 9
  IF Rates(I) = ARGS(4) THEN
     BaudCode = I
     EXIT FOR
  END IF
NEXT I
'Verify good baud rate
IF BaudCode = -1 THEN
  PRINT "Cannot recognize baud rate "; ARGS(4)
  END
END IF
PRINT " Baudrate : ";Rates(BaudCode)
IF FirstCOM < COM1 THEN
   PRINT "1stCom must be >= COM1"
   END
END IF
IF SecondCOM > ComLimit THEN
   PRINT "2ndCom must be <= COM",(1+ComLimit)
   END
END IF
IF TheSwitch = DB THEN
   ' Custom Configuration: DigiBoard PC/8
   PRINT "[ Configuring for DigiBoard PC/8 (IRQ5) ]"
   Code = SioPorts(8,COM1,&H140,DIGIBOARD)
   FOR Port = COM1 TO COM8
     ' set DigiBoard UART addresses
      CALL ErrorCheck( SioUART(Port,&H100+8*Port) )
      ' set DigiBoard IRQ
      CALL ErrorCheck( SioIRQ(Port,IRQ5) )
   NEXT Port
END IF
IF TheSwitch = BB THEN
   ' Custom Configuration: BOCA BB2016
   PRINT "[ Configuring for BOCA Board BB2016 (IRQ15) ]"
   Code = SioPorts(16,COM1,&H107,BOCABOARD)
   FOR Port = COM1 TO COM16
     ' set BOCA Board UART addresses
      CALL ErrorCheck( SioUART(Port,&H100+8*Port) )
      ' set BOCA Board IRQ
      CALL ErrorCheck( SioIRQ(Port,IRQ15) )
   NEXT Port
END IF
IF TheSwitch = PC THEN
   ' Standard Configuration
END IF
' set parmameters for FirstCOM
CALL ErrorCheck( SioParms(FirstCOM,NoParity,OneStopBit,WordLength8) )
' use 16650 FIFO if present
Code = SioFIFO(FirstCOM,LEVEL_4TH)
PRINT "     UART : "; UartString(Code)

' setup receive buffer
BufSeg = (1+SSEG(RxBuf256One$)) + (SADD(RxBuf256One$) \ 16)
CALL ErrorCheck( SioRxBuf(FirstCOM, BufSeg, Size256) )
IF SioInfo(ASC("I")) <> 0 THEN
   'setup transmit buffer
   BufSeg = (1+SSEG(TxBuf256One$)) + (SADD(TxBuf256One$) \ 16)
   CALL ErrorCheck( SioTxBuf(FirstCOM, BufSeg, Size256) )
END IF
' reset FirstCOM
CALL ErrorCheck( SioReset(FirstCOM, BaudCode) )
'check port assignments
IF SecondCOM <> FirstCOM THEN
  ' set parmameters for SecondCOM
  CALL ErrorCheck( SioParms(SecondCOM,NoParity,OneStopBit,WordLength8) )
  ' use 16650 FIFO if present
  Code = SioFIFO(SecondCOM,LEVEL_8)
  ' setup receive buffer
  BufSeg = (1+SSEG(TxBuf256Two$)) + (SADD(TxBuf256Two$) \ 16)
  CALL ErrorCheck( SioRxBuf(SecondCOM, BufSeg, Size256) )
  IF SioInfo(ASC("I")) <> 0 THEN
     'setup transmit buffer
     BufSeg = (1+SSEG(TxBuf256Two$)) + (SADD(TxBuf256Two$) \ 16)
     CALL ErrorCheck( SioTxBuf(SecondCOM, BufSeg, Size256) )
  END IF
  ' reset SecondCOM
  CALL ErrorCheck( SioReset(SecondCOM, BaudCode) )
END IF
PRINT

TestLength = LEN(TestString)
' send string
PRINT "  Sending: ";
FOR I = 1 TO TestLength
   X$ = MID$(TestString,I,1)
   C = ASC(X$)
   Code = SioPutc(FirstCOM,C)
   PRINT X$;
NEXT I
' receive string
PRINT
PRINT "Receiving: ";
FOR I = 1 TO TestLength
   Code = SioGetc(SecondCOM,18)
   IF Code < 0 THEN
       PRINT "ERROR: ";
       Code = SioError(Code)
       CALL ShutDown(FirstCOM,SecondCOM)
    END IF
    ' echo just received char
    PRINT CHR$(Code);
    ' compare character
    X$ = MID$(TestString,I,1)
    IF CHR$(Code) <> X$ THEN
       PRINT
       PRINT "ERROR: Expecting '";X$;"', received '";CHR$(Code)
       CALL ShutDown(FirstCOM,SecondCOM)
    END IF
 NEXT I
 PRINT
 PRINT "SUCCESS: Test AOK !"
 CALL ShutDown(FirstCOM,SecondCOM)
END


SUB ErrorCheck(BYVAL Code AS INTEGER)
' trap PCL error codes
IF Code < 0 THEN
   Code = SioError(Code)
   CALL ShutDown(FirstCOM,SecondCOM)
END IF
END SUB

SUB ShutDown(FirstCOM AS INTEGER, SecondCOM AS INTEGER)
DIM Code AS INTEGER
PRINT "Shutting down COM";(1+FirstCOM)
Code = SioDone(FirstCOM)
IF SecondCOM <> FirstCOM THEN
  PRINT "Shutting down COM";(1+SecondCOM)
  Code = SioDone(SecondCOM)
END IF
END
END SUB


 