{$F+,O+,D-}

unit Font;

interface

procedure LoadFont;
procedure RestoreFont;

implementation

uses
  {$IFDEF DPMI}
  WinAPI, PafDPMI, DPMIUtil, Objects,
  {$ENDIF}
  Dos, Drivers, Graph;

const
   VIDEO   = $10;

procedure Font8x16; external;
{$L FONT8x16.OBJ}

procedure Font8x14; external;
{$L FONT8x14.OBJ}

procedure Font8x8; external;
{$L FONT8x8.OBJ}

{$IFDEF DPMI}
procedure SetFonts (Font: Pointer; Size: Byte; Count: Word);
var
  Regs: TRealModeRegs;
  DosFont: Pointer;
begin
  ClearRegs (Regs);

  with Regs do
  begin
    DosFont := XGlobalDosAlloc (Size * Count, ES);
    Move (Font^, DosFont^, Size * Count);

    AX := $1100;
    BH := Size;
    CX := Count;
  end;

  RealModeInt ($10, Regs);

  XGlobalDosFree (DosFont);
end;
{$ENDIF}

procedure LoadFont;
var
   Gd,Gm: Integer;
   P: Pointer;
   R: Registers;
   Size: Byte;
   Count: Word;
begin
   Count := $100;
   if (ScreenMode and SMFont8X8) = 0 then
   begin
      DetectGraph( Gd,Gm );
      case Gd of
         MCGA,VGA:
         begin
            P := @Font8x16;
            Size := 16;
         end;
         EGA,EGA64,EGAMono:
         begin
            P := @Font8X14;
            Size := 14;
         end;
      end;
   end else
   begin
      P := @Font8X8;
      Size := 8;
   end;
   {$IFDEF DPMI}
   SetFonts (P, Size, Count);
   {$ELSE}
   R.BX := Size * $100;
   R.CX := Count;
   R.DX := 0;
   R.ES := Seg(P^);
   R.BP := Ofs(P^);
   R.AX := $1100;
   Intr( $10,R );
   {$ENDIF}
end;

procedure RestoreFont; assembler;
asm
   mov   ax,$03
   int   VIDEO
end;

end.