{

	picklist.pas
	4-25-90

    Copyright 1990
    John W. Small
    All rights reserved

    PSW / Power SoftWare
    P.O. Box 10072
    McLean, Virginia 22102 8072

}

unit pick;

interface

	uses crt, crtplus, flex;

	type

		PickAttr = (PICK_TITLE_ATTR, PICK_BORDER_ATTR,
					PICK_SCROLL_ATTR, PICK_NORMAL_ATTR,
					PICK_SELECT_ATTR, PICK_HILITE_ATTR);

		PickAttrs = array[PickAttr] of byte;

		PAptr = ^PickAttrs;

		PickList = object(FlexList)
			color, mono, attrs : PAptr;
			x, y, rows, cols, clen, startRow,
            crow, ccol : integer;
			update, finished : boolean;
			title : string;
			w : FramedTextWindow;
			constructor init(pdlen,px,py,
				prows,pcols,pclen : integer;
				ptitle : string);
			procedure   showItem; virtual;
			function    doItem : boolean; virtual;
			procedure   query;
			destructor  done; virtual;
			end;

	var

		PickColorDefaults,
		PickMonoDefaults : PickAttrs;


implementation

	constructor PickList.init(pdlen,px,py,
				prows,pcols,pclen : integer;
				ptitle : string);
		begin
			FlexList.init(pdlen);
			color := @PickColorDefaults;
			mono := @PickMonoDefaults;
			if TxtScr.ColorAttrs then
				attrs := color
			else
				attrs := mono;
			x := px;
			y := py;
			rows := prows;
			cols := pcols;
			clen := pclen;
			title := ptitle
		end;

	procedure   PickList.showItem;
		begin
		end;

	function    PickList.doItem : boolean;
		begin
		end;

	procedure   PickList.query;
		var i : integer;
		begin
			if nodes = 0 then exit;
			if TxtScr.ColorAttrs then
				attrs := color
			else
				attrs := mono;
			w.window(x,y,x+cols*(clen+3),y+rows+1);
			cursor.Off;
			w.frame(attrs^[PICK_BORDER_ATTR],svsh);
			w.titleFooter(true,attrs^[PICK_TITLE_ATTR],title);
			startRow := 1;
			ccol := 1;
			crow := 1;
			update := true;
            finished := false;
			while not finished  do begin
				if update then begin
					update := false;
					crt.textAttr := attrs^[PICK_NORMAL_ATTR];
					clrscr;
					i := (startRow-1)*cols+1;
					mkcur(i);
					while ok and
						(i <= (startRow-1)*cols+rows*cols)
						do begin
						gotoxy(((curNum-1) mod cols) * (clen + 3) + 2,
								(curNum-1) div cols - startRow + 2);
						showItem;
						inc(i);
						mkcur(i)
						end;
					TxtScr.windLightBar((ccol-1)*(clen+3)+1,
						crow-startRow+1,clen+2,attrs^[PICK_SELECT_ATTR]);
					w.scrollBar(true,attrs^[PICK_BORDER_ATTR],svsh,
						attrs^[PICK_SCROLL_ATTR],crow,(nodes-1) div cols + 1)
					end;
				case crtplus.readkey of
					#0: begin
						mkcur((crow-1)*cols+ccol);
						TxtScr.windLightBar((ccol-1)*
							(clen+3)+1, crow-startRow+1,
							clen+2,attrs^[PICK_NORMAL_ATTR]);
						gotoxy(((curNum-1) mod cols) * (clen + 3) + 2,
							(curNum-1) div cols - startRow + 2);
						showItem;
						case char(hi(crtplus.asciiScan)) of
							PgUp: begin
								dec(crow,rows);
								if crow < 1 then crow := 1;
								if crow < startRow then begin
									startRow := crow;
									update := true
									end
								end;
							PgDn: begin
								inc(crow,rows);
								if crow > ((nodes-1) div cols + 1) then
									crow := (nodes-1) div cols+1;
								if crow = (nodes-1) div cols+1 then
									if ccol > ((nodes-1) mod cols + 1) then
										dec(crow);
								if (crow - startRow) >= rows then begin
									startRow := crow - rows + 1;
									update := true
									end
								end;
							Home: begin
								ccol := 1;
								crow := 1;
								if startRow <> 1 then begin
									startRow := 1;
									update := true
									end
								end;
							EndKey: begin
								ccol := (nodes-1) mod cols + 1;
								crow := (nodes-1) div cols + 1;
								if (crow - startRow) >= rows then begin
									startRow := crow - rows + 1;
									update := true
									end
								end;
							UpArr: begin
								if crow > 1 then dec(crow);
								if crow < startRow then begin
									startRow := crow;
									update := true
									end
								end;
							DnArr: begin
								if crow < ((nodes-1) div cols + 1)  then begin
									if (crow+1) = ((nodes-1) div cols+1)  then begin
										if ccol <= ((nodes-1) mod cols+1) then
											inc(crow)
										end
									else
										inc(crow);
									if (crow - startRow) >= rows then begin
										startRow := crow - rows + 1;
										update := true
										end
									end
								end;
							LArr: begin
								if ccol > 1 then
									dec(ccol)
								else if crow > 1 then begin
									dec(crow);
									ccol := cols;
									if crow < startRow then begin
										startRow := crow;
										update := true
										end
									end
								end;
							RArr: begin
								if crow = ((nodes-1) div cols + 1) then begin
									if ccol < ((nodes-1) mod cols + 1) then
										inc(ccol)
									end
								else if ccol < cols then
									inc(ccol)
								else begin
									inc(crow);
									ccol := 1;
									if (crow - startRow) >= rows then begin
										startRow := crow - rows + 1;
										update := true
										end
									end
								end;
						end; { case hi(asciiScan) }
						if not update then begin
							TxtScr.windLightBar((ccol-1)*(clen+3)+1,
								crow-startRow+1,clen+2,attrs^[PICK_SELECT_ATTR]);
							w.scrollBar(true,attrs^[PICK_BORDER_ATTR],svsh,
								attrs^[PICK_SCROLL_ATTR],crow,(nodes-1) div cols + 1)
							end
						end; { #0: }
					ESC: begin
						w.done;
                        finished := true
                        end;
					CR: begin
						mkcur((crow-1)*cols+ccol);
						if doItem then
                           finished := true
                        else if nodes = 0 then
                             finished := true
                        else begin
                             startRow := 1;
                             crow := 1;
                             ccol := 1;
                             update := true;
							 w.frame(attrs^[PICK_BORDER_ATTR],svsh);
							 w.titleFooter(true,attrs^[PICK_TITLE_ATTR],title)
                             end;
						if finished then
                           w.done;
						end;
				end { case crtplus.readkey }
			    end { while not finished }
		end;

	destructor  PickList.done;
		begin
			FlexList.done
		end;

	begin
		PickColorDefaults[PICK_TITLE_ATTR]  := TxtScr.svideo(BLACK,LIGHTGRAY);
		PickColorDefaults[PICK_BORDER_ATTR] := TxtScr.svideo(BLACK,LIGHTGRAY);
		PickColorDefaults[PICK_SCROLL_ATTR] := TxtScr.svideo(RED  ,LIGHTGRAY);
		PickColorDefaults[PICK_NORMAL_ATTR] := TxtScr.svideo(BLACK,LIGHTGRAY);
		PickColorDefaults[PICK_SELECT_ATTR] := TxtScr.svideo(WHITE,BLACK    );
		PickColorDefaults[PICK_HILITE_ATTR] := TxtScr.svideo(RED  ,LIGHTGRAY);
		PickMonoDefaults[PICK_TITLE_ATTR]   := TxtScr.svideo(BLACK,LIGHTGRAY);
		PickMonoDefaults[PICK_BORDER_ATTR]  := TxtScr.svideo(BLACK,LIGHTGRAY);
		PickMonoDefaults[PICK_SCROLL_ATTR]  := TxtScr.svideo(WHITE,LIGHTGRAY);
		PickMonoDefaults[PICK_NORMAL_ATTR]  := TxtScr.svideo(BLACK,LIGHTGRAY);
		PickMonoDefaults[PICK_SELECT_ATTR]  := TxtScr.svideo(WHITE,BLACK    );
		PickMonoDefaults[PICK_HILITE_ATTR]  := TxtScr.svideo(WHITE,LIGHTGRAY);
	end.




