        PAGE 60,132
;       TITLE TESS.INC - TesSeRact Copyright Notice and Data Definitions
;----------------------------------------------------------------------------
;SUBTTL TesSeRact Revision Level 1
;-----------------------------------------------------------------------------
;   TesSeRact(TM) -- A Library of Routines for Creating Ram-Resident (TSR)
;                    programs for the IBM PC and compatible Personal
;                    Computers.
;
;The software, documentation and source code are: 
; 
;       Copyright (C) 1986, 1987, 1988 Tesseract Development Team
;       All Rights Reserved 
; 
;-----------------------------------------------------------------------------
COMMENT | 

     This product  supports the  TesSeRact(TM)  Standard  for  Ram-Resident
     Program Communication.   For  information about TesSeRact, contact the
     TesSeRact Development Team at:
     
          TesSeRact Development Team
          c/o Chip Rabinowitz
          2084 Woodlawn Avenue
          Glenside, PA 19038
          1-215-884-3373
     
          Compuserve:    70731,20
          MCIMAIL:       315-5415
     
     This MCIMAIL  Account has  been provided  to the TesSeRact Development
     Team by Borland International, Inc.  The TesSeRact Development Team is
     in no  way associated with Borland International, Inc.  TesSeRact is a
     trademark of the TesSeRact Development Team.

***************************************************************************
                             Copyright Notice
***************************************************************************

This  document,   other  accompanying  written  and  disk-based  notes  and
specifications, and all referenced and related program files, demonstration
code and  object modules  accompanying this document are copyrighted by the
TesSeRact Development  Team.   The copyright  owner hereby licenses you to:
use the  software; make as many copies of the software and documentation as
you wish;  give exact  copies of the original to anyone; and distribute the
software and  documentation in  its unmodified  form via  electronic means.
There is no charge for any of the above.

You are specifically prohibited from charging, or requesting donations, for
any such  copies, however made.  Exceptions may be granted to organizations
which charge  a small  fee for  materials, handling,  postage  and  general
overhead.  NO   ORGANIZATION  IS   AUTHORIZED  TO  CHARGE  ANY  AMOUNT  FOR
DISTRIBUTION OF  THE SOFTWARE  OR DOCUMENTATION UNDER ANY OTHER CONDITIONS.
Organizations which  charge a fee for distribution of any and all TesSeRact
materials, except  as noted  above or  with the express, written consent of
the TesSeRact  Development Team,  will be  considered in  violation of this
copyright, and will be prosecuted to the full extent of the law.

In addition,  you are specifically prohibited from making any modifications
to the  TesSeRact Library  Routines and/or documentation, unless you have a
license for  the use  of the  source code.   Under  no circumstances is the
copyright notice embedded in the TesSeRact code to be modified or removed.

This is  not free  software.   This license allows you to use this software
without charge  for a period of 30 days.  In order to include this software
as part  of any  product, either commercial, shareware, freeware, or public
domain, registration  is required.   TesSeRact  may not  be included in any
product for  any use  without registration.   Any such use of the TesSeRact
product are in violation of federal copyright laws, and will be prosecuted.

No copy  of the  software may  be distributed  or given  away without  this
accompanying documentation; this notice must not be removed.


***************************************************************************
                                 Warranty
***************************************************************************

There is  no warranty  of any  kind associated  with this software, and the
copyright owner  is not  liable for  damages of  any kind.   By  using this
software, you  agree to  this.  Every effort has been made by the TesSeRact
Development Team  to make  this product  bug-free.   However, the nature of
software development  is  that  it  is  impossible  to  guarantee  bug-free
software.

In the event a verifiable bug is found, the TesSeRact Development Team will
make every  attempt to  repair the  bug as  soon as possible.  

***************************************************************************
                             Acknowledgements
***************************************************************************

Grateful appreciation  is expressed  to CompuServe Information Service, the
IBM Software  Forums and  their Sysops, and Computer Language Magazine, for
providing us  with the  means to  accomplish the  development of TesSeRact.
Without their  gracious assistance,  TesSeRact could  never have  come into
existence.

And let's not forget Anne Marie, who suffered through the long evenings and
nights spent getting this product ready.

***************************************************************************
The TesSeRact Development Team:
***************************************************************************
     
     Team Leader:   Chip Rabinowitz
     Developers:    Lane Ferris
                    Kim Kokkonen
                    Jim Kyle
                    Neil J. Rubenking
                    Barry Simon
                    Rick Wilson
     Contributors:  Thomas Brandenborg
                    Chris Dunford
                    John Friend
                    Mark Horvatich
                    John Hensley
     Advisors:      Robert Bierman
                    David Intersimone
                    Rick Kraus
                    David Moskowitz
                    Gary Saxer

***************************************************************************

|                                       ; end of comment block


Pascal equ 1                            ;defined for mixed.inc

;
; dos delimiters and other utility equates
;
CR              equ     0dh
LF              equ     0ah
SPACE           equ     ' '
COMMA           equ     ','
SEMICOLON       equ     ';'
EQUAL_SIGN      equ     '='
TAB             equ     9

;
; These are the bits of the shift register at absolute 40:17 HEX
;
ALTBIT          equ     08h
CTLBIT          equ     04h
LSHBIT          equ     02h
RSHBIT          equ     01h

;
; These are the keyboard ports
;
KB_DATA         equ     60h
KB_CTL          equ     61h

;
; BIOS data areas
;
KB_FLG1         equ     17h
KB_FLG2         equ     18h
BIOS_DATA       equ     40h

;
; Command word 3 of the 8259 interrupt ctrlr
;
OCW3_8259       equ     20h


;------------------------------------------------------------------------------
;       Text Equates for Global Variables
;------------------------------------------------------------------------------

TsrIntTable struc
        OldVector       dd  ?           ;Old Interrupt Vector
        IntNumber       db  ?           ;Interrupt Number
        NewVector       dw  ?           ;offset of new vector
TsrIntTable ends

ExtraHot struc
        ExtHotKey       db  ?           ;hotkey to check for
        ShiftState      db  ?           ;shift state for this hot key
        FlagByte        db  ?           ;flag value to use
                                        ; MAY NOT BE ZERO!!!
ExtraHot ends

REVLVL        equ  <TESS_GLOBALS>       ;Revision Level of TESS Lib
SAVEDINDOSFLG equ  <TESS_GLOBALS + 1>   ;Type of popup in effect
WASINT8       equ  <TESS_GLOBALS + 2>   ;An Interrupt 08h occurred
WASINT13      equ  <TESS_GLOBALS + 3>   ;An Interrupt 13h occurred
INTFLAGS      equ  <TESS_GLOBALS + 4>   ;Which interrupts are active
SOFTINTFLAGS  equ  <TESS_GLOBALS + 5>   ;Which soft ints are active
DOSVERSION    equ  <TESS_GLOBALS + 6>   ;current major revision of DOS
WAITCOUNT     equ  <TESS_GLOBALS + 7>   ;Count to wait before popping up
INDOSFLAG     equ  <TESS_GLOBALS + 8>   ;Pointer to DOS INDOS flag
DOSCRITERR    equ  <TESS_GLOBALS + 12>  ;Pointer to DOS Critical Error
USERPSP       equ  <TESS_GLOBALS + 16>  ;PSP segment of user program
USER28PSP     equ  <TESS_GLOBALS + 18>  ;PSP segment of user program
USERDTA       equ  <TESS_GLOBALS + 20>  ;DTA of interrupted program
USER28DTA     equ  <TESS_GLOBALS + 24>  ;DTA of interrupted program
USERSS        equ  <TESS_GLOBALS + 28>  ;Stack segment of user program
USERSP        equ  <TESS_GLOBALS + 30>  ;Stack pointer of user program
USER28SS      equ  <TESS_GLOBALS + 32>  ;Stack segment of user program
USER28SP      equ  <TESS_GLOBALS + 34>  ;Stack pointer of user program
USERINT24     equ  <TESS_GLOBALS + 36>  ;pointer to use INT 24 handler
OLDEXTERR     equ  <TESS_GLOBALS + 40>  ;storage for old DOS 3 extended
                                        ;    error information
OLDBREAK      equ  <TESS_GLOBALS + 46>  ;Old Break Setting
OLDVERIFY     equ  <TESS_GLOBALS + 47>  ;Old Verify Setting
INWORD4       equ  <TESS_GLOBALS + 48>  ;flag to indicate in WORD 4.0
WASWORD4      equ  <TESS_GLOBALS + 49>  ;word 4 special popup flag
NEWKBDFLAG    equ  <TESS_GLOBALS + 50>  ;Enhanced Keyboard Call in use
WORD4DELAY    equ  <TESS_GLOBALS + 51>  ;Delay for Word 4

OLDINT8       equ  <TESS_GLOBALS + 52>  ;Interrupt vector tables
OLDINT9       equ  <TESS_GLOBALS + 59>  ;
OLDINT13      equ  <TESS_GLOBALS + 66>  ;
OLDINT16      equ  <TESS_GLOBALS + 73>  ;
OLDINT1C      equ  <TESS_GLOBALS + 80>  ;
OLDINT21      equ  <TESS_GLOBALS + 87>  ;
OLDINT28      equ  <TESS_GLOBALS + 94>  ;
OLDINT2F      equ  <TESS_GLOBALS + 101> ;
OLDINT1B      equ  <TESS_GLOBALS + 108> ;
OLDINT24      equ  <TESS_GLOBALS + 115> ;


USERPARMS     equ  <TESS_USERPARMS>      ;Unique TSR Identification String
                                         ;NOTE -- NOT NULL-TERMINATED
IDNUM         equ  <TESS_USERPARMS + 8>  ;Unique TSR Identification Number
FUNCFLG       equ  <TESS_USERPARMS + 10> ;Bit map of supported functions
HOTKEY        equ  <TESS_USERPARMS + 14> ;Hotkey used by TSR for popup
SHIFTST       equ  <TESS_USERPARMS + 15> ;ShiftState used by this TSR pop
HOTFLAG       equ  <TESS_USERPARMS + 16> ;which hotkey is in use
HOTCOUNT      equ  <TESS_USERPARMS + 17> ;Number of Extra Hotkeys to use
EXTRAHOTK     equ  <TESS_USERPARMS + 18> ;Pointer to extra hotkeys
STATUS        equ  <TESS_USERPARMS + 22> ;Current TSR Status Flags
OURPSP        equ  <TESS_USERPARMS + 24> ;TSR's PSP Segment
OURDTA        equ  <TESS_USERPARMS + 26> ;Pointer to TSR's DTA region
OURDSEG       equ  <TESS_USERPARMS + 30> ;TSR's Default Data Segment
OURSSSP       equ  <TESS_USERPARMS + 32> ;Pointer to Popup Stack Area
OUR28SP       equ  <TESS_USERPARMS + 36> ;Pointer to Background Stack

;
;       Keyboard Scan Codes
;
TSRHOT_A        equ     1eh
TSRHOT_B        equ     30h
TSRHOT_C        equ     2eh
TSRHOT_D        equ     20h
TSRHOT_E        equ     12h
TSRHOT_F        equ     21h
TSRHOT_G        equ     22h
TSRHOT_H        equ     23h
TSRHOT_I        equ     17h
TSRHOT_J        equ     24h
TSRHOT_K        equ     25h
TSRHOT_L        equ     26h
TSRHOT_M        equ     32h
TSRHOT_N        equ     31h
TSRHOT_O        equ     18h
TSRHOT_P        equ     19h
TSRHOT_Q        equ     10h
TSRHOT_R        equ     13h
TSRHOT_S        equ     1fh
TSRHOT_T        equ     14h
TSRHOT_U        equ     16h
TSRHOT_V        equ     2fh
TSRHOT_W        equ     11h
TSRHOT_X        equ     2dh
TSRHOT_Y        equ     15h
TSRHOT_Z        equ     2ch
TSRHOT_0        equ     0bh
TSRHOT_1        equ     02h
TSRHOT_2        equ     03h
TSRHOT_3        equ     04h
TSRHOT_4        equ     05h
TSRHOT_5        equ     06h
TSRHOT_6        equ     07h
TSRHOT_7        equ     08h
TSRHOT_8        equ     09h
TSRHOT_9        equ     0ah
TSRHOT_F1       equ     3bh
TSRHOT_F2       equ     3ch
TSRHOT_F3       equ     3dh
TSRHOT_F4       equ     3eh
TSRHOT_F5       equ     3fh
TSRHOT_F6       equ     40h
TSRHOT_F7       equ     41h
TSRHOT_F8       equ     42h
TSRHOT_F9       equ     43h
TSRHOT_F10      equ     44h
    
;
;Enhanced Keyboards only
;
;May not work with all computers, keyboards
;
TSRHOT_F11      equ     57h
TSRHOT_F12      equ     58h

;
;defines for ShiftState
;
TSRPOPRSHIFT    equ     01h
TSRPOPLSHIFT    equ     02h
TSRPOPCTRL      equ     04h
TSRPOPALT       equ     08h

; 
;  #defines for TSRFLAGS
;  
TSRUSEPOPUP     equ     0010h   ;Use TsrMain()
TSRUSEBACK      equ     0020h   ;Use TsrBackProc()
TSRUSETIMER     equ     0040h   ;Use TsrTimer()
TSRUSEUSER      equ     0100h   ;Use TsrUserProc()
NOPOPGRAPH      equ     1000h   ;Don't pop over graphics
NOPOPCOMMAND    equ     2000h   ;Don't pop over command-line

; 
;  #defines for TsrStatus flags
;  
HOTKEYON        equ     01h     ;hot key pressed
SHIFTSON        equ     02h     ;shift states match
TSRACTIVE       equ     04h     ;tsr is running in foreground
INT28ACTIVE     equ     08h     ;INT28 routine is running in background
;
POPUPSET        equ     10h     ;Popup resident routine installed
BACKSET         equ     20h     ;Interrupt 28 Background routine installed
TIMERSET        equ     40h     ;Interrupt 1C Timer Tick routine installed
EXTRAHOTSET     equ     80H     ;Extra Hot Keys have been installed
;
USERPROCON      equ     100h    ;User-defined procedure installed
TSRENABLED      equ     200h    ;TSR currently enabled
TSRRELEASED     equ     400h    ;TSR being released
EXTRAINT24      equ     800h    ;user installed replacement INT 24h routine
;------------------------------------------------------------------------------

;
; EQUates for IntFlags and SoftFlags
;
ININT13         equ     04h     ;Interrupt 13 is currently active
ININT21         equ     08h     ;Interrupt 21 is currently active
ININT16         equ     10h     ;Interrupt 16 is currently active
ININT28         equ     20h     ;Interrupt 28 is currently active
ININT08         equ     40h     ;Interrupt 08 is currently active
ININT1C         equ     80h     ;Interrupt 1C is currently active

;
; EQUates for Keyboard Stuffing
;
STUFF_SLOW      equ     0
STUFF_MED       equ     1
STUFF_FAST      equ     2

;
; EQUates used internally by TesSeRact routines
;
BIOSI8          equ     08h     ;Bios Timer interrupt
BIOSI9          equ     09h     ;BIOS Hardware Keyboard interrupt
BIOSIB          equ     0Bh
BIOSIC          equ     0Ch
BIOSI10         equ     10h
BIOSI13         equ     13h     ;Bios Disk interrupt
BIOSI14         equ     14h
BIOSI15         equ     15h
BIOSI16         equ     16h     ;Bios Keyboard interrupt
BIOSI17         equ     17h
BIOSI1C         equ     1Ch
DOSI21          equ     21h     ;DOS service router interrupt
DOSI28          equ     28h     ;DOS Idle interrupt
BIOSI1B         equ     1Bh
DOSI23          equ     23h
DOSI24          equ     24h
DOSI2F          equ     2fh
BIOSI5          equ     05h

NUMINTS_1       equ     8
NUMINTS_2       equ     3
NUMINTS_3       equ     5

;------------------------------------------------------------------------------
;       General Text Equates
;------------------------------------------------------------------------------

BPTR            equ     <BYTE PTR>
WPTR            equ     <WORD PTR>
DPTR            equ     <DWORD PTR>

;------------------------------------------------------------------------------
;       Macros
;------------------------------------------------------------------------------

setdta  macro   ddptr
        push    ds
        mov     ax,1a00h                ;;Function used to set current DTA 
        mov     dx,word ptr ddptr       ;;Offset of DTA 
        mov     ds,word ptr ddptr+2     ;;Segment of DTA
        int     21h                     ;;Execute MSDos function request
        pop     ds
        endm

getdta  macro   ddptr
        push    es
        mov     ax,2f00h                ;;Function used to get current DTA 
        int     21h                     ;;Execute MSDos function request
        mov     word ptr ddptr+2,es     ;;Segment of DTA returned by DOS
        mov     word ptr ddptr,bx       ;;Offset of DTA returned
        pop     es
        endm

ASSUMENODS macro                        ;; Macro to set assumes for various
IFDEF   TP4                             ;; segment configurations
IFNDEF  ASMCOM                          ;; this one is used when DS register
        ASSUME  CS:CODE, DS:NOTHING     ;; is undefined
ELSE
        ASSUME  CS:@code, DS:NOTHING
ENDIF
ELSE
        ASSUME  CS:@code, DS:NOTHING
ENDIF
        endm

ASSUMEDS macro                          ;; Macro to set assumes for various
IFDEF   TP4                             ;; segment configurations
IFNDEF  ASMCOM                          ;; this one is used when DS register
        ASSUME  CS:CODE, DS:CODE        ;; is same as CS register
ELSE
        ASSUME  CS:@code, DS:@code
ENDIF
ELSE
        ASSUME  CS:@code, DS:@code
ENDIF
        endm

POPFF   macro                           ;; Macro used to avoid the 'popf'
IFNDEF  TP4                             ;; bug on early 80286 chips
IFNDEF  ASMCOM
        EXTRN _TESS_INTERRUPTRETURN:near
ENDIF
ENDIF
        push    cs
        call    _TESS_INTERRUPTRETURN
        endm

IFDEF TP4
        ENDIT MACRO
                PAGE
        ENDM
ELSE
IFDEF MASM
        ENDIT MACRO
                END
        ENDM
ELSE
        ENDIT equ END
ENDIF
ENDIF
