' Program to convert most of DOS 4 DOSSHELL Menu structures to DOS 5
'               Version 1.2   multiple commands handling improved 
'                             some minor mods in documentation
' The program runs in QBasic which comes free with DOS 5, or in Microsoft
'   QuickBasic  (it has only been tested for 4.5)
' The program can be run any time after DOS 5 installation - it will be most
'   useful if run _before_ you start manually menuing.
' DOS 5 menus are coded by text statements in the file DOSSHELL.INI.
' DOS 4  used a system of binary files with the extent .MEU
'
' This program takes the binary SHELL.MEU file of DOS 4, analyses the menu
'   and submenu structure and forms statements suitable for DOS 5
'   It then takes the DOS 5 DOSSHELL.INI file plus the new information to
'   create DOSSHELL.NEW. This can be edited for those items whose commands
'   could not be determined, or changes can be made using the DOSSHELL 5
'   _properties_ dialogue boxes.
' Rename the .INI to .OLD and the .NEW to .INI and restart DOSSHELL
' NB All these files should be in the C:\DOS directory.
'
' Limitations:-
'   1. No attempt has been made to convert shell dialogue information.
'   2. Passwords are not converted, they are removed where present.
'
' This program may be used freely and without charge. If you use it then it
'   would be appreciated it you could notify me by email PB.VCP.MONASH.EDU.AU
'   Suggestions for improvements welcome.
'   Peter Bury, Victorian College of Pharmacy (Monash University)
' Usual disclaimers apply!
' If you have never run QBasic, brief instructions are appended at the end
'
DECLARE FUNCTION byte% (address%, slect%)
DECLARE SUB pgram (slect%)
DECLARE FUNCTION xtract$ (start%, last%, slect%)
DEFINT A-Z
COMMON SHARED GroupItem AS STRING * 1036, MenuItem AS STRING * 1036, ascii
DIM main(50), submen(50)
COLOR 7, 0
defpath$ = "c:\dos\"
PRINT "            DOSSHELL CONVERSION PROGRAM"
PRINT "Copying start of DOSSHELL.INI to DOSSHELL.NEW"
OPEN defpath$ + "shell.meu" FOR BINARY ACCESS READ AS #1 LEN = 1
OPEN defpath$ + "dosshell.ini" FOR INPUT AS #3
OPEN defpath$ + "dosshell.new" FOR OUTPUT AS #4
LINE INPUT #3, a$
WHILE a$ <> "}"                  ' Copy to end of existing groups/programs
  PRINT #4, a$
  LINE INPUT #3, a$
WEND
PRINT
PRINT "MAIN group"
GET #1, 1, GroupItem
NList = byte(&H318, 1)           ' This is length of list
NMain = byte(&H31A, 1)           ' This is how many items in main menu
FOR j = 1 TO NList
  main(byte(&H318 - 4 + 8 * j, 1)) = j      'and their order
NEXT j
FOR g1 = 1 TO NMain
  k = &H139 + &H40C * (main(g1) - 1)
  GET #1, k, GroupItem
  nm$ = xtract$(&H265, &H28E, 1)      'Title of item if program
  IF nm$ = "Command Prompt" OR nm$ = "Change Colors" THEN GOTO nxtgp
  IF nm$ = "File System" THEN GOTO nxtgp
  comgp$ = xtract$(&H298, &H40C, 1)      'Title of item if group
  IF INSTR(comgp$, ".MEU") > 0 THEN      'Test for group
    group$ = LEFT$(comgp$, INSTR(comgp$, ".MEU") + 3)
    IF group$ = "DOSUTIL.MEU" THEN GOTO nxtgp
    PRINT "Group "; group$
    PRINT #4, "   group ="
    PRINT #4, "   {"
    PRINT #4, "       title = "; nm$
    pw$ = xtract$(&H28E, &H29C, 1)
    IF pw$ <> "" THEN PRINT "Password removed from "; nm$: BEEP: SLEEP 2
    OPEN defpath$ + group$ FOR BINARY ACCESS READ AS #2 LEN = 1
    GET #2, 1, MenuItem      'Repeat above process for items in group
    nl2 = byte(&H318, 2)
    ng2 = byte(&H31A, 2)
    FOR j = 1 TO nl2
      j1 = byte(&H318 - 4 + 8 * j, 2)
      submen(j1) = j
    NEXT j
    FOR g2 = 1 TO ng2
      l = &H139 + &H40C * (submen(g2) - 1)
      GET #2, l, MenuItem
      CALL pgram(2)            ' This does the work for progs in group
      SLEEP 1
    NEXT g2
    PRINT #4, "   }"
    CLOSE #2
  ELSE
    CALL pgram(1)              ' This does the work for progs in main
  END IF
nxtgp:
NEXT g1
PRINT #4, "}"
PRINT "Copying tail of DOSSHELL.INI to DOSSHELL.NEW"
WHILE NOT EOF(3)               ' Copy to end of file
  LINE INPUT #3, a$
  PRINT #4, a$
WEND
CLOSE

FUNCTION byte (address, slect)
  dummy$ = xtract$(address, address + 1, slect)
  byte = ascii            ' extract a single byte as an integer
END FUNCTION

SUB pgram (slect)
' This routine extracts the command, help, password and title fields.
' It attempts to parse the command field to find the startup directory and
'   and command, and warns if later editing might be needed.
'   Hex BA corresponds to the F4 separator
  warn = 0
  PRINT
  hlp1$ = xtract$(&H139, &H265, slect)
  nm1$ = xtract$(&H265, &H28E, slect)
  pw1$ = xtract$(&H28E, &H29C, slect)
  comlines$ = xtract$(&H29C, &H40C, slect)
  path$ = ""
  p0 = 1
  NewCom$ = ""
comloop:
  p1 = INSTR(p0, comlines$, CHR$(&HBA))
  IF p1 = 0 THEN p2 = LEN(comlines$) - p0 + 1 ELSE p2 = p1 - p0
  c$ = MID$(comlines$, p0, p2)
  IF MID$(c$, 2, 1) = ":" AND path$ = "" THEN
    path$ = LTRIM$(RTRIM$(c$))
    specfound = 0
  ELSE
    IF LEFT$(UCASE$(c$), 2) = "CD" THEN
      IF LEN(path$) < 5 THEN      ' This is looking for change drive then
        IF INSTR(c$, ":") > 0 THEN      ' change directory
          path$ = MID$(c$, 3)
        ELSE
          path$ = path$ + MID$(c$, 3)
        END IF
        specfound = 1
      ELSE
        PRINT "Path not clear"
        warn = 1              ' Cant determine path. User should use shell
        path$ = MID$(c$, 3)   ' PROPERTIES option to check/edit the item
      END IF
    ELSE
      IF LEFT$(UCASE$(c$), 5) = "CHDIR" THEN
        IF LEN(path$) < 5 THEN      ' Same as above, other form of CD
          IF INSTR(c$, ":") > 0 THEN
            path$ = MID$(c$, 6)
          ELSE
            path$ = path$ + MID$(c$, 6)
          END IF
          specfound = 1
        ELSE
          PRINT "Path not clear"
          warn = 1              ' Cant determine path. User should use shell
          path$ = MID$(c$, 6)   ' PROPERTIES option to check/edit the item
        END IF
      ELSE
        IF NewCom$ = "" THEN
          NewCom$ = c$   ' Assume this is a valid command
        ELSE
          NewCom$ = NewCom$ + "  ; " + c$
        END IF
      END IF
    END IF
  END IF
  IF p1 > 0 THEN
    p0 = p1 + 1
    GOTO comloop
  END IF
' parsing finished, review what we've got
  sp = INSTR(path$, " ")
  WHILE sp > 0            ' Remove spaces from path
    path$ = LEFT$(path$, sp - 1) + MID$(path$, sp + 1)
    sp = INSTR(path$, " ")
  WEND

  IF NewCom$ = "" THEN
    sl = INSTR(path$, "\")
    IF sl = 0 THEN
      warn = 1
      PRINT "No command found"
    ELSE
      WHILE sl > 0      'find the last backslash
        sll = sl
        sl = INSTR(sll + 1, path$, "\")
      WEND
      NewCom$ = MID$(path$, sll + 1)
      path$ = LEFT$(path$, sll - 1)
    END IF
  ELSE
    IF path$ = "" THEN
      sc = INSTR(NewCom$, ";")
      IF sc = 0 THEN sc = LEN(NewCom$)
      sl = INSTR(NewCom$, "\")
      IF sl > 0 AND sl < sc THEN
        WHILE sl > 0      'find the last backslash
          sll = sl
          sl = INSTR(sll + 1, NewCom$, "\")
        WEND
        path$ = LEFT$(NewCom$, sll - 1)
        NewCom$ = MID$(NewCom$, sll + 1)
      ELSE
        warn = 1
        PRINT "No startup directory found"
      END IF
    END IF
  END IF
  PRINT #4, TAB(4 * slect); "program ="
  PRINT #4, TAB(4 * slect); "{"
  PRINT #4, TAB(4 * slect); "    title = "; nm1$
  PRINT TAB(4 * slect); "    title = "; nm1$
  IF path$ <> "" THEN PRINT #4, TAB(4 * slect); "    directory = "; path$
  IF path$ <> "" THEN PRINT TAB(4 * slect); "    directory = "; path$
  PRINT #4, TAB(4 * slect); "    command = "; NewCom$
  PRINT TAB(4 * slect); "    command = "; NewCom$
  IF hlp1$ <> "" THEN PRINT #4, TAB(4 * slect); "    help = "; hlp1$
  IF hlp1$ <> "" THEN PRINT TAB(4 * slect); "    help = "; hlp1$
  IF pw1$ <> "" THEN PRINT "Password removed from "; nm1$: BEEP: SLEEP 2
  PRINT #4, TAB(4 * slect); "    pause = disabled"
  PRINT #4, TAB(4 * slect); "}"
  IF warn = 1 THEN
    PRINT "Edit "; : COLOR 4, 2: PRINT nm1$; : COLOR 7, 0
    INPUT "if needed.  Press return to continue"; x
  END IF
EXIT SUB
END SUB

FUNCTION xtract$ (start, last, slect)
DIM Item AS STRING * 1036
IF slect = 1 THEN Item = GroupItem ELSE Item = MenuItem
x$ = ""
FOR j = start + 1 TO last
  ascii = ASC(MID$(Item, j, 1))
  IF ascii >= &H20 AND (ascii <= &H7E OR ascii = &HBA) THEN
    x$ = x$ + CHR$(ascii)
  ELSE
    EXIT FOR
  END IF
NEXT j
xtract$ = LTRIM$(RTRIM$(x$))
END FUNCTION
'
' Using a text editor to remove any headers, create a file called eg.
'   SHELL45.BAS. Lines starting with the apostrophe are comments and may be
'   left intact.
' To run this program after DOS 5 installation, select QBasic from the
'   shell menu. Type in the full path and name to wherever this file is
'   stored. Press the _F5_ key to run the program.
'   It will pause to let you note any warning messages displayed as it runs.
' Exit Basic by pressing _Alt_ then F then X, and exit DOSSHELL to DOS by
'   pressing the _F3_ key.
' Rename DOSSHELL.INI  DOSSHELL.OLD       and then
' Rename DOSSHELL.NEW  DOSSHELL.INI
' Type DOSSHELL to restart with new menus.
