/* MSGTEST.C */

#include <ctype.h>
#include <conio.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>

union REGS inregs;
union REGS outregs;
struct SREGS segregs;

/* convert a pointer to its segment and offset */

void segoff(val,seg,off)
int *val,*seg,*off;
{
   *seg = *(val + 1);
   *off = *val;
}

/* given a segment and offset, make a pointer */

void makptr(seg,off,adrptr)
int seg, off;
int *adrptr;
{
    *(adrptr+1) = seg;
    *adrptr     = off;
}

/*  put a message on a queue  */

void putmsg(msg, qnum)
char *msg;
int qnum;
{
	inregs.h.ah = 4;  /* send msg to q */
	inregs.h.al = qnum;  /* msg q num */
	inregs.x.cx = strlen(msg);  /* message buffer length */
	segoff(&msg, &(segregs.ds), &(inregs.x.si));
	int86x(0x15, &inregs, &outregs, &segregs);
	if (outregs.h.ah != 0) 
		printf("send message error: %d\n",outregs.h.ah);
	return;
}

/* routine to get a message from a queue */

void getmsg(msg, qnum)
char *msg;
int qnum;
{
	int i;
	
	for (i = 0;i < 150; ++i) msg[i] = '\0';
	inregs.h.ah = 5;  /* test message queue */
	inregs.h.al = qnum;
	int86(0x15, &inregs, &outregs);
	if (outregs.h.ah != 0)
	{
		printf("test message queue error: %d\r\n", outregs.h.ah);
		return;
	}
	if (outregs.x.dx == 0)
	{
		printf("no messages on queue: %d\r\n", qnum);
		return;
	}
	inregs.h.ah = 6;  /* get msg from q */
	inregs.h.al = qnum;  /* msg q num */
	inregs.x.cx = 100;  /* message buffer length */
	segoff(&msg, &(segregs.es), &(inregs.x.di));
	int86x(0x15, &inregs, &outregs, &segregs);
	return;
}

/****************/
/* main program */
/****************/

void main()
{
	char dspbuf[100], numbuf[50];
	int i, qnum;
	
	for (;;) 
	{
		printf("\r\n(S)end (R)eceive (Q)uit? ");
		i = getche();
		printf("\r\n");
		switch (i) {
			case 'S' :
			case 's' :
				printf("Queue number to send to (0 - 32)?: ");
				gets(numbuf);
				qnum = atoi(numbuf);
				printf("\r\nenter message text\n");
				gets(dspbuf);
				putmsg(dspbuf, qnum);
				break;
			case 'R' :
			case 'r' :
				printf(
				  "Queue number to receive from (0 - 32)?: ");
				gets(numbuf);
				qnum = atoi(numbuf);
				getmsg(dspbuf, qnum);
				printf("\r\n%s\r\n",dspbuf);
				break;
			case 'Q' :
			case 'q' :
				printf("\r\nexiting\r\n");
				exit(0);
			default :
				printf("\r\ninvalid command\r\n");
				break;
		}
	}
}

