/*
SETCHECK.C by Robert Morein.  10/26/86
(215)-646-4894

 Purpose: to read and set the byte-added checksum of a .bin file 
to any desired value, by adjusting the last byte of the file. 
*/


#include "STDIO.H"
long atoi();
main( argc, argv ) 
int argc; char *argv[]; {
FILE *source;
unsigned cha *base;
unsigned long i, count;
int eofcond;
unsigned char sum, oldsum, newsum, ckbyte;

if( !( argc > 1 ) ) {
  printf("\nAT rom object code checksum calculator and setter program.");
  printf("\nLast byte is assumed to hold checksum.");
  printf("\narg1 = object code to be patched: patched at last byte.");
  printf("\narg2 = decimal byte count (optional, defaults to 65536.");
  printf("\narg3 = desired checksum (optional, if not given, source");
  printf("\n  will not be patched.");
  exit();
  }
if( argc >= 3 ) {
  if( !(count = atoi( argv[2] )) ) {
    printf("\nByte count must be a number > 0\n");
    exit();
    }
  printf("\nYou have selected a byte count of: %lu\n", count );
  count -= 1;
  }
else count = 0xFFFF;

if( argc == 4 ) {
  newsum = atoi( argv[3] );
  printf("\nYou have selected a new checksum of: %d\n", newsum );
  }

source = fopen( argv[1], "rwb" );
/* The last byte is reserved for the checksum: */
for( i = 0, sum = 0; i < count; i++ ) {
  sum += (unsigned char)(eofcond = getc( source) );
  if( eofcond == -1 ) { printf("\nError: eof before count."); exit(); }
  }
oldsum = sum + (unsigned char)(eofcond = getc( source ));
if( eofcond == -1 ) { printf("\nError: eof before count."); exit(); }
printf("\nCurrent checksum (including last byte): (decimal) %d, (hex) %x",
  oldsum, oldsum );

/*  sum + ckbyte = newsum */

ckbyte = newsum - sum;

if( argc == 4 ) {
  printf("\nPatching last byte for a checksum of: (decimal) %d, (hex) %x", 
    newsum, newsum );
  fseek( source, (long)count, 0L );
  putc( ckbyte, source );
  }
fclose( source );
}

