jumps
locals
.286

wf	segment
	assume	cs:wf, ds:wf, es:wf

	org	100h

start:	jmp	begin

wipe		db	0
o_erased	db	0
o_files		db	0
o_directory	db	0
pgp_files	db	0
pgp_restore	db	0
pgp_count	dw	0

Drive		db	-1	; drive number (0=A, 1=B, etc.)
SectSiz		dw	?	; bytes per sector
SePerCl		dw	?	; sectors per cluster -1 (max sector in cluster)
ClSecSh		dw	?	; cluster-to-sector shift (cluster is 2 sectors)
BootSiz		dw	?	; reserved sectors (boot secs; start of root dir)
FatCnt		dw	?	; number of FATs
MaxDir		dw	?	; number of directory entries allowed in root
DataSec		dw	?	; sector number of cluster #2 (first data cluster)
HiClust		dw	?	; total clusters +2 (number of highest cluster)
				; 16-bit FAT if greater than 0FF6h, else 12-bit FAT
FatSects	dw	?	; sectors needed by 1 FAT
RootSec		dw	?	; sector # of start of root directory

procente	dw	?
bksp		dw	?

swap_fn		db	'386SPART.PAR',0
		db	'WIN386  .SWP',0
		db	0	; end marker
swap_cluster	dw	0
swap_wiped	dw	0
swap_total	dw	0
fname		db	'FILE_ENT.TMP',0
hand		dw	?
f_cluster	dw	?
f_size		dw	?, ?
freestr		db	'. Unused space .'
		db	'. Unused space .'
wipe_cl		dw	0
ClSize		dw	0
eof_cluster	dw	0

fat_read	dw	0
xfer_pack	dw	?, ?
		dw	?
		dw	?, ?

cluster		dd	?
dir_cl_chain	dd	?
dir_entry	dw	0
file_entry	dw	0
buf_file_entry	dw	0
dirs		dw	0

pw10		dw	10000,1000,100,10
ld_zero		db	0
col		db	0

cr	equ	<cr>

; [fold]  [
print	macro	p1,p2
	local	@@p1,@@p2
	jmp	short @@p2
	ifidni	<p1>,<cr>
@@p1	db	0dh,0ah
	else
@@p1	db	'&p1'
	endif
	ifnb	<p2>
	ifidni	<p2>,<cr>
	db	0dh,0ah
	else
	db	'&p2'
	endif
	endif
	db	0
@@p2:	mov	bx,offset @@p1
	call	o0
	endm
; [fold]  ]

; [fold]  [
printo	macro	addr
	mov	bx,offset addr
	call	o0
	endm
; [fold]  ]

; [fold]  [
die	macro	cond, p1, p2
	local	@@next,@@die
	j&cond	@@die
	jmp	short @@next
@@die:
	ifnb	<p1>
	ifb	<p2>
	print	<&p1>
	else
	print	<&p1>,<&p2>
	endif
	endif
	jmp	exit
@@next:
	endm
; [fold]  ]

;====================================================

; [fold]  [
o0	proc	near
nxtltr:
	mov	dl,[bx]
	inc	bx
	mov	ah,02h		;DOS fn putchar from DL
	cmp	dl,0		;Test 0 at the END of string
	jz	exito0
	int	21h
	inc	col
	jmp	nxtltr
exito0:
	ret
o0	endp
; [fold]  ]


;====================================================

; [fold]  [
number	proc	near
	push	dx cx bx
	mov	ld_zero,0
	mov	bksp,0
	lea	bx,pw10
	mov	cx,4
n_12:
	mov	dl,'0'
n_11:
	sub	ax,[bx]
	jc	n_10
	inc	dl
	jmp	n_11
n_10:
	add	ax,[bx]
	inc	bx
	inc	bx
	cmp	dl,'0'
	jnz	n_13
	cmp	ld_zero,0
	jz	n_14
n_13:
	inc	ld_zero
	push	ax
	mov	ah,02		;print char in DL
	int	21h
	inc	bksp
	pop	ax
n_14:
	loop	n_12
	mov	ah,02h		;print char in DL
	mov	dl,'0'
	add	dl,al
	int	21h
	inc	bksp
	pop	bx cx dx
	ret
number	endp
; [fold]  ]

;====================================================

; [fold]  [
p_hex	proc	near
	push	ax
	mov	cl,4
	shr	al,cl
	call	p_half
	pop	ax
	and	al,0fh
p_half: add	al,90h		; external entry
	daa
	adc	al,40h
	daa
pr_ch:	mov	ah,2		; external entry
	mov	dl,al
	int	21h	;fnct 02h display char dl
	ret
p_hex	endp
; [fold]  ]

;====================================================

; [fold]  [
p_dhex	proc	near
	push	ax
	mov	al,ah
	call	p_hex
	pop	ax
	call	p_hex
	ret
p_dhex	endp
; [fold]  ]

;====================================================

; [fold]  [
wipe_cluster	proc near
	mov	bx, offset xfer_pack
	mov	cx, 0ffffH
	mov	dx, SePerCl
	mov	[bx+4], dx
	sub	ax,2
	mul	SePerCl
	mov	si,ax
	mov	di,dx
	add	si,BootSiz
	adc	di,0
	mov	ax,20h
	mul	MaxDir
	div	SectSiz
	add	si,ax
	adc	di,0
	mov	ax, FatCnt
	mul	FatSects
	add	si,ax
	adc	di,dx
	mov	[bx+0], si
	mov	[bx+2], di
	mov	[bx+6], offset free
	mov	ax, ds
	mov	[bx+8], ax
	mov	al, Drive
	cmp	wipe,0
	jz	@@wprd
	jmp	@@wpwr
@@wprd: int	25h
	jmp	@@wpxx
@@wpwr: int	26h
@@wpxx: pop	ax
	die	c,cr,<Error writing cluster>
	ret
wipe_cluster	endp
; [fold]  ]

;====================================================

; [fold]  [
read_fat_sect	 proc near
	push	ax
	mov	bx, offset xfer_pack
	mov	cx, 0ffffH
	mov	[bx+4], ax
	mov	ax, BootSiz
	add	ax, fat_read
	cwd
	mov	[bx+0], ax
	mov	[bx+2], dx
	mov	[bx+6], offset load_fat
	mov	ax, ds
	mov	[bx+8], ax
	mov	al, Drive
	int	25h
	pop	ax
	die	c,cr,<Error reading FAT>
	pop	ax
	ret
read_fat_sect	 endp
; [fold]  ]

;====================================================

; [fold]  [
read_cluster	proc near
	push	ax
	mov	bx, offset xfer_pack
	mov	cx, 0ffffH
	sub	ax, 2
	mul	SePerCl
	add	ax, DataSec
	adc	dx, 0
	mov	[bx+0], ax
	mov	[bx+2], dx
	mov	ax, SePerCl
	mov	[bx+4], ax
	les	ax, cluster
	mov	[bx+6], ax
	mov	[bx+8], es
	mov	al, Drive
	int	25h
	pop	ax
	die	c,cr,<Error reading cluster>
	pop	ax
	ret
read_cluster	endp
; [fold]  ]

;====================================================

; [fold]  [
write_cluster	 proc near
	push	ax
	mov	bx, offset xfer_pack
	mov	cx, 0ffffH
	sub	ax, 2
	mul	SePerCl
	add	ax, DataSec
	adc	dx, 0
	mov	[bx+0], ax
	mov	[bx+2], dx
	mov	ax, SePerCl
	mov	[bx+4], ax
	les	ax, cluster
	mov	[bx+6], ax
	mov	[bx+8], es
	mov	al, Drive
	cmp	wipe,0
	jz	@@wprd
	jmp	@@wpwr
@@wprd:
	int	25h
	jmp	@@wpxx
@@wpwr:
	int	26h
@@wpxx:
	pop	ax
	die	c,cr,<Error writing cluster>
	pop	ax
	ret
write_cluster	 endp
; [fold]  ]

;====================================================

; [fold]  [
fill_cluster	proc near
	mov	bx,40h
	mov	es,bx
	mov	bx,es:[6ch]
	and	bx,7		; random number 0-7
	les	di,cluster
	mov	ax,f_size
	add	di,ax
	sub	ax,ClSize
	neg	ax
	mov	cx,ax
	shr	cx,4
	inc	cx
@@more: push	cx
	mov	cx,8
	lea	si, [freestr + bx]
	rep	movsw
	pop	cx
	loop	@@more
	ret
fill_cluster	endp
; [fold]  ]

;====================================================

; [fold]  [
init_cl_space	 proc near
	mov	bx,40h
	mov	es,bx
	mov	bx,es:[6ch]
	and	bx,7		; random number 0-7
	push	ds
	pop	es
	mov	di,offset free
	mov	ax,SectSiz
	mul	SePerCl
	mov	cx,ax
	shr	cx,4
@@more: push	cx
	mov	cx,8
	lea	si, [freestr + bx]
	rep	movsw
	pop	cx
	loop	@@more
	ret
init_cl_space	 endp
; [fold]  ]

;====================================================

; [fold]  [
clean_dir proc near
	les	bx,cluster
	mov	cx,0
d_loop: push	cx
	cmp	byte ptr es:[bx], 0
	jnz	@@n1
	mov	di,bx
	mov	cx,10h
	xor	ax,ax
	rep	stosw
	jmp	@@next
@@n1:	cmp	byte ptr es:[bx], 0e5h
	jnz	@@n2
	cmp	pgp_restore,1
	jnz	@@erase_entry
	cmp	byte ptr es:[bx+8],  'P'
	jnz	@@erase_entry
	cmp	byte ptr es:[bx+9],  'G'
	jnz	@@erase_entry
	cmp	byte ptr es:[bx+0ah],'P'
	jnz	@@erase_entry
	mov	al, es:[bx+16h]
	mov	es:[bx], al		; restore file first letter
	mov	byte ptr es:[bx+16h], 0 ; seconds to 0
	inc	pgp_count
	jmp	@@n2
@@erase_entry:
	mov	di,bx
	inc	di
	mov	cx,0fh
	xor	ax,ax
	stosb
	rep	stosw
	jmp	@@next
@@n2:	test	byte ptr es:[bx+0bh], 10h	; directory ?
	mov	cx, es:[bx+1ah]			; cluster
	jz	@@file
	cmp	byte ptr es:[bx], '.'
	jz	@@next
	cmp	word ptr es:[bx+0ch], 0		; some sanity check
	jnz	@@next
	cmp	word ptr es:[bx+0eh], 0		; some sanity check
	jnz	@@next
	cmp	word ptr es:[bx+10h], 0		; some sanity check
	jnz	@@next
	cmp	word ptr es:[bx+12h], 0		; some sanity check
	jnz	@@next
	cmp	word ptr es:[bx+14h], 0		; some sanity check
	jnz	@@next
	les	di, dir_cl_chain
	mov	si, dir_entry
	shl	si, 1
	add	di,si
	mov	es:[di], cx
	inc	dir_entry
	mov	es, word ptr cluster + 2
	jmp	@@next
@@file:
	cmp	cx, 0
	jz	@@next
	mov	si, offset swap_fn		; check for swap files
@@nname:
	cmp	byte ptr [si], 0
	jz	@@nssw
	mov	al, es:[bx]
	cmp	byte ptr [si], al
	jz	@@try_name
	add	si,8+1+3+1
	jmp	@@nname
@@try_name:
	push	cx bx
	mov	di,bx
	mov	cx,4
	repz	cmpsw
	jnz	@@no_match
	inc	si
	mov	cx,3
	repz	cmpsb
	jnz	@@no_match
	mov	cx, es:[bx+1ah]			; swap starting cluster
	mov	swap_cluster,cx
	mov	ax, es:[bx+1ch]			; swap size
	mov	dx, es:[bx+1eh]
	mov	cx, ClSecSh
@@shifts:
	shr	dx,1
	rcr	ax,1
	loop	@@shifts
	div	SectSiz
	mov	swap_total,ax
@@no_match:
	inc	si
	pop	bx cx
	jmp	@@nname
@@nssw:
	cmp	pgp_files,1			; hide PGP files?
	jnz	@@no_pgp_hide
	cmp	byte ptr es:[bx+8],  'P'
	jnz	@@no_pgp_hide
	cmp	byte ptr es:[bx+9],  'G'
	jnz	@@no_pgp_hide
	cmp	byte ptr es:[bx+0ah],'P'
	jnz	@@no_pgp_hide
	mov	al, es:[bx]
	mov	es:[bx+16h], al			; save file first letter
	mov	byte ptr es:[bx], 0e5h		; mark deleted
	inc	pgp_count
@@no_pgp_hide:
	cmp	o_files,1
	jnz	@@next
	mov	ax, es:[bx+1ch]			; file size
	mov	dx, es:[bx+1eh]
	mov	di, offset file_cl_chain
	mov	si, buf_file_entry
	cmp	si, 512
	jnz	@@more
	call	flush_buf
@@more:
	shl	si, 1
	add	di,si
	shl	si, 1
	add	di,si
	mov	[di],cx
	mov	[di+2],ax
	mov	[di+4],dx
	inc	file_entry
	inc	buf_file_entry
@@next:
	add	bx,20h
	pop	cx
	inc	cx
	cmp	cx, dirs
	jnz	d_loop
	ret
clean_dir endp
; [fold]  ]

;====================================================

; [fold]  [
read_root	proc near
	mov	bx, offset xfer_pack
	mov	cx, 0ffffH
	mov	ax, RootSec
	cwd
	mov	[bx+0], ax
	mov	[bx+2], dx
	mov	ax, 20h
	mul	MaxDir
	div	SectSiz
	mov	[bx+4], ax
	les	ax, cluster
	mov	[bx+6], ax
	mov	[bx+8], es
	mov	al, Drive
	int	25h
	pop	ax
	die	c,cr,<Error reading root directory>
	ret
read_root	endp
; [fold]  ]

;====================================================

; [fold]  [
write_root	proc near
	mov	bx, offset xfer_pack
	mov	cx, 0ffffH
	mov	ax, RootSec
	cwd
	mov	[bx+0], ax
	mov	[bx+2], dx
	mov	ax, 20h
	mul	MaxDir
	div	SectSiz
	mov	[bx+4], ax
	les	ax, cluster
	mov	[bx+6], ax
	mov	[bx+8], es
	mov	al, Drive
	cmp	wipe,0
	jz	@@wprd
	jmp	@@wpwr
@@wprd: int	25h
	jmp	@@wpxx
@@wpwr: int	26h
@@wpxx: pop	ax
	die	c,cr,<Error writing root directory>
	ret
write_root	endp
; [fold]  ]

;====================================================

; [fold]  [
find_dir_cluster	proc near
	les	si, dir_cl_chain
	mov	bx, 0
@@next:
	mov	ax, es:[si + bx]
	cmp	ax, -1
	jnz	@@vfy
	shr	bx, 1
	inc	bx
	cmp	bx, dir_entry
	stc			; signal end of list
	jz	@@exit
	shl	bx,1
	jmp	@@next
@@vfy:				; if not a final cluster put the next one
				; in the list
	mov	word ptr es:[si + bx], -1
	push	ax
	mov	ax,bx
	shr	ax,1
	inc	ax
	mov	dx,dir_entry
	call	show_proc
	pop	ax
	push	ax
	xor	dx,dx
	add	ax,ax
	adc	dx,0
	div	SectSiz
	mov	fat_read, ax
	push	dx
	mov	ax,1
	call	read_fat_sect
	pop	bx
	mov	cx,[bx+load_fat]
	cmp	cx, 0fff8h	; is it final ?
	jae	@@yes
	les	di, dir_cl_chain
	mov	si, dir_entry
	shl	si, 1
	add	di,si
	mov	es:[di], cx
	inc	dir_entry
@@yes:
	pop	ax
	clc
@@exit:
	ret
find_dir_cluster	endp
; [fold]  ]

;====================================================

; [fold]  [
flush_buf	proc near
	push	ax bx cx dx
	mov	ax,6
	mul	buf_file_entry
	mov	cx,ax
	mov	ah,40h		; write file
	mov	bx,hand
	mov	dx, offset file_cl_chain
	int	21h
	die	c,cr,<Error when writing to file_entry file>
	mov	buf_file_entry,0
	pop	dx cx bx ax
	ret
flush_buf	endp
; [fold]  ]

;====================================================

; [fold]  [
wipe_file_end	proc near
	call	find_eof_cluster
	mov	ax,f_size+2
	test	ax,ax
	die	nz,cr,<File size inconsistency>
	mov	ax,f_size
	cmp	ax,ClSize
	die	a,cr,<File size inconsistency>
	mov	ax,eof_cluster
	call	read_cluster
	call	fill_cluster
	mov	ax,eof_cluster
	call	write_cluster
	ret
wipe_file_end	endp
; [fold]  ]

;====================================================

; [fold]  [
get_chain_cluster	 proc near
	xor	dx,dx
	add	ax,ax
	adc	dx,0
	div	SectSiz
	push	dx
	cmp	fat_read, ax
	jz	in_mem
	mov	fat_read, ax
	mov	ax,1
	call	read_fat_sect
in_mem:
	pop	bx
	mov	ax,[bx+load_fat]
	ret
get_chain_cluster	 endp
; [fold]  ]

;====================================================

; [fold]  [
wipe_swap_file	 proc near
@@next_cl:
	mov	ax,swap_cluster
	call	wipe_cluster
	mov	ax,swap_cluster
	call	get_chain_cluster
	mov	swap_cluster,ax
	inc	swap_wiped
	mov	ax, swap_wiped
	mov	dx, swap_total
	call	show_proc
	cmp	swap_cluster, 0fff8h	       ; is it final ?
	jb	@@next_cl
	ret
wipe_swap_file	 endp
; [fold]  ]

;====================================================

; [fold]  [
find_eof_cluster	proc near
	mov	ax,f_cluster
@@next_cluster:
	mov	eof_cluster,ax
	call	get_chain_cluster
	cmp	ax, 0fff8h	; is it final ?
	jae	@@yes
	mov	cx,ClSize
	sub	word ptr f_size,cx
	sbb	word ptr f_size+2,0
	jmp	@@next_cluster
@@yes:
	ret
find_eof_cluster	endp
; [fold]  ]

;====================================================

; [fold]  [
show_proc	proc near
	push	dx cx bx ax
	mov	bp, dx
	mov	dx, 100
	mul	dx
	cmp	bp, 0
	jz	@@axz
	div	bp
	jmp	@@div
@@axz:	mov	ax,0
@@div:	cmp	procente, ax
	jz	@@no_update
	mov	procente, ax
	mov	cx,bksp
	inc	cx
	jcxz	@@show
@@pbk:	mov	al,08
	call	pr_ch
	loop	@@pbk
@@show: mov	ax, procente
	call	number
	mov	al,'%'
	call	pr_ch
@@no_update:
	pop	ax bx cx dx
	ret
show_proc	endp
; [fold]  ]

;====================================================

; [fold]  [
get_opt proc near
	mov	cl, ds:[80h]
	mov	ch, 0
	jcxz	@@nopara
	inc	cx
	mov	bx, 81h
@@nosw:
	mov	dl,0	;no switch
@@skip:
	dec	cx
	jz	@@nopara
	mov	al,[bx]
	inc	bx
	cmp	al,' '
	jz	@@nosw
	cmp	al,09
	jz	@@nosw
	cmp	al,0dh
	jz	@@nosw
	cmp	al,'/'
	jnz	@@et1
@@et2:
	mov	dl,1	;switch
	jmp	@@skip
@@et1:
	cmp	al,'-'
	jz	@@et2
	cmp	al,'a'
	jb	@@ok
	cmp	al,'z'
	ja	@@ok
	and	al,0dfh ; upper case
@@ok:
	cmp	dl,0
	jz	@@drive
	cmp	al,'W'
	jnz	@@nx1
	mov	wipe,1
	jmp	@@skip
@@nx1:
	cmp	al,'E'
	jnz	@@nx2
	mov	o_erased,1
	jmp	@@skip
@@nx2:
	cmp	al,'F'
	jnz	@@nx3
	mov	o_files,1
	jmp	@@skip
@@nx3:
	cmp	al,'D'
	jnz	@@nx4
	mov	o_directory,1
	jmp	@@skip
@@nx4:
	cmp	al,'P'
	jnz	@@nx5
	mov	pgp_files,1
	jmp	@@skip
@@nx5:
	cmp	al,'R'
	jnz	@@nx6
	mov	pgp_restore,1
	jmp	@@skip
@@nx6:
	push	ax
	print	cr,<Invalid option />
	pop	ax
	call	pr_ch
	jmp	exit
@@drive:
	cmp	Drive, -1
	jnz	@@skip	; drive already set
	cmp	al,'A'
	die	b,cr,<Invalid drive letter>
	cmp	al,'Z'
	die	a,cr,<Invalid drive letter>
	cmp	byte ptr [bx],':'
	die	nz,cr,<Drive must be in the form "letter:">
	mov	Drive,al
	jmp	@@skip
@@nopara:
	cmp	Drive, -1
	die	z,cr,<You must specify a drive>
	print	cr,<Drive >
	mov	al, Drive
	call	pr_ch
	print	<: >
	cmp	pgp_restore,1
	jnz	@@no_restore
	mov	wipe,1
	mov	o_directory,1
	mov	o_erased,0
	mov	o_files,0
	mov	pgp_files,0
	print	<"restore PGP files" >
	jmp	@@exit_opt
@@no_restore:
	mov	al,o_erased
	or	al,o_files
	or	al,o_directory
	cmp	al,0
	jnz	@@fin
	mov	o_erased,1
	mov	o_files,1
	mov	o_directory,1
@@fin:
	cmp	wipe,1
	jz	@@lb0
	print	<"simulate" >
	jmp	@@lb1
@@lb0:
	print	<"wipe" >
@@lb1:
	cmp	o_erased,1
	jnz	@@lb2
	print	<"erased space" >
@@lb2:
	cmp	o_directory,1
	jnz	@@lb3
	print	<"directory entries" >
@@lb3:
	cmp	o_files,1
	jnz	@@lb4
	print	<"files end" >
@@lb4:
	cmp	pgp_files,1
	jnz	@@lb5
	mov	o_directory,1
	print	<"hide PGP files" >
@@lb5:
@@exit_opt:
	ret
get_opt endp
; [fold]  ]

;========================  Main Program	 ================================

begin:
	print	cr, <WIPEM - EmilSoft(C)1997 - Wipes:>
	print	cr, <- the free space on a hard disk,>
	print	cr, <- the unused space of each file last cluster,>
	print	cr, <- every erased or unused directory entry,>
	print	cr, <- and swap files (if found)>
	print	cr
	print	cr, <Usage: WIPEM drive: [options]>
	print	cr, <	 /w - wipe (writes on disk - otherwise only simulates)>
	print	cr, <	 /e - only the erased space (free clusters)>
	print	cr, <	 /d - only directory entries>
	print	cr, <	 /f - only the files end (final clusters)>
	print	cr, <	 /p - hide .pgp files (mark delete)>
	print	cr, <	 /r - restore .pgp files (no other operation is performed)>
	print	cr
	call	get_opt
	print	cr
	mov	ah, 30h		; get DOS version
	int	21h
	cmp	al,4
	die	b,cr,<You need DOS version 4 or above to use this program>

; [fold]  [
	mov	ah, 32h		; get drive parameters
	mov	dl, drive
	sub	dl, 'A'-1
	int	21h
	push	ds
	push	es
	pop	ds
	pop	es
	cmp	al,-1
	die	z,cr,<Invalid drive>
	mov	al, byte ptr es:[bx+0]
	mov	Drive, al
	mov	ax, word ptr es:[bx+2]
	mov	SectSiz, ax
	mov	al, byte ptr es:[bx+4]
	cbw
	inc	ax
	mov	SePerCl, ax
	mov	al, byte ptr es:[bx+5]
	cbw
	mov	ClSecSh, ax
	mov	ax, word ptr es:[bx+6]
	mov	BootSiz, ax
	mov	al, byte ptr es:[bx+8]
	cbw
	mov	FatCnt, ax
	mov	ax, word ptr es:[bx+9]
	mov	MaxDir, ax
	mov	ax, word ptr es:[bx+0bh]
	mov	DataSec, ax
	mov	ax, word ptr es:[bx+0dh]
	mov	HiClust, ax
	mov	ax, word ptr es:[bx+0fh]
	mov	FatSects, ax
	mov	ax, word ptr es:[bx+11h]
	mov	RootSec, ax

	print	cr,<SectSiz  = >
	mov	ax, SectSiz
	call	number
	print	cr,<SePerCl  = >
	mov	ax, SePerCl
	call	number
	print	cr,<ClSecSh  = >
	mov	ax, ClSecSh
	call	number
	print	cr,<BootSiz  = >
	mov	ax, BootSiz
	call	number
	print	cr,<FatCnt   = >
	mov	ax, FatCnt
	call	number
	print	cr,<MaxDir   = >
	mov	ax, MaxDir
	call	number
	print	cr,<DataSec  = >
	mov	ax, DataSec
	call	number
	print	cr,<HiClust  = >
	mov	ax, HiClust
	call	number
	print	cr,<FatSects = >
	mov	ax, FatSects
	call	number
	print	cr,<RootSec  = >
	mov	ax, RootSec
	call	number
	print	cr
; [fold]  ]

	cmp	HiClust, 0ff6h
	die	b,cr,<Support for 12bit FAT not added yet>
	cmp	SePerCl, 64
	die	a,cr,<Drives bigger than 2G not supported>
	mov	ax,ds
	add	ax,1000h
	mov	word ptr cluster,0
	mov	word ptr cluster+2,ax
	mov	word ptr dir_cl_chain,8000h
	mov	word ptr dir_cl_chain+2,ax
	call	init_cl_space

	cmp	o_erased,1
	jnz	skip_erase
	print	cr,<Wiping erased space ... >
	mov	procente, -1
	mov	bksp, -1
	mov	fat_read, 0
loop_rf:
	mov	ax, FatSects
	sub	ax, fat_read
	jz	end_rf
	cmp	ax, 16
	jb	@@more
	mov	ax, 16
@@more:
	push	ax
	call	read_fat_sect
	mov	bx,0
@@mai:
	push	bx
	mov	ax, SectSiz
	shr	ax,1
	mul	fat_read	; get fat base
	shr	bx,1
	add	ax,bx
	mov	dx,HiClust
	cmp	ax,dx
	ja	@@skip
	call	show_proc
	shl	bx,1
	mov	dx, [bx + offset load_fat]
	cmp	dx,0
	jnz	@@skip
	call	wipe_cluster
	inc	wipe_cl
@@skip:
	pop	bx
	add	bx,2
	cmp	bx, 16 * 512
	jnz	@@mai
	pop	ax
	add	fat_read,ax
	jmp	loop_rf
end_rf:
	print	cr,
	mov	ax, wipe_cl
	call	number
	print	< free clusters were wiped>,cr
skip_erase:
	cmp	o_directory,1
	jz	do_dirs
	cmp	o_files,1
	jnz	skip_dir
	jmp	sk_fil1
do_dirs:
	cmp	pgp_restore,1
	jz	@@rest_pgp
	print	cr,<Wiping unused directories entries ... >
	jmp	sk_fil1
@@rest_pgp:
	print	cr,<Restoring hidden PGP files ... >
sk_fil1:
	mov	procente, -1
	mov	bksp, -1
	cmp	o_files,1
	jnz	sk_fil2
	mov	ah,3ch
	mov	cx,20h
	mov	dx,offset fname
	int	21h
	die	c,cr,<Die creating file_entry file>
	mov	hand,ax
sk_fil2:
	call	read_root
	mov	ax,MaxDir
	mov	dirs, ax
	call	clean_dir
	cmp	o_directory,1
	jnz	sk_dir1
	call	write_root
sk_dir1:
	mov	ax, SePerCl
	mul	SectSiz
	mov	cx, 20h
	div	cx
	mov	dirs, ax
loop_cl:
	call	find_dir_cluster
	jc	no_more
	push	ax
	call	read_cluster
	call	clean_dir
	pop	ax
	cmp	o_directory,1
	jnz	sk_dir2
	call	write_cluster
sk_dir2:
	jmp	loop_cl
no_more:
	cmp	o_files,1
	jnz	sk_fil3
	call	flush_buf
	mov	ah,3eh
	mov	bx,hand
	int	21h
	die	c,cr,<Die closing file>
sk_fil3:
	cmp	o_directory,1
	jnz	skip_dir
	print	cr
	mov	ax, dir_entry
	call	number
	print	< directories were cleaned>,cr
	cmp	word ptr pgp_count, 0
	jz	skip_dir
	print	cr
	mov	ax, pgp_count
	call	number
	print	< PGP files were >
	cmp	pgp_files,1
	jnz	@@tpgp
	print	<hidden>,cr
	jmp	skip_dir
@@tpgp:
	cmp	pgp_restore,1
	jnz	skip_dir
	print	<restored>,cr
skip_dir:
	cmp	pgp_restore,1
	jz	no_swap_wipe
	cmp	swap_cluster, 0
	jz	no_swap_wipe
	print	cr,<Wiping swap files ... >
	mov	procente, -1
	mov	bksp, -1
	call	wipe_swap_file
	print	cr
	mov	ax, swap_total
	call	number
	print	< swap clusters were wiped>,cr
no_swap_wipe:
	cmp	o_files,1
	jnz	skip_files
	print	cr,<Wiping files final cluster reminder space ... >
	mov	procente, -1
	mov	bksp, -1
	mov	ax,3d00h	; open file for reading
	mov	dx,offset fname
	int	21h
	die	c,cr,<Cannot open file_entry file>
	mov	hand,ax
	mov	ax,SectSiz
	mul	SePerCl
	mov	ClSize,ax
	mov	fat_read,-1
	mov	cx,0
@@still_files:
	push	cx
	mov	ah, 3fh
	mov	bx, hand
	mov	cx,6
	mov	dx, offset f_cluster
	int	21h
	die	c,cr,<Error while reading from file_entry file>
	call	wipe_file_end
	pop	cx
	inc	cx
	mov	ax, cx
	mov	dx, file_entry
	call	show_proc
	cmp	cx,file_entry
	jnz	@@still_files
	mov	ah, 3eh		; close file
	mov	bx, hand
	int	21h
	mov	ah, 41h		; delete file
	mov	dx, offset fname
	int	21h

	print	cr
	mov	ax, file_entry
	call	number
	print	< end of files were wiped>,cr
	mov	ax,SectSiz
	shr	ax,8
	mul	SePerCl
	shr	ax,3
	mul	file_entry	; medium lost space in K
	mov	cx,1000
	div	cx
	push	dx
	call	number
	mov	al,'.'
	call	pr_ch
	pop	dx
	mov	ax,dx
	call	number
	print	< MB unused space in final clusters>,cr
skip_files:

	jmp	exit

exit:
	int	20h

label	file_cl_chain
	db	512 * 6 dup (?)

label	load_fat
	db	512 * 16 dup (?)

label	free

wf	ends

	end	start
; [fold]  25
