#include "windows.h"
#include "monoscrn.h"
#include "gmhook.h"

#define WM_HOTEVENT     (WM_USER + 0x1000)

//function prototypes
int      PASCAL WinMain(HANDLE, HANDLE, LPSTR, int);
         BOOL   InitApplication(HANDLE);
         BOOL   InitInstance(HANDLE, int);
long FAR PASCAL MainWndProc(HWND, unsigned, WORD, LONG);
void     PASCAL ConvertToRowCol(POINT *, POINT *, int, int);

HANDLE  hInst;
BOOL    bOnMonoScreen = FALSE;

int PASCAL WinMain(HANDLE hInstance, 
                   HANDLE hPrevInstance, 
                   LPSTR lpCmdLine, int nCmdShow)
{
    MSG msg;

    if (!hPrevInstance) {
    	if (!InitApplication(hInstance))
	        return (FALSE);
    } else return(FALSE);

    if (!InitInstance(hInstance, nCmdShow))
        return (FALSE);

    while (GetMessage(&msg, NULL, NULL, NULL)) {
        TranslateMessage(&msg);
    	DispatchMessage(&msg);
    }
    whRemoveGMHook();                     //REMOVE the GM Hook !!!
    return (msg.wParam);
}

BOOL InitApplication(HANDLE hInstance)
{
    WNDCLASS  wc;

    wc.style         = CS_DBLCLKS;
    wc.lpfnWndProc   = MainWndProc;
    wc.cbClsExtra    = 0;
    wc.cbWndExtra    = 0;
    wc.hInstance     = hInstance;
    wc.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
    wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject(WHITE_BRUSH); 
    wc.lpszMenuName  = NULL;
    wc.lpszClassName = "MonoIconClass";
    return(RegisterClass(&wc));
}

BOOL InitInstance(HANDLE hInstance, int nCmdShow)
{
    HWND    hwnd;

    hwnd = CreateWindow("MonoIconClass", "Gateway to Mono Monitor",
                        WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT,
                        CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, hInstance,    
                        NULL);
    if (!hwnd)
        return (FALSE);

    VioInit();
    whInstallGMHook(hwnd, WM_HOTEVENT);         //INSTALL the GM Hook !!!
    whEnableGMHook(TRUE);
    ShowWindow(hwnd, SW_SHOWMINNOACTIVE);       //make window ICON
    UpdateWindow(hwnd);
    return(TRUE);
}

long FAR PASCAL MainWndProc(HWND hwnd, unsigned msg, WORD wParam, LONG lParam)
{
    POINT ptTemp;
    POINT ptMono;

    switch (msg) {
    	case WM_QUERYOPEN:
            return(FALSE);                      //stay as an ICON

        case WM_DESTROY:
            PostQuitMessage(0);
            break;

        case WM_MOUSEMOVE:
            if (bOnMonoScreen) {
                ptTemp.x = LOWORD(lParam);
                ptTemp.y = HIWORD(lParam);
                ClientToScreen(hwnd, &ptTemp);
                ConvertToRowCol(&ptTemp, &ptMono, 25, 80);
                VioMovePointer(ptMono.y, ptMono.x);
            }
            break;

        case WM_RBUTTONDBLCLK:
            if (bOnMonoScreen) {
                whEnableGMHook(TRUE);
                ReleaseCapture();
                ShowCursor(TRUE);
                VioShowPointer(FALSE);
                bOnMonoScreen = FALSE;
            }
            break;

        case WM_HOTEVENT:
            if (hwnd != GetActiveWindow())
                SetActiveWindow(hwnd);
            whEnableGMHook(FALSE);
            SetCapture(hwnd);
            ShowCursor(FALSE);
            VioShowPointer(TRUE);
            bOnMonoScreen = TRUE;
            break;

	    default:
	        return (DefWindowProc(hwnd, msg, wParam, lParam));
    }
    return(NULL);
}

void PASCAL ConvertToRowCol(POINT *ptScreen, POINT *ptMono, int iRow, int iCol)
{
    static BOOL bInit = 0;
    static int  cxScreen = 0;
    static int  cyScreen = 0;
           int  iXConvFactor = 0;
           int  iYConvFactor = 0;

    if (!bInit) {
        cxScreen = GetSystemMetrics(SM_CXSCREEN);
        cyScreen = GetSystemMetrics(SM_CYSCREEN);
    }

    iXConvFactor = cxScreen / iCol;
    iYConvFactor = cyScreen / iRow;

    (*ptMono).x = ptScreen->x / iXConvFactor;
    (*ptMono).y = ptScreen->y / iYConvFactor;

    // fixup the math because were using INT instead of real numbers.
    if (ptMono->x >= iCol)
        ptMono->x = iCol-1;

    if (ptMono->y >= iRow)
        ptMono->y = iRow-1;
}

