	title	test block
	include	asm.inc
	.stack

	public	main

BLOCK_SIZE	equ	16384
TEST_SIZE	equ	30		; number of blocks to use in test

	.data?
	extrn	argc:word,argv:dword

block_handles	dw	TEST_SIZE dup(?)

	.const
ertx_block_data	db	'Bad data in block',0


	.code
 extn startup,exit_program,perror,block_alloc,random,block_read,set_strerror
 extn block_file_open,block_file_read


;;	main
;
main	proc
	lea	di,block_handles

	mov	cx,TEST_SIZE
mai1:	call	create_test_block
	jc	mai9
	stosw
	loop	mai1

	mov	cx,TEST_SIZE*10		; read random blocks
	call	read_random_blocks
	jc	mai9

	cmp	argc[bp],2
	jb	mai3			;  if no file name on command line

	lds	si,argv[bp]		; map file to virtual memory
	mov	si,[si+2]
	call	block_file_open
	jc	mai9			;  if file not found

	mov	cx,ax			; read file blocks in reverse order
mai2:	mov	ax,cx
	dec	ax
	call	block_file_read
	jc	mai9
	loop	mai2

mai3:	mov	cx,TEST_SIZE		; read more random blocks
	call	read_random_blocks
	jc	mai9

	ret

mai9:	mov	si,NULL_POINTER
	call	perror
	stc
	ret
main	endp


;;	create test block
;
;	exit	AX,BX	block handle
;		Cf	if error
;
create_test_block proc
	pushm	cx,di,es
	call	block_alloc
	jc	ctb1
	mov	cx,ax
	shr	cx,1
	mov	ax,bx
	rep	stosw
ctb1:	popm	es,di,cx
	ret
create_test_block endp


;;	read random blocks
;
;	entry	CX	number of blocks to read
;	exit	Cf	if error
;	uses	AX,CX,SI,DS
;
read_random_blocks proc
	push	bx
rrb1:	mov	ax,TEST_SIZE
	call	random
	add	ax,ax
	mov	si,ax
	mov	bx,block_handles[bp+si]
	call	block_read
	jc	rrb2
	cmp	bx,[si]
	jne	rrb3
	loop	rrb1
	clc
rrb2:	pop	bx
	ret

rrb3:	lea	ax,ertx_block_data	; *Bad data in block*
	call	set_strerror
	jmp	rrb2
read_random_blocks endp

	end
