	title	rand - random number
	include	asm.inc

	public	rand
	public	random

	.data
; these primes come from Knuth's Seminumerical Algorithms
; useful prime numbers, table 1, section 4.5.4, page 390
ran_num	dw	0		; random number seed
ran_mod	dw	0FFEFh		;  modulus	2^16-17
ran_mul	dw	0FFD9h		;  multiplier	2^16-39
ran_inc	dw	0FFFFh		;  increment	-1

	.code

;;	rand
;
;	exit	AX	random number
;
rand	proc
	push	dx
	mov	ax,ran_num[bp]
	mul	ran_mul[bp]
	add	ax,ran_inc[bp]
	adc	dx,ZER0
	div	ran_mod[bp]
	xchg	ax,dx
	mov	ran_num[bp],ax
	pop	dx
	ret
rand	endp


;;	random
;
;	entry	AX	num
;	exit	AX	random number between 0 and num-1
;
random	proc
	pushm	cx,dx
	mov	cx,ax
	movx	dx,0
	jcxz	ran1
	call	rand
	div	cx
ran1:	mov	ax,dx
	popm	dx,cx
	ret
random	endp

	end
