/* _bufset.c -- Listing 2. */

#include <stdlib.h>
#include "textbuf.h"

/* You can't use the standard memset() and memmove() functions for
 * buffers because they may have been allocated from the far heap.
 * The bufset() and bufmove() calls are mapped to memset() and
 * memmove() when NEAR_HEAP is true, otherwise they are mapped to
 * calls to the following, equivalent, far-pointer functions. Bufset
 * is made a function, even though it's short enough for a macro,
 * to avoid side effects on "size" and "p."
 */

void _bufset( bufptr p, const int c, bufsize size )
{
    while( size-- > 0 )         /* Assume size can be unsigned */
        *p++ = c;
}

void _bufmove( bufptr dst, bufptr src, bufsize size )
{
    if( dst < src )
        while( size-- > 0 )
            *dst++ = *src++ ;
    else
    {
        dst += size;
        src += size;
        while( size-- > 0 )
            *--dst = *--src;
    }
}

