/* 
 * Winaux initialization module
 *
 * Written by Bill Hall
 * 3665  Benton Street, #66
 * Santa Clara, CA 95051
 *
 */

#define NOCOMM
#define NOMINMAX
#define NOKANJI
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <io.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <windows.h>
#include <ttycls.h>
#include "winaux.h"

/* local function declarations */
static BOOL NEAR RegisterWindowClass(HANDLE);
static void NEAR getcrect(HANDLE hInstance);
static BOOL NEAR MakeAndShowMainWnd(HANDLE, int);
static BOOL NEAR SearchKey(char *str, char *key, int len);

/* initial window size rectangle */
static RECT crect;

/* enter here to initialize the program */
BOOL FAR InitProgram(hInstance,hPrevInstance, lpszCmdLine, cmdShow)
HANDLE hInstance, hPrevInstance;
LPSTR lpszCmdLine;
int cmdShow;
{

    char szMessage[80];
    char crlf[3];

    crlf[0] = '\r';
    crlf[1] = '\n';
    crlf[2] = 0;

  /* if first instance, do these things */
    if (hPrevInstance == NULL) {
        LoadString(hInstance,IDS_ICONSTRING,(LPSTR)szIconTitle,
				sizeof(szIconTitle));
	LoadString(hInstance,IDS_HWND,(LPSTR)szhWnd,sizeof(szhWnd));
	strcpy(szBeginLog, crlf);
	LoadString(hInstance,IDS_BEGINLOG,szBeginLog + 2,
					sizeof(szBeginLog) - 5);
	strcat(szBeginLog, crlf);
	strcpy(szEndLog, crlf);
	LoadString(hInstance,IDS_ENDLOG,szEndLog + 2,
					sizeof(szEndLog) - 5);
	strcat(szEndLog, crlf);
	if (!RegisterWindowClass(hInstance))
	    return FALSE;
    }
    else
  	return FALSE;
  /* no additional instances allowed */

  /* read the rectangle for create window */
    getcrect(hInstance);

  /* create the window */
    if (!MakeAndShowMainWnd(hInstance,cmdShow))
	return FALSE;

  /* write the handle to win.ini */
    if (!SetWinIni(MWnd.hWnd))
	return FALSE;

    LoadString(hInstance,IDS_LOGFILE,(LPSTR)szMessage, sizeof(szMessage));
    hFile = open(szMessage, O_CREAT | O_TRUNC | O_WRONLY, S_IWRITE);
    if (hFile)
	EnableMenuItem(GetMenu(MWnd.hWnd), IDM_LOG, MF_ENABLED);
    else {
	LoadString(hInstance, IDS_NOLOGFILE, szMessage, sizeof(szMessage));
	MessageBox(MWnd.hWnd,szMessage,szAppName,MB_ICONEXCLAMATION | MB_OK);
    }

  /* show success */
    return TRUE;
}

/* register the windows class */
static BOOL near RegisterWindowClass(hInstance)
HANDLE hInstance;
{

    PWNDCLASS pWndClass;
    HANDLE hTemp;

  /* get the application name from the resources */
    LoadString(hInstance,IDS_APPNAME,(LPSTR)szAppName,sizeof(szAppName));

  /* make space for the WNDCLASS structure in the heap */
    hTemp = LocalAlloc(LPTR,sizeof(WNDCLASS));
    pWndClass = (PWNDCLASS)LocalLock(hTemp);
	
  /* enter data */
    pWndClass->hCursor = LoadCursor(NULL, IDC_ARROW);	/* stock cursor */
    pWndClass->hIcon = NULL;				/* no icon */
    pWndClass->lpszMenuName = (LPSTR)szAppName;		/* this menu */
    pWndClass->lpszClassName = (LPSTR)szAppName;	/* class name */
    pWndClass->hbrBackground = (HBRUSH)(COLOR_WINDOW + 1); /* background */
    pWndClass->hInstance = hInstance;			/* instance */
    pWndClass->style = CS_VREDRAW | CS_HREDRAW;		/* style */
    pWndClass->lpfnWndProc = MainWndProc;	/* pointer to wind proc */
    pWndClass->cbWndExtra = sizeof(PTTYWND);   /* space for ptr to MWnd */

  /* if failure, return FALSE */
    if (!RegisterClass((LPWNDCLASS)pWndClass))
	return FALSE;

  /* success, so free up heap data and show ok */
    LocalUnlock(hTemp);
    LocalFree(hTemp);
    return TRUE;
}

/* get the user's window size or load and write default values */
static void NEAR getcrect(HANDLE hInstance)
{

    char buf[20];
    char defstr[20];
    char keystr[20];
    char valstr[80];
    int initlen;

    initlen = GetProfileString(szAppName, NULL, "", valstr, sizeof(valstr));

    crect.left = CW_USEDEFAULT;
    itoa(CW_USEDEFAULT, defstr, 10);
    LoadString(hInstance,IDS_X,(LPSTR)keystr,sizeof(keystr));
    if (!SearchKey(valstr, keystr, initlen))
        WriteProfileString(szAppName, keystr, defstr);
    GetProfileString(szAppName, keystr, defstr, buf, sizeof(buf));
    crect.left = atoi(buf);

    crect.top = 0;
    itoa(0, defstr, 10);
    LoadString(hInstance,IDS_Y,(LPSTR)keystr,sizeof(keystr));
    if (!SearchKey(valstr, keystr, initlen))
        WriteProfileString(szAppName, keystr, defstr);
    GetProfileString(szAppName, keystr, defstr, buf, sizeof(buf));
    crect.top = atoi(buf);

    crect.right = CW_USEDEFAULT;
    itoa(CW_USEDEFAULT, defstr, 10);
    LoadString(hInstance,IDS_CX,(LPSTR)keystr,sizeof(keystr));
    if (!SearchKey(valstr, keystr, initlen))
        WriteProfileString(szAppName, keystr, defstr);
    GetProfileString(szAppName, keystr, defstr, buf, sizeof(buf));
    crect.right = atoi(buf);

    crect.bottom = 0;
    itoa(0, defstr, 10);
    LoadString(hInstance,IDS_CY,(LPSTR)keystr,sizeof(keystr));
    if (!SearchKey(valstr, keystr, initlen))
        WriteProfileString(szAppName, keystr, defstr);
    GetProfileString(szAppName, keystr, defstr, buf, sizeof(buf));
    crect.bottom = atoi(buf);
}

/* create a window of the class registered above */
static BOOL NEAR MakeAndShowMainWnd(hInstance, cmdShow)
HANDLE hInstance;
int cmdShow;
{

    char szWinTitle[30];

  /* get the text for the title */
    LoadString(hInstance, IDS_WINTITLE, (LPSTR)szWinTitle,sizeof(szWinTitle));

  /* create the window */
    MWnd.hWnd = CreateWindow((LPSTR)szAppName,	/* class */
			     (LPSTR)szWinTitle,	/* title string */
			     WS_OVERLAPPEDWINDOW,	/* style */
			     crect.left,   /* values obtained from getcrect */
			     crect.top,
			     crect.right,
			     crect.bottom,
			     (HWND)NULL,	/* no parent */
			     (HMENU)NULL,	/* class menu */
			     (HANDLE)hInstance,	/* instance */
			     (LPSTR)&MWnd);	/* ptr to window structure */

  /* if successful, display the window */
    if (MWnd.hWnd && MWnd.hVidBuf) {
	ShowWindow(MWnd.hWnd, cmdShow);
        UpdateWindow(MWnd.hWnd);
	return TRUE;
    }
  /* return failure */
    return FALSE;
}

/* this routine is called upon receipt of the WM_CREATE message */
void WndCreate(hWnd, lParam)
HWND hWnd;
LONG lParam;
{

    HDC hDC;
    TEXTMETRIC TM;
    short width, height, cwidth, cheight;
    LPCREATESTRUCT pCS;
    PTTYWND pMWnd;

  /* we are going to create a buffer for a window this large */
    width = GetSystemMetrics(SM_CXFULLSCREEN);
    height = GetSystemMetrics(SM_CYFULLSCREEN);

  /* get the font size */
    hDC = GetDC(hWnd);
    GetTextMetrics(hDC, &TM);
    cwidth = TM.tmAveCharWidth;
    cheight = TM.tmHeight + TM.tmExternalLeading;
    ReleaseDC(hWnd, hDC);

  /* here we retrieve the pointer to our local window stucture */
    pCS = (LPCREATESTRUCT)lParam;
    pMWnd = (PTTYWND)LOWORD(pCS->lpCreateParams);

  /* initialize the extra data to the pointer to the TWnd structure */
    SetWindowWord(hWnd,0,(WORD)pMWnd);

  /* now create the text buffer and set some defaults */
    InitTTYWindow(pMWnd,0,0,width,height,cwidth,cheight,FALSE,TRUE,TRUE,
					0,0x7f);
}

static BOOL NEAR SearchKey(char *str, char *key, int len)
{
    int i;
    char *startptr;
    startptr = str;

    for (i = 0; i < len; i++) {
	if (*str++)
	    ;
	else {
	    if (strcmp(key, startptr) == 0)
		return(TRUE);
	    startptr = str;
	}
    }
    return (FALSE);
}

