*  LISTING 1

DATA DIVISION.
WORKING-STORAGE SECTION.
EXEC SQL  BEGIN DECLARE SECTION  END-EXEC.
01 ORDER-ENTRY-WORK-AREA.
   05 PRODUCT-ID        PIC X(03).
   05 PRODUCT-NAME      PIC X(20).
   05 PRODUCT-COLOR     PIC X(10).
   05 PRODUCT-FABRIC    PIC X(10).
   05 PRODUCT-PRICE     PIC 9(02)V99.
   05 LOCATION          PIC X(20).
   05 CUSTOMER-ID       PIC X(03).
   05 CUSTOMER-NAME     PIC X(20).
   05 CUSTOMER-LOCATION PIC X(20).
   05 TARIFF-CODE       PIC X(02).
EXEC SQL END DECLARE SECTION END-EXEC.


*  LISTING 2

PROCEDURE DIVISION.
000-BEGIN.
           PERFORM 001-ACCESS-DATA-BASE.
       . . .


001-ACCESS-DATA-BASE.
          EXEC SQL
            SELECT PRODUCT.ID,
                   PRODUCT.COLOR,
                   PRODUCT.LOCATION
                INTO
                   :PRODUCT-ID,
                   :PRODUCT-COLOR,
                   :PRODUCT-LOCATION
                FROM PRODUCT
                WHERE PRODUCT.FABRIC = "MAUVE"
          END-EXEC.
001-END-DB-ACCESS.
        EXIT.


*  LISTING 3

 DATA DIVISION.
 WORKING-STORAGE SECTION.
 EXEC SQL  BEGIN DECLARE SECTION  END-EXEC.
 01 ORDER-ENTRY-WORK-AREA.
    05 PRODUCT-ID        PIC X(03).
    05 PRODUCT-NAME      PIC X(20).
    05 PRODUCT-COLOR     PIC X(10).
 EXEC SQL END DECLARE SECTION END-EXEC.
 SCREEN SECTION.

* (SCREEN SECTION is not standard COBOL but is included
* in many microcomputer COBOL compilers)

 01 MAIN-SCREEN.
    05 SC-PRODUCT-ID     PIC X(03).
    05 SC-PRODUCT-NAME   PIC X(20).
    05 SC-PRODUCT-COLOR  PIC X(10).
 PROCEDURE DIVISION.
 000-BEGIN.
     EXEC SQL WHENEVER SQLWARNING
          GO TO :900-WARNING-ROUTINE
     END-EXEC.
     EXEC SQL WHENEVER SQLERROR
          GO TO :920-ERROR-ROUTINE
     END-EXEC.
     PERFORM 100-MAIN-ROUTINE UNTIL some-condition.
     PERFORM 800-TERMINATION-ROUTINE.
     STOP RUN.
 100-MAIN-ROUTINE.
     PERFORM 200-GET-SCREEN-INPUT.
     MOVE SC-PRODUCT-ID TO PRODUCT-ID.
     MOVE SC-PRODUCT-NAME TO PRODUCT-NAME.
     MOVE SC-PRODUCT-COLOR TO PRODUCT-COLOR.
     EXEC SQL
        INSERT  INTO PRODUCT (ID,
                              NAME,
                              COLOR)
                     VALUES  (:PRODUCT-ID,
                              :PRODUCT-NAME,
                              :PRODUCT-COLOR)
     END-EXEC.

************  additional main routine code **************
 200-GET-SCREEN-INPUT.
 800-TERMINATION-ROUTINE.
 900-WARNING-ROUTINE.
 920-ERROR-ROUTINE.
/*  = LISTING 4
WORKING-STORAGE SECTION.


      . . .


     EXEC SQL  DECLARE  PRODUCT_CURSOR CURSOR FOR
               SELECT
                     PRODUCT.ID,
                     PRODUCT.NAME,
                     PRODUCT.COLOR,
                     PRODUCT.FABRIC
               FROM  PRODUCT
               WHERE PRODUCT.ID >= :PRODUCT-ID
               ORDER BY PRODUCT.ID
     END-EXEC.
PROCEDURE DIVISION.
000-MAIN.
    PERFORM 001-INITIALIZE.
    PERFORM 300-CHECK-ON-PRODUCT.
    PERFORM 900-END-PROGRAM.
300-CHECK-PRODUCT.
     EXEC SQL OPEN PRODUCT_CURSOR END-EXEC.
     PERFORM UNTIL SQLCODE = +100
             EXEC SQL
                  FETCH PRODUCT_CURSOR
                    INTO  :PRODUCT-ID,
                          :PRODUCT-NAME,
                          :PRODUCT-COLOR,
                          :PRODUCT-FABRIC
             END-SQL
             PERFORM 600-VALIDATE-ROUTINE
             IF VALIDATE-RETURN-CODE = 0 THEN
                ADD 1 TO VALID-RECORD-COUNT
                PERFORM 400-PRODUCT-UPDATE-ROUTINE
             ELSE
                ADD 1 TO NON-VALID-RECORD-COUNT
             END-IF
     END-PERFORM
     EXEC SQL CLOSE PRODUCT_CURSOR END-EXEC.


400-PRODUCT-UPDATE-ROUTINE.
         . . .


600-VALIDATE-ROUTINE.
         . . .


900-END-PROGRAM.


